<?php

function Get_modbus_epower_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('C*', substr($memData, 4, 2*55));
        //11
        $dataArray['主路电压'] = $v[1] == 1 ? "主路输入异常" : "交流输入正常";
        $dataArray['旁路电压'] = $v[2] == 1 ? "旁路输入异常" : "旁路输入正常";
        $dataArray['整流器工作'] = $v[3] == 1 ? "整流器正在工作" : "整流器关闭";
        $dataArray['逆变器工作'] = $v[4] == 1 ? "逆变器正在工作" : "逆变器关闭";
        $dataArray['逆变器带载'] = $v[5] == 1 ? "逆变器带载" : "非逆变器带载";
        $dataArray['旁路带载'] = $v[6] == 1 ? "旁路带载" : "非旁路带载";
        $dataArray['逆变与旁路同步'] = $v[7] == 1 ? "不同步" : "同步";
        $dataArray['操作模式'] = $v[8] == 1 ? "逆变供电" : "旁路供电";
        $dataArray['声音报警'] = $v[9] == 1 ? "蜂鸣器静音" : "蜂鸣器正常";
        $dataArray['电池状态'] = $v[10] == 1 ? "电池正在放电" : "电池正在充电";
        $dataArray['UPS 在线状态'] = $v[11] == 1 ? "电池逆变供电" : "主路逆变供电";
        //alarm
        $dataArray['主路输入电压低'] = $v[12] == 0 ? "正常" : "交流输入电压低";
        $dataArray['AlertArray']['主路输入电压低'] = $v[12] == 1;
        $dataArray['母线过电压'] = $v[13] == 0 ? "正常" : "母线过压";
        $dataArray['AlertArray']['母线过电压'] = $v[13];
        $dataArray['电池低压报警'] = $v[14] == 0 ? "正常" : "电池电压低";
        $dataArray['AlertArray']['电池低压报警'] = $v[14];
        $dataArray['电池未接入'] = $v[15] == 0 ? "正常" : "电池无";
        $dataArray['AlertArray']['电池未接入'] = $v[15];
        $dataArray['逆变器故障'] = $v[16] == 0 ? "正常" : "逆变器故障";
        $dataArray['AlertArray']['逆变器故障'] = $v[16];
        $dataArray['逆变器过电流'] = $v[17] == 0 ? "正常" : "逆变器过流";
        $dataArray['AlertArray']['逆变器过电流'] = $v[17];
        $dataArray['逆变器输出电压变化过大'] = $v[18] == 0 ? "正常" : "逆变输出电压异常";
        $dataArray['AlertArray']['逆变器输出电压变化过大'] = $v[18];
        $dataArray['风扇故障'] = $v[19] == 0 ? "正常" : "风扇故障";
        $dataArray['AlertArray']['风扇故障'] = $v[19];
        $dataArray['电池更换提示'] = $v[20] == 0 ? "正常" : "电池需更换";
        $dataArray['AlertArray']['电池更换提示'] = $v[20];
        $dataArray['整流器过温'] = $v[21] == 0 ? "正常" : "整流器过温";
        $dataArray['AlertArray']['整流器过温'] = $v[21];
        $dataArray['逆变器过温'] = $v[22] == 0 ? "正常" : "逆变器过温";
        $dataArray['AlertArray']['逆变器过温'] = $v[22];
        //data
        $offset = 22;
        $dataArray['输入线电压（AB）'] = number_format($v[$offset + 1]/10, 1)."V";
        $dataArray['输入线电压（BC）'] = number_format($v[$offset + 2]/10, 1)."V";
        $dataArray['输入线电压（CA）'] = number_format($v[$offset + 3]/10, 1)."V";
        
        $dataArray['旁路相电压（A）'] = number_format($v[$offset + 4]/10, 1)."V";
        $dataArray['旁路相电压（B）'] = number_format($v[$offset + 5]/10, 1)."V";
        $dataArray['旁路相电压（C）'] = number_format($v[$offset + 6]/10, 1)."V";

        $dataArray['主路输入电流（A）'] = number_format($v[$offset + 7]/10, 1)."A";
        $dataArray['主路输入电流（B）'] = number_format($v[$offset + 8]/10, 1)."A";
        $dataArray['主路输入电流（C）'] = number_format($v[$offset + 9]/10, 1)."A";
        $dataArray['主路输入频率'] = number_format($v[$offset + 10]/100, 2)."Hz";

        $dataArray['输出相电压（A）'] = number_format($v[$offset + 11]/10, 1)."V";
        $dataArray['输出相电压（B）'] = number_format($v[$offset + 12]/10, 1)."V";
        $dataArray['输出相电压（C）'] = number_format($v[$offset + 13]/10, 1)."V";
        $dataArray['输出频率'] = number_format($v[$offset + 14]/100, 2)."Hz";

        $dataArray['输出电流（A）'] = number_format($v[$offset + 15]/10, 1)."A";
        $dataArray['输出电流（B）'] = number_format($v[$offset + 16]/10, 1)."A";
        $dataArray['输出电流（C）'] = number_format($v[$offset + 17]/10, 1)."A";


        $dataArray['输出有功功率（A）'] = number_format($v[$offset + 18]/10, 1)."kW";
        $dataArray['输出有功功率（B）'] = number_format($v[$offset + 19]/10, 1)."kW";
        $dataArray['输出有功功率（C）'] = number_format($v[$offset + 20]/10, 1)."kW";
        $dataArray['输出视在功率（A）'] = number_format($v[$offset + 21]/10, 1)."kVA";
        $dataArray['输出视在功率（B）'] = number_format($v[$offset + 22]/10, 1)."kVA";
        $dataArray['输出视在功率（C）'] = number_format($v[$offset + 23]/10, 1)."kVA";
        $dataArray['输出负载率（A）'] = number_format($v[$offset + 24]/10, 1)."%";
        $dataArray['输出负载率（B）'] = number_format($v[$offset + 25]/10, 1)."%";
        $dataArray['输出负载率（C）'] = number_format($v[$offset + 26]/10, 1)."%";

        $dataArray['历史记录条数'] = $v[$offset + 27]."条";
        $dataArray['电池电压'] = number_format($v[$offset + 28]/10, 1)."V";
        $dataArray['电池容量'] = $v[$offset + 29]."AH";
        $dataArray['电池组数'] = $v[$offset + 30]."组";
        $dataArray['BUS电压'] = number_format($v[$offset + 31]/10, 1)."V";
        $dataArray['电池电流'] = number_format($v[$offset + 32]/10, 1)."A";
        //$dataArray['电池后备时间'] = number_format($v[$offset + 26]/10, 1)."%";
        $v = unpack('v', substr($memData, 4, 2*55, 2));
        $year = $v[1] ;
        $v = unpack('C*', substr($memData, 4, 2*55 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
