<?php

function Get_modbus_md500_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 104){
        return pack("s", $parameter[0]);
    }
    return "";
    
}


function Get_modbus_md500_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}


function Get_modbus_md500_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('s*', substr($memData, 4, 2*35));
        switch($v[1])
        {
            case 1:
                $dataArray['变频器状态'] = "正转运行";
                break;
            case 2:
                $dataArray['变频器状态'] = "反转运行";
                break;
            case 3:
                $dataArray['变频器状态'] = "停机";
                break;
        }
        $dataArray['通信设定值'] = $v[2];
        $dataArray['运行频率'] = $v[3];
        $dataArray['母线电压'] = $v[4]/10;
        $dataArray['输出电压'] = $v[5]/10;
        $dataArray['输出电流'] = $v[6];
        $dataArray['输出功率'] = $v[7];
        $dataArray['输出扭矩'] = $v[8];
        $dataArray['运行速度'] = $v[9];
        $dataArray['输入端子标志'] = $v[10];
        $dataArray['输出端子标志'] = $v[11];
        $dataArray['AI1电压'] = $v[12];
        $dataArray['AI2电压'] = $v[13];
        $dataArray['AI3电压'] = $v[14];
        $dataArray['计数值输入'] = $v[15];
        $dataArray['长度值输入'] = $v[16];
        $dataArray['负载速度'] = $v[17];
        $dataArray['PID设置'] = $v[18];

        $dataArray['PID反馈值'] = $v[19];
        $dataArray['PLC步骤'] = $v[20];
        $dataArray['PULSE输入脉冲频率1'] = ($v[21]/100)."kHz";
        $dataArray['反馈速度'] = ($v[22]/10)."Hz";
        $dataArray['剩余运行时间'] = $v[23];
        $dataArray['AI1校正前电压'] = $v[24];
        $dataArray['AI2校正前电压'] = $v[25];
        $dataArray['AI3校正前电压'] = $v[26];
        $dataArray['线速度'] = $v[27];
        $dataArray['当前上电时间'] = $v[28];
        $dataArray['当前运行时间'] = $v[29];
        $dataArray['PULSE输入脉冲频率2'] = $v[30]."Hz";
        $dataArray['通讯设定值'] = $v[31];
        $dataArray['实际反馈速度'] = $v[32];
        $dataArray['A频率显示'] = $v[33];
        $dataArray['B频率显示'] = $v[34];

        switch($v[35])
        {
            case 0:
                $dataArray['故障状态'] = "无故障";
                break;
            case 2:
                $dataArray['故障状态'] = "加速过电流";
                break;
            case 3:
                $dataArray['故障状态'] = "减速过电流";
                break;
            case 4:
                $dataArray['故障状态'] = "恒速过电流";
                break;
            case 5:
                $dataArray['故障状态'] = "加速过电压";
                break;
            case 6:
                $dataArray['故障状态'] = "减速过电压";
                break;
            case 7:
                $dataArray['故障状态'] = "恒速过电压";
                break;
            case 8:
                $dataArray['故障状态'] = "缓冲电阻过载故障";
                break;
            case 9:
                $dataArray['故障状态'] = "欠压故障";
                break;
            case 0xa:
                $dataArray['故障状态'] = "变频器过载";
                break;
            case 0xb:
                $dataArray['故障状态'] = "电机过载";
                break;
            case 0xC:
                $dataArray['故障状态'] = "输入缺相";
                break;
            case 0xD:
                $dataArray['故障状态'] = "输出缺相";
                break;
            case 0xE:
                $dataArray['故障状态'] = "模块过热";
                break;
            case 0xF:
                $dataArray['故障状态'] = "外部故障";
                break;
            case 0x10:
                $dataArray['故障状态'] = "通讯故障";
                break;
            case 0x11:
                $dataArray['故障状态'] = "接触器异常";
                break;
            case 0x12:
                $dataArray['故障状态'] = "电流检测故障";
                break;
            case 0x13:
                $dataArray['故障状态'] = "电机调谐故障";
                break;  
            case 0x14:
                $dataArray['故障状态'] = "编码器/PG卡故障";
                break;
            case 0x15:
                $dataArray['故障状态'] = "参数读写异常";
                break; 
            case 0x16:
                $dataArray['故障状态'] = "变频器硬件故障";
                break; 
            case 0x17:
                $dataArray['故障状态'] = "电机对地短路故障";
                break;
            case 0x1A:
                $dataArray['故障状态'] = "运行时间到达";
                break;
            case 0x1B:
                $dataArray['故障状态'] = "用户自定义故障1";
                break;
            case 0x1C:
                $dataArray['故障状态'] = "用户自定义故障2";
                break;
            case 0x1D:
                $dataArray['故障状态'] = "上电时间到达";
                break;
            case 0x1E:
                $dataArray['故障状态'] = "掉载";
                break;
            case 0x1F:
                $dataArray['故障状态'] = "运行时PID反馈丢失";
                break;
            case 0x28:
                $dataArray['故障状态'] = "快速限流超时故障";
                break;
            case 0x29:
                $dataArray['故障状态'] = "运行时切换电机故障";
                break;
            case 0x2A:
                $dataArray['故障状态'] = "速度偏差过大";
                break;
            case 0x2B:
                $dataArray['故障状态'] = "电机超速度";
                break;
            case 0x2D:
                $dataArray['故障状态'] = "电机过温";
                break;
            case 0x5A:
                $dataArray['故障状态'] = "编码器线数设定错误";
                break;
            case 0x5B:
                $dataArray['故障状态'] = "未接编码器";
                break;
            case 0x5C:
                $dataArray['故障状态'] = "初始位置错误";
                break;
            case 0x5E:
                $dataArray['故障状态'] = "速度反馈错误";
                break;
        }
        
        $v = unpack('v', substr($memData, 4 + 2*35, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*35 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
