<?php
function Get_modbus_vertiv_ac_Size()
{
    return 261;
}

function Get_modbus_vertiv_ac_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $offset = 4;
        $v = unpack("s*", substr($memData, $offset, 125 * 2));

        $arr = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 23];
        for ($i = 1; $i < 126; $i++) {
            if (!in_array($i, $arr)) {
                if ($v[$i] == 32767) {
                    $v[$i] = 0;
                }
            }
        }

        $dataArray['监控协议图号'] = $v[1];
        $dataArray['监控协议版本'] = $v[2];
        $dataArray['远程关机报警'] = $v[3] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['地板溢水报警'] = ($v[3] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['烟感报警'] = ($v[3] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['火感报警'] = ($v[3] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['防雷器报警'] = ($v[3] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义1报警'] = ($v[3] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义2报警'] = ($v[3] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义3报警'] = ($v[3] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义4报警'] = ($v[3] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义5报警'] = ($v[3] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义6报警'] = ($v[3] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['消防报警'] = ($v[3] >> 11) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水盘超高水位报警'] = ($v[3] >> 12) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['注水故障报警'] = ($v[3] >> 13) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水位开关故障报警'] = ($v[3] >> 14) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['远程关机报警'] = $v[3] & 0x1 == 1;
        $dataArray['AlertArray']['地板溢水报警'] = ($v[3] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['烟感报警'] = ($v[3] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['火感报警'] = ($v[3] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['防雷器报警'] = ($v[3] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['自定义1报警'] = ($v[3] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['自定义2报警'] = ($v[3] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['自定义3报警'] = ($v[3] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['自定义4报警'] = ($v[3] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['自定义5报警'] = ($v[3] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['自定义6报警'] = ($v[3] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['消防报警'] = ($v[3] >> 11) & 0x1 == 1;
        $dataArray['AlertArray']['水盘超高水位报警'] = ($v[3] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['注水故障报警'] = ($v[3] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['水位开关故障报警'] = ($v[3] >> 14) & 0x1 == 1;

        $dataArray['电源丢失报警'] = $v[4] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源过压报警'] = ($v[4] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源欠压报警'] = ($v[4] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源频偏报警'] = ($v[4] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源缺相报警'] = ($v[4] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源反相报警'] = ($v[4] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['交流断电报警（交流应急制冷报警）注 7'] = ($v[4] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['直流断电报警'] = ($v[4] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['联动地址重复报警'] = ($v[4] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['联动从机丢失报警'] = ($v[4] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['湿膜维护提醒'] = ($v[4] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源丢失报警'] = $v[4] & 0x1 == 1;
        $dataArray['AlertArray']['电源过压报警'] = ($v[4] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['电源欠压报警'] = ($v[4] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['电源频偏报警'] = ($v[4] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['电源缺相报警'] = ($v[4] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['电源反相报警'] = ($v[4] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['交流断电报警（交流应急制冷报警）注 7'] = ($v[4] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['直流断电报警'] = ($v[4] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['联动地址重复报警'] = ($v[4] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['联动从机丢失报警'] = ($v[4] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['湿膜维护提醒'] = ($v[4] >> 10) & 0x1 == 1;

        $dataArray['风机维护提醒'] = $v[5] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['过滤网维护提醒'] = ($v[5] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电加热维护提醒'] = ($v[5] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['加湿器维护提醒'] = ($v[5] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机维护提醒'] = ($v[5] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机故障报警'] = ($v[5] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电加热故障报警'] = ($v[5] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['加湿器故障报警'] = ($v[5] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['红外加湿高水位报警'] = ($v[5] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['过滤网堵塞报警'] = ($v[5] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风阀故障报警'] = ($v[5] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['气流丢失报警'] = ($v[5] >> 11) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝高水位报警'] = ($v[5] >> 12) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝水泵报警'] = ($v[5] >> 13) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水阀故障报警'] = ($v[5] >> 14) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水阀维护提醒'] = ($v[5] >> 15) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['风机维护提醒'] = $v[5] & 0x1 == 1;
        $dataArray['AlertArray']['过滤网维护提醒'] = ($v[5] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['电加热维护提醒'] = ($v[5] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['加湿器维护提醒'] = ($v[5] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机维护提醒'] = ($v[5] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['风机故障报警'] = ($v[5] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['电加热故障报警'] = ($v[5] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['加湿器故障报警'] = ($v[5] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['红外加湿高水位报警'] = ($v[5] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['过滤网堵塞报警'] = ($v[5] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['风阀故障报警'] = ($v[5] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['气流丢失报警'] = ($v[5] >> 11) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝高水位报警'] = ($v[5] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝水泵报警'] = ($v[5] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['水阀故障报警'] = ($v[5] >> 14) & 0x1 == 1;
        $dataArray['AlertArray']['水阀维护提醒'] = ($v[5] >> 15) & 0x1 == 1;

        $dataArray['回风高温报警'] = $v[6] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['回风低温报警'] = ($v[6] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风高温报警'] = ($v[6] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风低温报警'] = ($v[6] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程高温报警'] = ($v[6] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程低温报警'] = ($v[6] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['回风高湿报警'] = ($v[6] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['回风低湿报警'] = ($v[6] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风高湿报警'] = ($v[6] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风低湿报警'] = ($v[6] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程高湿报警'] = ($v[6] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程低湿报警'] = ($v[6] >> 11) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风高温报警'] = $v[6] & 0x1 == 1;
        $dataArray['AlertArray']['回风低温报警'] = ($v[6] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['送风高温报警'] = ($v[6] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['送风低温报警'] = ($v[6] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['远程高温报警'] = ($v[6] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['远程低温报警'] = ($v[6] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['回风高湿报警'] = ($v[6] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['回风低湿报警'] = ($v[6] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['送风高湿报警'] = ($v[6] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['送风低湿报警'] = ($v[6] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['远程高湿报警'] = ($v[6] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['远程低湿报警'] = ($v[6] >> 11) & 0x1 == 1;

        $dataArray['回风温度传感器故障'] = $v[7] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['回风湿度传感器故障'] = ($v[7] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风温度传感器故障'] = ($v[7] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风湿度传感器故障'] = ($v[7] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程温度传感器故障'] = ($v[7] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程湿度传感器故障'] = ($v[7] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['回风传感器通讯故障'] = ($v[7] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['送风传感器通讯故障'] = ($v[7] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程传感器通讯故障'] = ($v[7] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风温度传感器故障'] = $v[7] & 0x1 == 1;
        $dataArray['AlertArray']['回风湿度传感器故障'] = ($v[7] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['送风温度传感器故障'] = ($v[7] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['送风湿度传感器故障'] = ($v[7] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['远程温度传感器故障'] = ($v[7] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['远程湿度传感器故障'] = ($v[7] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['回风传感器通讯故障'] = ($v[7] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['送风传感器通讯故障'] = ($v[7] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['远程传感器通讯故障'] = ($v[7] >> 8) & 0x1 == 1;

        $dataArray['气流丢失传感器故障'] = $v[8] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高压压力传感器故障'] = ($v[8] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压压力传感器故障'] = ($v[8] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气温度传感器故障'] = ($v[8] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['吸气温度传感器故障'] = ($v[8] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['进水温度传感器故障'] = ($v[8] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['出水温度传感器故障'] = ($v[8] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风压传感器故障'] = ($v[8] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水压传感器故障'] = ($v[8] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水流量传感器故障'] = ($v[8] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['滤网压差传感器故障'] = ($v[8] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压压力传感器故障锁定'] = ($v[8] >> 12) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['气流丢失传感器故障'] = $v[8] & 0x1 == 1;
        $dataArray['AlertArray']['高压压力传感器故障'] = ($v[8] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['低压压力传感器故障'] = ($v[8] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['排气温度传感器故障'] = ($v[8] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['吸气温度传感器故障'] = ($v[8] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['进水温度传感器故障'] = ($v[8] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['出水温度传感器故障'] = ($v[8] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['风压传感器故障'] = ($v[8] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['水压传感器故障'] = ($v[8] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['水流量传感器故障'] = ($v[8] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['滤网压差传感器故障'] = ($v[8] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['低压压力传感器故障锁定'] = ($v[8] >> 12) & 0x1 == 1;

        $dataArray['高压报警'] = $v[9] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高压锁定报警'] = ($v[9] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压报警'] = ($v[9] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压锁定报警'] = ($v[9] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气高温报警'] = ($v[9] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气高温锁定报警'] = ($v[9] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气低温报警'] = ($v[9] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气低温锁定报警'] = ($v[9] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气过热度低报警'] = ($v[9] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气过热度低锁定报警'] = ($v[9] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['盘管冻结报警'] = ($v[9] >> 10) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['盘管冻结锁定报警'] = ($v[9] >> 11) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机高压异常报警'] = ($v[9] >> 12) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压差报警'] = ($v[9] >> 13) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压差锁定报警'] = ($v[9] >> 14) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机低压异常报警'] = ($v[9] >> 15) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压报警'] = $v[9] & 0x1 == 1;
        $dataArray['AlertArray']['高压锁定报警'] = ($v[9] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['低压报警'] = ($v[9] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['低压锁定报警'] = ($v[9] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['排气高温报警'] = ($v[9] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['排气高温锁定报警'] = ($v[9] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['排气低温报警'] = ($v[9] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['排气低温锁定报警'] = ($v[9] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['排气过热度低报警'] = ($v[9] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['排气过热度低锁定报警'] = ($v[9] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['盘管冻结报警'] = ($v[9] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['盘管冻结锁定报警'] = ($v[9] >> 11) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机高压异常报警'] = ($v[9] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['压差报警'] = ($v[9] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['压差锁定报警'] = ($v[9] >> 14) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机低压异常报警'] = ($v[9] >> 15) & 0x1 == 1;

        $dataArray['电子膨胀阀驱动通信故障'] = $v[10] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电子膨胀阀驱动故障'] = ($v[10] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机驱动通信故障'] = ($v[10] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机驱动故障'] = ($v[10] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机驱动故障锁定'] = ($v[10] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机检测板通讯故障'] = ($v[10] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机驱动通信锁定'] = ($v[10] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['功率表通讯故障'] = ($v[10] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵通讯故障'] = ($v[10] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器通讯故障'] = ($v[10] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['节能卡故障'] = ($v[10] >> 12) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电子膨胀阀驱动通信故障'] = $v[10] & 0x1 == 1;
        $dataArray['AlertArray']['电子膨胀阀驱动故障'] = ($v[10] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机驱动通信故障'] = ($v[10] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机驱动故障'] = ($v[10] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机驱动故障锁定'] = ($v[10] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['风机检测板通讯故障'] = ($v[10] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机驱动通信锁定'] = ($v[10] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['功率表通讯故障'] = ($v[10] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵通讯故障'] = ($v[10] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器通讯故障'] = ($v[10] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['节能卡故障'] = ($v[10] >> 12) & 0x1 == 1;

        $dataArray['群控主机丢失报警'] = $v[11] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['群控从机丢失报警'] = ($v[11] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['群控地址重复报警'] = ($v[11] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['群控主机丢失报警'] = $v[11] & 0x1 == 1;
        $dataArray['AlertArray']['群控从机丢失报警'] = ($v[11] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['群控地址重复报警'] = ($v[11] >> 2) & 0x1 == 1;

        $dataArray['进水高温报警'] = $v[12] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['进水低温报警'] = ($v[12] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['出水高温报警'] = ($v[12] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['出水低温报警'] = ($v[12] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['进水高压报警'] = ($v[12] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['进水低压报警'] = ($v[12] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水流丢失报警'] = ($v[12] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['水流量低报警'] = ($v[12] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['进水高温报警'] = $v[12] & 0x1 == 1;
        $dataArray['AlertArray']['进水低温报警'] = ($v[12] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['出水高温报警'] = ($v[12] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['出水低温报警'] = ($v[12] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['进水高压报警'] = ($v[12] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['进水低压报警'] = ($v[12] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['水流丢失报警'] = ($v[12] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['水流量低报警'] = ($v[12] >> 7) & 0x1 == 1;

        $dataArray['制冷剂泵驱动故障'] = $v[13] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵入口压力传感器故障'] = ($v[13] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵出口压力传感器故障'] = ($v[13] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵环境温度故障'] = ($v[13] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵过温故障'] = ($v[13] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵过温锁定故障'] = ($v[13] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵高扬程告警'] = ($v[13] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵高扬程锁定告警'] = ($v[13] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵低扬程告警'] = ($v[13] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['制冷剂泵低扬程锁定告警'] = ($v[13] >> 9) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['制冷剂泵驱动故障'] = $v[13] & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵入口压力传感器故障'] = ($v[13] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵出口压力传感器故障'] = ($v[13] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵环境温度故障'] = ($v[13] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵过温故障'] = ($v[13] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵过温锁定故障'] = ($v[13] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵高扬程告警'] = ($v[13] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵高扬程锁定告警'] = ($v[13] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵低扬程告警'] = ($v[13] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['制冷剂泵低扬程锁定告警'] = ($v[13] >> 9) & 0x1 == 1;

        $dataArray['冷凝器驱动故障'] = $v[14] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器压力传感器故障'] = ($v[14] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器风机故障'] = ($v[14] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器风机故障锁定'] = ($v[14] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器喷淋高压故障'] = ($v[14] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器低压差故障'] = ($v[14] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器环境温度传感器故障'] = ($v[14] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器风机未配置'] = ($v[14] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['冷凝器喷淋水系统故障'] = ($v[14] >> 8) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['冷凝器驱动故障'] = $v[14] & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器压力传感器故障'] = ($v[14] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器风机故障'] = ($v[14] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器风机故障锁定'] = ($v[14] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器喷淋高压故障'] = ($v[14] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器低压差故障'] = ($v[14] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器环境温度传感器故障'] = ($v[14] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器风机未配置'] = ($v[14] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['冷凝器喷淋水系统故障'] = ($v[14] >> 8) & 0x1 == 1;

        switch ($v[21]) {
            case 0:
                $dataArray['机组状态'] = '运行';
                break;
            case 1:
                $dataArray['机组状态'] = '备机';
                break;
            case 2:
                $dataArray['机组状态'] = '面板关机';
                break;
            case 3:
                $dataArray['机组状态'] = '远程关机';
                break;
            case 4:
                $dataArray['机组状态'] = '监控关机';
                break;
            default:
                $dataArray['机组状态'] = '未定义';
                break;
        }

        switch ($v[22]) {
            case 0:
                $dataArray['群控状态'] = '单机';
                break;
            case 1:
                $dataArray['群控状态'] = '群控模式0';
                break;
            case 2:
                $dataArray['群控状态'] = '群控模式1';
                break;
            case 3:
                $dataArray['群控状态'] = '群控模式2';
                break;
            case 4:
                $dataArray['群控状态'] = '群控模式3';
                break;
            default:
                $dataArray['群控状态'] = '未定义';
                break;
        }

        $dataArray['制冷状态'] = $v[23] & 0x1 == 1 ? '制冷' : '未制冷';
        $dataArray['加热状态'] = ($v[23] >> 1) & 0x1 == 1 ? '加热' : '未加热';
        $dataArray['加湿状态'] = ($v[23] >> 2) & 0x1 == 1 ? '加湿' : '未加湿';
        $dataArray['除湿状态'] = ($v[23] >> 3) & 0x1 == 1 ? '除湿' : '未除湿';

        $dataArray['A相电压'] = number_format($v[24] / 10, 2) . ' V';
        $dataArray['B相电压'] = number_format($v[25] / 10, 2) . ' V';
        $dataArray['C相电压'] = number_format($v[26] / 10, 2) . ' V';
        $dataArray['电源频率'] = number_format($v[27] / 10, 2) . ' Hz';
        $dataArray['回风温度1'] = number_format($v[31] / 10, 2) . ' ℃';
        $dataArray['回风温度2'] = number_format($v[32] / 10, 2) . ' ℃';
        $dataArray['回风温度3'] = number_format($v[33] / 10, 2) . ' ℃';
        $dataArray['回风湿度1'] = number_format($v[34] / 10, 2) . ' %RH';
        $dataArray['回风湿度2'] = number_format($v[35] / 10, 2) . ' %RH';
        $dataArray['回风湿度3'] = number_format($v[36] / 10, 2) . ' %RH';
        $dataArray['送风温度1（系统1）'] = number_format($v[37] / 10, 2) . ' ℃';
        $dataArray['送风温度2（系统1）'] = number_format($v[38] / 10, 2) . ' ℃';
        $dataArray['送风温度3（系统1）'] = number_format($v[39] / 10, 2) . ' ℃';
        $dataArray['送风湿度1（系统1）'] = number_format($v[40] / 10, 2) . ' %';
        $dataArray['送风湿度2（系统1）'] = number_format($v[41] / 10, 2) . ' %';
        $dataArray['送风湿度3（系统1）'] = number_format($v[42] / 10, 2) . ' %';
        $arr = [4, 6, 8, 10, 12, 14, 16];
        for ($i = 1; $i < 17; $i++) {
            $unit = ' ℃';
            if (in_array($i, $arr)) {
                $unit = ' %';
            }
            $dataArray['远程温度' . $i] = number_format($v[42 + $i] / 10, 2) . $unit;
        }

        for ($i = 1; $i < 17; $i++) {
            $unit = $i % 2 == 1 ? ' ℃' : ' %';
            $dataArray['远程湿度' . $i] = number_format($v[58 + $i] / 10, 2) . $unit;
        }
        $dataArray['A路进水温度'] = number_format($v[75] / 10, 2) . ' ℃';
        $dataArray['A路出水温度'] = number_format($v[76] / 10, 2) . ' ℃';
        $dataArray['B路进水温度'] = number_format($v[77] / 10, 2) . ' ℃';
        $dataArray['B路出水温度'] = number_format($v[78] / 10, 2) . ' ℃';
        $dataArray['A路进水压力'] = $v[79] . ' kPa';
        $dataArray['A路出水压力'] = $v[80] . ' kPa';
        $dataArray['B路进水压力'] = $v[81] . ' kPa';
        $dataArray['B路出水压力'] = $v[82] . ' kPa';
        $dataArray['A路水流量'] = number_format($v[83] / 10, 2) . ' m3/h';
        $dataArray['B路水流量'] = number_format($v[84] / 10, 2) . ' m3/h';
        $dataArray['风压1'] = $v[85] . ' Pa';
        $dataArray['风压2'] = $v[85] . ' Pa';
        $dataArray['风机1转速'] = $v[91] . ' %';
        $dataArray['风机2转速'] = $v[92] . ' %';
        $dataArray['压缩机1容量'] = $v[93] . ' %';
        $dataArray['压缩机2容量'] = $v[94] . ' %';
        $dataArray['水阀1开度'] = $v[95] . ' %';
        $dataArray['水阀2开度'] = $v[96] . ' %';
        $dataArray['监控开关机'] = $v[101] == 1 ? '开机' : '关机';
        $dataArray['回风温度设定'] = number_format($v[102] / 10, 2) . ' ℃';
        $dataArray['送风温度设定'] = number_format($v[103] / 10, 2) . ' ℃';
        $dataArray['远程温度设定'] = number_format($v[104] / 10, 2) . ' ℃';
        $dataArray['湿度设定'] = number_format($v[105] / 10, 2) . ' %';
        $dataArray['温度比例带'] = number_format($v[106] / 10, 2) . ' ℃';
        $dataArray['湿度比例带'] = number_format($v[107] / 10, 2) . ' %RH';
        $dataArray['回风湿度设定'] = number_format($v[108] / 10, 2) . ' %RH';
        $dataArray['远程湿度设定'] = number_format($v[110] / 10, 2) . ' %RH';
        $dataArray['风机温差设定'] = number_format($v[111] / 10, 2) . ' ℃';

        switch ($v[122]) {
            case 0:
                $dataArray['湿度控制方式'] = '回风平均湿度';
                break;
            case 1:
                $dataArray['湿度控制方式'] = '远程最低湿度';
                break;
            case 2:
                $dataArray['湿度控制方式'] = '远程平均湿度';
                break;
            case 3:
                $dataArray['湿度控制方式'] = '远程最高湿度';
                break;
            default:
                $dataArray['湿度控制方式'] = '未定义';
                break;
        }
        switch ($v[123]) {
            case 0:
                $dataArray['风机控制方式'] = '回风平均温度';
                break;
            case 1:
                $dataArray['风机控制方式'] = '回风最高温度';
                break;
            case 2:
                $dataArray['风机控制方式'] = '回风最低温度';
                break;
            case 3:
                $dataArray['风机控制方式'] = '送风平均温度';
                break;
            case 4:
                $dataArray['风机控制方式'] = '送风最高温度';
                break;
            case 5:
                $dataArray['风机控制方式'] = '送风最低温度';
                break;
            case 6:
                $dataArray['风机控制方式'] = '远程平均温度';
                break;
            case 7:
                $dataArray['风机控制方式'] = '远程最高温度';
                break;
            case 8:
                $dataArray['风机控制方式'] = '远程最低温度';
                break;
            case 9:
                $dataArray['风机控制方式'] = '温差';
                break;
            case 10:
                $dataArray['风机控制方式'] = '风压';
                break;
            default:
                $dataArray['风机控制方式'] = '无效';
                break;
        }
        switch ($v[124]) {
            case 0:
                $dataArray['压缩机控制方式'] = '回风平均温度';
                break;
            case 1:
                $dataArray['压缩机控制方式'] = '回风最高温度';
                break;
            case 2:
                $dataArray['压缩机控制方式'] = '回风最低温度';
                break;
            case 3:
                $dataArray['压缩机控制方式'] = '送风平均温度';
                break;
            case 4:
                $dataArray['压缩机控制方式'] = '送风最高温度';
                break;
            case 5:
                $dataArray['压缩机控制方式'] = '送风最低温度';
                break;
            case 6:
                $dataArray['压缩机控制方式'] = '远程平均温度';
                break;
            case 7:
                $dataArray['压缩机控制方式'] = '远程最高温度';
                break;
            case 8:
                $dataArray['压缩机控制方式'] = '远程最低温度';
                break;
            default:
                $dataArray['风机控制方式'] = '无效';
                break;
        }
        switch ($v[125]) {
            case 0:
                $dataArray['水阀控制方式'] = '回风平均温度';
                break;
            case 1:
                $dataArray['水阀控制方式'] = '回风最高温度';
                break;
            case 2:
                $dataArray['水阀控制方式'] = '回风最低温度';
                break;
            case 3:
                $dataArray['水阀控制方式'] = '送风平均温度';
                break;
            case 4:
                $dataArray['水阀控制方式'] = '送风最高温度';
                break;
            case 5:
                $dataArray['水阀控制方式'] = '送风最低温度';
                break;
            case 6:
                $dataArray['水阀控制方式'] = '远程平均温度';
                break;
            case 7:
                $dataArray['水阀控制方式'] = '远程最高温度';
                break;
            case 8:
                $dataArray['水阀控制方式'] = '远程最低温度';
                break;
            default:
                $dataArray['水阀控制方式'] = '无效';
                break;
        }
        $offset += 125 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
