<?php

function Get_ms19mb_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}

function Get_ms19mb_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定温度']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        case '开关机状态':
            return array(0, $dataArray['开关机状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_ms19mb_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('C*', substr($memData, 4, 112));
        $dataArray['手动模式'] = $v[1] == 0 ? "是" : "否";
        $dataArray['开关机状态'] = $v[2] == 1 ? "开机" : "关机";
        //告警状态 02_09
        $dataArray['风机过载'] = $v[3] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机过载'] = $v[3];
        $dataArray['空气流量低'] = $v[4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['空气流量低'] = $v[4];
        $dataArray['加湿器故障'] = $v[5] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿器故障'] = $v[5];
        $dataArray['电加热过载'] = $v[6] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电加热过载'] = $v[6];
        $dataArray['过滤网堵塞'] = $v[7] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['过滤网堵塞'] = $v[7];
        $dataArray['火警/急停'] = $v[8] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['火警/急停'] = $v[8];
        $dataArray['漏水报警'] = $v[9] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['漏水报警'] = $v[9];
        $dataArray['冷却水流量故障'] = $v[10] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷却水流量故障'] = $v[10];
        //14_18
        $dataArray['相序错误'] = $v[11] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['相序错误'] = $v[11];
        $dataArray['远程开关'] = $v[12] == 0 ? "有信号" : "无信号";
        $dataArray['[主板]压机高压'] = $v[13] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]压机高压'] = $v[13];
        $dataArray['[主板]压机低压'] = $v[14] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]压机低压'] = $v[14];
        $dataArray['[主板]压机过载'] = $v[15] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]压机过载'] = $v[15];
        //20_30
        $dataArray['[2 号扩展板]压机高压'] = $v[16] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]压机高压'] = $v[16];
        $dataArray['[2 号扩展板]压机低压'] = $v[17] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]压机低压'] = $v[17];
        $dataArray['[2 号扩展板]压机过载'] = $v[18] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]压机过载'] = $v[18];
        $dataArray['[2 号扩展板]压机禁用'] = $v[19] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]压机禁用'] = $v[19];
        $dataArray['[主板]变频压机过流'] = $v[20] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机过流'] = $v[20];
        $dataArray['[主板]变频压机欠压'] = $v[21] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机欠压'] = $v[21];
        $dataArray['[主板]变频压机过压'] = $v[22] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机过压'] = $v[22];
        $dataArray['[主板]变频压机过载'] = $v[23] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机过载'] = $v[23];
        $dataArray['[主板]变频压机过热'] = $v[24] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机过热'] = $v[24];
        $dataArray['[主板]电子膨胀阀错误'] = $v[25] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]电子膨胀阀错误'] = $v[25];
        $dataArray['[主板]变频压机启动失败'] = $v[26] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机启动失败'] = $v[26];
        //32_39
        $dataArray['[2 号扩展板]变频压机过流'] = $v[27] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机过流'] = $v[27];
        $dataArray['[2 号扩展板]变频压机欠压'] = $v[28] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机欠压'] = $v[28];
        $dataArray['[2 号扩展板]变频压机过压'] = $v[29] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机过压'] = $v[29];
        $dataArray['[2 号扩展板]变频压机过载'] = $v[30] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机过载'] = $v[30];
        $dataArray['[2 号扩展板]变频压机过热'] = $v[31] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机过热'] = $v[31];
        $dataArray['[2 号扩展板]电子膨胀阀错误'] = $v[32] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]电子膨胀阀错误'] = $v[32];
        $dataArray['[2 号扩展板]变频压机启动失败'] = $v[33] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机启动失败'] = $v[33];
        $dataArray['[2 号扩展板]变频压机通信丢失'] = $v[34] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板]变频压机通信丢失'] = $v[34];
        //41_52
        $dataArray['回风温度高限'] = $v[35] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['回风温度高限'] = $v[35];
        $dataArray['回风温度低限'] = $v[36] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['回风温度低限'] = $v[36];
        $dataArray['回风湿度高限'] = $v[37] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['回风湿度高限'] = $v[37];
        $dataArray['回风湿度低限'] = $v[38] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['回风湿度低限'] = $v[38];
        $dataArray['回风传感器丢失'] = $v[39] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['回风传感器丢失'] = $v[39];
        $dataArray['送风温度高限'] = $v[40] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['送风温度高限'] = $v[40];
        $dataArray['送风温度低限'] = $v[41] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['送风温度低限'] = $v[41];
        $dataArray['送风湿度高限'] = $v[42] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['送风湿度高限'] = $v[42];
        $dataArray['送风湿度低限'] = $v[43] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['送风湿度低限'] = $v[43];
        $dataArray['送风传感器丢失'] = $v[44] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['送风传感器丢失'] = $v[44];
        $dataArray['电压高限'] = $v[45] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电压高限'] = $v[45];
        $dataArray['电压低限'] = $v[46] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电压低限'] = $v[46];
        //55_70
        $dataArray['[主板]变频压机通信丢失'] = $v[47] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[主板]变频压机通信丢失'] = $v[47];
        $dataArray['2 号扩展板丢失'] = $v[48] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['2 号扩展板丢失'] = $v[48];
        $dataArray['干燥过滤器 1 堵塞'] = $v[49] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['干燥过滤器 1 堵塞'] = $v[49];
        $dataArray['干燥过滤器 2 堵塞'] = $v[50] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['干燥过滤器 2 堵塞'] = $v[50];
        //51 JUMP
        $dataArray['主板.EC 风机过载'] = $v[52] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.EC 风机过载'] = $v[52];
        $dataArray['主板.冷冻水 A 水流量报警'] = $v[53] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.冷冻水 A 水流量报警'] = $v[53];

        $dataArray['主板.UPS 模式'] = $v[54] == 0 ? "非UPS模式" : "UPS模式";

        $dataArray['主板.风机 1 转速报警'] = $v[55] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 1 转速报警'] = $v[55];
        $dataArray['主板.风机 2 转速报警'] = $v[56] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 2 转速报警'] = $v[56];
        $dataArray['主板.风机 3 转速报警'] = $v[57] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 3 转速报警'] = $v[57];
        $dataArray['主板.风机 4 转速报警'] = $v[58] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 4 转速报警'] = $v[58];
        $dataArray['主板.风机 5 转速报警'] = $v[59] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 5 转速报警'] = $v[59];
        $dataArray['主板.风机 6 转速报警'] = $v[60] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 6 转速报警'] = $v[60];
        $dataArray['主板.风机 7 转速报警'] = $v[61] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 7 转速报警'] = $v[61];
        $dataArray['主板.风机 8 转速报警'] = $v[62] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.风机 8 转速报警'] = $v[62];
        //78_80
        $dataArray['[2 号扩展板] 风机过载'] = $v[63] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 风机过载'] = $v[63];
        $dataArray['[2 号扩展板] 空气流量低'] = $v[64] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 空气流量低'] = $v[64];
        $dataArray['[2 号扩展板] 过滤网阻塞'] = $v[65] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 过滤网阻塞'] = $v[65];
        //82
        $dataArray['[2 号扩展板] EC 风机故障'] = $v[66] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] EC 风机故障'] = $v[66];
        //85_91
        $dataArray['[3 号扩展板] 压缩机高压报警'] = $v[67] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 压缩机高压报警'] = $v[67];
        $dataArray['[3 号扩展板] 压缩机低压报警'] = $v[68] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 压缩机低压报警'] = $v[68];
        $dataArray['[3 号扩展板] 压缩机过载'] = $v[69] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 压缩机过载'] = $v[69];
        $dataArray['[3 号扩展板] 压机禁用'] = $v[70] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 压机禁用'] = $v[70];
        $dataArray['[3 号扩展板] 风机过载'] = $v[71] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 风机过载'] = $v[71];
        $dataArray['[3 号扩展板] 空气流量低'] = $v[72] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 空气流量低'] = $v[72];
        $dataArray['[3 号扩展板] 过滤网阻塞'] = $v[73] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 过滤网阻塞'] = $v[73];
        //93
        $dataArray['[3 号扩展板] EC 风机故障'] = $v[74] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] EC 风机故障'] = $v[74];
        //96
        $dataArray['[3 号扩展板] 电子膨胀阀错误'] = $v[75] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 电子膨胀阀错误'] = $v[75];
        //98_104
        $dataArray['[4 号扩展板] 压缩机高压报警'] = $v[76] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 压缩机高压报警'] = $v[76];
        $dataArray['[4 号扩展板] 压缩机低压报警'] = $v[77] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 压缩机低压报警'] = $v[77];
        $dataArray['[4 号扩展板] 压缩机过载'] = $v[78] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 压缩机过载'] = $v[78];
        $dataArray['[4 号扩展板] 压机禁用'] = $v[79] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 压机禁用'] = $v[79];
        $dataArray['[4 号扩展板] 风机过载'] = $v[80] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 风机过载'] = $v[80];
        $dataArray['[4 号扩展板] 空气流量低'] = $v[81] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 空气流量低'] = $v[81];
        $dataArray['[4 号扩展板] 过滤网阻塞'] = $v[82] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 过滤网阻塞'] = $v[82];
        //106
        $dataArray['[4 号扩展板] EC 风机故障'] = $v[83] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] EC 风机故障'] = $v[83];
        //109
        $dataArray['[4 号扩展板] 电子膨胀阀错误'] = $v[84] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 电子膨胀阀错误'] = $v[84];
        //177_195
        $dataArray['冷却水流量报警'] = $v[81 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷却水流量报警'] = $v[81 +4];
        $dataArray['冷冻水 A 温度高限'] = $v[82 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷冻水 A 温度高限'] = $v[82 +4];
        $dataArray['冷冻水 A 温度低限'] = $v[83 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷冻水 A 温度低限'] = $v[83 +4];
        $dataArray['冷冻水 B 温度高限'] = $v[84 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷冻水 B 温度高限'] = $v[84 +4];
        $dataArray['冷冻水 B 温度低限'] = $v[85 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷冻水 B 温度低限'] = $v[85 +4];
        $dataArray['冷冻水 B 水流量报警'] = $v[86 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['冷冻水 B 水流量报警'] = $v[86 +4];
        //jump 87
        $dataArray['加湿罐维护提醒'] = $v[88 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['加湿罐维护提醒'] = $v[88 +4];
        $dataArray['主板变频通讯丢失'] = $v[89 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['主板变频通讯丢失'] = $v[89 +4];
        $dataArray['2 号扩展板丢失'] = $v[90 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['2 号扩展板丢失'] = $v[90 +4];
        $dataArray['3 号扩展板丢失'] = $v[91 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['3 号扩展板丢失'] = $v[91 +4];
        $dataArray['4 号扩展板丢失'] = $v[92 +4] == 0 ?"正常" : "告警";
        $dataArray['AlertArray']['4 号扩展板丢失'] = $v[92 +4];
        $dataArray['加湿高水位'] = $v[93 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿高水位'] = $v[93 +4];
        $dataArray['加湿低水位'] = $v[94 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿低水位'] = $v[94 +4];
        $dataArray['加湿电流过大'] = $v[95 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿电流过大'] = $v[95 +4];
        $dataArray['加湿电流过小'] = $v[96 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿电流过小'] = $v[96 +4];
        $dataArray['主板.过热度过高'] = $v[97 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.过热度过高'] = $v[97 +4];
        $dataArray['主板.排气温度过低'] = $v[98 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.排气温度过低'] = $v[98 +4];
        $dataArray['主板.排气温度过高'] = $v[99 +4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['主板.排气温度过高'] = $v[99 +4];
        //201_203
        $dataArray['[2 号扩展板] 过热度过高'] = $v[104] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 过热度过高'] = $v[104];
        $dataArray['[2 号扩展板] 排气温度过低'] = $v[105] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 排气温度过低'] = $v[105];
        $dataArray['[2 号扩展板] 排气温度过低'] = $v[106] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[2 号扩展板] 排气温度过低'] = $v[106];
        //201_203
        $dataArray['[3 号扩展板] 过热度过高'] = $v[107] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 过热度过高'] = $v[107];
        $dataArray['[3 号扩展板] 排气温度过低'] = $v[108] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 排气温度过低'] = $v[108];
        $dataArray['[3 号扩展板] 排气温度过低'] = $v[109] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[3 号扩展板] 排气温度过低'] = $v[109];
        //201_203
        $dataArray['[4 号扩展板] 过热度过高'] = $v[110] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 过热度过高'] = $v[110];
        $dataArray['[4 号扩展板] 排气温度过低'] = $v[111] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 排气温度过低'] = $v[111];
        $dataArray['[4 号扩展板] 排气温度过低'] = $v[112] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['[4 号扩展板] 排气温度过低'] = $v[112];

        $v = unpack('S*', substr($memData, 4 + 112, 2*28));
        $dataArray['设定温度'] = number_format(($v[1] - 400)/10, 2);
        $dataArray['控制模式'] = $v[2] == 0 ? "自动" : "手动";
        $dataArray['软件版本号'] = number_format($v[3]/100, 2);
        $dataArray["系统电压百分比"] = $v[4]."%";
        $dataArray["主板.送风压力 1"] = ($v[5]/10)."Pa";
        $dataArray['冷冻水 1 进水温度'] = number_format(($v[6] - 400)/10, 2)."°C";
        $dataArray['冷冻水 1 出水温度'] = number_format(($v[7] - 400)/10, 2)."°C";
        $dataArray['冷冻水 2 进水温度'] = number_format(($v[8] - 400)/10, 2)."°C";
        $dataArray['冷冻水 2 出水温度'] = number_format(($v[9] - 400)/10, 2)."°C";
        $dataArray['干燥过滤器 1 进口温度'] = number_format(($v[10] - 400)/10, 2)."°C";
        $dataArray['干燥过滤器 1 出口温度'] = number_format(($v[11] - 400)/10, 2)."°C";
        $dataArray['干燥过滤器 2 进口温度'] = number_format(($v[12] - 400)/10, 2)."°C";
        $dataArray['干燥过滤器 2 出口温度'] = number_format(($v[13] - 400)/10, 2)."°C";
        $dataArray['回风温度'] = number_format(($v[14] - 400)/10, 2)."°C";
        $dataArray['回风湿度'] = number_format(($v[15]/10), 1)."%";
        $dataArray['送风温度'] = number_format(($v[16] - 400)/10, 2)."°C";
        $dataArray['送风湿度'] = number_format(($v[17]/10), 1)."%";
        $dataArray['风机运行累加时'] = $v[18]."小时";
        $dataArray['主板.乙二醇温度'] = number_format(($v[19] - 400)/10, 2)."°C";
        $dataArray['电加热 1 运行时间'] = $v[20]."小时";
        $dataArray['电加热 2 运行时间'] = $v[21]."小时";
        $dataArray['电加热 3 运行时间'] = $v[22]."小时";
        $dataArray['加湿器运行累加时'] = $v[23]."小时";
        $dataArray['制冷累加时'] = $v[24]."小时";
        $dataArray['可用加热器数量'] = $v[25];
        $dataArray['可用加湿器数量'] = $v[26];
        $dataArray['可用压缩机数量'] = $v[27];
        $dataArray['可用除湿器数量'] = $v[28];

        $v = unpack('v', substr($memData, 4 + 112 + 2*28, 2));
        $year = $v[1] ;
        $v = unpack('C*', substr($memData, 4 + 112 + 2*28 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
