<?php

function Get_ndq5_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('s*',substr($memData,4,2*17));
        $dataArray["转换次数"] = $v[1];
        $dataArray["常用电源电压Uab"] = $v[2]."V";
        $dataArray["常用电源电压Ubc"] = $v[3]."V";
        $dataArray["常用电源电压Uca"] = $v[4]."V";
        $dataArray["常用电源频率"] = number_format($v[5]/10, 1)."Hz";
        $dataArray["常用电源不平衡度"] = $v[6]."%";

        $dataArray["备用电源电压Uab"] = $v[7]."V";
        $dataArray["备用电源电压Ubc"] = $v[8]."V";
        $dataArray["备用电源电压Uca"] = $v[9]."V";
        $dataArray["备用电源频率"] = number_format($v[10]/10, 1)."Hz";
        $dataArray["备用电源不平衡度"] = $v[11]."%";

        $dataArray["电网状态-备用报警"] = ($v[13] >> 15 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用报警"] = ($v[13] >> 15 & 0x1);
        $dataArray["电网状态-备用不平衡"] = ($v[13] >> 14 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用不平衡"] = ($v[13] >> 14 & 0x1);
        $dataArray["电网状态-备用相序/位"] = ($v[13] >> 13 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用相序/位"] = ($v[13] >> 13 & 0x1);
        $dataArray["电网状态-备用过频"] = ($v[13] >> 12 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用过频"] = ($v[13] >> 12 & 0x1);
        $dataArray["电网状态-备用欠频"] = ($v[13] >> 11 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用欠频"] = ($v[13] >> 11 & 0x1);
        $dataArray["电网状态-备用过压"] = ($v[13] >> 10 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用过压"] = ($v[13] >> 10 & 0x1);
        $dataArray["电网状态-备用欠压"] = ($v[13] >> 9 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用欠压"] = ($v[13] >> 9 & 0x1);
        $dataArray["电网状态-备用断相"] = ($v[13] >> 8 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-备用断相"] = ($v[13] >> 8 & 0x1);

        $dataArray["电网状态-常用报警"] = ($v[13] >> 7 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用报警"] = ($v[7] >> 15 & 0x1);
        $dataArray["电网状态-常用不平衡"] = ($v[13] >> 6 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用不平衡"] = ($v[13] >> 6 & 0x1);
        $dataArray["电网状态-常用相序/位"] = ($v[13] >> 5 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用相序/位"] = ($v[13] >> 5 & 0x1);
        $dataArray["电网状态-常用过频"] = ($v[13] >> 4 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用过频"] = ($v[13] >> 4 & 0x1);
        $dataArray["电网状态-常用欠频"] = ($v[13] >> 3 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用欠频"] = ($v[13] >> 3 & 0x1);
        $dataArray["电网状态-常用过压"] = ($v[13] >> 2 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用过压"] = ($v[13] >> 2 & 0x1);
        $dataArray["电网状态-常用欠压"] = ($v[13] >> 1 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用欠压"] = ($v[13] >> 1 & 0x1);
        $dataArray["电网状态-常用断相"] = ($v[13] >> 0 & 0x1) ? "报警" : "正常";
        $dataArray["AlertArray"]["电网状态-常用断相"] = ($v[13] >> 0 & 0x1);

        $dataArray["温度1"] = $v[14];
        $dataArray["温度2"] = $v[15];
        $dataArray["温度3"] = $v[16];
        $dataArray["温度4"] = $v[17];
        $v = unpack('v',substr($memData, 4 + 2*17, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 2*17 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}


?>
