<?php

function Get_nxr_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray['A相输出电流']);
        case 'B相输出电流':
            return array(0, $dataArray['B相输出电流']);
        case 'C相输出电流':
            return array(0, $dataArray['C相输出电流']);
        case 'A相输出负载百分比':    
            return array(0,$dataArray['整机模块']['A相输出负载百分比']);
        case 'B相输出负载百分比':    
            return array(0,$dataArray['整机模块']['B相输出负载百分比']);
        case 'C相输出负载百分比':    
            return array(0,$dataArray['整机模块']['C相输出负载百分比']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    


function Get_nxr_RtData($memData, &$dataArray, $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['更新时间'] = '无';
            $dataArray['无数据'] = true;
            $dataArray['错误'] = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //tele_c_nxr_41_t  系统模拟量
            $v = unpack('f*', substr($memData, 4, 4 * 11));
            $dataArray['A相输入电压'] = number_format($v[1] , 2).' V';
            $dataArray['B相输入电压'] = number_format($v[2] , 2).' V';
            $dataArray['C相输入电压'] = number_format($v[3] , 2).' V';
            $dataArray['A相输出电压'] = number_format($v[4] , 2).' V';
            $dataArray['B相输出电压'] = number_format($v[5] , 2).' V';
            $dataArray['C相输出电压'] = number_format($v[6] , 2).' V';
            $dataArray['A相输出电流'] = number_format($v[7] , 2).' A';
            $dataArray['B相输出电流'] = number_format($v[8] , 2).' A';
            $dataArray['C相输出电流'] = number_format($v[9] , 2).' A';
            $dataArray['电池组1电池电压'] = number_format($v[10] , 2).' V';
            $dataArray['输出频率'] = number_format($v[11] , 2).' Hz';
            $v = unpack('C*', substr($memData, 4 + 4 * 11, 1*3));
            $dataArray['整机标识电池数量'] = $v[1];
            $dataArray['整机标识温度数量'] = $v[2];
            //$dataArray['用户自定义遥测内容数量'] = $v[3];
            $v = unpack('f*', substr($memData, 4 + 4 * 11 + 1*3, 4*1));
            $dataArray['电池组2电池电压'] = number_format($v[1] , 2).' V';
            //tele_c_nxr_43_t   系统状态
            $v = unpack('C*', substr($memData, 4 + 4 * 12 + 1*3, 27*1));
            switch ($v[1]){
                case 1 : $dataArray['本机架供电方式'] = 'UPS供电'; break;
                case 2 : $dataArray['本机架供电方式'] = '旁路供电'; break;
                case 0xE9 : $dataArray['本机架供电方式'] = '均不供电'; break;
                default : $dataArray['本机架供电方式'] = '无效';
            }
            //$v[2]  用户自定义数量
            switch ($v[3]){
                case 0xE0 : $dataArray['电池组1电池自检'] = '自检中'; break;
                case 0xE1 : $dataArray['电池组1电池自检'] = '没在自检'; break;
                default : $dataArray['电池组1电池自检'] = '无效';
            }
            switch ($v[4]){
                case 0xE0 : $dataArray['电池组1均充/浮充'] = '浮充'; break;
                case 0xE1 : $dataArray['电池组1均充/浮充'] = '均充'; break;
                case 0xE2 : $dataArray['电池组1均充/浮充'] = '非充电状态'; break;
                default : $dataArray['电池组1均充/浮充'] = '无效';
            }
            switch ($v[5]){
                case 0xE0 : $dataArray['整机开机/关机'] = '关机'; break;
                case 0xE1 : $dataArray['整机开机/关机'] = '开机'; break;
                default : $dataArray['整机开机/关机'] = '无效';
            }
            switch ($v[6]){
                case 0xE0 : $dataArray['整流器供电状态'] = '主路逆变供电'; break;
                case 0xE1 : $dataArray['整流器供电状态'] = '电池逆变供电'; break;
                case 0xE2 : $dataArray['整流器供电状态'] = '联合逆变供电'; break;
                case 0xE3 : $dataArray['整流器供电状态'] = '整流电池均不供电'; break;
                default : $dataArray['整流器供电状态'] = '无效';
            }
            switch ($v[7]){
                case 0xE0 : $dataArray['整机发电机接入状态'] = '发电机接入'; break;
                case 0xE1 : $dataArray['整机发电机接入状态'] = '发电机没接入'; break;
                default : $dataArray['整机发电机接入状态'] = '无效';
            }
            switch ($v[8]){
                case 0xE0 : $dataArray['整机输入空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机输入空开状态'] = '闭合'; break;
                default : $dataArray['整机输入空开状态'] = '无效';
            }
            switch ($v[9]){
                case 0xE0 : $dataArray['整机维修旁路空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机维修旁路空开状态'] = '闭合'; break;
                default : $dataArray['整机维修旁路空开状态'] = '无效';
            }
            switch ($v[10]){
                case 0xE0 : $dataArray['整机旁路空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机旁路空开状态'] = '闭合'; break;
                default : $dataArray['整机旁路空开状态'] = '无效';
            }
            switch ($v[11]){
                case 0xE0 : $dataArray['整机输出空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机输出空开状态'] = '闭合'; break;
                default : $dataArray['整机输出空开状态'] = '无效';
            }
            switch ($v[12]){
                case 0xE0 : $dataArray['整机旋转空开状态'] = '关闭状态'; break;
                case 0xE1 : $dataArray['整机旋转空开状态'] = '测试状态'; break;
                case 0xE2 : $dataArray['整机旋转空开状态'] = '正常状态'; break;
                case 0xE3 : $dataArray['整机旋转空开状态'] = '旁路状态'; break;
                case 0xE4 : $dataArray['整机旋转空开状态'] = '维修状态'; break;
                default : $dataArray['整机旋转空开状态'] = '无效';
            }
            switch ($v[13]){
                case 0xE0 : $dataArray['机架并机系统供电状态'] = '均不供电'; break;
                case 0xE1 : $dataArray['机架并机系统供电状态'] = '旁路供电'; break;
                case 0xE2 : $dataArray['机架并机系统供电状态'] = '市电供电'; break;
                case 0xE3 : $dataArray['机架并机系统供电状态'] = '电池逆变供电'; break;
                case 0xE4 : $dataArray['机架并机系统供电状态'] = '联合供电'; break;
                case 0xE5 : $dataArray['机架并机系统供电状态'] = '输出禁止'; break;
                default : $dataArray['机架并机系统供电状态'] = '无效';
            }
            switch ($v[14]){
                case 0xE0 : $dataArray['电池组2电池自检'] = '自检中'; break;
                case 0xE1 : $dataArray['电池组2电池自检'] = '没在自检'; break;
                default : $dataArray['电池组2电池自检'] = '无效';
            }
            switch ($v[15]){
                case 0xE0 : $dataArray['电池组2均充/浮充'] = '浮充'; break;
                case 0xE1 : $dataArray['电池组2均充/浮充'] = '均充'; break;
                case 0xE2 : $dataArray['电池组2均充/浮充'] = '非充电状态'; break;
                default : $dataArray['电池组2均充/浮充'] = '无效';
            }
            $dataArray['模块1在线状态'] = $v[16] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块2在线状态'] = $v[17] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块3在线状态'] = $v[18] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块4在线状态'] = $v[19] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块5在线状态'] = $v[20] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块6在线状态'] = $v[21] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块7在线状态'] = $v[22] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块8在线状态'] = $v[23] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块9在线状态'] = $v[24] == 0xE0 ? '在线' : '不在线';
            $dataArray['模块10在线状态'] = $v[25] == 0xE0 ? '在线' : '不在线';

            $dataArray['变频器模式状态'] = $v[26] == 0xE0 ? '正常模式' : ($v[26] == 0xE1 ? "变频器模式" : '不支持');
            $dataArray['经济模式状态'] = $v[27] == 0xE0 ? '正常模式' : ($v[27] == 0xE1 ? "经济模式" : '不支持');
            //$dataArray['模块11在线状态'] = $v[28] == 0xE0 ? '在线' : '不在线';
            //tele_c_nxr_44_t   系统告警
            $v = unpack('C*', substr($memData, 4 + 4 * 12 + 1*30, 100*1));
            $dataArray['逆变器不同步告警'] = $v[1] == 3 ? '告警' : '正常';
            $dataArray['主路电压异常'] = $v[2] == 0xF0 ? '告警' : '正常';
            $dataArray['整流器故障'] = $v[3] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变器故障'] = $v[4] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路状态（电压或频率）'] = $v[5] == 0xF0 ? '告警' : '正常';
            switch($v[6]){
                case 0xF0: $dataArray['电池组1状态'] = '电压低于下限'; break;
                case 0xF1: $dataArray['电池组1状态'] = '电压高于上限'; break;
                case 0xF2: $dataArray['电池组1状态'] = '电池无'; break;
                case 0xF3: $dataArray['电池组1状态'] = '预告警'; break;
                case 0xF4: $dataArray['电池组1状态'] = '电池接反'; break;
                default : $dataArray['电池组1状态'] = '正常';
            }
            //7 8  标识电池数量    用户自定义告警数量
            $dataArray['功率模块1故障'] = $v[9] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块2故障'] = $v[10] == 0xF0 ? '告警' : '正常';

            $dataArray['AlertArray']['逆变器不同步告警'] = $v[1] == 3;
            $dataArray['AlertArray']['主路电压异常'] = $v[2] == 0xF0;
            $dataArray['AlertArray']['整流器故障'] = $v[3] == 0xF0;
            $dataArray['AlertArray']['逆变器故障'] = $v[4] == 0xF0;
            $dataArray['AlertArray']['旁路状态（电压或频率）'] = $v[5] == 0xF0;
            switch($v[6]){
                case 0xF0:
                case 0xF1:
                case 0xF2:
                case 0xF3:
                case 0xF4: $dataArray['AlertArray']['电池组1状态'] = true;
                default : $dataArray['AlertArray']['电池组1状态'] = false;
            }
            $dataArray['AlertArray']['功率模块1故障'] = $v[9] == 0xF0;
            $dataArray['AlertArray']['功率模块2故障'] = $v[10] == 0xF0;

            $dataArray['功率模块3故障'] = $v[11] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块4故障'] = $v[12] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块5故障'] = $v[13] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块6故障'] = $v[14] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块7故障'] = $v[15] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块8故障'] = $v[16] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块9故障'] = $v[17] == 0xF0 ? '告警' : '正常';
            $dataArray['功率模块10故障'] = $v[18] == 0xF0 ? '告警' : '正常';
            $dataArray['LBS异常'] = $v[19] == 0xF0 ? '告警' : '正常';
            $dataArray['键盘板故障'] = $v[20] == 0xF0 ? '告警' : '正常';
            $dataArray['机型容量无效'] = $v[20] == 0xF1 ? '告警' : '正常';
            $dataArray['AlertArray']['功率模块3故障'] = $v[11] == 0xF0;
            $dataArray['AlertArray']['功率模块4故障'] = $v[12] == 0xF0;
            $dataArray['AlertArray']['功率模块5故障'] = $v[13] == 0xF0;
            $dataArray['AlertArray']['功率模块6故障'] = $v[14] == 0xF0;
            $dataArray['AlertArray']['功率模块7故障'] = $v[15] == 0xF0;
            $dataArray['AlertArray']['功率模块8故障'] = $v[16] == 0xF0;
            $dataArray['AlertArray']['功率模块9故障'] = $v[17] == 0xF0;
            $dataArray['AlertArray']['功率模块10故障'] = $v[18] == 0xF0;
            $dataArray['AlertArray']['LBS异常'] = $v[19] == 0xF0;
            $dataArray['AlertArray']['键盘板故障'] = $v[20] == 0xF0;
            $dataArray['AlertArray']['机型容量无效'] = $v[20] == 0xF1;

            $dataArray['风扇故障'] = $v[21] == 0xF0 ? '告警' : '正常';
            $dataArray['环境温度过高'] = $v[22] == 0xF0 ? '告警' : '正常';
            $dataArray['紧急关机'] = $v[23] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路晶闸管故障'] = $v[24] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路相序反'] = $v[25] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路过流故障'] = $v[26] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路异常关机'] = $v[27] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路切换次数限制'] = $v[28] == 0xF0 ? '告警' : '正常';
            $dataArray['模块并机板故障'] = $v[29] == 0xF0 ? '告警' : '正常';
            $dataArray['模块并机线连接故障'] = $v[30] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['风扇故障'] = $v[21] == 0xF0;
            $dataArray['AlertArray']['环境温度过高'] = $v[22] == 0xF0;
            $dataArray['AlertArray']['紧急关机'] = $v[23] == 0xF0;
            $dataArray['AlertArray']['旁路晶闸管故障'] = $v[24] == 0xF0;
            $dataArray['AlertArray']['旁路相序反'] = $v[25] == 0xF0;
            $dataArray['AlertArray']['旁路过流故障'] = $v[26] == 0xF0;
            $dataArray['AlertArray']['旁路异常关机'] = $v[27] == 0xF0;
            $dataArray['AlertArray']['旁路切换次数限制'] = $v[28] == 0xF0;
            $dataArray['AlertArray']['模块并机板故障'] = $v[29] == 0xF0;
            $dataArray['AlertArray']['模块并机线连接故障'] = $v[30] == 0xF0;

            $dataArray['模块并机通讯故障'] = $v[31] == 0xF0 ? '告警' : '正常';
            $dataArray['辅助电源2掉电'] = $v[32] == 0xF0 ? '告警' : '正常';
            $dataArray['接触器电源板1故障'] = $v[33] == 0xF0 ? '告警' : '正常';
            $dataArray['接触器电源板2故障'] = $v[34] == 0xF0 ? '告警' : '正常';
            $dataArray['冗余风扇电源故障'] = $v[35] == 0xF0 ? '告警' : '正常';
            switch($v[36]){
                case 0: $dataArray['BCB接入情况'] = 'BCB未接入'; break;
                case 0xF0: $dataArray['BCB接入情况'] = 'BCB闭合'; break;
                case 0xF1: $dataArray['BCB接入情况'] = 'BCB断开'; break;
                default: $dataArray['BCB接入情况'] = '无效';
            }
            $dataArray['电池组1接触器故障'] = $v[37] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2接触器故障'] = $v[38] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组1变换器故障'] = $v[39] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2变换器故障'] = $v[40] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['模块并机通讯故障'] = $v[31] == 0xF0;
            $dataArray['AlertArray']['辅助电源2掉电'] = $v[32] == 0xF0;
            $dataArray['AlertArray']['接触器电源板1故障'] = $v[33] == 0xF0;
            $dataArray['AlertArray']['接触器电源板2故障'] = $v[34] == 0xF0;
            $dataArray['AlertArray']['冗余风扇电源故障'] = $v[35] == 0xF0;
            $dataArray['AlertArray']['电池组1接触器故障'] = $v[37] == 0xF0;
            $dataArray['AlertArray']['电池组2接触器故障'] = $v[38] == 0xF0;
            $dataArray['AlertArray']['电池组1变换器故障'] = $v[39] == 0xF0;
            $dataArray['AlertArray']['电池组2变换器故障'] = $v[40] == 0xF0;

            $dataArray['电池组1变换器过流'] = $v[41] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2变换器过流'] = $v[42] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组1变换器过温'] = $v[43] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2变换器过温'] = $v[44] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组1充电器故障'] = $v[45] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2充电器故障'] = $v[46] == 0xF0 ? '告警' : '正常';
            if($v[47] == 0xF0){
                $dataArray['电池组1寿命情况'] = '电池需更换';
            }else if($v[47] == 0xF1){
                $dataArray['电池组1寿命情况'] = '电池寿命终结';
            }else{
                $dataArray['电池组1寿命情况'] = '正常';
            }
            if($v[48] == 0xF0){
                $dataArray['电池组2寿命情况'] = '电池需更换';
            }else if($v[48] == 0xF1){
                $dataArray['电池组2寿命情况'] = '电池寿命终结';
            }else{
                $dataArray['电池组2寿命情况'] = '正常';
            }
            $dataArray['电池组1温度过高'] = $v[49] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2温度过高'] = $v[50] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['电池组1变换器过流'] = $v[41] == 0xF0;
            $dataArray['AlertArray']['电池组2变换器过流'] = $v[42] == 0xF0;
            $dataArray['AlertArray']['电池组1变换器过温'] = $v[43] == 0xF0;
            $dataArray['AlertArray']['电池组2变换器过温'] = $v[44] == 0xF0;
            $dataArray['AlertArray']['电池组1充电器故障'] = $v[45] == 0xF0;
            $dataArray['AlertArray']['电池组2充电器故障'] = $v[46] == 0xF0;
            if($v[47] == 0xF0 || $v[47] == 0xF1){
                $dataArray['AlertArray']['电池组1寿命情况'] = true;
            }else{
                $dataArray['AlertArray']['电池组1寿命情况'] = false;
            }
            if($v[48] == 0xF0 || $v[48] == 0xF1){
                $dataArray['AlertArray']['电池组2寿命情况'] = true;
            }else{
                $dataArray['AlertArray']['电池组2寿命情况'] = false;
            }
            $dataArray['AlertArray']['电池组1温度过高'] = $v[49] == 0xF0;
            $dataArray['AlertArray']['电池组2温度过高'] = $v[50] == 0xF0;

            $dataArray['电池组1接地故障'] = $v[51] == 0xF0 ? '告警' : '正常';
            $dataArray['电池组2接地故障'] = $v[52] == 0xF0 ? '告警' : '正常';
            $dataArray['主路频率异常'] = $v[53] == 0xF0 ? '告警' : '正常';
            $dataArray['平衡电感过温'] = $v[54] == 0xF0 ? '告警' : '正常';
            $dataArray['输入电感过温'] = $v[55] == 0xF0 ? '告警' : '正常';
            $dataArray['整流器过温'] = $v[56] == 0xF0 ? '告警' : '正常';
            $dataArray['平衡电路故障'] = $v[57] == 0xF0 ? '告警' : '正常';
            $dataArray['平衡电路过流'] = $v[58] == 0xF0 ? '告警' : '正常';
            $dataArray['主路熔丝断'] = $v[59] == 0xF0 ? '告警' : '正常';
            $dataArray['辅助电源1掉电'] = $v[60] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['电池组1接地故障'] = $v[51] == 0xF0;
            $dataArray['AlertArray']['电池组2接地故障'] = $v[52] == 0xF0;
            $dataArray['AlertArray']['主路频率异常'] = $v[53] == 0xF0;
            $dataArray['AlertArray']['平衡电感过温'] = $v[54] == 0xF0;
            $dataArray['AlertArray']['输入电感过温'] = $v[55] == 0xF0;
            $dataArray['AlertArray']['整流器过温'] = $v[56] == 0xF0;
            $dataArray['AlertArray']['平衡电路故障'] = $v[57] == 0xF0;
            $dataArray['AlertArray']['平衡电路过流'] = $v[58] == 0xF0;
            $dataArray['AlertArray']['主路熔丝断'] = $v[59] == 0xF0;
            $dataArray['AlertArray']['辅助电源1掉电'] = $v[60] == 0xF0;

            $dataArray['主路相序反'] = $v[61] == 0xF0 ? '告警' : '正常';
            $dataArray['整流器过流'] = $v[62] == 0xF0 ? '告警' : '正常';
            $dataArray['软启动失败'] = $v[63] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变电感过温'] = $v[64] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变器过温'] = $v[65] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变晶闸管故障'] = $v[66] == 0xF0 ? '告警' : '正常';
            $dataArray['用户操作错误'] = $v[67] == 0xF0 ? '告警' : '正常';
            $dataArray['输出熔丝断'] = $v[68] == 0xF0 ? '告警' : '正常';
            $dataArray['单机输出过载'] = $v[69] == 0xF0 ? '告警' : '正常';
            $dataArray['并机系统过载'] = $v[70] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['主路相序反'] = $v[61] == 0xF0;
            $dataArray['AlertArray']['整流器过流'] = $v[62] == 0xF0;
            $dataArray['AlertArray']['软启动失败'] = $v[63] == 0xF0;
            $dataArray['AlertArray']['逆变电感过温'] = $v[64] == 0xF0;
            $dataArray['AlertArray']['逆变器过温'] = $v[65] == 0xF0;
            $dataArray['AlertArray']['逆变晶闸管故障'] = $v[66] == 0xF0;
            $dataArray['AlertArray']['用户操作错误'] = $v[67] == 0xF0;
            $dataArray['AlertArray']['输出熔丝断'] = $v[68] == 0xF0;
            $dataArray['AlertArray']['单机输出过载'] = $v[69] == 0xF0;
            $dataArray['AlertArray']['并机系统过载'] = $v[70] == 0xF0;

            $dataArray['单机过载超时'] = $v[71] == 0xF0 ? '告警' : '正常';
            $dataArray['交流输出过压'] = $v[72] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变器过流'] = $v[73] == 0xF0 ? '告警' : '正常';
            $dataArray['负载冲击转旁路'] = $v[74] == 0xF0 ? '告警' : '正常';
            $dataArray['并机均流故障'] = $v[75] == 0xF0 ? '告警' : '正常';
            $dataArray['母线异常关机'] = $v[76] == 0xF0 ? '告警' : '正常';
            $dataArray['邻机请求转旁路'] = $v[77] == 0xF0 ? '告警' : '正常';
            $dataArray['直流母线过压故障'] = $v[78] == 0xF0 ? '告警' : '正常';
            $dataArray['整流通讯故障'] = $v[79] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变通讯故障'] = $v[80] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['单机过载超时'] = $v[71] == 0xF0;
            $dataArray['AlertArray']['交流输出过压'] = $v[72] == 0xF0;
            $dataArray['AlertArray']['逆变器过流'] = $v[73] == 0xF0;
            $dataArray['AlertArray']['负载冲击转旁路'] = $v[74] == 0xF0;
            $dataArray['AlertArray']['并机均流故障'] = $v[75] == 0xF0;
            $dataArray['AlertArray']['母线异常关机'] = $v[76] == 0xF0;
            $dataArray['AlertArray']['邻机请求转旁路'] = $v[77] == 0xF0;
            $dataArray['AlertArray']['直流母线过压故障'] = $v[78] == 0xF0;
            $dataArray['AlertArray']['整流通讯故障'] = $v[79] == 0xF0;
            $dataArray['AlertArray']['逆变通讯故障'] = $v[80] == 0xF0;

            $dataArray['输出直流分量过大故障'] = $v[81] == 0xF0 ? '告警' : '正常';
            $dataArray['并机系统电池预告警'] = $v[82] == 0xF0 ? '告警' : '正常';
            $dataArray['输入缺零故障'] = $v[83] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变接触器故障'] = $v[84] == 0xF0 ? '告警' : '正常';
            $dataArray['输入接触器故障'] = $v[85] == 0xF0 ? '告警' : '正常';
            $dataArray['输入电流异常'] = $v[86] == 0xF0 ? '告警' : '正常';
            $dataArray['输出电压异常'] = $v[87] == 0xF0 ? '告警' : '正常';
            $dataArray['输入电流超限'] = $v[88] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路过温'] = $v[89] == 0xF0 ? '告警' : '正常';
            $dataArray['邻机晶闸管故障'] = $v[90] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['输出直流分量过大故障'] = $v[81] == 0xF0;
            $dataArray['AlertArray']['并机系统电池预告警'] = $v[82] == 0xF0;
            $dataArray['AlertArray']['输入缺零故障'] = $v[83] == 0xF0;
            $dataArray['AlertArray']['逆变接触器故障'] = $v[84] == 0xF0;
            $dataArray['AlertArray']['输入接触器故障'] = $v[85] == 0xF0;
            $dataArray['AlertArray']['输入电流异常'] = $v[86] == 0xF0;
            $dataArray['AlertArray']['输出电压异常'] = $v[87] == 0xF0;
            $dataArray['AlertArray']['输入电流超限'] = $v[88] == 0xF0;
            $dataArray['AlertArray']['旁路过温'] = $v[89] == 0xF0;
            $dataArray['AlertArray']['邻机晶闸管故障'] = $v[90] == 0xF0;

            $dataArray['外部输入隔离变压器过温'] = $v[91] == 0xF0 ? '告警' : '正常';
            $dataArray['外部输入隔离变压器风扇故障'] = $v[92] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['外部输入隔离变压器过温'] = $v[91] == 0xF0;
            $dataArray['AlertArray']['外部输入隔离变压器风扇故障'] = $v[92] == 0xF0;

            $dataArray['旁路柜变压器过温'] = $v[93] == 0xF0 ? '告警' : '正常';
            $dataArray['上抽风外接风扇故障'] = $v[94] == 0xF0 ? '告警' : '正常';
            $dataArray['冗余消失故障'] = $v[95] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['旁路柜变压器过温'] = $v[91] == 0xF0;
            $dataArray['AlertArray']['上抽风外接风扇故障'] = $v[92] == 0xF0;
            $dataArray['AlertArray']['冗余消失故障'] = $v[95] == 0xF0;

            //tele_c_nxr_e1_t   模块数据1
            $offset = (4 + 4 * 12 + 1*130);
            for($i = 0 ; $i < 11 ; $i++){
                $module = '';
                if($i == 0){
                    $module = '整机模块';
                    $dataArray['整机模块'] = array();

                }else{
                    if($dataArray['模块'.$i.'在线状态'] == '在线'){
                        $module = '模块'.$i;
                        $dataArray[$module] = array();
                    }
                }
                if($module != ''){
                    $v = unpack('C*', substr($memData, $offset, 2*1));
                    $dataArray[$module]['模块号'] = $v[1];
                    //$dataArray[$module]['模拟量个数'] = $v[2];
                    $v = unpack('f*', substr($memData, $offset + 2*1, 4*14));
                    $dataArray[$module]['交流输入线电压AB'] = number_format($v[1] , 2).' V';
                    $dataArray[$module]['交流输入线电压BC'] = number_format($v[2] , 2).' V';
                    $dataArray[$module]['交流输入线电压CA'] = number_format($v[3] , 2).' V';
                    $dataArray[$module]['A相输入电流'] = number_format($v[4] , 2).' A';
                    $dataArray[$module]['B相输入电流'] = number_format($v[5] , 2).' A';
                    $dataArray[$module]['C相输入电流'] = number_format($v[6] , 2).' A';
                    $dataArray[$module]['输入频率'] = number_format($v[7] , 2).' Hz';
                    $dataArray[$module]['A相输入功率因数'] = number_format($v[8] , 2);
                    $dataArray[$module]['B相输入功率因数'] = number_format($v[9] , 2);
                    $dataArray[$module]['C相输入功率因数'] = number_format($v[10] , 2);
                    $dataArray[$module]['A相旁路电压'] = number_format($v[11] , 2).' V';
                    $dataArray[$module]['B相旁路电压'] = number_format($v[12] , 2).' V';
                    $dataArray[$module]['C相旁路电压'] = number_format($v[13] , 2).' V';
                    $dataArray[$module]['旁路频率'] = number_format($v[14] , 2).' Hz';
                }
                $offset += 58;
            }
            //tele_c_nxr_e2_t   模块数据2
            for($i = 0 ; $i < 11 ;$i++){
                $module = '模块'.$i;
                if($i == 0){
                    $module = '整机模块';
                }
                if(isset($dataArray[$module])){
                    $v = unpack('C*',substr($memData, $offset, 2*1));
                    //$dataArray[$module]['模块号'] = $v[1];
                    //$dataArray[$module]['模拟量个数'] = $v[2];
                    $v = unpack('f*', substr($memData, $offset + 2*1, 4*18));
                    $dataArray[$module]['A相输出功率因数'] = number_format($v[1] , 2);
                    $dataArray[$module]['B相输出功率因数'] = number_format($v[2] , 2);
                    $dataArray[$module]['C相输出功率因数'] = number_format($v[3] , 2);
                    $dataArray[$module]['A相输出峰值比'] = number_format($v[4] , 2);
                    $dataArray[$module]['B相输出峰值比'] = number_format($v[5] , 2);
                    $dataArray[$module]['C相输出峰值比'] = number_format($v[6] , 2);
                    $dataArray[$module]['A相输出有功功率'] = number_format($v[7] , 2).' KW';
                    $dataArray[$module]['B相输出有功功率'] = number_format($v[8] , 2).' KW';
                    $dataArray[$module]['C相输出有功功率'] = number_format($v[9] , 2).' KW';
                    $dataArray[$module]['A相输出无功功率'] = number_format($v[10] , 2).' KVA';
                    $dataArray[$module]['B相输出无功功率'] = number_format($v[11] , 2).' KVA';
                    $dataArray[$module]['C相输出无功功率'] = number_format($v[12] , 2).' KVA';
                    $dataArray[$module]['A相输出视在功率'] = number_format($v[13] , 2).' KVAR';
                    $dataArray[$module]['B相输出视在功率'] = number_format($v[14] , 2).' KVAR';
                    $dataArray[$module]['C相输出视在功率'] = number_format($v[15] , 2).' KVAR';
                    $dataArray[$module]['A相输出负载百分比'] = number_format($v[16] , 2).' %';
                    $dataArray[$module]['B相输出负载百分比'] = number_format($v[17] , 2).' %';
                    $dataArray[$module]['C相输出负载百分比'] = number_format($v[18] , 2).' %';
                }
                $offset += 74;
            }
            $v = unpack('v', substr($memData, $offset, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, $offset + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
