<?php 
function Get_P127_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总功率]":
            return array(0, $dataArray["总有功功率2"]);
         case "高压配电屏相电流Ia":
            return array(0, $dataArray["A相电流(A)"]); 
        case "高压配电屏相电流Ib":
            return array(0, $dataArray["B相电流(A)"]);
        case "高压配电屏相电流Ic":
            return array(0, $dataArray["C相电流(A)"]);
        case "高压配电屏零序电流":
            return array(0, $dataArray["零序电流(A)"]);
        case "高压配电屏频率":
            return array(0, $dataArray["频率(Hz)"]);
        case "高压配电屏正向有功电能":
            return array(0, $dataArray["正向有功电度(kwh)"]);
        case "高压配电屏正向无功电能":
            return array(0, $dataArray["正向无功电度(kvarh)"]);
         case "高压配电屏相电压Ua":
            return array(0, $dataArray["A相电压(kv)"]);
        case "高压配电屏相电压Ub":
            return array(0, $dataArray["B相电压(kv)"]);
        case "高压配电屏相电压Uc":
            return array(0, $dataArray["C相电压(kv)"]);
        case "高压配电屏功率因素":
            return array(0, $dataArray["三相功率因数"]);
         case "高压配电屏AB线电压":
            return array(0, $dataArray["UAB幅值(kv)"]);
        case "高压配电屏BC线电压":
            return array(0, $dataArray["UBC幅值(kv)"]);
        case "高压配电屏CA线电压":
            return array(0, $dataArray["UCA幅值(kv)"]);
           
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_P127_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电度(kwh)']);
}

function Get_P127_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('s*', substr($memData, 4, 2*2));
        $dataArray["openInStatus"] = $v[1];
        $dataArray["openOutStatus"] = $v[2];
        $v = unpack('i*', substr($memData, 8, 4*4));
        $dataArray["A相电流(A)"] = $v[1] / 100;
        $dataArray["B相电流(A)"] = $v[2] / 100;
        $dataArray["C相电流(A)"] = $v[3] / 100;
        $dataArray["零序电流(A)"] = $v[4] / 100;
        $v = unpack('S*', substr($memData, 24, 2));
        $dataArray["频率(Hz)"] = $v[1] / 100;
        $v = unpack('I*', substr($memData, 26, 4*8));
        $dataArray["正向有功电度(kwh)"] = $v[1];
        $dataArray["反向有功电度(kwh)"] = $v[2];
        $dataArray["正向无功电度(kvarh)"] = $v[3];
        $dataArray["反向无功电度(kvarh)"] = $v[4];
        $dataArray["A相电压(kv)"] = number_format($v[5] / 100000,2);
        $dataArray["B相电压(kv)"] = number_format($v[6] / 100000,2);
        $dataArray["C相电压(kv)"] = number_format($v[7] / 100000,2);
        $dataArray["平均电压(kv)"] = number_format($v[8] / 100000,2);
        $v = unpack('S*', substr($memData, 58, 2*3));
        $uab = $v[1] / 100000;
        $ubc = $v[2] / 100000;
        $uca = $v[3] / 100000;
        $v = unpack('i*', substr($memData, 64, 4*2));
        $dataArray["三相有功(kw)"] = $v[1] / 100;
        $dataArray["总有功功率2"] = $v[1] / 100;
        $dataArray["三相无功(kvar)"] = $v[2] / 100;
        $v = unpack('s*', substr($memData, 72, 2*5));
        $dataArray["三相功率因数"] = $v[1] / 100;
        $dataArray["CT_1"] = $v[2];
        $dataArray["CT_2"] = $v[3];
        $dataArray["CT0_1"] = $v[4];
        $dataArray["CT0_2"] = $v[5];

        $dataArray["UAB幅值(kv)"]  = number_format($uab * 1.6 * ($dataArray["CT_1"] / $dataArray["CT_2"]),2);
        $dataArray["UBC幅值(kv)"] = number_format($ubc * 1.6 * ($dataArray["CT_1"] / $dataArray["CT_2"]),2);
        $dataArray["UCA幅值(kv)"] = number_format($uca * 1.6 * ($dataArray["CT_1"] / $dataArray["CT_2"]),2);

        $v = unpack('v', substr($memData, 72 + 2*5, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  72 + 2*5 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
