<?php
function Get_pa2000_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压']);
	 case '[A相电流]':
            return array(0, $dataArray['A相电流']);
        case '[B相电流]':
            return array(0, $dataArray['B相电流']);
        case '[C相电流]':
            return array(0, $dataArray['C相电流']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pa2000_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}


function Get_pa2000_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData))
    {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        //PA2000_REG_0_13_t
        $v = unpack('S*',substr($memData, 4, 2*5));
        switch($v[1])
        {
            case 1:
                $dataArray["输入网络"] = "单相输入";
                break;
            case 2:
                $dataArray["输入网络"] = "三相三线输入";
                break;
            case 3:
                $dataArray["输入网络"] = "三相四线输入";
                break;
        }
        switch($v[2])
        {
            case 1:
                $dataArray["电压输入范围"] = "100 V";
                break;
            case 2:
                $dataArray["电压输入范围"] = "220 V";
                break;
            case 3:
                $dataArray["电压输入范围"] = "380 V";
                break;
        }
        $dataArray["电流类型"] = $v[3] == 1 ? "1 A" : "5 A";
        $dataArray["电压变比"] = $v[4];
        $dataArray["电流变比"] = $v[5];
        //PA2000_F8_12A_t
        $v = unpack('f*',substr($memData, 4 + 2*5, 30*4));
        $dataArray["A相相电压"] = number_format($v[1], 2)." V";
        $dataArray["B相相电压"] = number_format($v[2], 2)." V";
        $dataArray["C相相电压"] = number_format($v[3], 2)." V";
        $dataArray["AB线电压"] = number_format($v[4], 2)." V";
        $dataArray["A相线电压"] = number_format($v[4], 2);
        $dataArray["BC线电压"] = number_format($v[5], 2)." V";
        $dataArray["B相线电压"] = number_format($v[5], 2);
        $dataArray["CA线电压"] = number_format($v[6], 2)." V";
        $dataArray["C相线电压"] = number_format($v[6], 2);
        $dataArray["频率"] = number_format($v[7], 2)." Hz";
        $dataArray["A相电流"] = number_format($v[8], 2)." A";
        $dataArray["B相电流"] = number_format($v[9], 2)." A";
        $dataArray["C相电流"] = number_format($v[10], 2)." A";

        $dataArray["A相有功功率"] = number_format($v[11], 2)." W";
        $dataArray["B相有功功率"] = number_format($v[12], 2)." W";
        $dataArray["C相有功功率"] = number_format($v[13], 2)." W";
        $dataArray["总有功功率"] = number_format($v[14], 2)." W";
        $dataArray["总有功功率2"] = number_format($v[14]/1000, 3,'.','');

        $dataArray["A相无功功率"] = number_format($v[15], 2)." Var";
        $dataArray["B相无功功率"] = number_format($v[16], 2)." Var";
        $dataArray["C相无功功率"] = number_format($v[17], 2)." Var";
        $dataArray["总无功功率"] = number_format($v[18], 2)." Var";

        $dataArray["A相视在功率"] = number_format($v[19], 2)." VA";
        $dataArray["B相视在功率"] = number_format($v[20], 2)." VA";
        $dataArray["C相视在功率"] = number_format($v[21], 2)." VA";
        $dataArray["总视在功率"] = number_format($v[22], 2)." VA";

        $dataArray["A相功率因数"] = number_format($v[23], 2);
        $dataArray["B相功率因数"] = number_format($v[24], 2);
        $dataArray["C相功率因数"] = number_format($v[25], 2);
        $dataArray["总功率因数"] = number_format($v[26], 2);

        $dataArray["正向有功电能"] = number_format($v[27], 2,'.','')." KWh";
        $dataArray["正向有功电能2"] = number_format($v[27], 2,'.','');
        $dataArray["反向有功电能"] = number_format($v[28], 2,'.','')." KWh";
        $dataArray["正向无功电能"] = number_format($v[29], 2,'.','')." Kvarh";
        $dataArray["反向无功电能"] = number_format($v[30], 2,'.','')." Kvarh";

        $v = unpack('v', substr($memData, 4 + 2*5 + 30*4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*5 + 30*4 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }

}
