<?php

function Get_pcc2110_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $v = unpack('C', substr($memData, 4, 16));
        $dataArray["机组名"] = $v;
        $v = unpack('S*', substr($memData, 4 + 16, 82));
        $dataArray["型号"] = $v[1];
        $dataArray["控制状态"] = $v[2];
        $dataArray["状态"] = $v[3];
        $dataArray["错误代码"] = $v[4];
        $dataArray["错误类型"] = $v[5];
        $dataArray["功率百分比"] = $v[6];
        $dataArray["总功率"] = $v[7];
        //NFPA 8
        $dataArray["油机告警"] = ($v[8] >> 15) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油机告警"] = ($v[8] >> 15) & 0x1;
        $dataArray["油机对负载供电"] = ($v[8] >> 14) & 0x1 ? "供电" : "正常";
        $dataArray["AlertArray"]["油机对负载供电"] = ($v[8] >> 14) & 0x1;
        $dataArray["油机启动"] = ($v[8] >> 13) & 0x1 ? "启动" : "未启动";
        $dataArray["AlertArray"]["油机启动"] = ($v[8] >> 13) & 0x1;
        $dataArray["手动控制状态"] = ($v[8] >> 12) & 0x1 ? "手工" : "自动";
        $dataArray["AlertArray"]["手动控制状态"] = ($v[8] >> 12) & 0x1;

        $dataArray["启动电池电压高"] = ($v[8] >> 11) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动电池电压高"] = ($v[8] >> 11) & 0x1;
        $dataArray["启动电池电压低"] = ($v[8] >> 10) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动电池电压低"] = ($v[8] >> 10) & 0x1;
        $dataArray["充电器故障"] = ($v[8] >> 9) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["充电器故障"] = ($v[8] >> 9) & 0x1;
        $dataArray["启动失败故障"] = ($v[8] >> 8) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动失败故障"] = ($v[8] >> 8) & 0x1;

        $dataArray["冷却液温度低"] = ($v[8] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["冷却液温度低"] = ($v[8] >> 7) & 0x1;
        $dataArray["将要高温"] = ($v[8] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["将要高温"] = ($v[8] >> 6) & 0x1;
        $dataArray["高温告警"] = ($v[8] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["高温告警"] = ($v[8] >> 5) & 0x1;
        $dataArray["将要油压低"] = ($v[8] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["将要油压低"] = ($v[8] >> 4) & 0x1;

        $dataArray["油压低"] = ($v[8] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油压低"] = ($v[8] >> 3) & 0x1;
        $dataArray["超速停机"] = ($v[8] >>2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["超速停机"] = ($v[8] >> 2) & 0x1;
        $dataArray["冷却液液位低"] = ($v[8] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["冷却液液位低"] = ($v[8] >> 1) & 0x1;
        $dataArray["燃油液位低"] = ($v[8]) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["燃油液位低"] = ($v[8]) & 0x1;
        //Extend 9
        $dataArray["检修油机"] = ($v[9] >> 15) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["检修油机"] = ($v[9] >> 15) & 0x1;
        $dataArray["接地故障"] = ($v[9] >> 14) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["接地故障"] = ($v[9] >> 14) & 0x1;
        $dataArray["市电电压高"] = ($v[9] >> 13) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["市电电压高"] = ($v[9] >> 13) & 0x1;
        $dataArray["市电电压低"] = ($v[9] >> 12) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["市电电压低"] = ($v[9] >> 12) & 0x1;

        $dataArray["输出频率低"] = ($v[9] >> 11) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["输出频率低"] = ($v[9] >> 11) & 0x1;
        $dataArray["输出过载告警"] = ($v[9] >> 10) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["输出过载告警"] = ($v[9] >> 10) & 0x1;
        $dataArray["过流告警"] = ($v[9] >> 9) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["过流告警"] = ($v[9] >> 9) & 0x1;
        $dataArray["短路告警"] = ($v[9] >> 8) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["短路告警"] = ($v[9] >> 8) & 0x1;

        $dataArray["反向功率告警"] = ($v[9] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["反向功率告警"] = ($v[9] >> 7) & 0x1;
        $dataArray["反向无功功率告警"] = ($v[9] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["反向无功功率告警"] = ($v[9] >> 6) & 0x1;
        $dataArray["同步失败"] = ($v[9] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["同步失败"] = ($v[9] >> 5) & 0x1;
        $dataArray["关机失败"] = ($v[9] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["关机失败"] = ($v[9] >> 4) & 0x1;

        $dataArray["负载请求"] = ($v[9] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["负载请求"] = ($v[9] >> 3) & 0x1;
        $dataArray["发电机组断路器跳闸"] = ($v[9] >> 2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["发电机组断路器跳闸"] = ($v[9] >> 2) & 0x1;
        $dataArray["断路器跳闸"] = ($v[9] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["断路器跳闸"] = ($v[9] >> 1) & 0x1;
        $dataArray["油机紧急停机"] = ($v[9]) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油机紧急停机"] = ($v[9]) & 0x1;

        $acArray = array();
        $acArray["频率"] = $v[10];
        $acArray["功率因数"] = $v[11] == 0x7FFF ? "不支持" : $v[11];
        $acArray["视在功率"] = $v[12];
        $acArray["有功功率"] = $v[13];
        $acArray["无功功率"] = $v[14];
        $acArray["AB线电压"] = $v[15];
        $acArray["BC线电压"] = $v[16];
        $acArray["CA线电压"] = $v[17];
        $acArray["A相电压"] = $v[18];
        $acArray["B相电压"] = $v[19];
        $acArray["C相电压"] = $v[20];
        $acArray["A相电流"] = $v[21];
        $acArray["B相电流"] = $v[22];
        $acArray["C相电流"] = $v[23];
        $acArray["A相电流百分比"] = $v[24];
        $acArray["B相电流百分比"] = $v[25];
        $acArray["C相电流百分比"] = $v[26];
        $dataArray["交流数据"] = $acArray;

        $genArray = array();
        $dataArray["电池电压"] = $genArray["电池电压"] = number_format($v[27]/10, 1)."V";
        $genArray["油压"] = number_format($v[28]/10, 1)."KPA";
        $genArray["油温"] = $v[29] == 0xFFFF ? "不支持" : number_format($v[29]/10, 1)."℃";
        $genArray["冷却液温度"] = number_format($v[30]/100, 2)."℃";
        $genArray["其他温度1"] = number_format($v[31]/100, 2)."℃";
        $genArray["其他温度2"] = number_format($v[32]/100, 2)."℃";
        $genArray["油速"] = $v[33];
        $genArray["转速"] = $v[34];
        $genArray["启动状态"] = $v[35] == 0 ? "启动" : "未启动";
        $genArray["运行时长"] = intval($v[36]) * 2**16 +  intval($v[37]). "秒";
        $genArray["总电能"] = $v[38] * 2**16 +  $v[39];
        $genArray["总燃料"] = $v[40] * 2**16 +  $v[41];
        $dataArray["油机数据"] = $genArray;
        $v = unpack('v',substr($memData, 4 + 16 + 82, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 16 + 82 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
