<?php
function Get_pd1688z_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2']);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2']);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pd1688z_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}

function Get_pd1688z_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //PD1688Z_REG_12D_134_t
        $v = unpack("S*",substr($memData , 4 , 8 * 2));
        $dataArray['设备地址'] = $v[1];
        $dataArray['电压变比'] = $PT = $v[2];
        $dataArray['电流变比'] = $CT = $v[3];
        $dataArray['波特率'] = 1200 * (pow(2, $v[4])).' bps';
        switch($v[5]){
            case 0: $dataArray['通讯数据格式'] = 'N.8.1'; break;
            case 1: $dataArray['通讯数据格式'] = 'O.8.1'; break;
            case 2: $dataArray['通讯数据格式'] = 'E.8.1'; break;
            default: $dataArray['通讯数据格式'] = '无效';
        }
        switch($v[6]){
            case 0: $dataArray['接线方式'] = '三项四线'; break;
            case 1: $dataArray['接线方式'] = '三项三线'; break;
            default: $dataArray['接线方式'] = '无效';
        }
        switch($v[7]){
            case 0: $dataArray['电压量程'] = '100 V'; break;
            case 1: $dataArray['电压量程'] = '220 V'; break;
            case 2: $dataArray['电压量程'] = '380 V'; break;
            default: $dataArray['电压量程'] = '无效';
        }
        switch($v[8]){
            case 0: $dataArray['电流量程'] = '5 A'; break;
            case 1: $dataArray['电流量程'] = '1 A'; break;
            default: $dataArray['电流量程'] = '无效';
        }
        //PD1688Z_REG_46_5F_t
        $v = unpack("S*",substr($memData , 4 + 8*2 , 9 * 2));
        $dataArray['A相电压'] = ($v[1] * $PT / 10).' V';
        $dataArray['B相电压'] = ($v[2] * $PT / 10).' V';
        $dataArray['C相电压'] = ($v[3] * $PT / 10).' V';
        $dataArray['AB线电压'] = ($v[4] * $PT / 10).' V';
        $dataArray['BC线电压'] = ($v[5] * $PT / 10).' V';
        $dataArray['CA线电压'] = ($v[6] * $PT / 10).' V';
        $dataArray['A相电压2'] = ($v[4] * $PT / 10);
        $dataArray['B相电压2'] = ($v[5] * $PT / 10);
        $dataArray['C相电压2'] = ($v[6] * $PT / 10);
        $dataArray['A相电流'] = ($v[7] * $CT / 1000).' A';
        $dataArray['B相电流'] = ($v[8] * $CT / 1000).' A';
        $dataArray['C相电流'] = ($v[9] * $CT / 1000).' A';
        $v = unpack("s*",substr($memData , 4 + 17*2 , 8 * 2));
        $dataArray['A相有功功率'] = ($v[1] * $PT * $CT).' W';
        $dataArray['B相有功功率'] = ($v[2] * $PT * $CT).' W';
        $dataArray['C相有功功率'] = ($v[3] * $PT * $CT).' W';
        $dataArray['总有功功率'] = ($v[4] * $PT * $CT).' W';
        $dataArray['总有功功率2'] = ($v[4] * $PT * $CT / 1000);
        $dataArray['A相无功功率'] = ($v[5] * $PT * $CT).' Var';
        $dataArray['B相无功功率'] = ($v[6] * $PT * $CT).' Var';
        $dataArray['C相无功功率'] = ($v[7] * $PT * $CT).' Var';
        $dataArray['总无功功率'] = ($v[8] * $PT * $CT).' Var';
        $v = unpack("S*",substr($memData , 4 + 25*2 , 4 * 2));
        $dataArray['A相视在功率'] = $v[1].' VA';
        $dataArray['B相视在功率'] = $v[2].' VA';
        $dataArray['C相视在功率'] = $v[3].' VA';
        $dataArray['总视在功率'] = $v[4].' VA';
        $v = unpack("s*",substr($memData , 4 + 29*2 , 1 * 2));
        $dataArray['功率因数'] = $v[1] / 1000;
        $v = unpack("S*",substr($memData , 4 + 30*2 , 1 * 2));
        $dataArray['频率'] = ($v[1] / 100).' Hz';
        $v = unpack("I*",substr($memData , 4 + 31*2 , 2 * 4));
        $dataArray['正向有功电能'] = ($v[1] * $PT * $CT).' Wh';
        $dataArray['正向有功电能2'] = ($v[1] * $PT * $CT) / 1000;
        $dataArray['反向有功电能'] = ($v[2] * $PT * $CT).' Wh';
        //PD1688Z_REG_61_69_t
        $v = unpack("I*",substr($memData , 4 + 31*2 + 2*4, 2 * 4));
        $dataArray['感性无功电能'] = ($v[1] * $PT * $CT).' Varh';
        $dataArray['容性无功电能'] = ($v[2] * $PT * $CT).' Varh';
        $v = unpack("S*",substr($memData , 4 + 31*2 + 4*4, 5 * 2));
        $dataArray['电压最大需量'] = ($v[1] * $PT / 10).' V';
        $dataArray['电流最大需量'] = ($v[2] * $CT / 1000).' A';
        $dataArray['有功功率最大需量'] = ($v[3] * $PT * $CT).' W';
        $dataArray['无功功率最大需量'] = ($v[4] * $PT * $CT).' Var';
        $dataArray['零序电流'] = ($v[5] * $CT / 1000).' A';
        $v = unpack('v', substr($memData, 4 + 36*2 + 4*4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 36*2 + 4*4 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
