<?php
function Get_pd194e_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['一次电网数据']['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['一次电网数据']['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['一次电网数据']['C相线电压']);
 	case '[A相电流]':
            return array(0, $dataArray["一次电网数据"]['A相电流']);
        case '[B相电流]':
            return array(0, $dataArray["一次电网数据"]['B相电流']);
        case '[C相电流]':
            return array(0, $dataArray["一次电网数据"]['C相电流']);

        case '[总功率]':
            return array(0, $dataArray['一次电网数据']['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pd194e_Active_Power($dataArray){
    return array(0 , $dataArray['二次电网数据']['正向有功电能2']);
}

function Get_pd194e_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData))
    {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('f*',substr($memData, 4, 24*4));

        $data1 = array();
        $data1["A相相电压"] = number_format($v[1], 2)." V";
        $data1["B相相电压"] = number_format($v[2], 2)." V";
        $data1["C相相电压"] = number_format($v[3], 2)." V";
        $data1["AB线电压"] = number_format($v[4], 2)." V";
        $data1["A相线电压"] = number_format($v[4], 2);
        $data1["BC线电压"] = number_format($v[5], 2)." V";
        $data1["B相线电压"] = number_format($v[5], 2);
        $data1["CA线电压"] = number_format($v[6], 2)." V";
        $data1["C相线电压"] = number_format($v[6], 2);
        $data1["A相电流"] = number_format($v[7], 2)." A";
        $data1["B相电流"] = number_format($v[8], 2)." A";
        $data1["C相电流"] = number_format($v[9], 2)." A";

        $data1["A相有功功率"] = number_format($v[10], 2)." kW";
        $data1["B相有功功率"] = number_format($v[11], 2)." kW";
        $data1["C相有功功率"] = number_format($v[12], 2)." kW";
        $data1["总有功功率"] = number_format($v[13], 2)." kW";
        $data1["总有功功率2"] = number_format($v[13], 3,'.','');

        $data1["A相无功功率"] = number_format($v[14], 2)." kVar";
        $data1["B相无功功率"] = number_format($v[15], 2)." kVar";
        $data1["C相无功功率"] = number_format($v[16], 2)." kVar";
        $data1["总无功功率"] = number_format($v[17], 2)." kVar";
        $data1["总视在功率"] = number_format($v[18], 2)." kVA";
        $data1["总功率因数"] = number_format($v[19], 2);
        $data1["频率"] = number_format($v[20], 2);
        $data1["正向有功电能"] = number_format($v[21], 2,'.','')." kWH";
        $data1["正向有功电能2"] = number_format($v[21], 2 ,'.','');
        $data1["反向有功电能"] = number_format($v[22], 2,'.','')." kWH";
        $data1["感性无功电能"] = number_format($v[23], 2,'.','')." kvarh";
        $data1["容性无功电能"] = number_format($v[24], 2,'.','')." kvarh";
        $dataArray["一次电网数据"] = $data1;
        //跳过DO DI 4 个字节
        $v = unpack('S*',substr($memData, 4 + 24*4 + 2*2, 23*2));
        $data2 = array();
        $data2["A相相电压"] = number_format($v[1]/10, 2)." V";
        $data2["B相相电压"] = number_format($v[2]/10, 2)." V";
        $data2["C相相电压"] = number_format($v[3]/10, 2)." V";
        $data2["AB线电压"] = number_format($v[4]/10, 2)." V";
        $data2["BC线电压"] = number_format($v[5]/10, 2)." V";
        $data2["CA线电压"] = number_format($v[6]/10, 2)." V";
        $data2["A相电流"] = number_format($v[7]/1000, 2)." A";
        $data2["B相电流"] = number_format($v[8]/1000, 2)." A";
        $data2["C相电流"] = number_format($v[9]/1000, 2)." A";

        $data2["A相有功功率"] = number_format($v[10], 2)." W";
        $data2["B相有功功率"] = number_format($v[11], 2)." W";
        $data2["C相有功功率"] = number_format($v[12], 2)." W";
        $data2["总有功功率"] = number_format($v[13], 2)." W";

        $data2["A相无功功率"] = number_format($v[14], 2)." Var";
        $data2["B相无功功率"] = number_format($v[15], 2)." Var";
        $data2["C相无功功率"] = number_format($v[16], 2)." Var";
        $data2["总无功功率"] = number_format($v[17], 2)." Var";

        $data2["A相视在功率"] = number_format($v[18], 2)." VA";
        $data2["B相视在功率"] = number_format($v[19], 2)." VA";
        $data2["C相视在功率"] = number_format($v[20], 2)." VA";
        $data2["总视在功率"] = number_format($v[21], 2)." VA";

        $data2["总功率因数"] = number_format($v[22], 2);
        $data2["频率"] = number_format($v[23]/100, 2);
        $v = unpack('I*',substr($memData, 4 + 24*4 + 2*2 + 23*2, 4*4));
        $data2["正向有功电能"] = number_format($v[1], 2,'.','')." WH";
        $data2["正向有功电能2"] = number_format($v[1] / 1000, 2,'.','');
        $data2["反向有功电能"] = number_format($v[2], 2,'.','')." WH";
        $data2["感性无功电能"] = number_format($v[3], 2,'.','')." varh";
        $data2["容性无功电能"] = number_format($v[4], 2,'.','')." varh";

        $v = unpack('S*',substr($memData, 4 + 24*4 + 2*2 + 23*2 + 4*4, 2*2));
        $data2["PT"] = $v[1];
        $data2["CT"] = $v[2];
        $dataArray["二次电网数据"] = $data2;
        $v = unpack('v', substr($memData,  4 + 24*4 + 2*2 + 23*2 + 4*4 + 2*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 24*4 + 2*2 + 23*2 + 4*4 + 2*2 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }

}
