<?php
function Get_pd194ui_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            $dataArr = explode(' ' , $dataArray['A相相电压']);
            return array(0, $dataArr[0]);
        case '[B相电压]':
            $dataArr = explode(' ' , $dataArray['B相相电压']);
            return array(0, $dataArr[0]);
        case '[C相电压]':
            $dataArr = explode(' ' , $dataArray['C相相电压']);
            return array(0, $dataArr[0]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pd194ui_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData))
    {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('f*',substr($memData, 4, 6*4));
        $dataArray["A相相电压"] = number_format($v[1], 2)." V";
        $dataArray["B相相电压"] = number_format($v[2], 2)." V";
        $dataArray["C相相电压"] = number_format($v[3], 2)." V";
        $dataArray["A相电流"] = number_format($v[4], 2)." A";
        $dataArray["B相电流"] = number_format($v[5], 2)." A";
        $dataArray["C相电流"] = number_format($v[6], 2)." A";

        $v = unpack('v', substr($memData,  4 + 20*4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 20*4 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }

}
