<?php

function Get_pd510_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压Uab(V)']);
        case '[B相电压]':
            return array(0, $dataArray['线电压Ubc(V)']);
        case '[C相电压]':
            return array(0, $dataArray['线电压Uca(V)']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pd510_Active_Power($dataArray){
    return array(0 , $dataArray["净有功电度(kWh)"]);
}

function Get_pd510_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{    
        $dataArray["无数据"] = false;
        $v = unpack('S*',substr($memData, 4 , 4*2));
        // $dataArray["Addr"] = $v[1];
        $dataArray["通讯波特率1(bps)"] = pow(2,$v[2]) * 2400;
        switch ($v[3]) {
            case 0:
                $dataArray["电压接线方式(LN)"] = "3";
                break;
            case 1:
                $dataArray["电压接线方式(LN)"] = "2";
                break;
            case 1:
                $dataArray["电压接线方式(LN)"] = "1";
                break;
            default:
                $dataArray["电压接线方式"] = "无效";
                break;
        }          
        switch ($v[4]) {
            case 0:
                $dataArray["电流接线方式(CT)"] = "3";
                break;
            case 1:
                $dataArray["电流接线方式(CT)"] = "2";
                break;
            case 1:
                $dataArray["电流接线方式(CT)"] = "1";
                break;
            default:
                $dataArray["电流接线方式"] = "无效";
                break;
        }


        $v = unpack('I*',substr($memData, 4 + 4*2 , 1*4));
        $dataArray["PT1"] = $v[1];
        $v = unpack('S*',substr($memData, 4 + 4*2 + 1*4, 23*2));
        $dataArray["PT2"] = $v[1];
        $dataArray["CT1"] = $v[2];
        $dataArray["CTn"] = $v[3];
        // $dataArray["reset"] = $v[4];
        $dataArray["通讯波特率2(bps)"] = pow(2,$v[5]) * 2400;
        // $dataArray["energeyPulseDO"] = $v[6];
        // $dataArray["pulseConstantDO"] = $v[7];
        // $dataArray["timeOfbacklight"] = $v[8];
        // $dataArray["maxima_minima_reset"] = $v[9];
        // $dataArray["startObjectofRuntime"] = $v[10];
        // $dataArray["meterRuntimeReset"] = $v[11];
        //reserved
        // $dataArray["timeIntervalofCaculation"] = $v[13];
        // $dataArray["calculationOfmostValueEnable"] = $v[14];
        // $dataArray["slidingWindowTimeOfdemand"] = $v[15];
        // $dataArray["resetNeeding"] = $v[16];
        //reserved  5
        $dataArray["DO1脉冲输出电度量"] = getDoSignal($v[22]);
        $dataArray["DO2脉冲输出电度量"] = getDoSignal($v[23]);
        //PD510_reg_120_167_t
        $v = unpack('S*',substr($memData, 4 + 27*2 + 1*4, 3*2));
        switch ($v[1]){
            case 0: $dataArray["负载特性"] = '阻性'; break;
            case 1: $dataArray["负载特性"] = '感性'; break;
            case 2: $dataArray["负载特性"] = '容性'; break;
            default: $dataArray["负载特性"] = '无效';
        }
        $dataArray["电压不对称度"] = $v[2] / 1000;
        $dataArray["电流不对称度"] = $v[3] / 1000;
        $v = unpack('I*',substr($memData, 4 + 30*2 + 1*4, 1*4));
        $dataArray["运行时间(h)"] = $v[1] / 100;
        $v = unpack('S*',substr($memData, 4 + 30*2 + 2*4, 25*2));
        //reserved
        $dataArray["频率(Hz)"] = $v[12] / 100;
        $voltagefactor = ($dataArray["PT1"] / $dataArray["PT2"]) / 10;
        $dataArray["A相电压(V)"] = number_format($v[13] * $voltagefactor,2);
        $dataArray["B相电压(V)"] = number_format($v[14] * $voltagefactor,2);
        $dataArray["C相电压(V)"] = number_format($v[15] * $voltagefactor,2);
        $dataArray["三相平均电压(V)"] = number_format($v[16] * $voltagefactor,2);
        $dataArray["线电压Uab(V)"] = number_format($v[17] * $voltagefactor,2);
        $dataArray["线电压Ubc(V)"] = number_format($v[18] * $voltagefactor,2);
        $dataArray["线电压Uca(V)"] = number_format($v[19] * $voltagefactor,2);
        $dataArray["三相平均线电压(V)"] = number_format($v[20] * $voltagefactor,2);

        $electricfactor = ($dataArray["CT1"] / 5) / 1000;
        $dataArray["A相电流(A)"] = number_format($v[21] * $electricfactor,2);
        $dataArray["B相电流(A)"] = number_format($v[22] * $electricfactor,2);
        $dataArray["C相电流(A)"] = number_format($v[23] * $electricfactor,2);
        $dataArray["三相平均电流"] = number_format($v[24] * $electricfactor,2);
        $dataArray["中线电流(A)"] = number_format($v[25] * $electricfactor,2);
        $v = unpack('s*',substr($memData, 4 + 55*2 + 2*4, 8*2));
        $powerfactor = ($dataArray["PT1"] / $dataArray["PT2"]) * ($dataArray["CT1"] / $dataArray["CTn"]);
        $dataArray["A相有功功率(W)"] = $v[1] * $powerfactor;
        $dataArray["B相有功功率(W)"] = $v[2] * $powerfactor;
        $dataArray["C相有功功率(W)"] = $v[3] * $powerfactor;
        $dataArray["系统有功功率(W)"] = $v[4] * $powerfactor;
        $dataArray["总有功功率2"] = $v[4] * $powerfactor / 1000;
        $dataArray["A相无功功率(var)"] = $v[5] * $powerfactor;
        $dataArray["B相无功功率(var)"] = $v[6] * $powerfactor;
        $dataArray["C相无功功率(var)"] = $v[7] * $powerfactor;
        $dataArray["系统无功功率(var)"] = $v[8] * $powerfactor;
        $v = unpack('S*',substr($memData, 4 + 63*2 + 2*4, 4*2));
        $dataArray["A相视在功率(VA)"] = $v[1] * $powerfactor;
        $dataArray["B相视在功率(VA)"] = $v[2] * $powerfactor;
        $dataArray["C相视在功率(VA)"] = $v[3] * $powerfactor;
        $dataArray["系统视在功率(VA)"] = $v[4] * $powerfactor;
        $v = unpack('s*',substr($memData, 4 + 67*2 + 2*4, 4*2));
        $dataArray["A相功率因数"] = $v[1] / 1000;
        $dataArray["A相功率因数"] = $v[2] / 1000;
        $dataArray["A相功率因数"] = $v[3] / 1000;
        $dataArray["系统相功率因数"]= $v[4] / 1000;
        $v = unpack('I*',substr($memData, 4 + 71*2 + 2*4, 3*4));
        $dataArray["系统有功功率需量(W)"] = $v[1] * $powerfactor;
        $dataArray["系统无功功率需量(var)"] = $v[2] * $powerfactor;
        $dataArray["系统视在功率需量(VA)"] = $v[3] * $powerfactor;
        //保留   2 short
        $v = unpack('I*',substr($memData, 4 + 73*2 + 5*4, 9*4));
        $dataArray["消耗性有功电度(kWh)"] = $v[1] / 10;
        $dataArray["释放性有功电度(kWh)"] = $v[2] / 10;
        $dataArray["感性无功电度(kvarh)"] = $v[3] / 10;
        $dataArray["容性无功电度(kvarh)"] = $v[4] / 10;
        $dataArray["总有功电度(kWh)"] = $v[5] / 10;
        $dataArray["净有功电度(kWh)"] = $v[6] / 10;
        $dataArray["总无功电度(kvarh)"] = $v[7] / 10;
        $dataArray["净无功电度(kvarh)"] = $v[8] / 10;
        $dataArray["视在电度(kVAh)"] = $v[9];

        $v = unpack('v',substr($memData, 4 + 73*2 + 5*4 + 9*4, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 73*2 + 5*4 + 9*4 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

function getDoSignal($data){
    switch ($data){
        case 0: return '无输出';
        case 1: return '消耗性有功电度';
        case 2: return '释放性有功电度';
        case 3: return '感性无功电度';
        case 4: return '容性无功电度';
        case 5: return '绝对值和有功电度';
        case 6: return '净有功电度';
        case 7: return '绝对值和功电度';
        case 8: return '净无功电度';
    }
    return '无效';
}

?>
