<?php
function Get_pdu8000_RtData($memData, &$dataArray, $extraPara = false)
{
        if ($memData == false) {
            $dataArray['更新时间'] = '无';
            $dataArray['无数据'] = true;
            $dataArray['错误'] = '无数据';
        } else {//2823
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //主路采集 模拟信号
            $v = unpack('I*', substr($memData , 4 , 4));
            $runningMode = $v[1];
            switch ($v[1]){
                case 0: $dataArray['系统运行模式'] = '双路模式'; break;
                case 1: $dataArray['系统运行模式'] = '双路双屏1路模式'; break;
                case 2: $dataArray['系统运行模式'] = '双路双屏2路模式'; break;
                case 3: $dataArray['系统运行模式'] = '单路模式'; break;
                case 4: $dataArray['系统运行模式'] = '变压器模式'; break;
                default: $dataArray['系统运行模式'] = '无效'; 
            }
            
            //PDU8000_40001_40055_t
           $dataArray['Ⅰ主路输入'] = array();
           $v = unpack('S*', substr($memData, 4 + 4*1 , 2 * 22));
           $dataArray['Ⅰ主路输入']['L1输入电压'] = ($v[1] / 10).' V';
           $dataArray['Ⅰ主路输入']['L2输入电压'] = ($v[2] / 10).' V';
           $dataArray['Ⅰ主路输入']['L3输入电压'] = ($v[3] / 10).' V';
           $dataArray['Ⅰ主路输入']['L1-L2输入线电压'] = ($v[4] / 10).' V';
           $dataArray['Ⅰ主路输入']['L2-L3输入线电压'] = ($v[5] / 10).' V';
           $dataArray['Ⅰ主路输入']['L3-L1输入线电压'] = ($v[6] / 10).' V';
           $dataArray['Ⅰ主路输入']['L1输入电流'] = ($v[7] / 10).' A';
           $dataArray['Ⅰ主路输入']['L2输入电流'] = ($v[8] / 10).' A';
           $dataArray['Ⅰ主路输入']['L3输入电流'] = ($v[9] / 10).' A';
           $dataArray['Ⅰ主路输入']['输入频率'] = ($v[10] / 100).' Hz';
           $dataArray['Ⅰ主路输入']['L1输入有功功率'] = ($v[11] / 10).' KW';
           $dataArray['Ⅰ主路输入']['L2输入有功功率'] = ($v[12] / 10).' KW';
           $dataArray['Ⅰ主路输入']['L3输入有功功率'] = ($v[13] / 10).' KW';
           $dataArray['Ⅰ主路输入']['L1输入视在功率'] = ($v[14] / 10).' KVA';
           $dataArray['Ⅰ主路输入']['L2输入视在功率'] = ($v[15] / 10).' KVA';
           $dataArray['Ⅰ主路输入']['L3输入视在功率'] = ($v[16] / 10).' KVA';
           $dataArray['Ⅰ主路输入']['L1输入无功功率'] = ($v[17] / 10).' KVAR';
           $dataArray['Ⅰ主路输入']['L2输入无功功率'] = ($v[18] / 10).' KVAR';
           $dataArray['Ⅰ主路输入']['L3输入无功功率'] = ($v[19] / 10).' KVAR';
           $dataArray['Ⅰ主路输入']['L1输入功率因数'] = ($v[20] / 100);
           $dataArray['Ⅰ主路输入']['L2输入功率因数'] = ($v[21] / 100);
           $dataArray['Ⅰ主路输入']['L3输入功率因数'] = ($v[22] / 100);
            $v = unpack('I*', substr($memData, 4 + 4*1 + 2*22 , 4 * 1));
           $dataArray['Ⅰ主路输入']['输入有功电能'] = ($v[1] / 10).' KWh';
            $v = unpack('S*', substr($memData, 4 + 4*2 + 2*22 , 2 * 31));
           $dataArray['Ⅰ主路输入']['L1输入电源负载率'] = $v[1].' %';
           $dataArray['Ⅰ主路输入']['L2输入电源负载率'] = $v[2].' %';
           $dataArray['Ⅰ主路输入']['L3输入电源负载率'] = $v[3].' %';
           $dataArray['Ⅰ主路输入']['输入N线电流'] = ($v[4] / 10).' A';
           $dataArray['Ⅰ主路输入']['L1总电压谐波畸变率'] = ($v[5] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2总电压谐波畸变率'] = ($v[6] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3总电压谐波畸变率'] = ($v[7] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-5次电压谐波畸变率'] = ($v[8] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-5次电压谐波畸变率'] = ($v[9] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-5次电压谐波畸变率'] = ($v[10] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-7次电压谐波畸变率'] = ($v[11] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-7次电压谐波畸变率'] = ($v[12] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-7次电压谐波畸变率'] = ($v[13] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-11次电压谐波畸变率'] = ($v[14] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-11次电压谐波畸变率'] = ($v[15] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-11次电压谐波畸变率'] = ($v[16] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1总电流谐波畸变率'] = ($v[17] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2总电流谐波畸变率'] = ($v[18] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3总电流谐波畸变率'] = ($v[19] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-5次电流谐波畸变率'] = ($v[20] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-5次电流谐波畸变率'] = ($v[21] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-5次电流谐波畸变率'] = ($v[22] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-7次电流谐波畸变率'] = ($v[23] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-7次电流谐波畸变率'] = ($v[24] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-7次电流谐波畸变率'] = ($v[25] / 100).' %';
           $dataArray['Ⅰ主路输入']['L1-11次电流谐波畸变率'] = ($v[26] / 100).' %';
           $dataArray['Ⅰ主路输入']['L2-11次电流谐波畸变率'] = ($v[27] / 100).' %';
           $dataArray['Ⅰ主路输入']['L3-11次电流谐波畸变率'] = ($v[28] / 100).' %';
           $dataArray['Ⅰ主路输入']['总输入有功功率'] = ($v[29] / 10).' KW';
           $dataArray['Ⅰ主路输入']['总输入视在功率'] = ($v[30] / 10).' KVA';
           $dataArray['Ⅰ主路输入']['总输入无功功率'] = ($v[31] / 10).' KVAR';
            
            //PDU8000_40101_40155_t
            $dataArray['Ⅱ主路输入'] = array();
            $v = unpack('S*', substr($memData, 4 + 4*2 + 2*53 , 2 * 22));
            $dataArray['Ⅱ主路输入']['L1输入电压'] = ($v[1] / 10).' V';
            $dataArray['Ⅱ主路输入']['L2输入电压'] = ($v[2] / 10).' V';
            $dataArray['Ⅱ主路输入']['L3输入电压'] = ($v[3] / 10).' V';
            $dataArray['Ⅱ主路输入']['L1-L2输入线电压'] = ($v[4] / 10).' V';
            $dataArray['Ⅱ主路输入']['L2-L3输入线电压'] = ($v[5] / 10).' V';
            $dataArray['Ⅱ主路输入']['L3-L1输入线电压'] = ($v[6] / 10).' V';
            $dataArray['Ⅱ主路输入']['L1输入电流'] = ($v[7] / 10).' A';
            $dataArray['Ⅱ主路输入']['L2输入电流'] = ($v[8] / 10).' A';
            $dataArray['Ⅱ主路输入']['L3输入电流'] = ($v[9] / 10).' A';
            $dataArray['Ⅱ主路输入']['输入频率'] = ($v[10] / 100).' Hz';
            $dataArray['Ⅱ主路输入']['L1输入有功功率'] = ($v[11] / 10).' KW';
            $dataArray['Ⅱ主路输入']['L2输入有功功率'] = ($v[12] / 10).' KW';
            $dataArray['Ⅱ主路输入']['L3输入有功功率'] = ($v[13] / 10).' KW';
            $dataArray['Ⅱ主路输入']['L1输入视在功率'] = ($v[14] / 10).' KVA';
            $dataArray['Ⅱ主路输入']['L2输入视在功率'] = ($v[15] / 10).' KVA';
            $dataArray['Ⅱ主路输入']['L3输入视在功率'] = ($v[16] / 10).' KVA';
            $dataArray['Ⅱ主路输入']['L1输入无功功率'] = ($v[17] / 10).' KVAR';
            $dataArray['Ⅱ主路输入']['L2输入无功功率'] = ($v[18] / 10).' KVAR';
            $dataArray['Ⅱ主路输入']['L3输入无功功率'] = ($v[19] / 10).' KVAR';
            $dataArray['Ⅱ主路输入']['L1输入功率因数'] = ($v[20] / 100);
            $dataArray['Ⅱ主路输入']['L2输入功率因数'] = ($v[21] / 100);
            $dataArray['Ⅱ主路输入']['L3输入功率因数'] = ($v[22] / 100);
            $v = unpack('I*', substr($memData, 4 + 4*2 + 2*75 , 4 * 1));
            $dataArray['Ⅱ主路输入']['输入有功电能'] = ($v[1] / 10).' KWh';
            $v = unpack('S*', substr($memData, 4 + 4*3 + 2*75 , 2 * 31));
            $dataArray['Ⅱ主路输入']['L1输入电源负载率'] = $v[1].' %';
            $dataArray['Ⅱ主路输入']['L2输入电源负载率'] = $v[2].' %';
            $dataArray['Ⅱ主路输入']['L3输入电源负载率'] = $v[3].' %';
            $dataArray['Ⅱ主路输入']['输入N线电流'] = ($v[4] / 10).' A';
            $dataArray['Ⅱ主路输入']['L1总电压谐波畸变率'] = ($v[5] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2总电压谐波畸变率'] = ($v[6] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3总电压谐波畸变率'] = ($v[7] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-5次电压谐波畸变率'] = ($v[8] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-5次电压谐波畸变率'] = ($v[9] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-5次电压谐波畸变率'] = ($v[10] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-7次电压谐波畸变率'] = ($v[11] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-7次电压谐波畸变率'] = ($v[12] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-7次电压谐波畸变率'] = ($v[13] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-11次电压谐波畸变率'] = ($v[14] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-11次电压谐波畸变率'] = ($v[15] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-11次电压谐波畸变率'] = ($v[16] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1总电流谐波畸变率'] = ($v[17] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2总电流谐波畸变率'] = ($v[18] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3总电流谐波畸变率'] = ($v[19] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-5次电流谐波畸变率'] = ($v[20] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-5次电流谐波畸变率'] = ($v[21] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-5次电流谐波畸变率'] = ($v[22] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-7次电流谐波畸变率'] = ($v[23] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-7次电流谐波畸变率'] = ($v[24] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-7次电流谐波畸变率'] = ($v[25] / 100).' %';
            $dataArray['Ⅱ主路输入']['L1-11次电流谐波畸变率'] = ($v[26] / 100).' %';
            $dataArray['Ⅱ主路输入']['L2-11次电流谐波畸变率'] = ($v[27] / 100).' %';
            $dataArray['Ⅱ主路输入']['L3-11次电流谐波畸变率'] = ($v[28] / 100).' %';
            $dataArray['Ⅱ主路输入']['总输入有功功率'] = ($v[29] / 10).' KW';
            $dataArray['Ⅱ主路输入']['总输入视在功率'] = ($v[30] / 10).' KVA';
            $dataArray['Ⅱ主路输入']['总输入无功功率'] = ($v[31] / 10).' KVAR';
            
            //PDU8000_40201_40272_t  双路模式下有功功率和
            $v = unpack('S*', substr($memData, 4 + 4*3 + 2*106 , 2 * 72));
            if($runningMode == 0 || $runningMode == 1 || $runningMode == 2){//双路模式
                $dataArray['主路采集有功功率和'] = array();
                for($i = 1 ; $i <= 72 ; $i++){
                    $dataArray['主路采集有功功率和']['第 '.$i.' 输出支路总有功功率'] = ($v[$i] / 100).' KW';
                }
            }
            
            //PDU8000_40300_40312_t  主路采集  系统状态
            $v = unpack('S*', substr($memData, 4 + 4*3 + 2*178 , 2 * 13));
            $dataArray['主路采集状态信号'] = array();
            $dataArray['主路采集状态信号']['提示告警信息监控'] = ($v[1] & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['重要告警信息监控'] = (($v[1] >> 1) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['紧急告警信息监控'] = (($v[1] >> 2) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['活动告警监控'] = (($v[1] >> 3) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['历史告警监控'] = (($v[1] >> 4) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['配置参数监控'] = (($v[1] >> 5) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['版本变更监控'] = (($v[1] >> 6) & 0x1) == 1 ? '有变化' : '无变化';
            $dataArray['主路采集状态信号']['当前活动告警流水号H'] = $v[2];
            $dataArray['主路采集状态信号']['当前活动告警流水号L'] = $v[3];
            $dataArray['主路采集状态信号']['当前历史告警流水号H'] = $v[4];
            $dataArray['主路采集状态信号']['当前历史告警流水号L'] = $v[5];//6-11保留
            $dataArray['主路采集状态信号']['模块1在位状态'] = ($v[12] & 0x1) == 1 ? '在位' : '不在位';
            $dataArray['主路采集状态信号']['模块2在位状态'] = (($v[12] >> 1) & 0x1) == 1 ? '在位' : '不在位';
            $dataArray['主路采集状态信号']['模块3在位状态'] = (($v[12] >> 2) & 0x1) == 1 ? '在位' : '不在位';
            $dataArray['主路采集状态信号']['模块4在位状态'] = (($v[12] >> 3) & 0x1) == 1 ? '在位' : '不在位';
            $dataArray['主路采集状态信号']['在线模块个数'] = $v[13];
            
            //PDU8000_40321_40351_t  主路采集  告警信号
            $v = unpack('S*', substr($memData, 4 + 4*3 + 2*191 , 2 * 10));
            if($runningMode == 0 || $runningMode == 1 || $runningMode == 2){//双路模式
                $dataArray['主路采集双路模式告警'] = array();
                $dataArray['主路采集双路模式告警']['AlertArray'] = array();
                //主路开关状态  reg_40321 reg_40322
                $dataArray['主路采集双路模式告警']['1路输入空开状态'] = ($v[1] & 0x1) == 1 ? '闭合' : '断开';
                $dataArray['主路采集双路模式告警']['2路输入空开状态'] = ($v[2] & 0x1) == 1 ? '闭合' : '断开';
                //重要告警    reg_40336  reg_40337
                $dataArray['主路采集双路模式告警']['1主路频率高'] = ($v[3] & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路频率低'] = (($v[3] >> 1) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路防雷器状态'] = (($v[3] >> 5) & 0x1) == 0 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1 ? '接反'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路频率高'] = ($v[4] & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路频率低'] = (($v[4] >> 1) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1电流高阈值越限'] = (($v[4] >> 2) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2电流高阈值越限'] = (($v[4] >> 3) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3电流高阈值越限'] = (($v[4] >> 4) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路防雷器状态'] = (($v[4] >> 5) & 0x1) == 0 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路电流互感器接线反'] = (($v[4] >> 7) & 0x1) == 1 ? '接反'  : '正常';
                
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路频率高'] = ($v[3] & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路频率低'] = (($v[3] >> 1) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路防雷器状态'] = (($v[3] >> 5) & 0x1) == 0;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路频率高'] = ($v[4] & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路频率低'] = (($v[4] >> 1) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1电流高阈值越限'] = (($v[4] >> 2) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2电流高阈值越限'] = (($v[4] >> 3) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3电流高阈值越限'] = (($v[4] >> 4) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路防雷器状态'] = (($v[4] >> 5) & 0x1) == 0;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路电流互感器接线反'] = (($v[4] >> 7) & 0x1) == 1;
                //紧急告警   reg_40342  reg_40343
                $dataArray['主路采集双路模式告警']['1主路-L1缺相'] = ($v[5] & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路掉电'] = (($v[5] >> 12) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['1主路输入开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1缺相'] = ($v[6] & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2缺相'] = (($v[6] >> 1) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3缺相'] = (($v[6] >> 2) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1过压'] = (($v[6] >> 3) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2过压'] = (($v[6] >> 4) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3过压'] = (($v[6] >> 5) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1欠压'] = (($v[6] >> 6) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2欠压'] = (($v[6] >> 7) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3欠压'] = (($v[6] >> 8) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1过载'] = (($v[6] >> 9) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2过载'] = (($v[6] >> 10) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3过载'] = (($v[6] >> 11) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路掉电'] = (($v[6] >> 12) & 0x1) == 1 ? '异常'  : '正常';
                $dataArray['主路采集双路模式告警']['2主路输入开关脱扣故障'] = (($v[6] >> 13) & 0x1) == 0 ? '异常'  : '正常';
                
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1缺相'] = ($v[5] & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路掉电'] = (($v[5] >> 12) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路输入开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1缺相'] = ($v[6] & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2缺相'] = (($v[6] >> 1) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3缺相'] = (($v[6] >> 2) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1过压'] = (($v[6] >> 3) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2过压'] = (($v[6] >> 4) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3过压'] = (($v[6] >> 5) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1欠压'] = (($v[6] >> 6) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2欠压'] = (($v[6] >> 7) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3欠压'] = (($v[6] >> 8) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1过载'] = (($v[6] >> 9) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2过载'] = (($v[6] >> 10) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3过载'] = (($v[6] >> 11) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路掉电'] = (($v[6] >> 12) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路输入开关脱扣故障'] = (($v[6] >> 13) & 0x1) == 0;
                //提示告警  reg_40349  reg_40351
                $dataArray['主路采集双路模式告警']['1主路-L1电流低阈值越限'] = (($v[9] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L2电流低阈值越限'] = (($v[9] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['1主路-L3电流低阈值越限'] = (($v[9] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['1主路三相电流不平衡'] = (($v[9] >> 11) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['1主路电压谐波畸变率高'] = (($v[9] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['1主路电流谐波畸变率高'] = (($v[9] >> 13) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L1电流低阈值越限'] = (($v[10] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L2电流低阈值越限'] = (($v[10] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路-L3电流低阈值越限'] = (($v[10] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路三相电流不平衡'] = (($v[10] >> 11) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路电压谐波畸变率高'] = (($v[10] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集双路模式告警']['2主路电流谐波畸变率高'] = (($v[10] >> 13) & 0x1) == 1 ? '异常' : '正常';
                
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L1电流低阈值越限'] = (($v[9] >> 8) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L2电流低阈值越限'] = (($v[9] >> 9) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路-L3电流低阈值越限'] = (($v[9] >> 10) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路三相电流不平衡'] = (($v[9] >> 11) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路电压谐波畸变率高'] = (($v[9] >> 12) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['1主路电流谐波畸变率高'] = (($v[9] >> 13) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L1电流低阈值越限'] = (($v[10] >> 8) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L2电流低阈值越限'] = (($v[10] >> 9) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路-L3电流低阈值越限'] = (($v[10] >> 10) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路三相电流不平衡'] = (($v[10] >> 11) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路电压谐波畸变率高'] = (($v[10] >> 12) & 0x1) == 1;
                $dataArray['主路采集双路模式告警']['AlertArray']['2主路电流谐波畸变率高'] = (($v[10] >> 13) & 0x1) == 1;
            }else if($runningMode == 3){//单路模式
                $dataArray['主路采集单路模式告警'] = array();
                $dataArray['主路采集单路模式告警']['AlertArray'] = array();
                //主路开关状态  40321
                $dataArray['主路采集单路模式告警']['主路输入空开状态'] = ($v[1] & 0x1) == 1 ? '闭合' : '断开';
                //重要告警  40336  
                $dataArray['主路采集单路模式告警']['主路频率高'] = ($v[3] & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路频率低'] = (($v[3] >> 1) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路防雷器状态'] = (($v[3] >> 5) & 0x1) == 0 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1 ? '接反' : '正常';
                
                $dataArray['主路采集单路模式告警']['AlertArray']['主路频率高'] = ($v[3] & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路频率低'] = (($v[3] >> 1) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路防雷器状态'] = (($v[3] >> 5) & 0x1) == 0;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1;
                //紧急告警   40342
                $dataArray['主路采集单路模式告警']['主路-L1缺相'] = ($v[5] & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路掉电'] = (($v[5] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路输入开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0 ? '异常' : '正常';
                
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1缺相'] = ($v[5] & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路掉电'] = (($v[5] >> 12) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路输入开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0;
                //提示告警 40348
                $dataArray['主路采集单路模式告警']['主路-L1电流低阈值越限'] = (($v[8] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L2电流低阈值越限'] = (($v[8] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路-L3电流低阈值越限'] = (($v[8] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路三相电流不平衡'] = (($v[8] >> 11) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路电压谐波畸变率高'] = (($v[8] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集单路模式告警']['主路电流谐波畸变率高'] = (($v[8] >> 13) & 0x1) == 1 ? '异常' : '正常';
                
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L1电流低阈值越限'] = (($v[8] >> 8) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L2电流低阈值越限'] = (($v[8] >> 9) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路-L3电流低阈值越限'] = (($v[8] >> 10) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路三相电流不平衡'] = (($v[8] >> 11) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路电压谐波畸变率高'] = (($v[8] >> 12) & 0x1) == 1;
                $dataArray['主路采集单路模式告警']['AlertArray']['主路电流谐波畸变率高'] = (($v[8] >> 13) & 0x1) == 1;
                
            }else if($runningMode == 4){//变压器模式
                $dataArray['主路采集变压器模式告警'] = array();
                $dataArray['主路采集变压器模式告警']['AlertArray'] = array();
                //主路开关状态  40321 40322
                $dataArray['主路采集变压器模式告警']['变压器输出空开状态'] = ($v[1] & 0x1) == 1 ? '闭合' : '断开';
                $dataArray['主路采集变压器模式告警']['变压器输入空开状态'] = ($v[2] & 0x1) == 1 ? '闭合' : '断开';
                //重要告警  40336  40337
                $dataArray['主路采集变压器模式告警']['主路频率高'] = ($v[3] & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路频率低'] = (($v[3] >> 1) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['防雷器状态'] = (($v[3] >> 5) & 0x1) == 0 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['变压器输出板电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1 ? '接反' : '正常';
                $dataArray['主路采集变压器模式告警']['变压器输入板电流互感器接线反'] = (($v[4] >> 7) & 0x1) == 1 ? '接反' : '正常';
                
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路频率高'] = ($v[3] & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路频率低'] = (($v[3] >> 1) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1电流高阈值越限'] = (($v[3] >> 2) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2电流高阈值越限'] = (($v[3] >> 3) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3电流高阈值越限'] = (($v[3] >> 4) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['防雷器状态'] = (($v[3] >> 5) & 0x1) == 0;
                $dataArray['主路采集变压器模式告警']['AlertArray']['变压器输出板电流互感器接线反'] = (($v[3] >> 7) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['变压器输入板电流互感器接线反'] = (($v[4] >> 7) & 0x1) == 1;
                //紧急告警 40342 40343 40345 40347
                $dataArray['主路采集变压器模式告警']['主路-L1缺相'] = ($v[5] & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路掉电'] = (($v[5] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['变压器输出开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['变压器输入开关脱扣故障'] = (($v[6] >> 13) & 0x1) == 0 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['变压器超高温告警'] = (($v[7] >> 5) & 0x1) == 0 ? '异常' : '正常';
                
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1缺相'] = ($v[5] & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2缺相'] = (($v[5] >> 1) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3缺相'] = (($v[5] >> 2) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1过压'] = (($v[5] >> 3) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2过压'] = (($v[5] >> 4) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3过压'] = (($v[5] >> 5) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1欠压'] = (($v[5] >> 6) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2欠压'] = (($v[5] >> 7) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3欠压'] = (($v[5] >> 8) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1过载'] = (($v[5] >> 9) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2过载'] = (($v[5] >> 10) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3过载'] = (($v[5] >> 11) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路掉电'] = (($v[5] >> 12) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['变压器输出开关脱扣故障'] = (($v[5] >> 13) & 0x1) == 0;
                $dataArray['主路采集变压器模式告警']['AlertArray']['变压器输入开关脱扣故障'] = (($v[6] >> 13) & 0x1) == 0;
                $dataArray['主路采集变压器模式告警']['AlertArray']['变压器超高温告警'] = (($v[7] >> 5) & 0x1) == 0;
                //提示告警   40348  40349
                $dataArray['主路采集变压器模式告警']['主路总电压谐波畸变率高'] = ($v[8] & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路5次电压谐波畸变率高'] = (($v[8] >> 3) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路7次电压谐波畸变率高'] = (($v[8] >> 6) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路11次电压谐波畸变率高'] = (($v[8] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路总电流谐波畸变率高'] = (($v[8] >> 12) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路5次电流谐波畸变率高'] = (($v[8] >> 15) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路7次电流谐波畸变率高'] = (($v[9] >> 2) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路11次电流谐波畸变率高'] = (($v[9] >> 5) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L1电流低阈值越限'] = (($v[9] >> 8) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L2电流低阈值越限'] = (($v[9] >> 9) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路-L3电流低阈值越限'] = (($v[9] >> 10) & 0x1) == 1 ? '异常' : '正常';
                $dataArray['主路采集变压器模式告警']['主路三相电流不平衡'] = (($v[9] >> 11) & 0x1) == 1 ? '异常' : '正常';
                
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路总电压谐波畸变率高'] = ($v[8] & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路5次电压谐波畸变率高'] = (($v[8] >> 3) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路7次电压谐波畸变率高'] = (($v[8] >> 6) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路11次电压谐波畸变率高'] = (($v[8] >> 9) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路总电流谐波畸变率高'] = (($v[8] >> 12) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路5次电流谐波畸变率高'] = (($v[8] >> 15) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路7次电流谐波畸变率高'] = (($v[9] >> 2) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路11次电流谐波畸变率高'] = (($v[9] >> 5) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L1电流低阈值越限'] = (($v[9] >> 8) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L2电流低阈值越限'] = (($v[9] >> 9) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路-L3电流低阈值越限'] = (($v[9] >> 10) & 0x1) == 1;
                $dataArray['主路采集变压器模式告警']['AlertArray']['主路三相电流不平衡'] = (($v[9] >> 11) & 0x1) == 1;
            }
            //支路信号   未完待续
            //PDU8000_40354_40713_t;    模块1模拟量   252个short 
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*201 , 2 * 252));
            
            //PDU8000_40714_41073_t;    模块2模拟量   252个short 
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*453 , 2 * 252));
            
            //PDU8000_41074_41433_t;    模块3模拟量   252个short 
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*705 , 2 * 252));
            
            //PDU8000_41434_41793_t;    模块4模拟量   252个short 
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*957 , 2 * 252));
            
            //PDU8000_41794_41803_t;    双路模式状态     11个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1209 , 2 * 11));
            
            //PDU8000_41810_41820_t;    单路模式状态   11个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1220 , 2 * 11));
            
            //PDU8000_41821_41824_t;    系统紧急告警        4个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1231 , 2 * 4));
            
            //PDU8000_41822_t;          系统重要告警        1个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1235 , 2 * 1));
            
            //PDU8000_41825_t;          系统提示告警        1个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1236 , 2 * 1));
            
            //PDU8000_41830_41849_t;    双路模式   Ⅰ主路告警       20个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1237 , 2 * 20));
            
            //PDU8000_41890_41943_t;    双路模式    Ⅱ主路告警      44个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1257 , 2 * 44));
            
            //PDU8000_41950_42049_t;    单路模式告警      100个short
            //$v = unpack('S*', substr($memData, 4 + 4*3 + 2*1301 , 2 * 100));

            //实际数据长度比协议上少了  2个
            $v = unpack('v', substr($memData, strlen($memData) - 7 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, strlen($memData) - 5 , 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}