<?php

function Get_pex3dx_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", 10*intval($parameter[0]));
    }
    return -1;
}


function Get_pex3dx_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['室内温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_pex3dx_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['无数据'] = true;
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //模拟量
        $v = unpack('s*',substr($memData,4,40*2));
        $dataArray['回风平均温度'] = number_format($v[1]/10, 1).' ℃';
        $dataArray['回风最高温度'] = number_format($v[2]/10, 1).' ℃';
        $dataArray['回风最低温度'] = number_format($v[3]/10, 1).' ℃';
        $dataArray['回风温度1'] = number_format($v[4]/10, 1).' ℃';

        $dataArray['回风平均湿度'] = number_format($v[5]/10, 1).' %';
        $dataArray['回风最高湿度'] = number_format($v[6]/10, 1).' %';
        $dataArray['回风最低湿度'] = number_format($v[7]/10, 1).' %';
        $dataArray['回风湿度1'] = number_format($v[8]/10, 1).' %';

        $dataArray['送风温度1'] = number_format($v[9]/10, 1).' ℃';

        $dataArray['回风平均温度2'] = number_format($v[10]/10, 1).' ℃';
        $dataArray['回风平均湿度2'] = number_format($v[11]/10, 1).' %';

        $dataArray['电源电压A'] = number_format($v[12]/10, 1).' V';
        $dataArray['电源电压B'] = number_format($v[13]/10, 1).' V';
        $dataArray['电源电压C'] = number_format($v[14]/10, 1).' V';
        $dataArray['电源电流'] = number_format($v[15]/10, 1).' A';
        $dataArray['电源频率'] = number_format($v[16]/10, 1).' Hz';

        $dataArray['NTC输入1检测温度'] = number_format($v[17]/10, 1).' ℃';
        $dataArray['NTC输入2检测温度'] = number_format($v[18]/10, 1).' ℃';
        $dataArray['NTC输入3检测温度'] = number_format($v[19]/10, 1).' ℃';
        $dataArray['NTC输入4检测温度'] = number_format($v[20]/10, 1).' ℃';

        $dataArray['模拟量输入1测量值'] = number_format($v[21]/10, 1);
        $dataArray['模拟量输入2测量值'] = number_format($v[22]/10, 1);
        $dataArray['模拟量输入3测量值'] = number_format($v[23]/10, 1);
        $dataArray['模拟量输入4测量值'] = number_format($v[24]/10, 1);

        $vS = unpack('S*',substr($memData,4 + 24*2, 10*2));

        $dataArray["电表A相有功功率"] = (intval($vS[1]) << 16 + $vS[2])."W";
        $dataArray["电表B相有功功率"] = (intval($vS[3]) << 16 + $vS[4])."W";
        $dataArray["电表C相有功功率"] = (intval($vS[5]) << 16 + $vS[6])."W";

        $dataArray["电表电能"] = (intval($vS[7]) << 16 + $vS[8])."WH";
        $dataArray["抄表电能"] = (intval($vS[9]) << 16 + $vS[10])."WH";

        $dataArray["风压1测量值"] = $v[35];
        $dataArray["风压2测量值"] = $v[36];

        $dataArray["风机1转速"] = number_format($v[37]/10, 1);
        $dataArray["风机2转速"] = number_format($v[38]/10, 1);

        $dataArray["压缩机1转速"] = number_format($v[39]/10, 1);
        $dataArray["压缩机2转速"] = number_format($v[40]/10, 1);

        //空调开关
        $v = unpack('c*', substr($memData, 4 + 40*2, 32));
        $dataArray['远程关机报警开关'] = $v[1] == 0 ? '关' : '开';
        $dataArray['地板溢水告警开关'] = $v[2] == 0 ? '关' : '开';
        $dataArray['自定义1报警开关'] = $v[3] == 0 ? '关' : '开';
        $dataArray['自定义2报警开关'] = $v[4] == 0 ? '关' : '开';
        $dataArray['风机1报警开关'] = $v[11] == 0 ? '关' : '开';
        $dataArray['电加热报警开关'] = $v[13] == 0 ? '关' : '开';
        $dataArray['加湿器报警开关'] = $v[14] == 0 ? '关' : '开';
        $dataArray['加湿高水位报警开关'] = $v[15] == 0 ? '关' : '开';
        $dataArray['高压1报警开关'] = $v[16] == 0 ? '关' : '开';
        $dataArray['高压2报警开关'] = $v[17] == 0 ? '关' : '开';

        $dataArray['低压开关1'] = $v[21] == 0 ? '关' : '开';
        $dataArray['低压开关2'] = $v[22] == 0 ? '关' : '开';

        $dataArray['地板溢水告警开关2'] = $v[26] == 0 ? '关' : '开';
        $dataArray['自定义开关1'] = $v[31] == 0 ? '关' : '开';
        $dataArray['自定义开关2'] = $v[32] == 0 ? '关' : '开';
        //系统参数
        $v = unpack('s*',substr($memData, 4 + 40*2 + 32, 13*2));
        $dataArray['回风温度设定点（℃）'] = ($v[1] / 10).' ℃';
        $dataArray['湿度设定点（%）'] = ($v[2] / 10).' %';
        $dataArray['送风温度设定点'] = ($v[3] / 10).' ℃';
        $dataArray['回风温度设定点'] = ($v[4] / 10).' ℃';
        $dataArray['温度比例带'] = ($v[5] / 10);
        $dataArray['湿度比例带（%）'] = ($v[6] / 10);

        $dataArray['温度死区（℃）'] = ($v[7] / 10).' ℃';
        $dataArray['湿度死区（%）'] = ($v[8] / 10).' %';
        $dataArray['回风高温报警值（℃）'] = ($v[9] / 10).' ℃';
        $dataArray['回风低温报警值（℃）'] = ($v[10] / 10).' ℃';
        $dataArray['回风高湿报警值（%）'] = ($v[11] / 10).' %';
        $dataArray['回风低湿报警值（%）'] = ($v[12] / 10).' %';
        $dataArray['送风高温报警值（℃）'] = ($v[13] / 10).' ℃';

        //机组状态
        $v = unpack('c*', substr($memData, 4 + 40*2 + 32 + 13*2, 19));
        switch($v[1]){
            case 0:
                $dataArray['空调开关机状态'] = '运行';
                break;
            case 1:
                $dataArray['空调开关机状态'] = '备机';
                break;
            case 2:
                $dataArray['空调开关机状态'] = '关机';
                break;
            case 3:
                $dataArray['空调开关机状态'] = '远程关机';
                break;
            default:
                $dataArray['空调开关机状态'] = '无效';
        }
        $dataArray['风机输出开关状态'] = $v[2] == 0 ? '关' : '开';
        $dataArray['加湿器输出开关状态'] = $v[3] == 0 ? '关' : '开';
        $dataArray['压缩机1输出开关状态'] = $v[4] == 0 ? '关' : '开';
        $dataArray['压缩机2输出开关状态'] = $v[5] == 0 ? '关' : '开';
        $dataArray['电加热1输出开关状态'] = $v[6] == 0 ? '关' : '开';
        $dataArray['电加热2输出开关状态'] = $v[7] == 0 ? '关' : '开';
        $dataArray['公共报警输出开关状态'] = $v[8] == 0 ? '关' : '开';
        $dataArray['液路电磁阀1输出开关状态'] = $v[9] == 0 ? '关' : '开';
        $dataArray['液路电磁阀2输出开关状态'] = $v[10] == 0 ? '关' : '开';
        $dataArray['加湿器注水输出开关状态'] = $v[11] == 0 ? '关' : '开';
      

        $dataArray['备用开关（压缩机1反相输出开关状态）'] = $v[14] == 0 ? '关' : '开';
        $dataArray['风阀开关（压缩机2反相输出开关状态）'] = $v[15] == 0 ? '关' : '开';
        $dataArray['制冷状态'] = $v[16] == 0 ? '关' : '开';
        $dataArray['加热状态'] = $v[17] == 0 ? '关' : '开';
        $dataArray['除湿状态'] = $v[18] == 0 ? '关' : '开';
        $dataArray['加湿状态'] = $v[19] == 0 ? '关' : '开';

        //机组运行模式和报警状态
        $v = unpack('c*', substr($memData, 4 + 40*2 + 32 + 13*2 + 19, 28));
        $dataArray['远程关机报警'] = ($v[1]) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['远程关机报警'] = ($v[1]) & 0x1 == 1;
        $dataArray['地板溢水报警'] = ($v[1] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['地板溢水报警'] = ($v[1] >> 1) & 0x1 == 1;
        $dataArray['加湿器报警'] = ($v[1] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['加湿器报警'] = ($v[1] >> 3) & 0x1 == 1;
        $dataArray['电加热报警'] = ($v[1] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电加热报警'] = ($v[1] >> 4) & 0x1 == 1;
        $dataArray['风机1故障报警'] = ($v[1] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['风机1故障报警'] = ($v[1] >> 6) & 0x1 == 1;

        $dataArray['烟感报警'] = ($v[3] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['烟感报警'] = ($v[3] >> 3) & 0x1 == 1;
        $dataArray['气流丢失报警'] = ($v[3] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['气流丢失报警'] = ($v[3] >> 7) & 0x1 == 1;
        $dataArray['自定义1报警'] = ($v[4] >> 0) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['自定义1报警'] = ($v[4] >> 0) & 0x1 == 1;
        $dataArray['过滤网维护提醒'] = ($v[4] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['过滤网维护提醒'] = ($v[4] >> 1) & 0x1 == 1;
        $dataArray['自定义2报警'] = ($v[4] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['自定义2报警'] = ($v[4] >> 4) & 0x1 == 1;

        $dataArray['加湿高水位报警'] = ($v[5] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['加湿高水位报警'] = ($v[5] >> 3) & 0x1 == 1;

        $dataArray['回风高湿报警'] = ($v[6] >> 0) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风高湿报警'] = ($v[6] >> 0) & 0x1 == 1;
        $dataArray['回风低湿报警'] = ($v[6] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风低湿报警'] = ($v[6] >> 1) & 0x1 == 1;
        $dataArray['回风高温报警'] = ($v[6] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风高温报警'] = ($v[6] >> 2) & 0x1 == 1;
        $dataArray['回风低温报警'] = ($v[6] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风低温报警'] = ($v[6] >> 3) & 0x1 == 1;
        $dataArray['送风高温报警'] = ($v[6] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['送风高温报警'] = ($v[6] >> 4) & 0x1 == 1 ;

        $dataArray['回风温度传感器1故障'] = $v[8] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风温度传感器1故障'] = $v[8] & 0x1 == 1;
        $dataArray['回风湿度传感器1故障'] = ($v[8] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['回风湿度传感器1故障'] = ($v[8] >> 3) & 0x1 == 1;
        $dataArray['气流温度传感器故障'] = ($v[8] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['气流温度传感器故障'] = ($v[8] >> 6) & 0x1 == 1;
        $dataArray['送风温度传感器1故障'] = ($v[8] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['送风温度传感器1故障'] = ($v[8] >> 7) & 0x1 == 1;

        $dataArray['风压传感器1故障'] = ($v[13] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['风压传感器1故障'] = ($v[13] >> 7) & 0x1 == 1;

        $dataArray['电源丢失报警'] = ($v[14] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源丢失报警'] = ($v[14] >> 3) & 0x1 == 1;
        $dataArray['电源过压报警'] = ($v[14] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源过压报警'] = ($v[14] >> 4) & 0x1 == 1;
        $dataArray['电源欠压报警'] = ($v[14] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源欠压报警'] = ($v[14] >> 5) & 0x1 == 1;
        $dataArray['电源频偏报警'] = ($v[14] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源频偏报警'] = ($v[14] >> 6) & 0x1 == 1;
        $dataArray['电源缺相报警'] = ($v[14] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源缺相报警'] = ($v[14] >> 7) & 0x1 == 1;

        $dataArray['电源反相报警'] = $v[15] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['电源反相报警'] = $v[15] & 0x1 == 1;
        $dataArray['群控地址重复'] = ($v[15] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['群控地址重复'] = ($v[15] >> 3) & 0x1 == 1 ;
        $dataArray['群控主机丢失'] = ($v[15] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['群控主机丢失'] = ($v[15] >> 4) & 0x1 == 1;
        $dataArray['群控从机丢失'] = ($v[15] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['群控从机丢失'] = ($v[15] >> 5) & 0x1 == 1;

        $dataArray['高压1报警'] = ($v[17] >> 0) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压1报警'] = ($v[17] >> 0) & 0x1 == 1;
        $dataArray['高压2报警'] = ($v[17] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压2报警'] = ($v[17] >> 1) & 0x1 == 1;
        $dataArray['低压1报警'] = ($v[17] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压1报警'] = ($v[17] >> 2) & 0x1 == 1;
        $dataArray['低压2报警'] = ($v[17] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压2报警'] = ($v[17] >> 3) & 0x1 == 1;
        $dataArray['高压1锁定报警'] = ($v[17] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压1锁定报警'] = ($v[17] >> 4) & 0x1 == 1;
        $dataArray['高压2锁定报警'] = ($v[17] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压2锁定报警'] = ($v[17] >> 5) & 0x1 == 1;
        $dataArray['低压1锁定报警'] = ($v[17] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压1锁定报警'] = ($v[17] >> 6) & 0x1 == 1;
        $dataArray['低压2锁定报警'] = ($v[17] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压2锁定报警'] = ($v[17] >> 7) & 0x1 == 1;

        $dataArray['排气1高温报警'] = ($v[18] >> 0) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气1高温报警'] = ($v[18] >> 0) & 0x1 == 1;
        $dataArray['排气2高温报警'] = ($v[18] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气2高温报警'] = ($v[18] >> 1) & 0x1 == 1;
        $dataArray['排气1过低报警'] = ($v[18] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气1过低报警'] = ($v[18] >> 2) & 0x1 == 1;
        $dataArray['排气2过低报警'] = ($v[18] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气2过低报警'] = ($v[18] >> 3) & 0x1 == 1;
        $dataArray['排气1高温锁定报警'] = ($v[18] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气1高温锁定报警'] = ($v[18] >> 4) & 0x1 == 1;
        $dataArray['排气2高温锁定报警'] = ($v[18] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气2高温锁定报警'] = ($v[18] >> 5) & 0x1 == 1;
        $dataArray['排气1过低锁定报警'] = ($v[18] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气1过低锁定报警'] = ($v[18] >> 6) & 0x1 == 1;
        $dataArray['排气2过低锁定报警'] = ($v[18] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气2过低锁定报警'] = ($v[18] >> 7) & 0x1 == 1;

        $dataArray['高压1压力故障报警'] = ($v[20] >> 0) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压1压力故障报警'] = ($v[20] >> 0) & 0x1 == 1;
        $dataArray['高压2压力故障报警'] = ($v[20] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高压2压力故障报警'] = ($v[20] >> 1) & 0x1 == 1;
        $dataArray['低压1压力故障报警'] = ($v[20] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压1压力故障报警'] = ($v[20] >> 2) & 0x1 == 1;
        $dataArray['低压2压力故障报警'] = ($v[20] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['低压2压力故障报警'] = ($v[20] >> 3) & 0x1 == 1;
        $dataArray['排气1温度故障报警'] = ($v[20] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气1温度故障报警'] = ($v[20] >> 4) & 0x1 == 1;
        $dataArray['排气2温度故障报警'] = ($v[20] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['排气2温度故障报警'] = ($v[20] >> 5) & 0x1 == 1;
        $dataArray['吸气1温度故障报警'] = ($v[20] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['吸气1温度故障报警'] = ($v[20] >> 6) & 0x1 == 1;
        $dataArray['吸气2温度故障报警'] = ($v[20] >> 7) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['吸气2温度故障报警'] = ($v[20] >> 7) & 0x1 == 1;

        $dataArray['压缩机过载'] = ($v[25] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['压缩机过载'] = ($v[25] >> 2) & 0x1 == 1;

        $dataArray['压缩机故障'] = ($v[27]) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['压缩机故障'] = ($v[27]) & 0x1 == 1;
        $dataArray['主机关机报警'] = ($v[27] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['主机关机报警'] = ($v[27] >> 5) & 0x1 == 1;
        $dataArray['风机关机报警'] = ($v[27] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['风机关机报警'] = ($v[27] >> 6) & 0x1 == 1;

        $v = unpack('v',substr($memData, 4 + 40*2 + 32 + 13*2 + 19 + 28, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 40*2 + 32 + 13*2 + 19 + 28 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
