<?php
function Get_pexap_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '回风温度':
            return array(0, $dataArray["回风温度"]);
        case '温度设定点':
            return array(0, $dataArray["温度设定点"]);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pexap_RtData($memData, &$dataArray, $extraPara = false)
{
    if(emtpy($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('s*',substr($memData, 4, 2*2));
        switch($v[1])
        {
            case 0:
                $dataArray['开关机状态'] = "关机";
                break;
            case 1:
                $dataArray['开关机状态'] = "开机";
                break;
            case 2:
                $dataArray['开关机状态'] = "备机";
                break;
        }
        switch($v[2])
        {
            case 0:
                $dataArray['群控运行模式'] = "单机";
                break;
            case 1:
                $dataArray['群控运行模式'] = "群控 0 模式";
                break;
            case 2:
                $dataArray['群控运行模式'] = "群控 1 模式";
                break;
            case 3:
                $dataArray['群控运行模式'] = "群控 2 模式";
                break;
            case 4:
                $dataArray['群控运行模式'] = "群控 3 模式";
                break;
        }
        $v = unpack('f*',substr($memData,4 + 2*2, 6*4));
        $dataArray['回风温度'] = number_format($v[1],2);
        $dataArray['回风湿度'] = number_format($v[2],2);
        $dataArray['A相电压'] = number_format($v[3],2);
        $dataArray['B相电压'] = number_format($v[4],2);
        $dataArray['C相电压'] = number_format($v[5],2);
        $dataArray['电源频率'] = $v[6];
        $v = unpack('S*',substr($memData, 4 + 2*2 + 16*4, 13*2));
        $dataArray['风机已运行时间'] = $v[1];
        $dataArray['压缩机1已运行时间'] = $v[2];
        $dataArray['压缩机2已运行时间'] = $v[3];
        $dataArray['加热器1已运行时间'] = $v[4];
        $dataArray['加热器2已运行时间'] = $v[5];
        $dataArray['加湿器已运行时间'] = $v[6];
        $dataArray['制冷状态'] = ($v[7] & 0x1) ? "开" : "关";
        $dataArray['加热状态'] = (($v[7]>>1) & 0x1) ? "开" : "关";
        $dataArray['除湿状态'] = (($v[7]>>2) & 0x1) ? "开" : "关";
        $dataArray['加湿状态'] = (($v[7]>>3) & 0x1) ? "开" : "关";
        $dataArray['风机输出开关状态'] = (($v[7]>>4) & 0x1) ? "开" : "关";
        $dataArray['注水输出开关状态'] = (($v[7]>>5) & 0x1) ? "开" : "关";
        $dataArray['公共告警输出开关状态'] = (($v[7]>>6) & 0x1) ? "开" : "关";

        $dataArray['AlertArray'] = array();
        //alarm1
        $dataArray['压缩机1高压报警'] = ($v[10] & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机1高压报警'] = ($v[10] & 0x1);
        $dataArray['压缩机2高压报警'] = (($v[10]>>1) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机2高压报警'] = (($v[10]>>1) & 0x1);
        $dataArray['压缩机1低压报警'] = (($v[10]>>2) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机1低压报警'] = (($v[10]>>2) & 0x1);
        $dataArray['压缩机2低压报警'] = (($v[10]>>3) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机2低压报警'] = (($v[10]>>3) & 0x1);
        $dataArray['排气1高温报警'] = (($v[10]>>4) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气1高温报警'] = (($v[10]>>4) & 0x1);
        $dataArray['排气1低温报警'] = (($v[10]>>5) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气1低温报警'] = (($v[10]>>5) & 0x1);
        $dataArray['排气2高温报警'] = (($v[10]>>6) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气2高温报警'] = (($v[10]>>6) & 0x1);
        $dataArray['排气2低温报警'] = (($v[10]>>7) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气2低温报警'] = (($v[10]>>7) & 0x1);
        $dataArray['风机故障报警'] = (($v[10]>>8) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['风机故障报警'] = (($v[10]>>8) & 0x1);
        $dataArray['高温报警'] = (($v[10]>>9) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['高温报警'] = (($v[10]>>9) & 0x1);
        $dataArray['低温报警'] = (($v[10]>>10) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低温报警'] = (($v[10]>>10) & 0x1);
        $dataArray['高湿报警'] = (($v[10]>>11) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['高湿报警'] = (($v[10]>>11) & 0x1);
        $dataArray['低湿报警'] = (($v[10]>>12) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低湿报警'] = (($v[10]>>12) & 0x1);
        $dataArray['加湿器故障报警'] = (($v[10]>>13) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['加湿器故障报警'] = (($v[10]>>13) & 0x1);
        $dataArray['气流丢失报警'] = (($v[10]>>14) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['气流丢失报警'] = (($v[10]>>14) & 0x1);
        $dataArray['远程关机报警'] = (($v[10]>>15) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['远程关机报警'] = (($v[10]>>15) & 0x1);
        //alarm2
        $dataArray['温湿度检测板报警'] = ($v[11] & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['温湿度检测板报警'] = ($v[11] & 0x1);
        $dataArray['NTC1故障'] = (($v[11]>>1) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['NTC1故障'] = (($v[11]>>1) & 0x1);
        $dataArray['NTC2故障'] = (($v[11]>>2) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['NTC2故障'] = (($v[11]>>2) & 0x1);
        $dataArray['NTC3故障'] = (($v[11]>>3) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['NTC3故障'] = (($v[11]>>3) & 0x1);
        $dataArray['烟雾传感器报警'] = (($v[11]>>4) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['烟雾传感器报警'] = (($v[11]>>4) & 0x1);
        $dataArray['电加热故障报警'] = (($v[11]>>5) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电加热故障报警'] = (($v[11]>>5) & 0x1);
        $dataArray['自定义1报警'] = (($v[11]>>6) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['自定义1报警'] = (($v[11]>>6) & 0x1);
        $dataArray['自定义2报警'] = (($v[11]>>7) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['自定义2报警'] = (($v[11]>>7) & 0x1);
        $dataArray['风机运行超时报警'] = (($v[11]>>8) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['风机运行超时报警'] = (($v[11]>>8) & 0x1);
        $dataArray['压缩机1运行超时报警'] = (($v[11]>>9) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机1运行超时报警'] = (($v[11]>>9) & 0x1);
        $dataArray['压缩机2运行超时报警'] = (($v[11]>>10) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['压缩机2运行超时报警'] = (($v[11]>>10) & 0x1);
        $dataArray['加热器1运行超时报警'] = (($v[11]>>11) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['加热器1运行超时报警'] = (($v[11]>>11) & 0x1);
        $dataArray['加热器2运行超时报警'] = (($v[11]>>12) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['加热器2运行超时报警'] = (($v[11]>>12) & 0x1);
        $dataArray['加湿器需维护'] = (($v[11]>>13) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['加湿器需维护'] = (($v[11]>>13) & 0x1);
        $dataArray['电源丢失报警'] = (($v[11]>>14) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源丢失报警'] = (($v[11]>>14) & 0x1);
        $dataArray['电源过压报警'] = (($v[11]>>15) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源过压报警'] = (($v[11]>>15) & 0x1);
        //alarm3
        $dataArray['电源欠压报警'] = ($v[12] & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源欠压报警'] = ($v[12] & 0x1);
        $dataArray['电源频偏报警'] = (($v[12]>>1) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源频偏报警'] = (($v[12]>>1) & 0x1);
        $dataArray['电源缺相报警'] = (($v[12]>>2) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源缺相报警'] = (($v[12]>>2) & 0x1);
        $dataArray['电源反相报警'] = (($v[12]>>3) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['电源反相报警'] = (($v[12]>>3) & 0x1);
        $dataArray['地板溢水报警'] = (($v[12]>>4) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['地板溢水报警'] = (($v[12]>>4) & 0x1);
        $dataArray['机组地址重复报警'] = (($v[12]>>5) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['机组地址重复报警'] = (($v[12]>>5) & 0x1);
        $dataArray['群控从机丢失报警'] = (($v[12]>>6) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['群控从机丢失报警'] = (($v[12]>>6) & 0x1);
        $dataArray['群控主机丢失报警'] = (($v[12]>>7) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['群控主机丢失报警'] = (($v[12]>>7) & 0x1);
        $dataArray['高压1锁定报警'] = (($v[12]>>8) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['高压 1 锁定报警'] = (($v[12]>>8) & 0x1);
        $dataArray['高压2锁定报警'] = (($v[12]>>9) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['高压2锁定报警'] = (($v[12]>>9) & 0x1);
        $dataArray['低压1锁定报警'] = (($v[12]>>10) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低压1锁定报警'] = (($v[12]>>10) & 0x1);
        $dataArray['低压2锁定报警'] = (($v[12]>>11) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低压2锁定报警'] = (($v[12]>>11) & 0x1);
        $dataArray['盘管1冻结报警'] = (($v[12]>>12) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['盘管1冻结报警'] = (($v[12]>>12) & 0x1);
        $dataArray['盘管2冻结报警'] = (($v[12]>>13) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['盘管2冻结报警'] = (($v[12]>>13) & 0x1);
        $dataArray['送风高温报警'] = (($v[12]>>14) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['送风高温报警'] = (($v[12]>>14) & 0x1);
        $dataArray['A路水流丢失报警'] = (($v[12]>>15) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['A路水流丢失报警'] = (($v[12]>>15) & 0x1);
        //alarm4
        $dataArray['B路水流丢失报警'] = ($v[13] & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['B路水流丢失报警'] = ($v[13] & 0x1);
        $dataArray['风压传感器故障报警'] = (($v[13]>>1) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['风压传感器故障报警'] = (($v[13]>>1) & 0x1);
        $dataArray['加湿器高水位报警'] = (($v[13]>>2) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['加湿器高水位报警'] = (($v[13]>>2) & 0x1);
        $dataArray['排气1高温锁定'] = (($v[13]>>3) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气1高温锁定'] = (($v[13]>>3) & 0x1);
        $dataArray['排气2高温锁定'] = (($v[13]>>4) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气2高温锁定'] = (($v[13]>>4) & 0x1);
        $dataArray['排气1低温锁定'] = (($v[13]>>5) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气1低温锁定'] = (($v[13]>>5) & 0x1);
        $dataArray['排气2低温锁定'] = (($v[13]>>6) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['排气2低温锁定'] = (($v[13]>>6) & 0x1);
        $dataArray['低压传感器1故障'] = (($v[13]>>7) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低压传感器1故障'] = (($v[13]>>7) & 0x1);
        $dataArray['低压传感器2故障'] = (($v[13]>>8) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['低压传感器2故障'] = (($v[13]>>8) & 0x1);
        $dataArray['过滤网需维护'] = (($v[13]>>9) & 0x1) ? "告警" : "正常" ;
        $dataArray['AlertArray']['过滤网需维护'] = (($v[13]>>9) & 0x1);
        $v = unpack('S*', substr($memData, 4 + 2*2 + 16*4 + 13*2, 2*2));
        $dataArray['温度设定点'] = number_format($v[1]/10, 1);
        $dataArray['湿度设定点'] = number_format($v[2]/10, 1);
        $v = unpack('v',substr($memData, 4 + 2*2 + 16*4 + 13*2 + 4, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*2 + 16*4 + 13*2 + 4 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
?>
