<?php
function Get_pm4s_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['更新时间'] = '无';
            $dataArray['无数据']  = true;
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //电源参数
            $v = unpack('s*',substr($memData, 4 ,52 * 2));
            $dataArray['交流1一路AB线电压'] = ($v[1] / 10).' V';
            $dataArray['交流1一路BC线电压'] = ($v[2] / 10).' V';
            $dataArray['交流1一路CA线电压'] = ($v[3] / 10).' V';
            $dataArray['交流1二路AB线电压'] = ($v[4] / 10).' V';
            $dataArray['交流1二路BC线电压'] = ($v[5] / 10).' V';
            $dataArray['交流1二路CA线电压'] = ($v[6] / 10).' V';
            $dataArray['交流1电流'] = ($v[7] / 10).' A';
            $dataArray['一组电池电压'] = ($v[8] / 10).' V';
            $dataArray['一段合母电压'] = ($v[9] / 10).' V';
            $dataArray['一段控母电压'] = ($v[10] / 10).' V';
            $dataArray['一组电池电流'] = $v[11] == -32766 ? '0 A' : ($v[11] / 10).' A';
            $dataArray['一段控母电流'] = ($v[12] / 10).' A';
            $dataArray['二组电池电压'] = ($v[13] / 10).' V';
            $dataArray['二段合母电压'] = ($v[14] / 10).' V';
            $dataArray['二段控母电压'] = ($v[15] / 10).' V';
            $dataArray['二组电池电流'] = ($v[16] / 10).' A';
            $dataArray['二段控母电流'] = ($v[17] / 10).' A';
            $dataArray['环境温度'] = ($v[18] / 10).' ℃';
            //扩展量   4
            $dataArray['交流2一路AB线电压'] = ($v[23] / 10).' V';
            $dataArray['交流2一路BC线电压'] = ($v[24] / 10).' V';
            $dataArray['交流2一路CA线电压'] = ($v[25] / 10).' V';
            $dataArray['交流2二路AB线电压'] = ($v[26] / 10).' V';
            $dataArray['交流2二路BC线电压'] = ($v[27] / 10).' V';
            $dataArray['交流2二路CA线电压'] = ($v[28] / 10).' V';
            $dataArray['交流2电流'] = ($v[29] / 10).' A';
            //保留7
            $dataArray['逆变模块01输出电压'] = ($v[37] / 10).' V';
            $dataArray['逆变模块01输出电流'] = ($v[38] / 10).' A';
            $dataArray['逆变模块02输出电压'] = ($v[39] / 10).' V';
            $dataArray['逆变模块02输出电流'] = ($v[40] / 10).' A';
            $dataArray['逆变模块03输出电压'] = ($v[41] / 10).' V';
            $dataArray['逆变模块03输出电流'] = ($v[42] / 10).' A';
            $dataArray['逆变模块04输出电压'] = ($v[43] / 10).' V';
            $dataArray['逆变模块04输出电流'] = ($v[44] / 10).' A';
            $dataArray['DC/DC模块01输出电压'] = ($v[45] / 10).' V';
            $dataArray['DC/DC模块01输出电流'] = ($v[46] / 10).' A';
            $dataArray['DC/DC模块02输出电压'] = ($v[47] / 10).' V';
            $dataArray['DC/DC模块02输出电流'] = ($v[48] / 10).' A';
            $dataArray['DC/DC模块03输出电压'] = ($v[49] / 10).' V';
            $dataArray['DC/DC模块03输出电流'] = ($v[50] / 10).' A';
            $dataArray['DC/DC模块04输出电压'] = ($v[51] / 10).' V';
            $dataArray['DC/DC模块04输出电流'] = ($v[52] / 10).' A';
            //一组电池1-112节电压
            $v = unpack('s*',substr($memData,4 + 52 * 2 , 112 *2));
            $dataArray['电池组一'] = array();
            for($k = 1 ; $k <= 112 ; $k++){
                $dataArray['电池组一'][$k.' 节电压'] = ($v[$k] / 100).' V';
            }
            //二组电池1-112节电压
            $v = unpack('s*',substr($memData,4 + 164 * 2, 112 *2));
            $dataArray['电池组二'] = array();
            for($k = 1 ; $k <= 112 ; $k++){
                $dataArray['电池组二'][$k.' 节电压'] = ($v[$k] / 100).' V';
            }
            //告警状态量
            $v = unpack('C*',substr($memData,4 + 276 * 2, 64));
            $dataArray['交流1一路故障'] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['交流1二路故障'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['交流1一路工作'] = $v[3] == 1 ? '工作' : '备用';
            $dataArray['交流1二路工作'] = $v[4] == 1 ? '工作' : '备用';
            $dataArray['交流1防雷故障'] = $v[5] == 1 ? '告警' : '正常';
            $dataArray['交流1开关故障'] = $v[6] == 1 ? '告警' : '正常';
            $dataArray['交流1通讯故障'] = $v[7] == 1 ? '告警' : '正常';
            $dataArray['逆变模块通讯故障'] = $v[8] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['交流1一路故障'] = $v[1] == 1;
            $dataArray['AlertArray']['交流1二路故障'] = $v[2] == 1;
            $dataArray['AlertArray']['交流1防雷故障'] = $v[5] == 1;
            $dataArray['AlertArray']['交流1开关故障'] = $v[6] == 1;
            $dataArray['AlertArray']['交流1通讯故障'] = $v[7] == 1;
            $dataArray['AlertArray']['逆变模块通讯故障'] = $v[8] == 1;
            
            $dataArray['模块故障'] = $v[9] == 1 ? '告警' : '正常';
            $dataArray['模块通讯故障'] = $v[10] == 1 ? '告警' : '正常';//保留   11  12  13  14
            $dataArray['开关监控通讯故障'] = $v[15] == 1 ? '告警' : '正常';
            $dataArray['DC/DC模块通讯故障'] = $v[16] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['模块故障'] = $v[9] == 1;
            $dataArray['AlertArray']['模块通讯故障'] = $v[10] == 1;
            $dataArray['AlertArray']['开关监控通讯故障'] = $v[15] == 1;
            $dataArray['AlertArray']['DC/DC模块通讯故障'] = $v[16] == 1;
            
            $dataArray['一段合母过压'] = $v[17] == 1 ? '告警' : '正常';
            $dataArray['一段合母欠压'] = $v[18] == 1 ? '告警' : '正常';
            $dataArray['一段控母过压'] = $v[19] == 1 ? '告警' : '正常';
            $dataArray['一段控母欠压'] = $v[20] == 1 ? '告警' : '正常';
            $dataArray['一组电池欠压'] = $v[21] == 1 ? '告警' : '正常';
            $dataArray['一组电池均充'] = $v[22] == 1 ? '均充' : '浮充';
            $dataArray['直流监控通讯故障'] = $v[23] == 1 ? '告警' : '正常';//保留   24
            $dataArray['AlertArray']['一段合母过压'] = $v[17] == 1;
            $dataArray['AlertArray']['一段合母欠压'] = $v[18] == 1;
            $dataArray['AlertArray']['一段控母过压'] = $v[19] == 1;
            $dataArray['AlertArray']['一段控母欠压'] = $v[20] == 1;
            $dataArray['AlertArray']['一组电池欠压'] = $v[21] == 1;
            $dataArray['AlertArray']['直流监控通讯故障'] = $v[23] == 1;
            
            $dataArray['二段合母过压'] = $v[25] == 1 ? '告警' : '正常';
            $dataArray['二段合母欠压'] = $v[26] == 1 ? '告警' : '正常';
            $dataArray['二段控母过压'] = $v[27] == 1 ? '告警' : '正常';
            $dataArray['二段控母欠压'] = $v[28] == 1 ? '告警' : '正常';
            $dataArray['二组电池欠压'] = $v[29] == 1 ? '告警' : '正常';
            $dataArray['二组电池均充'] = $v[30] == 1 ? '均充' : '浮充';//保留 31 32
            $dataArray['AlertArray']['二段合母过压'] = $v[25] == 1;
            $dataArray['AlertArray']['二段合母欠压'] = $v[26] == 1;
            $dataArray['AlertArray']['二段控母过压'] = $v[27] == 1;
            $dataArray['AlertArray']['二段控母欠压'] = $v[28] == 1;
            $dataArray['AlertArray']['二组电池欠压'] = $v[29] == 1;
            
            //33 34 35 保留
            $dataArray['一段绝缘差压'] = $v[36] == 1 ? '告警' : '正常';
            $dataArray['二段绝缘差压'] = $v[37] == 1 ? '告警' : '正常';
            $dataArray['一段绝缘故障'] = $v[38] == 1 ? '告警' : '正常';
            $dataArray['二段绝缘故障'] = $v[39] == 1 ? '告警' : '正常';
            $dataArray['绝缘检测通讯故障'] = $v[40] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['一段绝缘差压'] = $v[36] == 1;
            $dataArray['AlertArray']['二段绝缘差压'] = $v[37] == 1;
            $dataArray['AlertArray']['一段绝缘故障'] = $v[38] == 1;
            $dataArray['AlertArray']['二段绝缘故障'] = $v[39] == 1;
            $dataArray['AlertArray']['绝缘检测通讯故障'] = $v[40] == 1;
            
            $dataArray['一组单体电池过压'] = $v[41] == 1 ? '告警' : '正常';
            $dataArray['一组单体电池欠压'] = $v[42] == 1 ? '告警' : '正常';
            $dataArray['一组单体电池差压'] = $v[43] == 1 ? '告警' : '正常';
            $dataArray['二组单体电池过压'] = $v[44] == 1 ? '告警' : '正常';
            $dataArray['二组单体电池欠压'] = $v[45] == 1 ? '告警' : '正常';
            $dataArray['二组单体电池差压'] = $v[46] == 1 ? '告警' : '正常';//47 保留
            $dataArray['电池巡检通讯故障'] = $v[48] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['一组单体电池过压'] = $v[41] == 1;
            $dataArray['AlertArray']['一组单体电池欠压'] = $v[42] == 1;
            $dataArray['AlertArray']['一组单体电池差压'] = $v[43] == 1;
            $dataArray['AlertArray']['二组单体电池过压'] = $v[44] == 1;
            $dataArray['AlertArray']['二组单体电池欠压'] = $v[45] == 1;
            $dataArray['AlertArray']['二组单体电池差压'] = $v[46] == 1;
            $dataArray['AlertArray']['电池巡检通讯故障'] = $v[48] == 1;
            
            $dataArray['交流2一路故障'] = $v[49] == 1 ? '告警' : '正常';
            $dataArray['交流2二路故障'] = $v[50] == 1 ? '告警' : '正常';
            $dataArray['交流2一路工作'] = $v[51] == 1 ? '告警' : '正常';
            $dataArray['交流2二路工作'] = $v[52] == 1 ? '告警' : '正常';
            $dataArray['交流2防雷故障'] = $v[53] == 1 ? '告警' : '正常';
            $dataArray['交流2开关故障'] = $v[54] == 1 ? '告警' : '正常';
            $dataArray['交流2通讯故障'] = $v[55] == 1 ? '告警' : '正常';//56-64 保留
            $dataArray['AlertArray']['交流2一路故障'] = $v[49] == 1;
            $dataArray['AlertArray']['交流2二路故障'] = $v[50] == 1;
            $dataArray['AlertArray']['交流2一路工作'] = $v[51] == 1;
            $dataArray['AlertArray']['交流2二路工作'] = $v[52] == 1;
            $dataArray['AlertArray']['交流2防雷故障'] = $v[53] == 1;
            $dataArray['AlertArray']['交流2开关故障'] = $v[54] == 1;
            $dataArray['AlertArray']['交流2通讯故障'] = $v[55] == 1;
            //告警
            $alertArr1 = array('交流监控1通讯故障','交流监控2通讯故障','交流监控3通讯故障','直流监控通讯故障','电池巡检1通讯故障','电池巡检2通讯故障','电池巡检3通讯故障','电池巡检4通讯故障','开关量监控1通讯故障','开关量监控2通讯故障','开关量监控3通讯故障','开关量监控4通讯故障','绝缘检测1通讯故障','绝缘检测2通讯故障','绝缘检测3通讯故障','绝缘检测4通讯故障');
            $v = unpack('C*',substr($memData,4 + 276 * 2 + 64, 224));
            foreach($alertArr1 as $key=>$val){
                $j = $key+1;
                $dataArray[$val] = $v[$key] == 1 ? '告警' : '正常';
                $dataArray['AlertArray'][$val] = $v[$key] == 1;
            }
            $moduleAlert = array('01#模块通讯故障','02#模块通讯故障','03#模块通讯故障','04#模块通讯故障','05#模块通讯故障','06#模块通讯故障','07#模块通讯故障','08#模块通讯故障','09#模块通讯故障','10#模块通讯故障',
                '11#模块通讯故障','12#模块通讯故障','13#模块通讯故障','14#模块通讯故障','15#模块通讯故障','16#模块通讯故障','01#模块故障','02#模块故障','03#模块故障','04#模块故障','05#模块故障','06#模块故障','07#模块故障',
                '08#模块故障','09#模块故障','10#模块故障','11#模块故障','12#模块故障','13#模块故障','14#模块故障','15#模块故障','16#模块故障','01#逆变模块通讯故障','02#逆变模块通讯故障','03#逆变模块通讯故障','04#逆变模块通讯故障',
                '01#通讯模块通讯故障','02#通讯模块通讯故障','03#通讯模块通讯故障','04#通讯模块通讯故障','01#逆变模块故障','02#逆变模块故障','03#逆变模块故障','04#逆变模块故障','01#通讯模块故障','02#通讯模块故障','03#通讯模块故障',
                '04#通讯模块故障');
            foreach($moduleAlert as $key=>$alert){
                $j = $key+17;
                $dataArray[$alert] = $v[$j] == 1 ? '告警' : '正常';
                $dataArray['AlertArray'][$alert] = $v[$j] == 1;
            }
            $dataArray['开关量1'] = array();
            $dataArray['开关量2'] = array();
            $dataArray['开关量3'] = array();
            $dataArray['开关量4'] = array();
            for($i = 1 ; $i <= 32 ; $i++){
                $j = $i+64;
                $dataArray['开关量1'][$i.' 路开关故障'] = $v[$j] == 1 ? '告警' : '正常';
                $dataArray['开关量1']['AlertArray'][$i.' 路开关故障'] = $v[$j] == 1;
                $k = $i+96;
                $dataArray['开关量3'][$i.' 路开关故障'] = $v[$k] == 1 ? '告警' : '正常';
                $dataArray['开关量3']['AlertArray'][$i.' 路开关故障'] = $v[$k] == 1;
                $p = $i+128;
                $dataArray['开关量2'][$i.' 路开关故障'] = $v[$p] == 1 ? '告警' : '正常';
                $dataArray['开关量2']['AlertArray'][$i.' 路开关故障'] = $v[$p] == 1;
                $q = $i+160;
                $dataArray['开关量4'][$i.' 路开关故障'] = $v[$q] == 1 ? '告警' : '正常';
                $dataArray['开关量4']['AlertArray'][$i.' 路开关故障'] = $v[$q] == 1;
            }
            $switchAlert = array('电池开关01故障','电池开关02故障','外接设备01故障','外接设备02故障','熔断器01故障','熔断器02故障','绝缘01故障','绝缘02故障');
            foreach($switchAlert as $key=>$alert){
                $i = $key+193;
                $j = $key+201;
                $k = $key+209;
                $p = $key+217;
                $dataArray['开关量1'][$alert] = $v[$i] == 1 ? '告警' : '正常';
                $dataArray['开关量1']['AlertArray'][$alert] = $v[$i] == 1;
                $dataArray['开关量2'][$alert] = $v[$j] == 1 ? '告警' : '正常';
                $dataArray['开关量2']['AlertArray'][$alert] = $v[$j] == 1;
                $dataArray['开关量3'][$alert] = $v[$k] == 1 ? '告警' : '正常';
                $dataArray['开关量3']['AlertArray'][$alert] = $v[$k] == 1;
                $dataArray['开关量4'][$alert] = $v[$p] == 1 ? '告警' : '正常';
                $dataArray['开关量4']['AlertArray'][$alert] = $v[$p] == 1;
            }
            $v = unpack('v', substr($memData,4 + 276 * 2 + 64 + 224, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData,4 + 276 * 2 + 64 + 224 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
