<?php
function Get_pm5350_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pm5350_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功总电能2']);
}

function Get_pm5350_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('f*',substr($memData, 4, 47*4));
        $dataArray["A相电流"] = number_format($v[1], 2)." A";
        $dataArray["B相电流"] = number_format($v[2], 2)." A";
        $dataArray["C相电流"] = number_format($v[5], 2)." A";
        $dataArray["N相电流"] = number_format($v[4], 2)." A";
        $dataArray["G相电流"] = number_format($v[3], 2)." A";
        $dataArray["平均电流"] = number_format($v[6], 2)." A";
        $dataArray["A相电流不平衡度"] = number_format($v[7], 2)." %";
        $dataArray["B相电流不平衡度"] = number_format($v[8], 2)." %";
        $dataArray["C相电流不平衡度"] = number_format($v[9], 2)." %";
        //$dataArray["电流最差不平衡度"] = number_format($v[10], 2)."%";

        $dataArray["AB线电压"] = number_format($v[10], 2)." V";
        $dataArray["A相线电压"] = number_format($v[10], 2);
        $dataArray["BC线电压"] = number_format($v[11], 2)." V";
        $dataArray["B相线电压"] = number_format($v[11], 2);
        $dataArray["CA线电压"] = number_format($v[12], 2)." V";
        $dataArray["C相线电压"] = number_format($v[12], 2);
        $dataArray["平均线电压"] = number_format($v[13], 2)." V";

        $dataArray["A相相电压"] = number_format($v[14], 2)." V";
        $dataArray["B相相电压"] = number_format($v[15], 2)." V";
        $dataArray["C相相电压"] = number_format($v[16], 2)." V";
        //17 是 reserved
        $dataArray["L相相电压"] = number_format($v[18], 2)." V";

        $dataArray["AB线电压不平衡度"] = number_format($v[19], 2)." %";
        $dataArray["BC线电压不平衡度"] = number_format($v[20], 2)." %";
        $dataArray["CA线电压不平衡度"] = number_format($v[21], 2)." %";
        $dataArray["线电压最差不平衡度"] = number_format($v[22], 2)." %";

        $dataArray["A相电压不平衡度"] = number_format($v[23], 2)." %";
        $dataArray["B相电压不平衡度"] = number_format($v[24], 2)." %";
        $dataArray["C相电压不平衡度"] = number_format($v[25], 2)." %";
        $dataArray["相电压最差不平衡度"] = number_format($v[26], 2)." %";

        $dataArray["A相有功功率"] = number_format($v[27], 2)." kW";
        $dataArray["B相有功功率"] = number_format($v[28], 2)." kW";
        $dataArray["C相有功功率"] = number_format($v[29], 2)." kW";
        $dataArray["总有功功率"] = number_format($v[30], 2)." kW";
        $dataArray["总有功功率2"] = number_format($v[30], 3,'.','');

        $dataArray["A相无功功率"] = number_format($v[31], 2)." kVar";
        $dataArray["B相无功功率"] = number_format($v[32], 2)." kVar";
        $dataArray["C相无功功率"] = number_format($v[33], 2)." kVar";
        $dataArray["总无功功率"] = number_format($v[34], 2)." kVar";

        $dataArray["A相视在功率"] = number_format($v[35], 2)." VA";
        $dataArray["B相视在功率"] = number_format($v[36], 2)." VA";
        $dataArray["C相视在功率"] = number_format($v[37], 2)." VA";
        $dataArray["总视在功率"] = number_format($v[38], 2)." VA";

        $dataArray["A相功率因数"] = number_format($v[39], 2);
        $dataArray["B相功率因数"] = number_format($v[40], 2);
        $dataArray["C相功率因数"] = number_format($v[41], 2);
        $dataArray["总功率因数"] = number_format($v[42], 2);

        $dataArray["相移A相功率因数"] = number_format($v[43], 2);
        $dataArray["相移B相功率因数"] = number_format($v[44], 2);
        $dataArray["相移C相功率因数"] = number_format($v[45], 2);
        $dataArray["相移总功率因数"] = number_format($v[46], 2);

        $dataArray["频率"] = number_format($v[47], 2). " Hz";
        //能量
        $v = unpack('q*', substr($memData,  4 + 47*4, 8*11));
        $dataArray["正向有功总电能"] = $v[1]." WH";
        $dataArray["正向有功总电能2"] = $v[1]/1000;
        $dataArray["反向有功总电能"] = $v[2]." WH";
        $dataArray["正反向有功总电能和"] = $v[3]." WH";
        $dataArray["正反向有功总电能差"] = $v[4]." WH";

        $dataArray["正向无功总电能"] = $v[5]." VARh";
        $dataArray["反向无功总电能"] = $v[6]." VARh";
        $dataArray["正反向无功总电能和"] = $v[7]." VARh";
        $dataArray["正反向无功总电能差"] = $v[8]." VARh";

        $dataArray["正向视在总电能"] = $v[9]." VAh";
        $dataArray["反向视在总电能"] = $v[10]." VAh";
        $dataArray["正反向视在总电能和"] = $v[11]." VAh";
        $v = unpack('v', substr($memData,  4 + 47*4 + 11*8, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 47*4 + 11*8 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
