<?php
function Get_pmac203_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[总功率]':
            return array(0, $dataArray['进线模拟量']["进线有功功率2"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmac203_Active_Power($dataArray){
    return array(0 , $dataArray['进线模拟量']['进线有功电度2'],$dataArray['进线模拟量']['进线有功功率']);
}

function Get_pmac203_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //进线测量数据  PMAC203_1_68_t
        $inputLineSignal = array();
        $v = unpack('f*', substr($memData , 4 , 4*4));
        $inputLineSignal['进线电压'] = number_format($v[1] , 2).' V';
        $inputLineSignal['正极对地电压'] = number_format($v[2] , 2).' V';
        $inputLineSignal['负极对地电压'] = number_format($v[3] , 2).' V';
        $inputLineSignal['进线电流'] = number_format($v[4] , 2).' V';
        $v = unpack('s*', substr($memData , 4 + 4*4 , 1*2));
        $inputLineSignal['进线最大电流'] = $v[1].' A';
        $v = unpack('f*', substr($memData , 4 + 4*4 + 1*2, 6*4));
        $inputLineSignal['进线电流需量'] = number_format($v[1] , 2).' A';
        $inputLineSignal['进线最大电流需量'] = number_format($v[2] , 2).' A';
        $inputLineSignal['进线有功功率'] = number_format($v[3] , 2).' W';
        $inputLineSignal['进线有功功率2'] = number_format($v[3] / 1000 , 3,'.','');
        $inputLineSignal['进线有功需量'] = number_format($v[4] , 2).' W';
        $inputLineSignal['进线最大有功需量'] = number_format($v[5] , 2).' W';
        $inputLineSignal['进线有功电度'] = number_format($v[6] , 2 , '.' ,'').' KWh';
        $inputLineSignal['进线有功电度2'] = number_format($v[6] , 2 , '.' ,'');
        $v = unpack('C*', substr($memData , 4 + 10*4 + 1*2, 6*1));
        $inputLineSignal['开关量模块数量'] = $v[1];
        $inputLineSignal['是否有开关量模块'] = $v[2] == 1 ? '有' : '没有';
        $inputLineSignal['是否有对地电压'] = $v[3] == 1 ? '有' : '没有';
        $inputLineSignal['是否有温度测量'] = $v[4] == 1 ? '有' : '没有';
        $inputLineSignal['是否有第1路绝缘电阻测量'] = $v[5] == 1 ? '有' : '没有';
        $inputLineSignal['是否有第2路绝缘电阻测量'] = $v[6] == 1 ? '有' : '没有';
        $v = unpack('S*', substr($memData , 4 + 10*4 + 1*2 + 6*1, 1*2));
        $inputLineSignal['CT变比'] = $v[1];
        $inputLineStatus = array();
        $v = unpack('C*', substr($memData , 4 + 10*4 + 2*2 + 6*1, 6*1));
        $inputLineStatus['主机开关量1'] = $v[1] == 1 ? '闭合' : '断开';
        $inputLineStatus['主机开关量2'] = $v[2] == 1 ? '闭合' : '断开';
        $inputLineStatus['主机开关量3'] = $v[3] == 1 ? '闭合' : '断开';
        $inputLineStatus['主机开关量4'] = $v[4] == 1 ? '闭合' : '断开';
        $inputLineStatus['主机继电器1'] = $v[5] == 1 ? '闭合' : '断开';
        $inputLineStatus['主机继电器2'] = $v[6] == 1 ? '闭合' : '断开';
        $v = unpack('C*', substr($memData , 4 + 10*4 + 2*2 + 12*1, 21*1));
        for($i = 1 ; $i <= 21 ; $i++){
            $inputLineStatus['模块A开关量'.$i] = $v[$i] == 1 ? '闭合' : '断开';
        }
        $v = unpack('C*', substr($memData , 4 + 10*4 + 2*2 + 33*1, 21*1));
        for($i = 1 ; $i <= 21 ; $i++){
            $inputLineStatus['模块B开关量'.$i] = $v[$i] == 1 ? '闭合' : '断开';
        }
        $dataArray['进线状态量'] = $inputLineStatus;
        $v = unpack('f*', substr($memData , 4 + 10*4 + 2*2 + 54*1, 2*4));
        $inputLineSignal['进线绝缘电阻1'] = number_format($v[1] , 2).' KΩ';
        $inputLineSignal['进线绝缘电阻2'] = number_format($v[2] , 2).' KΩ';
        $dataArray['进线模拟量'] = $inputLineSignal;
        
        //PMAC203_101_152_t  进线 出线 告警
        $dataArray['进线告警'] = array();
        $dataArray['进线告警']['AlertArray'] = array();
        $v = unpack('C*', substr($memData , 4 + 12*4 + 2*2 + 54*1, 10*1));
        $dataArray['进线告警']['电流下下限报警'] = $v[1] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['电流下限报警'] = $v[2] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['电流上限报警'] = $v[3] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['电流上上限报警'] = $v[4] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['对地电压上限报警'] = $v[5] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['绝缘电阻1下限报警'] = $v[6] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['低电压报警'] = $v[7] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['高电压报警'] = $v[8] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['绝缘电阻2下限报警'] = $v[9] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['温度上限报警'] = $v[10] == 1 ? '告警' : '正常';       
        $dataArray['进线告警']['AlertArray']['电流下下限报警'] = $v[1] == 1;
        $dataArray['进线告警']['AlertArray']['电流下限报警'] = $v[2] == 1;
        $dataArray['进线告警']['AlertArray']['电流上限报警'] = $v[3] == 1;
        $dataArray['进线告警']['AlertArray']['电流上上限报警'] = $v[4] == 1;
        $dataArray['进线告警']['AlertArray']['对地电压上限报警'] = $v[5] == 1;
        $dataArray['进线告警']['AlertArray']['绝缘电阻1下限报警'] = $v[6] == 1;
        $dataArray['进线告警']['AlertArray']['低电压报警'] = $v[7] == 1;
        $dataArray['进线告警']['AlertArray']['高电压报警'] = $v[8] == 1;
        $dataArray['进线告警']['AlertArray']['绝缘电阻2下限报警'] = $v[9] == 1;
        $dataArray['进线告警']['AlertArray']['温度上限报警'] = $v[10] == 1;
        $v = unpack('C*', substr($memData , 4 + 12*4 + 2*2 + 64*1, 4*1));
        $dataArray['进线告警']['进线开关1断开报警'] = $v[1] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['进线开关2断开报警'] = $v[2] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['进线开关3断开报警'] = $v[3] == 1 ? '告警' : '正常';
        $dataArray['进线告警']['进线开关4断开报警'] = $v[4] == 1 ? '告警' : '正常';        
        $dataArray['进线告警']['AlertArray']['进线开关1断开报警'] = $v[1] == 1;
        $dataArray['进线告警']['AlertArray']['进线开关2断开报警'] = $v[2] == 1;
        $dataArray['进线告警']['AlertArray']['进线开关3断开报警'] = $v[3] == 1;
        $dataArray['进线告警']['AlertArray']['进线开关4断开报警'] = $v[4] == 1;
        
        $offset = 4 + 12*4 + 2*2 + 68*1;
        for($i = 1 ; $i <= 42 ; $i++){
            $dataArray['出线'.$i.'信息'] = array();
            $dataArray['出线'.$i.'信息']['AlertArray'] = array();
            $v = unpack('C*', substr($memData , $offset , 5*1));
            $dataArray['出线'.$i.'信息']['电流下下限报警'] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['出线'.$i.'信息']['电流下限报警'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['出线'.$i.'信息']['电流上限报警'] = $v[3] == 1 ? '告警' : '正常';
            $dataArray['出线'.$i.'信息']['电流上上限报警'] = $v[4] == 1 ? '告警' : '正常';
            $dataArray['出线'.$i.'信息']['开关断开报警'] = $v[5] == 1 ? '告警' : '正常';
            $dataArray['出线'.$i.'信息']['AlertArray']['电流下下限报警'] = $v[1] == 1;
            $dataArray['出线'.$i.'信息']['AlertArray']['电流下限报警'] = $v[2] == 1;
            $dataArray['出线'.$i.'信息']['AlertArray']['电流上限报警'] = $v[3] == 1;
            $dataArray['出线'.$i.'信息']['AlertArray']['电流上上限报警'] = $v[4] == 1;
            $dataArray['出线'.$i.'信息']['AlertArray']['开关断开报警'] = $v[5] == 1;
            $offset += 5;            
        }
        
        //主机开关量和继电器状态  
        $v = unpack('C*', substr($memData , 334 , 6*1));
        $dataArray['switch_relay_status2'] = $v;
        //开关量模块A B状态
        $v = unpack('C*', substr($memData , 334 + 6*1 , 21*1));
        $dataArray['switchAModlueStatus2'] = $v;
        $v = unpack('C*', substr($memData , 334 + 27*1 , 21*1));
        $dataArray['switchBModuleStatus2'] = $v;
        
        //Module201_201_289_t  -- Module201_735_823_t  每隔6个出线数据   后面有主机开关量、继电器、开关量模块状态
        $offset = 382;
        for($i = 1 ; $i <= 42 ; $i++){
            $v = unpack('f*', substr($memData , $offset , 8*4));
            $dataArray['出线'.$i.'信息']['电流'] = number_format($v[1] , 2).' A';
            $dataArray['出线'.$i.'信息']['最大电流'] = number_format($v[2] , 2).' A';
            $dataArray['出线'.$i.'信息']['电流需量'] = number_format($v[3] , 2).' A';
            $dataArray['出线'.$i.'信息']['最大电流需量'] = number_format($v[4] , 2).' A';
            $dataArray['出线'.$i.'信息']['有功功率'] = number_format($v[5] , 2).' W';
            $dataArray['出线'.$i.'信息']['有功需量'] = number_format($v[6] , 2).' W';
            $dataArray['出线'.$i.'信息']['最大有功需量'] = number_format($v[7] , 2).' W';
            $dataArray['出线'.$i.'信息']['有功电度'] = number_format($v[8] , 2).' KWh';
            $offset += 32;
            if($i % 6 == 0){
                //主机开关量   开关量模块A B  和前面重复
                /* $v = unpack('C*' , substr($memData , $offset , 6*1));
                $v = unpack('C*' , substr($memData , $offset + 6*1 , 21*1));
                $v = unpack('C*' , substr($memData , $offset + 27*1 , 21*1)); */
                $offset += 48;
            }
        }
        
        //PMAC203_901_945_t   电流快速访问寄存器   与前面重复
        /* $v = unpack('f*',substr($memData , $offset , 4*1));
        $dataArray['进线电流'] = $v[1];
        $v = unpack('f*',substr($memData , $offset + 4*1 , 4*42)); */

        //PMAC203_2001_2002_t    设备配置信息
        $systemConfig = array();
        $v = unpack('s*',substr($memData , $offset + 4*43 , 2*2));
        $systemConfig['设备地址'] = $v[1];
        $systemConfig['波特率'] = $v[2].' bps';
        //PMAC203_2003_2102_t
        $v = unpack('f*',substr($memData , $offset + 4*43 + 2*2 , 4*1));
        $systemConfig['进线电流额定值'] = number_format($v[1] , 2).' A';
        $v = unpack('s*',substr($memData , $offset + 4*44 + 2*2 , 8*2));
        switch ($v[1]){
            case 0 : $systemConfig['主机开关量1功能'] = '通用开关'; break;
            case 1 : $systemConfig['主机开关量1功能'] = '进线开关'; break;
            case 2 : $systemConfig['主机开关量1功能'] = '防雷开关'; break;
            default : $systemConfig['主机开关量1功能'] = '无效';
        }
        switch ($v[2]){
            case 0 : $systemConfig['主机开关量2功能'] = '通用开关'; break;
            case 1 : $systemConfig['主机开关量2功能'] = '进线开关'; break;
            case 2 : $systemConfig['主机开关量2功能'] = '防雷开关'; break;
            default : $systemConfig['主机开关量2功能'] = '无效';
        }
        switch ($v[3]){
            case 0 : $systemConfig['主机开关量3功能'] = '通用开关'; break;
            case 1 : $systemConfig['主机开关量3功能'] = '进线开关'; break;
            case 2 : $systemConfig['主机开关量3功能'] = '防雷开关'; break;
            default : $systemConfig['主机开关量3功能'] = '无效';
        }
        switch ($v[4]){
            case 0 : $systemConfig['主机开关量4功能'] = '通用开关'; break;
            case 1 : $systemConfig['主机开关量4功能'] = '进线开关'; break;
            case 2 : $systemConfig['主机开关量4功能'] = '防雷开关'; break;
            default : $systemConfig['主机开关量4功能'] = '无效';
        }
        if($v[5] == 0){
            $systemConfig['电度脉冲输出线路选择'] = '进线';
        }else if($v[5] > 0 && $v[5] < 43){
            $systemConfig['电度脉冲输出线路选择'] = '出线'.$v[5];
        }else{
            $systemConfig['电度脉冲输出线路选择'] = '无效';
        }
        $systemConfig['电度脉冲常数'] = $v[6];
        $systemConfig['电度脉冲宽度'] = $v[7];
        $systemConfig['DI报警使能'] = $v[8] == 1 ? '允许' : '禁止';
        $v = unpack('f*',substr($memData , $offset + 4*44 + 10*2 , 8*4));
        $systemConfig['进线电流下下限报警值'] = number_format($v[1] , 2).' A';
        $systemConfig['进线电流下限报警值'] = number_format($v[2] , 2).' A';
        $systemConfig['进线电流上限报警值'] = number_format($v[3] , 2).' A';
        $systemConfig['进线电流上上限报警值'] = number_format($v[4] , 2).' A';
        $systemConfig['进线电压下限报警值'] = number_format($v[5] , 2).' V';
        $systemConfig['进线电压上限报警值'] = number_format($v[6] , 2).' V';
        $systemConfig['温度上限报警值'] = number_format($v[7] , 2).' ℃';
        $systemConfig['对地电压报警值'] = number_format($v[8] , 2).' V';
        
        //PMAC203_2103_2194_t
        $offset += 4*52 + 10*2;
        //出线1-42 报警阈值
        /* for($i = 0 ; $i < 42 ; $i++){
            $v = unpack('f*' , substr($memData , $offset + $i*16 , 4*4));
            $dataArray['出线'.$i.'信息']['电流下下限报警值'] = number_format($v[1] , 2).' A';
            $dataArray['出线'.$i.'信息']['电流下限报警值'] = number_format($v[2] , 2).' A';
            $dataArray['出线'.$i.'信息']['电流上限报警值'] = number_format($v[3] , 2).' A';
            $dataArray['出线'.$i.'信息']['电流上上限报警值'] = number_format($v[4] , 2).' A';
        }  */
        //PMAC203_2202_2215_t
        $offset += 42*16;
        $v = unpack('I*' , substr($memData , $offset , 4*14));
        for($j = 1 ; $j <=14 ; $j++){
            if($v[$j] == 0){
                $systemConfig['CT'.$j] = '50';
            }else if($v[$j] == 1){
                $systemConfig['CT'.$j] = '100';
            }else if($v[$j] == 2){
                $systemConfig['CT'.$j] = '200';
            }else{
                $systemConfig['CT'.$j] = '无效';
            }  
        }
        $dataArray['系统配置信息'] = $systemConfig;
        
        $v = unpack('v',substr($memData , $offset + 4*14 , 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData , $offset + 4*14 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }        
}

?>
