<?php 

function Get_pmac625_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['AB线电压(V)']);
        case '[B相电压]':
            return array(0, $dataArray['BC线电压(V)']);
        case '[C相电压]':
            return array(0, $dataArray['CA线电压(V)']);
        case '[总功率]':
            return array(0, $dataArray["有功功率总和(kW)"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmac625_Active_Power($dataArray){
    return array(0 , $dataArray['有功电度总和(kWh)']);
}

function _GetPmac625Status($val)
{
    $v = decbin($val);
    for($i = strlen($v); $i < 32; $i++){
        $v = '0'.$v;
    }
    $bit1 = bindec(substr($v, 0, 1));
    $bit2 = bindec(substr($v, 1, 1));
    if($bit1 == '1' && $bit2 == '1'){
        return "1通道闭合2通道闭合";
    }else if($bit1 == '1' && $bit2 == '0'){
        return "1通道闭合2通道断开";
    }else if($bit1 == '0' && $bit2 == '0'){
        return "1通道断开2通道断开";
    }else if($bit1 == '0' && $bit2 == '1'){
        return "1通道断开2通道闭合";
    }else{
        return "数据无效";
    }
}

function _GetPmac625ActionObject($v)
{
    switch ($v) {
        case 0: return "空";
        case 1: return "VA";
        case 2: return "VB";
        case 3: return "VC";
        case 4: return "IA";
        case 5: return "IB";
        case 6: return "IC";
        case 7: return "I0";
    }
    return "无效";
}

function Is_pmac625_NeedExtraPara(){
    return true;
}
function Get_pmac625_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
      $dataArray['无数据'] = true;
      $dataArray['更新时间'] = '无';
      $dataArray['错误'] = '数据长度不一致';
   } else {
	$ct = 80;
	$pt = 1;
	if(isset($extraPara->pt)){
                $pt = $extraPara->pt;
        }
	if(isset($extraPara->ct)){
                $ct = $extraPara->ct;
        }
        $dataArray['无数据'] = false;
        $v = unpack('S*', substr($memData, 4, 2 * 10));
        $dataArray["A相电压(V)"] = $v[1]/100;
        $dataArray["B相电压(V)"] = $v[2]/100;
        $dataArray["C相电压(V)"] = $v[3]/100;
        $dataArray["AB线电压(V)"] = $v[4]/100;
        $dataArray["BC线电压(V)"] = $v[5]/100;
        $dataArray["CA线电压(V)"] = $v[6]/100;
        $dataArray["A相电流(A)"] = $v[7]*$ct/1000;
        $dataArray["B相电流(A)"] = $v[8]*$ct/1000;
        $dataArray["C相电流(A)"] = $v[9]*$ct/1000;
        $dataArray["零序电流(A)"] = $v[10]*$ct/1000;
        $v = unpack('S*', substr($memData, 4 + 2 * 10, 4 * 2));
        $dataArray["有功功率总和(kW)"] = $ct * ( ( ($v[2] >> 15) & 0x1) ? -1 : 1) * ((($v[2]&0x7fff) << 16) | $v[1])/10;
        $dataArray["无功功率总和(kVAr)"] = $ct * ( ( ($v[4] >> 15) & 0x1) ? -1 : 1) * ((($v[4]&0x7fff) << 16) | $v[3])/10;
        $v = unpack('S*', substr($memData, 4 + 2 * 10 + 4 * 2, 2 * 11));
        $dataArray["功率因数总和"] = ( ( ($v[1] >> 15) & 0x1) ? -1 : 1) * ($v[1]&0x7fff) /1000;
        $dataArray["A相有功功率(kW)"] = $ct * $v[2]/10/1000;
        $dataArray["B相有功功率(kW)"] = $ct * $v[3]/10/1000;
        $dataArray["C相有功功率(kW)"] = $ct * $v[4]/10/1000;
        $dataArray["A相无功功率(kVAr)"] = $ct * $v[5]/10/1000;
        $dataArray["B相无功功率(kVAr)"] = $ct * $v[6]/10/1000;
        $dataArray["C相无功功率(kVAr)"] = $ct * $v[7]/10/1000;
        $dataArray["A相功率因数"] = ( ( ($v[8] >> 15) & 0x1) ? -1 : 1) * ($v[8]&0x7fff) /1000;
        $dataArray["B相功率因数"] = ( ( ($v[9] >> 15) & 0x1) ? -1 : 1) * ($v[9]&0x7fff) /1000;
        $dataArray["C相功率因数"] = ( ( ($v[10] >> 15) & 0x1) ? -1 : 1) * ($v[10]&0x7fff) /1000;
        $dataArray["频率(Hz)"] = $v[10]/100;
        $v = unpack('S*', substr($memData, 4 + 2 * 21 + 4 * 2, 4 * 6));
        $dataArray["有功电度总和(kWh)"] = (($v[2]<<16)|$v[1])/10;
        $dataArray["无功电度总和(kVArh)"] = (($v[4]<<16)|$v[3])/10;
        $dataArray["输入有功电度(kWh)"] = (($v[6]<<16)|$v[5])/10;
        $dataArray["输出有功电度(kWh)"] = (($v[8]<<16)|$v[7])/10;
        $dataArray["输入无功电度(kVArh)"] = (($v[10]<<16)|$v[9])/10;
        $dataArray["输出无功电度(kVArh)"] = (($v[12]<<16)|$v[11])/10;
        $v = unpack('S*', substr($memData, 4 + 2 * 21 + 4 * 8, 2 * 2));
        $dataArray["开关量状态"]= _GetPmac625Status($v[1]);
        $dataArray["继电器状态"]= _GetPmac625Status($v[2]);
        //REG_201_220_t
        $v = unpack('S*', substr($memData, 4 + 2 * 23 + 4 * 8, 2 * 6));
        $dataArray["通讯地址"] = $v[1];
        $dataArray["CT"]= $v[2];
        $dataArray["接线模式"] = $v[3] > 0 ? "三相三线" : "三相四线";
        $dataArray["PT"] = $v[4]/10;
        $dataArray["reserved_1"] = $v[5];
        $dataArray["波特率"] = $v[6] > 0 ? "9600" : "4800";
        $v = unpack('S*', substr($memData, 4 + 2 * 33 + 4 * 8, 2 * 10));//reserved[4]没解
        $dataArray["继电器一动作模式"] = $v[1] > 0 ? "远程模式" : "本地模式";
        $dataArray["继电器一动作对象"] = _GetPmac625ActionObject($v[2]);
        $dataArray["继电器一动作上限"] = $v[3];
        $dataArray["继电器一动作下限"] = $v[4];
        $dataArray["继电器一动作时间"] = $v[5];
        $dataArray["继电器二动作模式"] = $v[6] > 0 ? "远程模式" : "本地模式";
        $dataArray["继电器二动作对象"] = _GetPmac625ActionObject($v[7]);
        $dataArray["继电器二动作上限"] = $v[8];
        $dataArray["继电器二动作下限"] = $v[9];
        $dataArray["继电器二动作时间"] = $v[10];
       $v = unpack('v', substr($memData, 4 + 2 * 43 + 4 * 8, 2));
       $year = $v[1];
       $v = unpack('C*', substr($memData,  6 + 2 * 43 + 4 * 8, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
