<?php

function Get_pmc33x_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, floatval($dataArray['A相电压']));
        case '[B相电压]':
            return array(0, floatval($dataArray['B相电压']));
        case '[C相电压]':
            return array(0, floatval($dataArray['C相电压']));
        case "[总功率]":
            return array(0, floatval($dataArray['三相有功功率']));
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmc33x_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能']);
}


function Get_pmc33x_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('f*',substr($memData, 4,4*29));
        $dataArray['AlertArray'] = array();

        $dataArray['A相电压'] = number_format($v[1], 2);
        $dataArray['B相电压'] = number_format($v[2], 2);
        $dataArray['C相电压'] = number_format($v[3], 2);
        $dataArray['平均相电压'] = number_format($v[4], 2);

        $dataArray['AB线电压'] = number_format($v[5], 2);
        $dataArray['BC线电压'] = number_format($v[6], 2);
        $dataArray['CA线电压'] = number_format($v[7], 2);
        $dataArray['平均线电压'] = number_format($v[8], 2);

        $dataArray['A相电流'] = number_format($v[9], 2);
        $dataArray['B相电流'] = number_format($v[10], 2);
        $dataArray['C相电流'] = number_format($v[11], 2);
        $dataArray['平均相电流'] = number_format($v[12], 2);

        $dataArray['A相有功功率'] = number_format($v[13], 2);
        $dataArray['B相有功功率'] = number_format($v[14], 2);
        $dataArray['C相有功功率'] = number_format($v[15], 2);
        $dataArray['三相有功功率'] = number_format($v[16], 2);

        $dataArray['A相无功功率'] = number_format($v[17], 2);
        $dataArray['B相无功功率'] = number_format($v[18], 2);
        $dataArray['C相无功功率'] = number_format($v[19], 2);
        $dataArray['三相无功功率'] = number_format($v[20], 2);
        $dataArray['A相视在功率'] = number_format($v[21], 2);
        $dataArray['B相视在功率'] = number_format($v[22], 2);
        $dataArray['C相视在功率'] = number_format($v[23], 2);
        $dataArray['三相视在功率'] = number_format($v[24], 2);
        $dataArray['A相功率因数'] = number_format($v[25], 2);
        $dataArray['B相功率因数'] = number_format($v[26], 2);
        $dataArray['C相功率因数'] = number_format($v[27], 2);
        $dataArray['总功率因数'] = number_format($v[28], 2);
        $dataArray['频率'] = number_format($v[29], 2);

        $v = unpack('S*',substr($memData, 4 + 4*29, 2*2));
        $dataArray["DI1"] = ($v[1]&0x1) ? "闭合" : "断开";
        $dataArray["DI2"] = (($v[1]>>1)&0x1) ? "闭合" : "断开";
        $dataArray["DI3"] = (($v[1]>>2)&0x1) ? "闭合" : "断开";
        $dataArray["DI4"] = (($v[1]>>3)&0x1) ? "闭合" : "断开";
        $dataArray["DO1"] = ($v[2]&0x1) ? "闭合" : "断开";
        $dataArray["DO2"] = (($v[2]>>1)&0x1) ? "闭合" : "断开";
        $dataArray["DO3"] = (($v[2]>>2)&0x1) ? "闭合" : "断开";
        $dataArray["DO4"] = (($v[2]>>3)&0x1) ? "闭合" : "断开";
        $v = unpack('S*',substr($memData, 4 + 4*29 + 2*2, 2*2));
        $dataArray['AlertArray'] = array();
        $dataArray['越限1'] = $v[1]&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['越限1'] = $v[1]&0x1;

        $dataArray['越限2'] = ($v[1]>>1) ? "告警" : "正常";
        $dataArray['AlertArray']['越限2'] = ($v[1]>>1)&0x1;

        $dataArray['越限3'] = ($v[1]>>2) ? "告警" : "正常";
        $dataArray['AlertArray']['越限3'] = ($v[1]>>2)&0x1;

        $dataArray['越限4'] = ($v[1]>>3) ? "告警" : "正常";
        $dataArray['AlertArray']['越限4'] = ($v[1]>>3)&0x1;

        $dataArray['越限5'] = ($v[1]>>4) ? "告警" : "正常";
        $dataArray['AlertArray']['越限5'] = ($v[1]>>4)&0x1;

        $dataArray['越限6'] = ($v[1]>>5) ? "告警" : "正常";
        $dataArray['AlertArray']['越限6'] = ($v[1]>>5)&0x1;

        $dataArray['越限7'] = ($v[1]>>6) ? "告警" : "正常";
        $dataArray['AlertArray']['越限7'] = ($v[1]>>6)&0x1;

        $dataArray['越限8'] = ($v[1]>>7) ? "告警" : "正常";
        $dataArray['AlertArray']['越限8'] = ($v[1]>>7)&0x1;

        $dataArray['越限9'] = ($v[1]>>8) ? "告警" : "正常";
        $dataArray['AlertArray']['越限9'] = ($v[1]>>8)&0x1;

        $dataArray['测频超出45～65Hz范围'] = ($v[2]>>1)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['测频超出45～65Hz范围'] = ($v[2]>>1)&0x1;

        $dataArray['电压缺相'] = ($v[2]>>2)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电压缺相'] = ($v[2]>>2)&0x1;

        $dataArray['电流缺相'] = ($v[2]>>3)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电流缺相'] = ($v[2]>>3)&0x1;

        $dataArray['电压相序错误'] = ($v[2]>>6)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电压相序错误'] = ($v[2]>>6)&0x1;

        $dataArray['电流相序错误'] = ($v[2]>>7)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['电流相序错误'] = ($v[2]>>7)&0x1;

        $dataArray['总有功功率为负'] = ($v[2]>>8)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['总有功功率为负'] = ($v[2]>>8)&0x1;

        $dataArray['A相有功功率为负'] = ($v[2]>>9)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['A相有功功率为负'] = ($v[2]>>9)&0x1;

        $dataArray['B相有功功率为负'] = ($v[2]>>10)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['B相有功功率为负'] = ($v[2]>>10)&0x1;

        $dataArray['C相有功功率为负'] = ($v[2]>>11)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['C相有功功率为负'] = ($v[2]>>11)&0x1;

        $dataArray['CTa反极性'] = ($v[2]>>12)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['CTa反极性'] = ($v[2]>>12)&0x1;

        $dataArray['CTb反极性'] = ($v[2]>>13)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['CTb反极性'] = ($v[2]>>13)&0x1;

        $dataArray['CTc反极性'] = ($v[2]>>14)&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['CTc反极性'] = ($v[2]>>14)&0x1;

        $v = unpack('f*',substr($memData, 4 + 4*29 + 2*2 + 2*2, 4 * 9));
        $dataArray['正向有功电能'] = number_format($v[1]/100,1,".","")."kWh";
        $dataArray['反向有功电能'] = number_format($v[2]/100,1,".","")."kWh";
        $dataArray['有功电能净值'] = number_format($v[3]/100,1,".","")."kWh";
        $dataArray['有功电能总和'] = number_format($v[4]/100,1,".","")."kWh";
        $dataArray['正向无功电能'] = number_format($v[5]/100,1,".","")."kvarh";
        $dataArray['反向无功电能'] = number_format($v[6]/100,1,".","")."kvarh";
        $dataArray['无功电能净值'] = number_format($v[7]/100,1,".","")."kvarh";
        $dataArray['无功电能总和'] = number_format($v[8]/100,1,".","")."kvarh";
        $dataArray['视在电能'] = number_format($v[9]/100,1,".","")."kVAh";


        $v = unpack('v',substr($memData, 4 + 4*29 + 2*2 + 2*2 + 4*9, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*29 + 2*2 + 2*2 + 4*9 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
?>
