
<?php
//设备类型
function Get_pmc630s_UnicomCategory()
{
    return "321";//智能电表	380V交流智能电表	32	1	321
}


function Get_pmc630s_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = $memData ? '数据长度不一致' : "无数据";
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //DTSD3366D_REG_8_A_t
        $mem = substr($memData, 4, 82 * 2);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i+3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("f*" , $newMem);
        $dataArray['A相电压'] = number_format($v[1], 2);
        $dataArray['B相电压'] = number_format($v[2], 2);
        $dataArray['C相电压'] = number_format($v[3], 2);
        $dataArray['平均相电压'] = number_format($v[4], 2);

        $dataArray['AB线电压'] = number_format($v[5], 2);
        $dataArray['BC线电压'] = number_format($v[6], 2);
        $dataArray['CA线电压'] = number_format($v[7], 2);
        $dataArray['平均线电压'] = number_format($v[8], 2);

        $dataArray['A相电流'] = number_format($v[9], 2);
        $dataArray['B相电流'] = number_format($v[10], 2);
        $dataArray['C相电流'] = number_format($v[11], 2);
        $dataArray['平均相电流'] = number_format($v[12], 2);

        $dataArray['A相有功功率'] = number_format($v[13], 4);
        $dataArray['B相有功功率'] = number_format($v[14], 4);
        $dataArray['C相有功功率'] = number_format($v[15], 4);
        $dataArray['三相有功功率'] = number_format($v[16], 4);

        $dataArray['A相无功功率'] = number_format($v[17], 4);
        $dataArray['B相无功功率'] = number_format($v[18], 4);
        $dataArray['C相无功功率'] = number_format($v[19], 4);
        $dataArray['三相无功功率'] = number_format($v[20], 4);
        $dataArray['A相视在功率'] = number_format($v[21], 4);
        $dataArray['B相视在功率'] = number_format($v[22], 4);
        $dataArray['C相视在功率'] = number_format($v[23], 4);
        $dataArray['三相视在功率'] = number_format($v[24], 4);
        $dataArray['A相功率因数'] = number_format($v[25], 4);
        $dataArray['B相功率因数'] = number_format($v[26], 4);
        $dataArray['C相功率因数'] = number_format($v[27], 4);
        $dataArray['总功率因数'] = number_format($v[28], 4);
        $dataArray['频率'] = number_format($v[29], 2);
	
        $dataArray['正向有功电能'] = number_format($v[30]/100,2,".","")."kWh";
        $dataArray['反向有功电能'] = number_format($v[31]/100,2,".","")."kWh";
        $dataArray['有功电能净值'] = number_format($v[32]/100,2,".","")."kWh";
        $dataArray['有功电能总和'] = number_format($v[33]/100,2,".","")."kWh";
        $dataArray['正向无功电能'] = number_format($v[34]/100,2,".","")."kvarh";
        $dataArray['反向无功电能'] = number_format($v[35]/100,2,".","")."kvarh";

	$dataArray['A相电流THD'] = number_format($v[36], 2). "%";
	$dataArray['B相电流THD'] = number_format($v[37], 2). "%";
	$dataArray['C相电流THD'] = number_format($v[38], 2). "%";

	
	$dataArray['A相电压THD'] = number_format($v[39], 2). "%";
	$dataArray['B相电压THD'] = number_format($v[40], 2). "%";
	$dataArray['C相电压THD'] = number_format($v[41], 2). "%";

        $mem = unpack("S", substr($memData, 4, 82 * 2, 2));
	//报警状态
	$dataArray['越限1'] = $v[1]&0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['越限1'] = $v[1]&0x1;

        $dataArray['越限2'] = ($v[1]>>1) ? "告警" : "正常";
        $dataArray['AlertArray']['越限2'] = ($v[1]>>1)&0x1;

        $dataArray['越限3'] = ($v[1]>>2) ? "告警" : "正常";
        $dataArray['AlertArray']['越限3'] = ($v[1]>>2)&0x1;

        $dataArray['越限4'] = ($v[1]>>3) ? "告警" : "正常";
        $dataArray['AlertArray']['越限4'] = ($v[1]>>3)&0x1;

        $dataArray['越限5'] = ($v[1]>>4) ? "告警" : "正常";
        $dataArray['AlertArray']['越限5'] = ($v[1]>>4)&0x1;

        $dataArray['越限6'] = ($v[1]>>5) ? "告警" : "正常";
        $dataArray['AlertArray']['越限6'] = ($v[1]>>5)&0x1;

        $dataArray['越限7'] = ($v[1]>>6) ? "告警" : "正常";
        $dataArray['AlertArray']['越限7'] = ($v[1]>>6)&0x1;

        $dataArray['越限8'] = ($v[1]>>7) ? "告警" : "正常";
        $dataArray['AlertArray']['越限8'] = ($v[1]>>7)&0x1;

        $dataArray['越限9'] = ($v[1]>>8) ? "告警" : "正常";
        $dataArray['AlertArray']['越限9'] = ($v[1]>>8)&0x1;

        $v = unpack('v', substr($memData, 4 + 83 * 2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 83 * 2 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
