<?php

function Is_pmchmi_NeedExtraPara(){
    return true;
}

function Get_pmchmi_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $output_number = 200;
        if($extraPara && isset($extraPara->output_number)){
            $output_number = $extraPara->output_number;
        }


        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*',substr($memData, 4,2*95));
        //通信状态
        $dataArray["总通信状态"] = $v[1] == 0 ? "正常":"异常";
        for($i=0;$i<32;$i++){
            $dataArray["设备".($i+1)."通信状态"] = (($v[2 + intval($i/10)] >> ($i%10)) & 0x1) == 0 ? "正常":"异常";
        }
        //自检状态
        $dataArray["总自检状态"] = $v[6] == 0 ? "正常":"异常";
        for($i=0;$i<32;$i++){
            $dataArray["设备".($i+1)."自检状态"] = (($v[7 + intval($i/10)] >> ($i%10)) & 0x1) == 0 ? "正常":"异常";
        }
        //DI状态
        $dataArray["进线1进线开关"] = ($v[11] & 0x1) == 0 ? "打开": "闭合";
        $dataArray["进线1防雷开关"] = (($v[11] >> 1) & 0x1) == 0 ? "打开": "闭合";
        $dataArray["进线1防雷故障"] = (($v[11] >> 2) & 0x1) == 0 ? "打开": "闭合";
        $dataArray["进线1进线跳闸"] = (($v[11] >> 3) & 0x1) == 0 ? "打开": "闭合";

        $dataArray["进线2进线开关"] = ($v[12] & 0x1) == 0 ? "打开": "闭合";
        $dataArray["进线2防雷开关"] = ($v[12] >> 1) & 0x1 == 0 ? "打开": "闭合";
        $dataArray["进线2防雷故障"] = ($v[12] >> 2) & 0x1 == 0 ? "打开": "闭合";
        $dataArray["进线2进线跳闸"] = ($v[12] >> 3) & 0x1 == 0 ? "打开": "闭合";
        //告警状态
        $dataArray["进线1电流过流"] = $v[14] & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流过流'] = $v[14] & 0x1;
        $dataArray["进线1频率越限"] = ($v[14]>>1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1频率越限'] = $v[14] & 0x1;

        $dataArray["进线2电流过流"] = $v[15] & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流过流'] = $v[15] & 0x1;
        $dataArray["进线2频率越限"] = ($v[15]>>1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2频率越限'] = $v[15] & 0x1;


        $dataArray["进线1电压高"] = $v[18] & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电压高'] = $v[18] & 0x1;
        $dataArray["进线1电压低"] = ($v[18]>>1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电压低'] = ($v[18]>>1) & 0x1;
        $dataArray["进线1电流过高"] = ($v[18]>>2) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流过高'] = ($v[18]>>2) & 0x1;
        $dataArray["进线1电流高"] = ($v[18]>>3) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流高'] = ($v[18]>>3)  & 0x1;
        $dataArray["进线1电流过低"] = ($v[18]>>4) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流过低'] = ($v[18]>>4)  & 0x1;
        $dataArray["进线1电流低"] = ($v[18]>>5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流低'] = ($v[18]>>5)  & 0x1;
        $dataArray["进线1频率高"] = ($v[18]>>6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1频率高'] = ($v[18]>>6)  & 0x1;
        $dataArray["进线1频率低"] = ($v[18]>>7) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1频率低'] = ($v[18]>>7) & 0x1;
        $dataArray["进线1电压不平衡"] = ($v[18]>>8) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电压不平衡'] = ($v[18]>>8) & 0x1;
        $dataArray["进线1电流不平衡"] = ($v[18]>>9) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1电流不平衡'] = ($v[18]>>9) & 0x1;
        $dataArray["进线1缺相"] = ($v[18]>>10) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1缺相'] = ($v[18]>>10) & 0x1;
        $dataArray["进线1零地电压"] = ($v[18]>>11) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1零地电压'] = ($v[18]>>11) & 0x1;
        $dataArray["进线1零序电流"] = ($v[18]>>12) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1零序电流'] = ($v[18]>>12) & 0x1;
        $dataArray["进线1进线跳闸"] = ($v[18]>>13) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1进线跳闸'] = ($v[18]>>13) & 0x1;
        $dataArray["进线1防雷故障"] = ($v[18]>>14) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线1防雷故障'] = ($v[18]>>14) & 0x1;

        $dataArray["进线2电压高"] = $v[20] & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电压高'] = $v[20] & 0x1;
        $dataArray["进线2电压低"] = ($v[20]>>1) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电压低'] = ($v[20]>>1) & 0x1;
        $dataArray["进线2电流过高"] = ($v[20]>>2) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流过高'] = ($v[20]>>2) & 0x1;
        $dataArray["进线2电流高"] = ($v[20]>>3) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流高'] = ($v[20]>>3)  & 0x1;
        $dataArray["进线2电流过低"] = ($v[20]>>4) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流过低'] = ($v[20]>>4)  & 0x1;
        $dataArray["进线2电流低"] = ($v[20]>>5) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流低'] = ($v[20]>>5)  & 0x1;
        $dataArray["进线2频率高"] = ($v[20]>>6) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2频率高'] = ($v[20]>>6)  & 0x1;
        $dataArray["进线2频率低"] = ($v[20]>>7) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2频率低'] = ($v[20]>>7) & 0x1;
        $dataArray["进线2电压不平衡"] = ($v[20]>>8) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电压不平衡'] = ($v[20]>>8) & 0x1;
        $dataArray["进线2电流不平衡"] = ($v[20]>>9) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2电流不平衡'] = ($v[20]>>9) & 0x1;
        $dataArray["进线2缺相"] = ($v[20]>>10) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2缺相'] = ($v[20]>>10) & 0x1;
        $dataArray["进线2零地电压"] = ($v[20]>>11) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2零地电压'] = ($v[20]>>11) & 0x1;
        $dataArray["进线2零序电流"] = ($v[20]>>12) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2零序电流'] = ($v[20]>>12) & 0x1;
        $dataArray["进线2进线跳闸"] = ($v[20]>>13) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2进线跳闸'] = ($v[20]>>13) & 0x1;
        $dataArray["进线2防雷故障"] = ($v[20]>>14) & 0x1 ? "告警" : "正常";
        $dataArray['AlertArray']['进线2防雷故障'] = ($v[20]>>14) & 0x1;

        for($i=0; $i<$output_number; $i++){
            $key = "出线".($i+1);
            $regIndex = 26 + intval($i/4);
            $regOffset = ($i%4) * 4;

            $dataArray[$key."电流过高"] = ($v[$regIndex]>> $regOffset ) & 0x1 ? "告警" : "正常";
            $dataArray['AlertArray'][$key."电流过高"] = ($v[$regIndex]>> $regOffset) & 0x1;
            $dataArray[$key."电流高"] = ($v[$regIndex]>> ($regOffset+1)) & 0x1 ? "告警" : "正常";
            $dataArray['AlertArray'][$key.'电流高'] = ($v[$regIndex]>> ($regOffset+1)) & 0x1;
            $dataArray[$key."电流过低"] = ($v[$regIndex]>> ($regOffset+2)) & 0x1 ? "告警" : "正常";
            $dataArray['AlertArray'][$key.'电流过低'] = ($v[$regIndex]>> ($regOffset+2)) & 0x1;
            $dataArray[$key."电流低"] = ($v[$regIndex]>> ($regOffset+3)) & 0x1 ? "告警" : "正常";
            $dataArray['AlertArray'][$key.'电流低'] = ($v[$regIndex]>> ($regOffset+3)) & 0x1;

            //跳闸报警
            $jumpIndex = 76 + $i/10;
            $dataArray[$key."跳闸报警"] = ($v[$jumpIndex]>> ($i%10)) & 0x1 ? "告警" : "正常";
            $dataArray['AlertArray'][$key.'跳闸报警'] = ($v[$jumpIndex]>> ($i%10)) & 0x1;
        }
        //实时数据
        $v = unpack('f*',substr($memData, 4 + 2*95, 4 * 1876));
        for($i=0;$i<2;$i++){
            $index = $i+1;
            $dataArray["进线".$index."数据"]['A相电压'] = number_format($v[38*$i + 1], 2);
            $dataArray["进线".$index."数据"]['B相电压'] = number_format($v[38*$i + 2], 2);
            $dataArray["进线".$index."数据"]['C相电压'] = number_format($v[38*$i + 3], 2);
            $dataArray["进线".$index."数据"]['平均相电压'] = number_format($v[38*$i + 4], 2);
    
            $dataArray["进线".$index."数据"]['AB线电压'] = number_format($v[38*$i + 5], 2);
            $dataArray["进线".$index."数据"]['BC线电压'] = number_format($v[38*$i + 6], 2);
            $dataArray["进线".$index."数据"]['CA线电压'] = number_format($v[38*$i + 7], 2);
            $dataArray["进线".$index."数据"]['平均线电压'] = number_format($v[38*$i + 8], 2);
    
            $dataArray["进线".$index."数据"]['A相电流'] = number_format($v[38*$i + 9], 2);
            $dataArray["进线".$index."数据"]['B相电流'] = number_format($v[38*$i + 10], 2);
            $dataArray["进线".$index."数据"]['C相电流'] = number_format($v[38*$i + 11], 2);
            $dataArray["进线".$index."数据"]['平均相电流'] = number_format($v[38*$i + 12], 2);
    
            $dataArray["进线".$index."数据"]['A相负载率'] = number_format($v[38*$i + 13], 2);
            $dataArray["进线".$index."数据"]['B相负载率'] = number_format($v[38*$i + 14], 2);
            $dataArray["进线".$index."数据"]['C相负载率'] = number_format($v[38*$i + 15], 2);
            $dataArray["进线".$index."数据"]['平均负载率'] = number_format($v[38*$i + 16], 2);
    
            $dataArray["进线".$index."数据"]['A相有功功率'] = number_format($v[38*$i + 17], 2);
            $dataArray["进线".$index."数据"]['B相有功功率'] = number_format($v[38*$i + 18], 2);
            $dataArray["进线".$index."数据"]['C相有功功率'] = number_format($v[38*$i + 19], 2);
            $dataArray["进线".$index."数据"]['三相有功功率'] = number_format($v[38*$i + 20], 2);
    
            $dataArray["进线".$index."数据"]['A相无功功率'] = number_format($v[38*$i + 21], 2);
            $dataArray["进线".$index."数据"]['B相无功功率'] = number_format($v[38*$i + 22], 2);
            $dataArray["进线".$index."数据"]['C相无功功率'] = number_format($v[38*$i + 23], 2);
            $dataArray["进线".$index."数据"]['三相无功功率'] = number_format($v[38*$i + 24], 2);
            $dataArray["进线".$index."数据"]['A相视在功率'] = number_format($v[38*$i + 25], 2);
            $dataArray["进线".$index."数据"]['B相视在功率'] = number_format($v[38*$i + 26], 2);
            $dataArray["进线".$index."数据"]['C相视在功率'] = number_format($v[38*$i + 27], 2);
            $dataArray["进线".$index."数据"]['三相视在功率'] = number_format($v[38*$i + 28], 2);
    
    
            $dataArray["进线".$index."数据"]['A相功率因数'] = number_format($v[38*$i + 29], 2);
            $dataArray["进线".$index."数据"]['B相功率因数'] = number_format($v[38*$i + 30], 2);
            $dataArray["进线".$index."数据"]['C相功率因数'] = number_format($v[38*$i + 31], 2);
            $dataArray["进线".$index."数据"]['总功率因数'] = number_format($v[38*$i + 32], 2);
    
            $dataArray["进线".$index."数据"]['电压不平衡度'] = number_format($v[38*$i + 33], 2);
            $dataArray["进线".$index."数据"]['电流不平衡度'] = number_format($v[38*$i + 34], 2);
            $dataArray["进线".$index."数据"]['频率'] = number_format($v[38*$i + 35], 2);
            $dataArray["进线".$index."数据"]['总有功电能'] = number_format($v[38*$i + 36], 2);
            $dataArray["进线".$index."数据"]['零地电压'] = number_format($v[38*$i + 37], 2);
            $dataArray["进线".$index."数据"]['In'] = number_format($v[38*$i + 38], 2);
        }
        


        for($i=0; $i < $output_number; $i++)
        {
            $key = "出线".($i+1);
            $dataArray[$key]["电流或三相平均值"] = number_format($v[76 + 9*$i +1], 2);
            $dataArray[$key]["负载率"] = number_format($v[76 + 9*$i +2] ,2);
            $dataArray[$key]["有功功率"] = number_format($v[76 + 9*$i +3] ,2, ".", "");
            $dataArray[$key]["PF"] = number_format($v[76 + 9*$i +4] ,2);
            $dataArray[$key]["有功电能"] = number_format($v[76 + 9*$i +5] ,2, ".", "");
            $dataArray[$key]["THD"] = number_format($v[76 + 9*$i +6] ,2);
            $dataArray[$key]["电流(A 相)"] = number_format($v[76 + 9*$i +7] ,2);
            $dataArray[$key]["电流(B 相)"] = number_format($v[76 + 9*$i +8] ,2);
            $dataArray[$key]["电流(C 相)"] = number_format($v[76 + 9*$i +9] ,2);
        }
        
        $v = unpack('v',substr($memData, 4 + 2*95 + 4 * 1876, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 2*95 + 4 * 1876 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
