<?php



function PmHiWave_SetAlarm(&$dataArray, $label, $v)
{
    switch($v)
    {
        case 1:
            $dataArray[$label] = "低于下限";
            break;
        case 2:
            $dataArray[$label] = "高于下限";
            break;
        case 0x20:
            $dataArray[$label] = "未检测";
            break;
        case 0xF0:
            $dataArray[$label] = "故障";
            break;
        default:
            $dataArray[$label] = "正常";
            break;
    }
    $dataArray["AlertArray"][$label] = $v == 1 || $v == 2 || $v == 0xF0;
}
function Get_pmhiwave_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false){
        $dataArray['len'] = strlen($memData);
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('s*',substr($memData, 4, 2*18));
        $dataArray["主机电源相电压A"] = $v[1]."V";
        $dataArray["主机电源相电压B"] = $v[2] == 0x2020 ? "未监控" : $v[2]."V";
        $dataArray["主机电源相电压C"] = $v[3] == 0x2020 ? "未监控" : $v[3]."V";

        $dataArray["主机/压缩机工作电流A相"] = $v[4]."A";
        $dataArray["主机/压缩机工作电流B相"] = $v[5] == 0x2020 ? "未监控" : $v[5]."A";
        $dataArray["主机/压缩机工作电流C相"] = $v[6] == 0x2020 ? "未监控" : $v[6]."A";

        $dataArray["送风温度"] = $v[7] == 0x2020 ? "未监控" : $v[7]."℃";
        $dataArray["回风温度/室内环境温度"] = $v[8] == 0x2020 ? "未监控" : $v[8]."℃";

        $dataArray["送风湿度"] = $v[9] == 0x2020 ? "未监控" : $v[9]."%";
        $dataArray["回风湿度/室内环境湿度"] = $v[10] == 0x2020 ? "未监控" : $v[10]."%";

        $dataArray["压缩机吸气压力"] = $v[11] == 0x2020 ? "未监控" : $v[11]."bar";
        $dataArray["压缩机排气压力"] = $v[12] == 0x2020 ? "未监控" : $v[12]."bar";

        $dataArray["室外环境温度"] = $v[13] == 0x2020 ? "未监控" : $v[13]."℃";
        $dataArray["压缩机排气温度"] = $v[14] == 0x2020 ? "未监控" : $v[14]."℃";

        $dataArray["室外湿度"] = $v[15] == 0x2020 ? "未监控" : $v[15]."%";
        $dataArray["室内盘管/蒸发器盘管温度"] = $v[16]."℃";

        $dataArray["压缩机运行时间"] = $v[17]."小时";
        $dataArray["机组运行时间"] = $v[18]."小时";

        $v = unpack('C*',substr($memData, 4 + 2*18, 9));
        $dataArray["空调状态"] = $v[1] == 0 ? "关机" : "开机";
        switch($v[3])
        {
            case 0:
                $dataArray["空调运行模式"] = "自动";
                break;
            case 1:
                $dataArray["空调运行模式"] = "制冷";
                break;
            case 2:
                $dataArray["空调运行模式"] = "除湿";
                break;
            case 3:
                $dataArray["空调运行模式"] = "送风";
                break;
            case 4:
                $dataArray["空调运行模式"] = "制热";
                break;
        }
        switch($v[4])
        {
            case 0:
                $dataArray["内风机状态"] = "停";
                break;
            case 1:
                $dataArray["内风机状态"] = "低风";
                break;
            case 2:
                $dataArray["内风机状态"] = "中风";
                break;
            case 3:
                $dataArray["内风机状态"] = "高风";
                break;
        }
        switch($v[5])
        {
            case 0:
                $dataArray["四通阀状态"] = "运转";
                break;
            case 1:
                $dataArray["四通阀状态"] = "停止";
                break;
            case 0x20:
                $dataArray["四通阀状态"] = "无";
                break;
        }
        $dataArray["压缩机状态"] = $v[6] == 0 ? "停止" : "运转";
        switch($v[7])
        {
            case 0:
                $dataArray["外风机状态"] = "停";
                break;
            case 1:
                $dataArray["外风机状态"] = "低风";
                break;
            case 2:
                $dataArray["外风机状态"] = "中风";
                break;
            case 3:
                $dataArray["外风机状态"] = "高风";
                break;
        }
        switch($v[8])
        {
            case 0:
                $dataArray["摆风状态"] = "运转";
                break;
            case 1:
                $dataArray["摆风状态"] = "停止";
                break;
            case 0x20:
                $dataArray["摆风状态"] = "无";
                break;
        }
        switch($v[9])
        {
            case 0:
                $dataArray["电加热状态"] = "运转";
                break;
            case 1:
                $dataArray["电加热状态"] = "停止";
                break;
            case 0x20:
                $dataArray["电加热状态"] = "无";
                break;
        }

        $v = unpack('C*',substr($memData, 4 + 2*18 + 9, 35));
        PmHiWave_SetAlarm($dataArray, "A相交流电压告警" ,$v[1]);
        PmHiWave_SetAlarm($dataArray, "B相交流电压告警" ,$v[2]);
        PmHiWave_SetAlarm($dataArray, "C相交流电压告警" ,$v[3]);

        PmHiWave_SetAlarm($dataArray, "A相交流电流告警" ,$v[4]);
        PmHiWave_SetAlarm($dataArray, "B相交流电流告警" ,$v[5]);
        PmHiWave_SetAlarm($dataArray, "C相交流电流告警" ,$v[6]);

        PmHiWave_SetAlarm($dataArray, "回风温度告警" ,$v[7]);
        PmHiWave_SetAlarm($dataArray, "回风湿度告警" ,$v[8]);
        PmHiWave_SetAlarm($dataArray, "过滤网保护告警" ,$v[9]);
        PmHiWave_SetAlarm($dataArray, "压缩机保护告警" ,$v[10]);
        PmHiWave_SetAlarm($dataArray, "风机保护告警" ,$v[11]);
        //12 jump
        PmHiWave_SetAlarm($dataArray, "高压保护告警" ,$v[13]);
        PmHiWave_SetAlarm($dataArray, "低压保护告警" ,$v[14]);
        PmHiWave_SetAlarm($dataArray, "排气温度保护告警" ,$v[15]);
        PmHiWave_SetAlarm($dataArray, "内外机通讯故障" ,$v[16]);
        PmHiWave_SetAlarm($dataArray, "室内环境温度传感器" ,$v[17]);
        PmHiWave_SetAlarm($dataArray, "内机盘管进口温度传感器" ,$v[18]);
        PmHiWave_SetAlarm($dataArray, "内机盘管中间温度传感器" ,$v[19]);
        PmHiWave_SetAlarm($dataArray, "内机盘管出口温度传感器" ,$v[20]);
        PmHiWave_SetAlarm($dataArray, "室外环境温度传感器", $v[21]);
        //22 jump
        PmHiWave_SetAlarm($dataArray, "室外环境温度传感器" ,$v[23]);
        PmHiWave_SetAlarm($dataArray, "排气温度传感器" ,$v[24]);
        PmHiWave_SetAlarm($dataArray, "相序错误" ,$v[25]);
        PmHiWave_SetAlarm($dataArray, "缺相保护" ,$v[26]);
        PmHiWave_SetAlarm($dataArray, "室外风机保护" ,$v[27]);
        PmHiWave_SetAlarm($dataArray, "EEPROM故障" ,$v[28]);
        PmHiWave_SetAlarm($dataArray, "消防报警" ,$v[29]);
        PmHiWave_SetAlarm($dataArray, "室内湿度传感器" ,$v[30]);
        PmHiWave_SetAlarm($dataArray, "室外湿度传感器" ,$v[31]);
        PmHiWave_SetAlarm($dataArray, "系统异常" ,$v[32]);
        PmHiWave_SetAlarm($dataArray, "水浸告警" ,$v[33]);
        PmHiWave_SetAlarm($dataArray, "其他不正常告警" ,$v[34]);
        PmHiWave_SetAlarm($dataArray, "外机被盗告警" ,$v[35]);


	$newMem = '';
        $mem = substr($memData, 4 + 2*18 + 9 + 35, 2*7);
        for ($i = 0; $i < strlen($mem); $i += 2) {
            $newMem .= $mem[$i + 1] . $mem[$i];
        }
        $v = unpack('s*',$newMem);
	

        $dataArray["空调开机温度"] = $v[1] == 0x2020 ? "未监控" : $v[1];
        $dataArray["空调关机温度"] = $v[2] == 0x2020 ? "未监控" : $v[2];
        $dataArray["室内高温报警回风温度上限"] = $v[3] == 0x2020 ? "未监控" : $v[3];
        $dataArray["室内低温报警回风温度下限"] = $v[4] == 0x2020 ? "未监控" : $v[4];
        $dataArray["室内高湿报警回风湿度上限"] = $v[5] == 0x2020 ? "未监控" : $v[5];
        $dataArray["室内低湿报警回风湿度下限"] = $v[6] == 0x2020 ? "未监控" : $v[6];
        $dataArray["制冷模式温度设定值"] = $v[7] == 0x2020 ? "未监控" : $v[7];

	$newMem = '';
        $mem = substr($memData, 4 + 2*18 + 9 + 35 + 2*7 + 1, 2*9);
        for ($i = 0; $i < strlen($mem); $i += 2) {
            $newMem .= $mem[$i + 1] . $mem[$i];
        }
        $v = unpack('s*',$newMem);

        //jump 8
        switch($v[1])
        {
            case 0:
                $dataArray["运行模式设定"] = '自动';
                break;
            case 1:
                $dataArray["运行模式设定"] = '制冷';
                break;
            case 2:
                $dataArray["运行模式设定"] = '除湿';
                break;
            case 3:
                $dataArray["运行模式设定"] = '送风';
                break;
            case 4:
                $dataArray["运行模式设定"] = '制热';
                break;
        }
        switch($v[2])
        {
            case 0:
                $dataArray["内风机风速设定"] = '停';
                break;
            case 1:
                $dataArray["内风机风速设定"] = '低风';
                break;
            case 2:
                $dataArray["内风机风速设定"] = '中风';
                break;
            case 3:
                $dataArray["内风机风速设定"] = '高
                风';
                break;
        }
        
        $dataArray["摆风功能设定"] = $v[3] == 1 ? "运转":"停止";
        $dataArray["屏蔽本地操作"] = $v[4] == 1 ? "屏蔽本地操作" : "允许本地操作";
        $dataArray["双机备份切换时间"] = $v[5] == 1 ? "24小时设定有效" : "不启用双机备份切换功能";
        $dataArray["高温同开温度设定"] = $v[6];
        $dataArray["制热模式温度设定值"] = $v[7];
        $dataArray["制冷温控精度"] = $v[8];
        $dataArray["制热温控精度"] = $v[9];

        $v = unpack('I',substr($memData, 4 + 2*18 + 9 + 35 + 2*16 + 1, 4));
        $dataArray["累计总电量"] = number_format($v[1]/100, 2)."kwh";

        $v = unpack('s',substr($memData, 4 + 2*18 + 9 + 35 + 2*16 + 1 + 4, 2));
        $dataArray["今日电量"] = number_format($v[1]/100, 2)."kwh";

        $v = unpack('v',substr($memData, 4 + 2*18 + 9 + 35 + 2*16 + 1 + 4 + 2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*18 + 9 + 35 + 2*16 + 1 + 4 + 2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
