<?php
function Is_pmu400_NeedExtraPara(){
    return true;
}

function Get_pmu400_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
        case '[B相电压]':
        case '[C相电压]':
            return array(0, $dataArray['相电压2'] * 1.732);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmu400_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray['len'] = strlen($memData);
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $ct = isset($extraPara->ct) ? $extraPara->ct : 1;
        $dataArray["无数据"] = false;
        $v = unpack('f*',substr($memData,4, 4*4));
        $dataArray['相电压'] = number_format($v[1], 2).' V';
        $dataArray['相电压2'] = number_format($v[1], 2);
        $dataArray['相电流'] = number_format($v[2] * $ct, 2).' A';
        $dataArray['相有功功率'] = number_format($v[3] * $ct /10, 2).' W';
        $dataArray['总有功功率2'] = number_format($v[3] * $ct / 10/ 1000, 3,'.','');
        $dataArray['频率'] = number_format($v[4], 2).' Hz';
        /* $dataObj->v = number_format($v[1], 2);
        $dataObj->i = number_format($v[2], 2);
        $dataObj->p = $v[3];
        $dataObj->freq = number_format($v[4], 2); */
        $v = unpack('C*',substr($memData,4 + 4*4, 2));
        $dataArray['DI1'] = $v[1] == 1 ? '闭合' : '断开';
        $dataArray['DI2'] = $v[2] == 1 ? '闭合' : '断开';
        $v = unpack('v',substr($memData, 4 + 4*4 +2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*4 + 4,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}


?>
