<?php
function Is_pmu500_NeedExtraPara(){
    return true;
}

function Get_pmu500_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压(V)'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压(V)'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压(V)'] * 1.732);
        case '[总功率]':
            return array(0, $dataArray["总有功功率2"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmu500_Active_Power($dataArray){
    return array(0 , $dataArray['有功电度总和(KWh)']);
}

function Get_pmu500_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $ct = isset($extraPara->ct) ? $extraPara->ct : 1;
        $dataArray["无数据"] = false;
        $v = unpack('S*',substr($memData,4,6*2));
        $dataArray['A相电压(V)'] = $dataArray["AB相电压(V)"] = $v[1] / 10;
        $dataArray['B相电压(V)'] = $dataArray["BC相电压(V)"] =  $v[2] / 10;
        $dataArray['C相电压(V)'] = $dataArray["CA相电压(V)"] =  $v[3] / 10;
        $dataArray['A相电流(A)'] = $v[4]  / 1000 * $ct;
        $dataArray['B相电流(A)'] = $v[5]  / 1000 * $ct;
        $dataArray['C相电流(A)'] = $v[6]  / 1000 * $ct;
        $v = unpack('i*',substr($memData,4 + 6*2,2*4));
        $dataArray["有功功率总和(KW)"] = $v[1]/16;
        $dataArray["总有功功率2"] = $v[1]/16;
        $dataArray["无功功率总和(KVA)"] = $v[2]/16;
        $v = unpack('s*',substr($memData,4 + 6*2 + 2*4,10*2));
        $dataArray["功率因数总和"] = $v[1] / 16;
        $dataArray["A相有功功率(KW)"] = $v[2]/16;
        $dataArray["B相有功功率(KW)"] = $v[3]/16;
        $dataArray["C相有功功率(KW)"] = $v[4]/16;
        $dataArray["A相无功功率(KVA)"] = $v[5]/16;
        $dataArray["B相无功功率(KVA)"] = $v[6]/16;
        $dataArray["C相无功功率(KVA)"] = $v[7]/16;
        $dataArray["A相功率因数"] = $v[8] / 1000;
        $dataArray["B相功率因数"] = $v[9] / 1000;
        $dataArray["C相功率因数"] = $v[10] / 1000;
        $v = unpack('S*',substr($memData,4 + 16*2 + 2*4,1*2));
        $dataArray["频率(Hz)"] = $v[1] / 100;
        $v = unpack('I*',substr($memData,4 + 17*2 + 2*4,2*4));
        $dataArray["有功电度总和(KWh)"] = $v[1] / 10;
        $dataArray["无功电度总和(KWh)"] = $v[2] / 10;
        $v = unpack('S*',substr($memData,4 + 17*2 + 4*4,4*2));
        $dataArray["通讯地址"] = $v[1];
        switch ($v[2]) {
            case 0:
                $dataArray["波特率(bps)"] = 4800;
                break;
            case 1:
                $dataArray["波特率(bps)"] = 9600;
                break;
            case 2:
                $dataArray["波特率(bps)"] = 19200;
                break;
            default:
                $dataArray["波特率(bps)"] = "无效";
                break;
        }

        $dataArray["CT变比"] = $v[3] > 9999 ? "无效" : $v[3];
        $dataArray["接线模式"] = $v[4] == 0 ? "三相四线" : "三相三线";


        $v = unpack('v',substr($memData, 4 + 17*2 + 4*4 + 4*2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 17*2 + 4*4 + 4*2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}



?>
