<?php
function Is_pmw2800_NeedExtraPara(){
    return false;
}

function Get_pmw2800_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压(V)']);
        case '[B相电压]':
            return array(0, $dataArray['B线电压(V)']);
        case '[C相电压]':
            return array(0, $dataArray['C线电压(V)']);
        case '[总功率]':
            return array(0, $dataArray["总有功功率2"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_pmw2800_Active_Power($dataArray){
    return array(0 , $dataArray['有功电度总和(KWh)']);
}

function Get_pmw2800_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('f*',substr($memData,4,4*34));
        $dataArray['A相电流(A)'] = number_format($v[1], 2);
        $dataArray['B相电流(A)'] = number_format($v[2], 2);
        $dataArray['C相电流(A)'] = number_format($v[3], 2);
        $dataArray['中性线电流(A)'] = number_format($v[4], 2);
        $dataArray['3相平均电流(A)'] = number_format($v[5], 2);

        $dataArray['A相相电压(V)'] = number_format($v[6], 1);
        $dataArray['B相相电压(V)'] = number_format($v[7], 1);
        $dataArray['C相相电压(V)'] = number_format($v[8], 1);
        $dataArray['相电压平均值(V)'] = number_format($v[9], 1);

        $dataArray['AB线电压(V)'] = number_format($v[10], 1);
        $dataArray['BC线电压(V)'] = number_format($v[11], 1);
        $dataArray['CA线电压(V)'] = number_format($v[12], 1);
        $dataArray['线电压平均值(V)'] = number_format($v[13], 1);


        $dataArray["A相有功功率(KW)"] = number_format($v[14]/1000, 5);
        $dataArray["B相有功功率(KW)"] = number_format($v[15]/1000, 5);
        $dataArray["C相有功功率(KW)"] = number_format($v[16]/1000, 5);
        $dataArray["总有功功率(KW)"] = number_format($v[17]/1000, 5);

        $dataArray["A相无功功率(KVar)"] = number_format($v[18]/1000, 5);
        $dataArray["B相无功功率(KVar)"] = number_format($v[19]/1000, 5);
        $dataArray["C相无功功率(KVar)"] = number_format($v[20]/1000, 5);
        $dataArray["总无功功率(KVar)"] = number_format($v[21]/1000, 5);

        $dataArray["A相视在功率(KVA)"] = number_format($v[22]/1000, 5);
        $dataArray["B相视在功率(KVA)"] = number_format($v[23]/1000, 5);
        $dataArray["C相视在功率(KVA)"] = number_format($v[24]/1000, 5);
        $dataArray["总视在功率(KVA)"] = number_format($v[25]/1000, 5);
        
        $dataArray["A相功率因数"] = number_format($v[26], 1);
        $dataArray["B相功率因数"] = number_format($v[27], 1);
        $dataArray["C相功率因数"] = number_format($v[28], 1);
        $dataArray["功率因数总和"] = number_format($v[29], 1);

        $dataArray["频率(Hz)"] = number_format($v[30], 2);
        $dataArray["有功电度总和(KWh)"] = number_format($v[31]/1000, 5);
        $dataArray["无功电度总和(KVarh)"] = number_format($v[32]/1000, 5);
        $dataArray["反向有功电度总和(KWh)"] = number_format($v[33]/1000, 5);
        $dataArray["反向无功电度总和(KVarh)"] = number_format($v[34]/1000, 5);
        
        $v = unpack('S*',substr($memData,4 + 4*34, 2*4));
        $dataArray["有功电度溢出"] = $v[1];
        $dataArray["无功电度溢出"] = $v[2];
        $dataArray["反向有功电度溢出"] = $v[3];
        $dataArray["反向无功电度溢出"] = $v[4];

        $v = unpack('v',substr($memData, 4 + 4*34 + 2*4, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*34 + 2*4 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}



?>
