<?php
function Is_power_302a_NeedExtraPara(){
    return true;
}

function Get_power_302a_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2'] * 1.732);
        case '[A相电流]':
            return array(0, $dataArray['A相电流']);
        case '[B相电流]':
            return array(0, $dataArray['B相电流']);
        case '[C相电流]':
            return array(0, $dataArray['C相电流']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_power_302a_Active_Power($dataArray){
    return array(0 , floatval($dataArray['总有功电能']));
}

function Get_power_302a_RtData($memData, &$dataArray, $extraPara = false)
{
        if (strlen($memData)) {
            $dataArray["无数据"] = false;
            $v = unpack('f*', substr($memData, 4, 244));
            //功率寄存器
            if(isset($extraPara->direction) && $extraPara->direction == '1'){
                $dataArray['有功功率'] = number_format($v[4] / 1000, 3)." KW";
                $dataArray['总有功功率2'] = number_format($v[4] / 1000, 3,'.','');
                $dataArray["电压"] = number_format($v[28], 3)." V";
                $dataArray["电流"] = number_format($v[27], 3)." A";
                $dataArray["频率"] = number_format($v[45], 3)." Hz";
                $dataArray["功率因数"] = number_format($v[38], 3);
                $dataArray["有功电能"] = number_format($v[49], 3, ".", "")." KWH";
            }else{
                $dataArray["A相有功功率"] = number_format($v[1] / 1000, 3)." KW";
                $dataArray["B相有功功率"] = number_format($v[2] / 1000, 3)." KW";
                $dataArray["C相有功功率"] = number_format($v[3] / 1000, 3)." KW";
                $dataArray["总有功功率"]  = number_format($v[4] / 1000, 3)." KW";
                $dataArray["总有功功率2"]  = number_format($v[4] / 1000, 3,'.','');

                /*$dataArray->qa = number_format($v[5], 3);
                 $dataArray->qb = number_format($v[6], 3);
                 $dataArray->qc = number_format($v[7], 3);
                 $dataArray->qt = number_format($v[8], 3);
                 $dataArray->sa = number_format($v[9], 3);
                 $dataArray->sb = number_format($v[10], 3);
                 $dataArray->sc = number_format($v[11], 3);
                 $dataArray->st = number_format($v[12], 3);
                 $dataArray->linePa = number_format($v[13], 3);
                 $dataArray->linePb = number_format($v[14], 3);
                 $dataArray->linePc = number_format($v[15], 3);
                 $dataArray->linePt = number_format($v[16], 3);
                 $dataArray->lineQa = number_format($v[17], 3);
                 $dataArray->lineQb = number_format($v[18], 3);
                 $dataArray->lineQc = number_format($v[19], 3);
                 $dataArray->lineQt = number_format($v[20], 3);*/
                //有效值寄存器
                $dataArray["A相电压"] = number_format($v[21], 3)." V";
                $dataArray["A相电压2"] = number_format($v[21], 3);
                $dataArray["B相电压"] = number_format($v[22], 3)." V";
                $dataArray["B相电压2"] = number_format($v[22], 3);
                $dataArray["C相电压"] = number_format($v[23], 3)." V";
                $dataArray["C相电压2"] = number_format($v[23], 3);
                $dataArray["A相电流"] = number_format($v[24], 3)." A";
                $dataArray["B相电流"] = number_format($v[25], 3)." A";
                $dataArray["C相电流"] = number_format($v[26], 3)." A";
                /*            $dataArray->itRms = number_format($v[27], 3);
                 $dataArray->utRms = number_format($v[28], 3);
                 $dataArray->luaRms = number_format($v[29], 3);
                 $dataArray->lubRms = number_format($v[30], 3);
                 $dataArray->lucRms = number_format($v[31], 3);
                 $dataArray->liaRms = number_format($v[32], 3);
                 $dataArray->libRms = number_format($v[33], 3);
                 $dataArray->licRms = number_format($v[34], 3);*/
                //功率因数寄存器
                $dataArray["A相功率因数"] = number_format($v[35], 3);
                $dataArray["B相功率因数"]  = number_format($v[36], 3);
                $dataArray["C相功率因数"] = number_format($v[37], 3);
                //$dataArray->pft = number_format($v[38], 3);
                //功率角和电压夹角寄存器
                /*$dataArray->pga = number_format($v[39], 3);
                 $dataArray->pgb = number_format($v[40], 3);
                 $dataArray->pgc = number_format($v[41], 3);
                 $dataArray->yuaub = number_format($v[42], 3);
                 $dataArray->yuauc = number_format($v[43], 3);
                $dataArray->yubuc = number_format($v[44], 3);*/
                //线频率寄存器,如果频率>500，则能量需要除10000
                if($v[45] > 500)
                {
                    $dataArray["频率"] = number_format($v[45] - 1000, 3).' Hz';
                    //能量寄存器
                    $dataArray["A相有功电能"] = number_format($v[46]/10000, 4, ".", "")." KWH";
                    $dataArray["B相有功电能"] = number_format($v[47]/10000, 4, ".", "")." KWH";
                    $dataArray["C相有功电能"] = number_format($v[48]/10000, 4, ".", "")." KWH";
                    $dataArray["总有功电能"] = number_format($v[49]/10000, 4, ".", "")." KWH";
                }
                else
                {
                    $dataArray["频率"] = number_format($v[45], 3).' Hz';
                    //能量寄存器
                    $dataArray["A相有功电能"] = number_format($v[46], 4, ".", "")." KWH";
                    $dataArray["B相有功电能"] = number_format($v[47], 4, ".", "")." KWH";
                    $dataArray["C相有功电能"] = number_format($v[48], 4, ".", "")." KWH";
                    $dataArray["总有功电能"] = number_format($v[49], 4, ".", "")." KWH";
                }
               
                /*$dataArray->eqa = number_format($v[50], 3);
                 $dataArray->eqb = number_format($v[51], 3);
                 $dataArray->eqc = number_format($v[52], 3);
                 $dataArray->eqt = number_format($v[53], 3);
                 $dataArray->esa = number_format($v[54], 3);
                 $dataArray->esb = number_format($v[55], 3);
                 $dataArray->esc = number_format($v[56], 3);
                 $dataArray->est = number_format($v[57], 3);
                 $dataArray->lineEpa = number_format($v[58], 3);
                 $dataArray->lineEpb = number_format($v[59], 3);
                 $dataArray->lineEpc = number_format($v[60], 3);
                 $dataArray->lineEpt = number_format($v[61], 3);*/
            }
	        $CI = &get_instance();
            $memData = $CI->cache->get($dataArray["数据ID"].":time");
            if ($memData == false) {
                //没有时间的
                $dataArray['更新时间'] = "无最后更新时间";
            } else if ((time() - intval($memData)) > 600) {
                //超时5分钟
                $dataArray['更新时间'] = date("Y-m-d H:i:s", intval($memData));
            } else {
                $dataArray['更新时间'] = date("Y-m-d H:i:s", intval($memData));
            }
        } else{
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }

}
