<?php

function Get_powercommand33_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $v = unpack('S*', substr($memData, 4, 2*34));
        switch($v[1])
        {
            case 0:
                $dataArray['控制状态'] = "关";
                break;
            case 1:
                $dataArray['控制状态'] = "自动";
                break;
            case 2:
                $dataArray['控制状态'] = "手动";
                break;
            default:
                $dataArray['控制状态'] = $v[1];
                break;
        }
        switch($v[2])
        {
            case 0:
                $dataArray['运行状态'] = "停止";
                break;
            case 1:
                $dataArray['运行状态'] = "延迟启动";
                break;
            case 2:
                $dataArray['运行状态'] = "待机热机中";
                break;
            case 3:
                $dataArray['运行状态'] = "额定频率和电压运行";
                break;
            case 4:
                $dataArray['运行状态'] = "冷却中";
                break;
            case 5:
                $dataArray['运行状态'] = "待机冷却";
                break;
            case 6:
                $dataArray['运行状态'] = "待机";
                break;
            default:
                $dataArray['运行状态'] = $v[2];
                break;
        }
        $dataArray['错误代码'] = $v[3];
        switch($v[4])
        {
            case 0:
                $dataArray['错误类型'] = "无";
                break;
            case 1:
                $dataArray['错误类型'] = "警告";
                break;
            case 2:
                $dataArray['错误类型'] = "关机";
                break;
        }
        $dataArray['待机输出%'] = $v[5] == 65535 ? "无效数据" : $v[5];

        //NFPA 6
        $dataArray["油机告警"] = ($v[6] >> 15) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油机告警"] = ($v[6] >> 15) & 0x1;
        $dataArray["油机对负载供电"] = ($v[6] >> 14) & 0x1 ? "供电" : "正常";
        $dataArray["AlertArray"]["油机对负载供电"] = ($v[6] >> 14) & 0x1;
        $dataArray["油机启动"] = ($v[6] >> 13) & 0x1 ? "启动" : "未启动";
        $dataArray["AlertArray"]["油机启动"] = ($v[6] >> 13) & 0x1;
        $dataArray["手动控制状态"] = ($v[6] >> 12) & 0x1 ? "手工" : "自动";
        $dataArray["AlertArray"]["手动控制状态"] = ($v[6] >> 12) & 0x1;

        $dataArray["启动电池电压高"] = ($v[6] >> 11) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动电池电压高"] = ($v[6] >> 11) & 0x1;
        $dataArray["启动电池电压低"] = ($v[6] >> 10) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动电池电压低"] = ($v[6] >> 10) & 0x1;
        $dataArray["充电器故障"] = ($v[6] >> 9) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["充电器故障"] = ($v[6] >> 9) & 0x1;
        $dataArray["启动失败故障"] = ($v[6] >> 8) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["启动失败故障"] = ($v[6] >> 8) & 0x1;

        $dataArray["冷却液温度低"] = ($v[6] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["冷却液温度低"] = ($v[6] >> 7) & 0x1;
        $dataArray["将要高温"] = ($v[6] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["将要高温"] = ($v[6] >> 6) & 0x1;
        $dataArray["高温告警"] = ($v[6] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["高温告警"] = ($v[6] >> 5) & 0x1;
        $dataArray["将要油压低"] = ($v[6] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["将要油压低"] = ($v[6] >> 4) & 0x1;

        $dataArray["油压低"] = ($v[6] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油压低"] = ($v[6] >> 3) & 0x1;
        $dataArray["超速停机"] = ($v[6] >>2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["超速停机"] = ($v[6] >> 2) & 0x1;
        $dataArray["冷却液液位低"] = ($v[6] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["冷却液液位低"] = ($v[6] >> 1) & 0x1;
        $dataArray["燃油液位低"] = ($v[6]) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["燃油液位低"] = ($v[6]) & 0x1;
        //Extend 7
        $dataArray["检修油机"] = ($v[7] >> 15) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["检修油机"] = ($v[7] >> 15) & 0x1;
        $dataArray["接地故障"] = ($v[7] >> 14) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["接地故障"] = ($v[7] >> 14) & 0x1;
        $dataArray["市电电压高"] = ($v[7] >> 13) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["市电电压高"] = ($v[7] >> 13) & 0x1;
        $dataArray["市电电压低"] = ($v[7] >> 12) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["市电电压低"] = ($v[7] >> 12) & 0x1;

        $dataArray["输出频率低"] = ($v[7] >> 11) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["输出频率低"] = ($v[7] >> 11) & 0x1;
        $dataArray["输出过载告警"] = ($v[7] >> 10) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["输出过载告警"] = ($v[7] >> 10) & 0x1;
        $dataArray["过流告警"] = ($v[7] >> 9) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["过流告警"] = ($v[7] >> 9) & 0x1;
        $dataArray["短路告警"] = ($v[7] >> 8) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["短路告警"] = ($v[7] >> 8) & 0x1;

        $dataArray["反向功率告警"] = ($v[7] >> 7) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["反向功率告警"] = ($v[7] >> 7) & 0x1;
        $dataArray["反向无功功率告警"] = ($v[7] >> 6) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["反向无功功率告警"] = ($v[7] >> 6) & 0x1;
        $dataArray["同步失败"] = ($v[7] >> 5) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["同步失败"] = ($v[7] >> 5) & 0x1;
        $dataArray["关机失败"] = ($v[7] >> 4) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["关机失败"] = ($v[7] >> 4) & 0x1;

        $dataArray["负载请求"] = ($v[7] >> 3) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["负载请求"] = ($v[7] >> 3) & 0x1;
        $dataArray["发电机组断路器跳闸"] = ($v[7] >> 2) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["发电机组断路器跳闸"] = ($v[7] >> 2) & 0x1;
        $dataArray["断路器跳闸"] = ($v[7] >> 1) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["断路器跳闸"] = ($v[7] >> 1) & 0x1;
        $dataArray["油机紧急停机"] = ($v[7]) & 0x1 ? "告警" : "正常";
        $dataArray["AlertArray"]["油机紧急停机"] = ($v[7]) & 0x1;

        $dataArray["L1N电压"] = $v[8];
        $dataArray["L2N电压"] = $v[9];
        $dataArray["L3N电压"] = $v[10];
        $dataArray["LN平均电压"] = $v[11];

        $dataArray["L1-L2电压"] = $v[12];
        $dataArray["L2-L3电压"] = $v[13];
        $dataArray["L3-L1电压"] = $v[14];
        $dataArray["LL平均电压"] = $v[15];

        $dataArray["L1电流"] = $v[16];
        $dataArray["L2电流"] = $v[17];
        $dataArray["L3电流"] = $v[18];
        $dataArray["平均电流"] = $v[19] == 65535 ? "无效数据" : $v[19];
        $dataArray["中线电流"] = $v[20] == 65535 ? "无效数据" : $v[20];

        $dataArray["L1有功功率"] = $v[21];
        $dataArray["L2有功功率"] = $v[22];
        $dataArray["L3有功功率"] = $v[23];
        $dataArray["总有功功率"] = $v[24];

        $dataArray["L1无功功率"] = $v[25];
        $dataArray["L2无功功率"] = $v[26];
        $dataArray["L3无功功率"] = $v[27];
        $dataArray["总无功功率"] = $v[28];

        $dataArray["功率因数"] = $v[29];

        $dataArray["L1视在功率"] = $v[30];
        $dataArray["L2视在功率"] = $v[31];
        $dataArray["L3视在功率"] = $v[32];
        $dataArray["总视在功率"] = $v[33];
        $dataArray["频率"] = $v[34] == 65535 ? "无效数据" : $v[34];

        $v = unpack('i*', substr($memData, 4 + 2*34, 4*6));
        $dataArray["反向有功能耗"] = $v[1]  == 65535 ? "无效数据" : $v[1];
        $dataArray["正向有功能耗"] = $v[2]  == 65535 ? "无效数据" : $v[2];
        $dataArray["净有功能耗"] = $v[3];

        $dataArray["反向无功能耗"] = $v[4];
        $dataArray["正向无功能耗"] = $v[5];
        $dataArray["净无功能耗"] = $v[6];

        $v = unpack('S*', substr($memData, 4 + 2*34 + 4*6, 2*12));
        $dataArray["L1电流"] = $v[1];
        $dataArray["L2电流"] = $v[2];
        $dataArray["L3电流"] = $v[3];

        $dataArray["电池电压"] = ($v[4]/10). "v";
        $dataArray["油压"] = $v[5]/10;
        $dataArray["油温"] = $v[6]/10;
        $dataArray['冷却液温度'] = ($v[7]/10);
        $dataArray['进气歧管温度'] = $v[8]/10;
        $dataArray['燃油温度'] = $v[9]/10;
        $dataArray['燃油速度'] = $v[10];
        $dataArray["平均引擎速度"] = $v[11];
        $dataArray["尝试启动次数"] = $v[12];

        $v = unpack('i*', substr($memData, 4 + 2*34 + 4*6 + 2*12, 4*3));
        $dataArray["引擎运行次数"] = $v[1];
        $dataArray["总燃油消耗"] = $v[2];
        $dataArray["总启动次数"] = $v[3];

        $v = unpack('v',substr($memData, 4 + 2*34 + 4*6 + 2*12 + 4*3, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*34 + 4*6 + 2*12 + 4*3 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
