<?php



function Get_powerwizard_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('s*',substr($memData,4,2*2));
        $dataArray["平均线电压"] = $v[1];
        $dataArray["平均电流"] = $v[2];
        $v = unpack('f*',substr($memData,4 + 4 , 4*2));
        $dataArray["平均频率"] = $v[1];
        $dataArray["功率因素"] = $v[2];
        $v = unpack('s',substr($memData,4 + 4 + 4*2 , 2));
        $dataArray["功率因素滞后"] = $v[1] == 0 ? "提前" : "滞后";
        $v = unpack('f',substr($memData,4 + 4 + 4*2 + 2, 4));
        $dataArray["总负载输出率"] = $v[1];
        $v = unpack('i',substr($memData,4 + 4 + 4*2 + 2 + 4, 4));
        $dataArray["总负载输出功率"] = $v[1];
        $v = unpack('s*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 ,2*9));
        $dataArray["AB线电压"] = $v[1];
        $dataArray["BC线电压"] = $v[2];
        $dataArray["CA线电压"] = $v[3];
        $dataArray["A相电流"] = $v[4];
        $dataArray["B相电流"] = $v[5];
        $dataArray["C相电流"] = $v[6];
        $dataArray["A相电压"] = $v[7];
        $dataArray["B相电压"] = $v[8];
        $dataArray["C相电压"] = $v[9];
        $v = unpack('i*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9, 4*9));
        $dataArray["A相有功功率"] = $v[1];
        $dataArray["B相有功功率"] = $v[2];
        $dataArray["C相有功功率"] = $v[3];
        $dataArray["A相视在功率"] = $v[4];
        $dataArray["B相视在功率"] = $v[5];
        $dataArray["C相视在功率"] = $v[6];
        $dataArray["A相无功功率"] = $v[7];
        $dataArray["B相无功功率"] = $v[8];
        $dataArray["C相无功功率"] = $v[9];
        $v = unpack('f*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9, 4*3));
        $dataArray["A相功率因素"] = $v[1];
        $dataArray["B相功率因素"] = $v[2];
        $dataArray["C相功率因素"] = $v[3];
        $v = unpack('i',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3, 4));
        $dataArray["总视在功率"] = $v[1];
        $v = unpack('f',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4, 4));
        $dataArray["总视在功率输出率"] = $v[1];
        $v = unpack('i',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4, 4));
        $dataArray["总无功功率"] = $v[1];
        $v = unpack('f',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4, 4));
        $dataArray["总无功功率输出率"] = $v[1];
        $v = unpack('i*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4, 8));
        $dataArray["总有功电度"] = $v[1];
        $dataArray["总无功电度"] = $v[2];
        $v = unpack('s*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4 + 8, 2*4));
        $dataArray["平均相电压"] = $v[1];

        $dataArray["A相功率因素滞后"] = $v[2] == 0 ? "提前" : "滞后";
        $dataArray["B相功率因素滞后"] = $v[3] == 0 ? "提前" : "滞后";
        $dataArray["C相功率因素滞后"] = $v[4] == 0 ? "提前" : "滞后";

        $v = unpack('f*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4 + 8 + 2*4, 4*6));
        $dataArray["平均线电压"] = $v[1];
        $dataArray["油压"] = $v[2];
        $dataArray["冷却液温度"] = $v[3];
        $dataArray["电池电压"] = number_format($v[4], 2);
        $dataArray["转速"] = $v[5];
        $dataArray["运行时长"] = $v[6];

        $v = unpack('s*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4 + 8 + 2*4 + 4*6, 2*6));
        switch($v[1])
        {
            case 0:
                $dataArray["运行状态"] = "初始化";
                break;
            case 1:
                $dataArray["运行状态"] = "预启动";
                break;
            case 2:
                $dataArray["运行状态"] = "启动中";
                break;
            case 3:
                $dataArray["运行状态"] = "运行中";
                break;
            case 4:
                $dataArray["运行状态"] = "预冷却";
                break;
            case 5:
                $dataArray["运行状态"] = "冷却中";
                break;
            case 6:
                $dataArray["运行状态"] = "停止中";
                break;
            case 7:
                $dataArray["运行状态"] = "已停止";
                break;
            case 8:
                $dataArray["运行状态"] = "空闲";
                break;
            default:
                $dataArray["运行状态"] = "未知状态";
                break;
        }
        $dataArray["下次维护剩余小时数"] = $v[2];
        $dataArray["下次维护剩余天数"] = $v[3];
        $dataArray["启动尝试次数"] = $v[4];
        $dataArray["成功启动次数"] = $v[5];
        switch($v[6])
        {
            case 0:
                $dataArray["自动控制状态"] = "停止";
                break;
            case 1:
                $dataArray["自动控制状态"] = "自动";
                break;
            case 2:
                $dataArray["自动控制状态"] = "运行";
                break;
            default:
                $dataArray["自动控制状态"] = "未知状态";
                break;
        }
        $v = unpack('v',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4 + 8 + 2*4 + 4*6 + 2*6, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 4 + 4*2 + 2 + 4 + 4 + 2*9 + 4*9 + 4*3 + 4 + 4 + 4 + 4 + 8 + 2*4 + 4*6 + 2*6 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
