<?php

function Get_psma_419_UnicomCategory()
{
    return "419";
}

function Get_psma_419_config()
{
    $config = array("ac" => 
			array(
                        "airlock" => 8, "p40_43" => 3, "p40_41" => 0, "p40_44" => 8,
                        "p40_41_label" => array(),
                        'p40_43_label' => array('交流切换状态' => true, '事故照明灯状态' => true, '当前工作路号' => true),
                        'p40_43_rules' => array(
                                0 => array(array(0xE0 => "交流切换自动", 0xE1 => "交流切换手动"), "无效状态"),
                                1 => array(array(0 => "闭合", 1 => "断开", 0xE0 => "交流切换自动", 0xE1 => "交流切换手动", 0xE2 => "照明开", 0xE3 => "照明关", 0xE4 => "第一路", 0xE5 => "第二路", 0xE6 => "第三路", 0xE7 => "无工作路号"), "无效状态"),
                                2 => array(array(0 => "闭合", 1 => "断开", 0xE0 => "交流切换自动", 0xE1 => "交流切换手动", 0xE2 => "照明开", 0xE3 => "照明关", 0xE4 => "第一路", 0xE5 => "第二路", 0xE6 => "第三路", 0xE7 => "无工作路号"), "无效状态")
                        ),
                        'p40_44_label' => array('交流输入空开跳' => true, '交流输出空开跳' => true, '防雷器断' => true, '交流输入1停电' => true, '交流输入2停电' => true, '交流输入3停电' => true, '市电切换失败' => true, '交流屏通讯中断' => true),
                        "p40_44_rules" => array(
                                0 => array(array(0 => "正常", 5 => "故障"), "无效"),
                                1 => array(array(0 => "正常", 5 => "故障"), "无效"),
                                2 => array(array(0 => "正常", 5 => "故障"), "无效"),
                                3 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                                4 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                                5 => array(array(0 => "正常", 0xe1 => "故障"), "无效"),
                                6 => array(array(0 => "正常", 0xe3 => "故障"), "无效"),
                                7 => array(array(0 => "正常", 0xe2 => "故障"), "无效")
                        ),
                        "ia_support" => true, "ib_support" => true, "ic_support" => true,
                        "ia_alert_support" => true, "ib_alert_support" => true, "ic_alert_support" => true
                ) ,
    "rc" => 
		array(
                        "p42_46" => 9, "p42_46_size" => 36, "p41_41" => 4, "p41_43" => 1, "p41_44" => 4,
                        'p41_41_label' => array('模块温度' => true, '模块限流点(百分数)' => true, '模块输出电压' => true, '输出电压保护点' => true),
                        'p41_43_label' => array('控制状态(自动或手动)' => true),
                        'p41_43_rules' => array(0 => array(array(0xE0 => "自动", 0xE1 => "手动"), "未知")),
                        'p41_44_label' => array('模块保护' => true, '风扇故障' => true, '模块过温' => true, '模块通讯中断' => true),
                        'p41_44_rules' => array(
                                0 => array(array(0 => "正常", 1 => "故障"), "无效"),
                                1 => array(array(0 => "正常", 1 => "故障"), "无效"),
                                2 => array(array(0 => "正常", 1 => "故障"), "无效"),
                                3 => array(array(0 => "正常", 0xe2 => "故障"), "无效")
                        ),
                        'params' => array('整流模块输出电压', '整流模块数量')
                )
    ,
    "dc" => 
		array(
                        "m" => 3, "n" => 6, "p" => 5, "alert_m" => 64, "alert_p" => 13,
                        "p_label" => array('电池组1电压' => true, '电池组2电压' => true, "电池房温度" => true, "测点1温度" => true, "测点2温度" => true),
                        "alert_p_label" => array('电池组1熔丝断' => true, '电池组2熔丝断' => true, '电池组1充电过流' => true, '电池组2充电过流' => true, '电池组1保护' => true, '电池组2保护' => true, '二次下电' => true, '电池房过温' => true, '测点1过温' => true, '测点2过温' => true, '直流屏通讯中断' => true, '电池组1电压异常' => true, '电池组2电压异常' => true),
                        "alert_p_rules" => array(
                                0 => array(array(0x0 => "正常", 0x03 => "熔丝断"), "无效"),
                                1 => array(array(0x0 => "正常", 0x3 => "熔丝断"), "无效"),
                                2 => array(array(0x0 => "正常", 0x2 => "充电过流"), "无效"),
                                3 => array(array(0x0 => "正常", 0x2 => "充电过流"), "无效"),
                                4 => array(array(0x0 => "正常", 0xe4 => "保护"), "无效"),
                                5 => array(array(0x0 => "正常", 0xe4 => "保护"), "无效"),
                                6 => array(array(0x0 => "正常", 0xe3 => "二次下电"), "无效"),
                                7 => array(array(0x0 => "正常", 0xe1 => "过温"), "无效"),
                                8 => array(array(0x0 => "正常", 0xe1 => "过温"), "无效"),
                                9 => array(array(0x0 => "正常", 0xe1 => "过温"), "无效"),
                                10 => array(array(0x0 => "正常", 0xe2 => "中断"), "无效"),
                                11 => array(array(0x0 => "正常", 0x1 => "欠压", 0x2 => "过压"), "无效"),
                                12 => array(array(0x0 => "正常", 0x1 => "欠压", 0x2 => "过压"), "无效"),
                        )
                )
    );
    return $config;
}

function Get_psma_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_psma_419_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}


?>
