<?php

function Get_sca_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}

function Get_sca_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定温度']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        case '开关机状态':
            return array(0, $dataArray['开关机状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_sca_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('f*', substr($memData, 4 + 2*1, 4 * 2));
        $dataArray['设定温度'] = number_format($v[1], 1);
        $dataArray['设定湿度'] = number_format($v[2], 1);
        $v = unpack('S*', substr($memData, 4 + 2*1 +4*2 , 2 * 1));
        $dataArray['开关机状态'] = (($v[1] >> 0) & 0x1) === 0 ? '关机' : '开机';
        $v = unpack('f*', substr($memData, 4 + 2*2 +4*2 , 4 * 2));
        $dataArray['回风温度'] = number_format($v[1], 1);
        $v = unpack('v', substr($memData, 48, 2));
        $year = $v[1] ;
        $v = unpack('C*', substr($memData, 50, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
