<?php 

function Get_scu_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定回风温度（℃）']);
        case '回风温度':
            return array(0, $dataArray['回风温度值（℃）']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    

function Get_scu_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $v = unpack('s*', substr($memData, 4, 2 * 1));
       $dataArray["开关机"] = $v[1] == 1 ? '开机' : '关机';
       $v = unpack('f*', substr($memData, 4 + 2*1, 4 * 2));
       $dataArray["设定回风温度（℃）"] = number_format($v[1],1);
       $dataArray["设定回风湿度（%）"] = number_format($v[2],1);
       $v = unpack('S*', substr($memData, 4 + 2*1 +4*2 , 2 * 1));
       $dataArray["开关机状态"] = (($v[1] >> 0) & 0x1) === 0 ? '关机状态' : '开机状态';
       $dataArray["风机"] = (($v[1] >> 1) & 0x1) === 0 ? '关闭状态' : '开启状态';
       $dataArray["制热"] = (($v[1] >> 2) & 0x1) === 0 ? '非制热状态' : '制热状态';
       $dataArray["制冷"] = (($v[1] >> 3) & 0x1) === 0 ? '非制冷状态' : '制冷状态';
       $dataArray["加湿"] = (($v[1] >> 4) & 0x1) === 0 ? '非加湿状态' : '加湿状态';
       $dataArray["除湿"] = (($v[1] >> 5) & 0x1) === 0 ? '非除湿状态' : '除湿状态';
       $dataArray["单机/群控"] = (($v[1] >> 8) & 0x1) === 0 ? '单机状态' : '群控状态';
       $dataArray["告警状态"] = (($v[1] >> 14) & 0x1) === 0 ? '无告警' : '有告警';
       $v = unpack('f*', substr($memData, 4 + 2*2 +4*2 , 4 * 2));
       $dataArray["回风温度值（℃）"] = number_format($v[1],1);
       $dataArray["回风湿度值（%）"] = number_format($v[2],1);
       $v = unpack('S*', substr($memData, 4 + 2*2 +4*4 , 2 * 12));
       $dataArray["回风高温告警"] = (($v[1] >> 0) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["回风低温告警"] = (($v[1] >> 1) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["回风高湿告警"] = (($v[1] >> 2) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["送风高温告警"] = (($v[1] >> 4) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["送风低温告警"] = (($v[1] >> 5) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["硬件故障"] = (($v[1] >> 8) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["通信故障"] = (($v[1] >> 9) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["NTC故障"] = (($v[1] >> 10) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["风机故障"] = (($v[1] >> 11) & 0x1) === 0 ? '正常' : '告警';

       $dataArray["风机超时"] = (($v[2] >> 1) & 0x1) === 0 ? '正常' : '告警';

       $dataArray["加湿器大电流"] = (($v[3] >> 7) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加湿器干烧"] = (($v[3] >> 9) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加湿器超时"] = (($v[3] >> 10) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加热器过载"] = (($v[3] >> 11) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加热器1超时"] = (($v[3] >> 12) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加热器2超时"] = (($v[3] >> 13) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["掉电告警"] = (($v[3] >> 14) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["相序错误"] = (($v[3] >> 15) & 0x1) === 0 ? '正常' : '告警';

       $dataArray["电源频率偏高"] = (($v[4] >> 0) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["电源频率偏低"] = (($v[4] >> 1) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["A相过压"] = (($v[4] >> 2) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["B相过压"] = (($v[4] >> 3) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["C相过压"] = (($v[4] >> 4) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["A相欠压"] = (($v[4] >> 5) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["B相欠压"] = (($v[4] >> 6) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["C相欠压"] = (($v[4] >> 7) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["A相缺相"] = (($v[4] >> 8) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["B相缺相"] = (($v[4] >> 9) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["C相缺相"] = (($v[4] >> 10) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["气流丢失告警"] = (($v[4] >> 11) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["过滤网超时"] = (($v[4] >> 12) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["过滤网堵塞"] = (($v[4] >> 13) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["远程关机"] = (($v[4] >> 14) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["漏水告警"] = (($v[4] >> 15) & 0x1) === 0 ? '正常' : '告警';

       $dataArray["群控异常"] = (($v[5] >> 0) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["烟雾告警"] = (($v[5] >> 4) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["入水高温告警"] = (($v[5] >> 7) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["水阀故障告警"] = (($v[5] >> 8) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["盘管断流故障"] = (($v[5] >> 9) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加湿器故障"] = (($v[6] >> 1) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["地板压差告警"] = (($v[6] >> 2) & 0x1) === 0 ? '正常' : '告警';
       $dataArray["加湿器过载"] = (($v[6] >> 3) & 0x1) === 0 ? '正常' : '告警';

       $dataArray['AlertArray']["回风高温告警"] = (($v[1] >> 0) & 0x1) !== 0;
       $dataArray['AlertArray']["回风低温告警"] = (($v[1] >> 1) & 0x1) !== 0;
       $dataArray['AlertArray']["回风高湿告警"] = (($v[1] >> 2) & 0x1) !== 0;
       $dataArray['AlertArray']["送风高温告警"] = (($v[1] >> 4) & 0x1) !== 0;
       $dataArray['AlertArray']["送风低温告警"] = (($v[1] >> 5) & 0x1) !== 0;
       $dataArray['AlertArray']["硬件故障"] = (($v[1] >> 8) & 0x1) !== 0;
       $dataArray['AlertArray']["通信故障"] = (($v[1] >> 9) & 0x1) !== 0;
       $dataArray['AlertArray']["NTC故障"] = (($v[1] >> 10) & 0x1) !== 0;
       $dataArray['AlertArray']["风机故障"] = (($v[1] >> 11) & 0x1) !== 0;
       $dataArray['AlertArray']["风机超时"] = (($v[2] >> 1) & 0x1) !== 0;
       $dataArray['AlertArray']["加湿器大电流"] = (($v[3] >> 7) & 0x1) !== 0;
       $dataArray['AlertArray']["加湿器干烧"] = (($v[3] >> 9) & 0x1) !== 0;
       $dataArray['AlertArray']["加湿器超时"] = (($v[3] >> 10) & 0x1) !== 0;
       $dataArray['AlertArray']["加热器过载"] = (($v[3] >> 11) & 0x1) !== 0;
       $dataArray['AlertArray']["加热器1超时"] = (($v[3] >> 12) & 0x1) !== 0;
       $dataArray['AlertArray']["加热器2超时"] = (($v[3] >> 13) & 0x1) !== 0;
       $dataArray['AlertArray']["掉电告警"] = (($v[3] >> 14) & 0x1) !== 0;
       $dataArray['AlertArray']["相序错误"] = (($v[3] >> 15) & 0x1) !== 0;
       $dataArray['AlertArray']["电源频率偏高"] = (($v[4] >> 0) & 0x1) !== 0;
       $dataArray['AlertArray']["电源频率偏低"] = (($v[4] >> 1) & 0x1) !== 0;
       $dataArray['AlertArray']["A相过压"] = (($v[4] >> 2) & 0x1) !== 0;
       $dataArray['AlertArray']["B相过压"] = (($v[4] >> 3) & 0x1) !== 0;
       $dataArray['AlertArray']["C相过压"] = (($v[4] >> 4) & 0x1) !== 0;
       $dataArray['AlertArray']["A相欠压"] = (($v[4] >> 5) & 0x1) !== 0;
       $dataArray['AlertArray']["B相欠压"] = (($v[4] >> 6) & 0x1) !== 0;
       $dataArray['AlertArray']["C相欠压"] = (($v[4] >> 7) & 0x1) !== 0;
       $dataArray['AlertArray']["A相缺相"] = (($v[4] >> 8) & 0x1) !== 0;
       $dataArray['AlertArray']["B相缺相"] = (($v[4] >> 9) & 0x1) !== 0;
       $dataArray['AlertArray']["C相缺相"] = (($v[4] >> 10) & 0x1) !== 0;
       $dataArray['AlertArray']["气流丢失告警"] = (($v[4] >> 11) & 0x1) !== 0;
       $dataArray['AlertArray']["过滤网超时"] = (($v[4] >> 12) & 0x1) !== 0;
       $dataArray['AlertArray']["过滤网堵塞"] = (($v[4] >> 13) & 0x1) !== 0;
       $dataArray['AlertArray']["远程关机"] = (($v[4] >> 14) & 0x1) !== 0;
       $dataArray['AlertArray']["漏水告警"] = (($v[4] >> 15) & 0x1) !== 0;
       $dataArray['AlertArray']["群控异常"] = (($v[5] >> 0) & 0x1) !== 0;
       $dataArray['AlertArray']["烟雾告警"] = (($v[5] >> 4) & 0x1) !== 0;
       $dataArray['AlertArray']["入水高温告警"] = (($v[5] >> 7) & 0x1) !== 0;
       $dataArray['AlertArray']["水阀故障告警"] = (($v[5] >> 8) & 0x1) !== 0;
       $dataArray['AlertArray']["盘管断流故障"] = (($v[5] >> 9) & 0x1) !== 0;
       $dataArray['AlertArray']["加湿器故障"] = (($v[6] >> 1) & 0x1) !== 0;
       $dataArray['AlertArray']["地板压差告警"] = (($v[6] >> 2) & 0x1) !== 0;
       $dataArray['AlertArray']["加湿器过载"] = (($v[6] >> 3) & 0x1) !== 0;

       $v = unpack('f*', substr($memData, 4 + 2*14 +4*4 , 4 * 5));
       $dataArray["送风温度设定（℃）"] = number_format($v[1],1);
       $dataArray["送风湿度设定（%）"] = number_format($v[2],1);
       $dataArray["送风温度测量值（℃）"] = $v[3] > 3276 ? "无效" : number_format($v[3],1);
       $dataArray["送风湿度测量值（%）"] = $v[4] > 3276 ? "无效" : number_format($v[4],1);
       $dataArray["加湿电流（A）"] = number_format($v[5],1);
       $v = unpack('S*', substr($memData, 4 + 2*14 +4*9 , 2 * 2));
       $dataArray["电导率（s/cm）"] = $v[1];
       $dataArray["室内风机转速（%）"] = $v[2];
       $v = unpack('f*', substr($memData, 4 + 2*16 +4*9 , 4 * 8));
       $dataArray["回风高温告警阈值（℃）"] = number_format($v[1],1);
       $dataArray["回风低温告警阈值（℃）"] = number_format($v[2],1);
       $dataArray["回风高湿告警阈值（%）"] = number_format($v[3],1);
       $dataArray["回风低湿告警阈值（%）"] = number_format($v[4],1);
       $dataArray["送风高温告警阈值（℃）"] = number_format($v[5],1);
       $dataArray["送风低温告警阈值（℃）"] = number_format($v[6],1);
       $dataArray["过压告警阈值（v）"] = number_format($v[7],1);
       $dataArray["欠压告警阈值（v）"] = number_format($v[8],1);
       $v = unpack('S*', substr($memData, 4 + 2*16 +4*17 , 2 * 1));
       $dataArray["静音"] = $v[1] == 1 ? '开启静音' : '关闭静音';
       $v = unpack('f*', substr($memData, 4 + 2*17 +4*17 , 4 * 4));
       $dataArray["A相电压（v）"] = number_format($v[1],1);
       $dataArray["B相电压（v）"] = number_format($v[2],1);
       $dataArray["C相电压（v）"] = number_format($v[3],1);
       $dataArray["市电频率（Hz）"] = number_format($v[4],1);
       $v = unpack('S*', substr($memData, 4 + 2*17 +4*21 , 2 * 2));
       $dataArray["电源错相"] = $v[1] == 1 ? '相序错误' : '相序正确';
       $dataArray["解除告警"] = $v[2] == 0 ? '告警保持当前状态' : '执行解除当前告警';
       $v = unpack('v', substr($memData, 4 + 2*17 +4*21 + 2 * 2, 2));
       $year = $v[1];
       $v = unpack('C*', substr($memData,  4 + 2*17 +4*21 + 2 * 2 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}
