<?php
function GetHvdcBatteryFault($value){
    $faultArr = array();
    $fault = decbin($value);
    for($i = strlen($fault);$i<16;$i++){
        $fault = '0'.$fault;
    }
    for($i = 0;$i<16;$i++){
        if(substr($fault,15-$i,1) == '1'){
            array_push($faultArr,'1');
        }else{
            array_push($faultArr,'0');
        }
    }
    return $faultArr;
}

function Get_scwchiller_standard_Variable($dataArray, $varname){

    switch ($varname){
        case "冷冻水进水温度":
            return array(0,$dataArray["总循环水进水温度（℃）"]."℃");
        case "冷冻水出水温度":
            return array(0,$dataArray["总循环水出水温度（℃）"]."℃");
        case "1#排气压力":
            return array(0,$dataArray["1#排气压力（Kpa）"]."Kpa");
        case "1#吸气压力":
            return array(0,$dataArray["1#吸气压力（Kpa）"]."Kpa");
        case "2#排气压力":
            return array(0,$dataArray["2#排气压力（Kpa）"]."Kpa");
        case "2#吸气压力":
            return array(0,$dataArray["2#吸气压力（Kpa）"]."Kpa");
    }
}

function Get_scwchiller_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('S*', substr($memData, 4, 2*6));
        $MBH1AlmChlr_1 = GetHvdcBatteryFault($v[1]);
        $MBH1AlmChlr_1_Names_Arr = [
            "冷冻总进水温度传感器故障",
            "冷冻总出水温度传感器故障",
            "冷却总进水温度传感器故障",
            "冷却总出水温度传感器故障",
            "环境温度传感器故障",
            "控制器内部通讯故障",
            "防冻报警",
            "出水温度过低报警",
            "冷冻水缺水报警",
            "冷却水缺水报警/乙二醇缺水报警",
            "冷冻泵过载",
            "冷却泵过载",  
            "冷却塔风机过载",
            "外部故障报警",
            "无可用压缩机警告",
            "冷水温度下降过快报警"
        ];
        foreach ($MBH1AlmChlr_1_Names_Arr as $k => $name) {
            $dataArray[$name] = $MBH1AlmChlr_1[$k] === 1 ? "是" : "否";
        }
        $dataArray["制冷机系统综合故障"] = GetHvdcBatteryFault($v[2])[0] === 1 ? "是" : "否";
        $circut_1_MBH3AlmCrct1_1 = GetHvdcBatteryFault($v[3]);
        $circut_1_MBH4AlmCrct1_2 = GetHvdcBatteryFault($v[4]);
        $circut_2_MBH5AlmCrct2_1 = GetHvdcBatteryFault($v[5]);
        $circut_2_MBH6AlmCrct2_2 = GetHvdcBatteryFault($v[6]);

        $MBHAlm_names_Arr = [
            "模块出水温度传感器故障",
            "模块出水温度过低报警",
            "压机吸气压力传感器故障",
            "压机排气压力传感器故障",
            "压机经济器压力传感器故障",
            "压机吸气温度传感器故障",
            "压机排气温度传感器故障",
            "压机经济器温度传感器故障",
            "压机电源保护故障",
            "压机电子保护故障",
            "压机过载保护故障",
            "压机低压开关报警",
            "压机高压开关报警",
            "压机油位保护报警",
            "压机油压差保护报警",
            "风机组故障报警",
            "压机吸气压力过低预警",
            "压机吸气压力过低报警",
            "压机排气压力过高预警",
            "压机排气压力过高报警",
            "压机吸气温度过低预警",
            "压机吸气温度过低报警",
            "压机排气温度过高预警",
            "压机排气温度过高报警",
            "压机过热度较低预警",
            "压机过热度过低报警",
            "压机高低压差低报警",
            "主供液阀故障报警",
            "副供液阀故障报警",
            "冷冻水缺水报警",
            "冷却水缺水报警"
        ];
        for($i = 0;$i < 31;$i++) {
            if ($i < 16) {
                $dataArray["1#".$MBHAlm_names_Arr[$i]] = $circut_1_MBH3AlmCrct1_1[$i] === 1 ? "是" : "否";
                $dataArray["2#".$MBHAlm_names_Arr[$i]] = $circut_1_MBH3AlmCrct1_2[$i] === 1 ? "是" : "否";
            } else {
                $dataArray["1#".$MBHAlm_names_Arr[$i]] = $circut_2_MBH5AlmCrct2_1[$i] === 1 ? "是" : "否";
                $dataArray["2#".$MBHAlm_names_Arr[$i]] = $circut_2_MBH5AlmCrct2_2[$i] === 1 ? "是" : "否";
            }
        }
        $v = unpack('s*', substr($memData, 16, 2*7));
        $freezeWaterOutTempSetup = $v[1] / 10;
        $startTempDiffSetupPoint = $v[2] / 10;
        $stopTempDiffSetupPoint = $v[3] / 10;
        $dataArray["总三通阀开度"] = $v[4];
        $dataArray["外界环境温度（℃）"] = $v[5] / 10;
        $dataArray["总循环水进水温度（℃）"] = $v[6] / 10;
        $dataArray["总循环水出水温度（℃）"] = $v[7] / 10;
        $v = unpack('s*', substr($memData, 30, 2*2));
        $systemDIStatus = GetHvdcBatteryFault($v[1]);
        $dataArray["冷冻水流开关"] = $systemDIStatus[2] === 0 ? "关" : "开";
        $dataArray["冷却水流开关/乙二醇水流开关"] = $systemDIStatus[3] === 0 ? "关" : "开";
        $dataArray["远程启动信号"] = $systemDIStatus[5] === 0 ? "关" : "开";
        $dataArray["远程停止信号"] = $systemDIStatus[6] === 0 ? "关" : "开";
        $systemDOStatus = GetHvdcBatteryFault($v[2]);
        $dataArray["冷冻泵控制"] = $systemDOStaus[2] === 0 ? "关" : "开";
        $dataArray["冷却泵控制/乙二醇泵控制"] = $systemDOStaus[4] === 0 ? "关" : "开";
        $dataArray["冷却塔风扇"] = $systemDOStaus[6] === 0 ? "关" : "开";
        $dataArray["轮机故障报警指示"] = $systemDOStaus[7] === 0 ? "正常" : "故障";
        $dataArray["冷机运行"] = $systemDOStaus[8] === 0 ? "否" : "是";
        $dataArray["冷机停机"] = $systemDOStaus[9] === 0 ? "否" : "是";
        $dataArray["就地/远程模式"] = $systemDOStaus[10] === 0 ? "就地" : "远程";
        $dataArray["压缩机模式开启"] = $systemDOStaus[11] === 0 ? "关" : "开";
        $dataArray["自然冷源模式开启"] = $systemDOStaus[12] === 0 ? "关" : "开";
        $v = unpack('s*', substr($memData, 34, 2*11));
        $dataArray["1#模块出水温度（℃）"] = $v[1] / 10;
        $dataArray["1#排气温度（℃）"] = $v[2] / 10;
        // $economyDeviceTemp = $v[3] / 10;
        $dataArray["1#吸气温度（℃）"] = $v[4] / 10;
        $dataArray["1#吸气压力（Kpa）"] = $v[5] / 10;
        $dataArray["1#排气压力（Kpa）"] = $v[6] / 10;
        // $economyDevicePressure = $v[7] / 10;
        $dataArray["1#模块三通阀输出信号"] = $v[8] / 10;
        $dataArray["1#变频风机控制信号"] = $v[9] / 10;
        $dataArray["1#蒸发器液位"] = $v[10] / 10;
        $dataArray["1#主供液阀开度（%）"] = $v[11];
        $v = unpack('s*', substr($memData, 56, 2*4));
        $dataArray["1#经济器阀开度"] = $v[1] / 10;
        //$roomDevObj->rsv = $v[2];保留
        $dataArray["1#压机能量状态（%）"] = $v[3];
        $dataArray["1#压机运行电流（A）"] = $v[4];
        $v = unpack('s*', substr($memData, 64, 2*3));
        $dataArray["1#排气过热度（℃）"] = $v[1] / 10;
        $dataArray["1#吸气过热度（℃）"] = $v[2] / 10;
        $dataArray["1#当前目标过热度（℃）"] = $v[3] / 10;
        $v = unpack('S*', substr($memData, 70, 2*3));
        $dataArray["1#压机累计运行时间（h）"] = $v[1];
        $Circuit1DI = GetHvdcBatteryFault($v[2]);
        $Circuit1DO = GetHvdcBatteryFault($v[3]);
        $v = unpack('s*', substr($memData, 76, 2*9));



        $dataArray["2#模块出水温度（℃）"] = $v[1] / 10;
        $dataArray["2#排气温度（℃）"] = $v[2] / 10;
        // $economyDeviceTemp2 = $v[3] / 10;
        $dataArray["2#吸气温度（℃）"] = $v[4] / 10;
        $dataArray["2#吸气压力（Kpa）"] = $v[5] / 10;
        $dataArray["2#排气压力（Kpa）"] = $v[6] / 10;
        // $economyDevicePressure2 = $v[7] / 10;
        $dataArray["2#模块三通阀输出信号"] = $v[8] / 10;
        $dataArray["2#变频风机控制信号"] = $v[9] / 10;
        $v = unpack('s*', substr($memData, 94, 2*12));
        $dataArray["2#蒸发器液位"] = $v[1] / 10;
        $dataArray["2#主供液阀开度（%）"] = $v[2];
        $dataArray["2#经济器阀开度"] = $v[3] / 10;
        //$roomDevObj->rsv = $v[4];保留
        $dataArray["2#压机能量状态（%）"] = $v[5];
        $dataArray["2#压机运行电流（A）"] = $v[6];
        $dataArray["2#排气过热度（℃）"] = $v[7] / 10;
        $dataArray["2#吸气过热度（℃）"] = $v[8] / 10;
        $dataArray["2#当前目标过热度（℃）"] = $v[9] / 10;
        $dataArray["2#压机累计运行时间（h）"] = $v[10];
        $Circuit2DI = GetHvdcBatteryFault($v[11]);
        $Circuit2DO = GetHvdcBatteryFault($v[12]);

        $Circuit_Name_Arr = [
            "电源保护",
            "压机电子保护",
            "压机过载保护",
            "压机油压差保护",
            "压机油位保护",
            "压机高压保护",
            "压机低压保护",
            "模块循环水流开关保护",
            "风机变频器故障",
            "1#风机组过载",
            "2#风机组过载",
            "压机角型启动",
            "压机星型启动",
            "SV1能调阀",
            "SV2能调阀",
            "SV3能调阀",
            "喷液阀",
            "1#风机组启动（AC）",
            "2#风机组启动（AC）",
            "SV4间歇调节阀",
            "模块故障报警蜂鸣"
        ];

        for($i = 0;$i <21;$i++) {
            if ($i < 11) {
                $dataArray["1#".$Circuit_Name_Arr[$i]] = $Circuit1DI[$i] === 0 ? "断开" : "闭合";
                $dataArray["2#".$Circuit_Name_Arr[$i]] = $Circuit2DI[$i] === 0 ? "断开" : "闭合";
            } else {
                $dataArray["1#".$Circuit_Name_Arr[$i]] = $Circuit1DO[$i] === 0 ? "断开" : "闭合";
                $dataArray["2#".$Circuit_Name_Arr[$i]] = $Circuit2DO[$i] === 0 ? "断开" : "闭合";
            }
        }


        $v = unpack('v', substr($memData,  94 + 2*12, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 94 + 2*12 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

