<?php
function Get_sdc_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['室内温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    


function Get_sdc_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['无数据'] = true;
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //模拟量
        $v = unpack('s*',substr($memData,4,2*2));
        $dataArray['室内温度'] = number_format($v[1]/10, 2).' ℃';
        $dataArray['室内湿度'] = number_format($v[2]/10, 2).' %';

        $v = unpack('S*',substr($memData,4 + 2*2, 5*2));
        $dataArray['A相电压'] = ($v[1]/10).' V';
        $dataArray['B相电压'] = ($v[2]/10).' V';
        $dataArray['C相电压'] = ($v[3]/10).' V';
        $dataArray['加湿器电流'] = ($v[4]/10).' A';
        $dataArray['电源频率'] = ($v[5]/10).' Hz';

        $v = unpack('s*',substr($memData,4 + 2*2 + 5*2, 4*2));
        $dataArray['温度1'] = ($v[1]/10).' ℃';
        $dataArray['温度2'] = ($v[2]/10).' ℃';
        $dataArray['温度3'] = ($v[3]/10).' ℃';
        $dataArray['温度4'] = ($v[4]/10).' ℃';

        $v = unpack('S*',substr($memData,4 + 2*2 + 5*2 + 4*2, 4*2));
        $dataArray['模拟量1'] = ($v[1]/10).' mA';
        $dataArray['模拟量2'] = ($v[2]/10).' mA';
        $dataArray['模拟量3'] = ($v[3]/10).' mA';
        $dataArray['模拟量4'] = ($v[4]/10).' mA';

        //空调开关
        $v = unpack('c*', substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2, 19));
        $dataArray['高压开关1'] = $v[1] == 0 ? '关' : '开';
        $dataArray['高压开关2'] = $v[2] == 0 ? '关' : '开';
        $dataArray['低压开关1'] = $v[3] == 0 ? '关' : '开';
        $dataArray['低压开关2'] = $v[4] == 0 ? '关' : '开';
        $dataArray['排气温度开关1'] = $v[5] == 0 ? '关' : '开';
        $dataArray['排气温度开关2'] = $v[6] == 0 ? '关' : '开';
        $dataArray['过滤网开关'] = $v[7] == 0 ? '关' : '开';
        $dataArray['地板溢水开关'] = $v[8] == 0 ? '关' : '开';
        $dataArray['风机过载开关1'] = $v[9] == 0 ? '关' : '开';
        $dataArray['风机过载开关2'] = $v[10] == 0 ? '关' : '开';
        $dataArray['风机过载开关3'] = $v[11] == 0 ? '关' : '开';
        $dataArray['气流不足开关'] = $v[12] == 0 ? '关' : '开';
        $dataArray['自定义开关1'] = $v[13] == 0 ? '关' : '开';
        $dataArray['自定义开关2'] = $v[14] == 0 ? '关' : '开';
        $dataArray['自定义开关3'] = $v[15] == 0 ? '关' : '开';
        $dataArray['自定义开关4'] = $v[16] == 0 ? '关' : '开';
        $dataArray['CM+水位探头'] = $v[17] == 0 ? '关' : '开';
        $dataArray['远程关机'] = $v[18] == 0 ? '关' : '开';
        $dataArray['加湿器告警'] = $v[19] == 0 ? '关' : '开';

        //系统参数
        $v = unpack('s*',substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2 + 19, 6*2));
        $dataArray['温度设定点'] = ($v[1] / 10).' ℃';
        $dataArray['湿度设定点'] = ($v[2] / 10).' %';
        $dataArray['温度偏差'] = ($v[3] / 10).' ℃';
        $dataArray['湿度偏差'] = ($v[4] / 10).' %';
        $dataArray['温度死区'] = ($v[5] / 10).' ℃';
        $dataArray['湿度死区'] = ($v[6] / 10).' %';

        //机组状态
        $v = unpack('c*', substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2 + 19 + 6*2, 13));
        switch($v[1]){
            case 0:
                $dataArray['空调开关机状态'] = '运行';
                break;
            case 1:
                $dataArray['空调开关机状态'] = '待机';
                break;
            case 2:
                $dataArray['空调开关机状态'] = '关机';
                break;
            case 3:
                $dataArray['空调开关机状态'] = '远程关机';
                break;
            default:    
                $dataArray['空调开关机状态'] = '无效';
        }
        $dataArray['风机输出开关状态'] = $v[2] == 0 ? '关' : '开';
        $dataArray['加湿器输出开关状态'] = $v[3] == 0 ? '关' : '开';
        $dataArray['压缩机1输出开关状态'] = $v[4] == 0 ? '关' : '开';
        $dataArray['压缩机2输出开关状态'] = $v[5] == 0 ? '关' : '开';
        $dataArray['加热器1输出开关状态'] = $v[6] == 0 ? '关' : '开';
        $dataArray['加热器2输出开关状态'] = $v[7] == 0 ? '关' : '开';
        $dataArray['公共报警输出开关状态'] = $v[8] == 0 ? '关' : '开';
        $dataArray['液路旁通1输出开关状态'] = $v[9] == 0 ? '关' : '开';
        $dataArray['液路旁通2输出开关状态'] = $v[10] == 0 ? '关' : '开';
        $dataArray['注水输出开关状态'] = $v[11] == 0 ? '关' : '开';
        $dataArray['除湿输出开关状态'] = $v[12] == 0 ? '关' : '开';
        //13 备用
       
        //机组运行模式和报警状态
        $v = unpack('c*', substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2 + 19 + 6*2 + 13, 10));
        if($v[1] & 0x1){
            $dataArray['空调运行模式'] = '单机';
        }else if(($v[1] >> 1) & 0x1){
            $dataArray['空调运行模式'] = '群控0模式';
        }else if(($v[1] >> 2) & 0x1){
            $dataArray['空调运行模式'] = '群控1模式';
        }else if(($v[1] >> 3) & 0x1){
            $dataArray['空调运行模式'] = '群控2模式';
        }else if(($v[1] >> 4) & 0x1){
            $dataArray['空调运行模式'] = '群控3模式';
        }else{
            $dataArray['空调运行模式'] = '其他模式';
        }
        //2.0保留
        $dataArray['高压1报警'] = ($v[2] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高压2报警'] = ($v[2] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压1报警'] = ($v[2] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压2报警'] = ($v[2] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气温度1报警'] = ($v[2] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气温度2报警'] = ($v[2] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['盘管冻结1报警'] = ($v[2] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['盘管冻结2报警'] = $v[3] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机过载1报警'] = ($v[3] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机过载2报警'] = ($v[3] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机过载3报警'] = ($v[3] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['短周期1报警'] = ($v[3] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['短周期2报警'] = ($v[3] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高温报警'] = ($v[3] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低温报警'] = ($v[3] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['高湿报警'] = $v[4] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低湿报警'] = ($v[4] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['红外加湿器故障告警'] = ($v[4] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['卡乐加湿器故障告警'] = ($v[4] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['加湿器低水位故障报警'] = ($v[4] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['气流丢失报警'] = ($v[4] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['过滤网堵报警'] = ($v[4] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['远程关机报警'] = ($v[4] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['温湿度检测板故障报警'] = $v[5] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['烟感传感器报警'] = ($v[5] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['火警传感器报警'] = ($v[5] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义1报警'] = ($v[5] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['自定义2报警'] = ($v[5] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['风机运行超时报警'] = ($v[5] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机1运行超时报警'] = ($v[5] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['压缩机2运行超时报警'] = ($v[5] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['加热器1运行超时报警'] = $v[6] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['加热器2运行超时报警'] = ($v[6] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['加湿器运行超时报警'] = ($v[6] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源丢失报警'] = ($v[6] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源过压报警'] = ($v[6] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源欠压报警'] = ($v[6] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源频偏报警'] = ($v[6] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['电源缺相报警'] = ($v[6] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['电源反相报警'] = $v[7] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['地板溢水报警'] = ($v[7] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['NTC1故障报警'] = ($v[7] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['NTC2故障报警'] = ($v[7] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['NTC3故障报警'] = ($v[7] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['NTC4故障报警'] = ($v[7] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#0机组组网故障报警'] = ($v[7] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#1机组组网故障报警'] = ($v[7] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['#2机组组网故障报警'] = $v[8] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#3机组组网故障报警'] = ($v[8] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#4机组组网故障报警'] = ($v[8] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#5机组组网故障报警'] = ($v[8] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#6机组组网故障报警'] = ($v[8] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#7机组组网故障报警'] = ($v[8] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#8机组组网故障报警'] = ($v[8] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#9机组组网故障报警'] = ($v[8] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['#10机组组网故障报警'] = $v[9] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#11机组组网故障报警'] = ($v[9] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#12机组组网故障报警'] = ($v[9] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#13机组组网故障报警'] = ($v[9] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#14机组组网故障报警'] = ($v[9] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['#15机组组网故障报警'] = ($v[9] >> 5) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高压1锁定报警'] = ($v[9] >> 6) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['高压2锁定报警'] = ($v[9] >> 7) & 0x1 == 1 ? '告警' : '正常';
        
        $dataArray['低压1锁定报警'] = $v[10] & 0x1 == 1 ? '告警' : '正常';
        $dataArray['低压2锁定报警'] = ($v[10] >> 1) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气温度1锁定报警'] = ($v[10] >> 2) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['排气温度2锁定报警'] = ($v[10] >> 3) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['盘管冻结1锁定报警'] = ($v[10] >> 4) & 0x1 == 1 ? '告警' : '正常';
        $dataArray['盘管冻结2锁定报警'] = ($v[10] >> 5) & 0x1 == 1 ? '告警' : '正常';
        /////
        $dataArray['AlertArray']['高压1报警'] = ($v[2] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['高压2报警'] = ($v[2] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['低压1报警'] = ($v[2] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['低压2报警'] = ($v[2] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['排气温度1报警'] = ($v[2] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['排气温度2报警'] = ($v[2] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['盘管冻结1报警'] = ($v[2] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['盘管冻结2报警'] = $v[3] & 0x1 == 1;
        $dataArray['AlertArray']['风机过载1报警'] = ($v[3] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['风机过载2报警'] = ($v[3] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['风机过载3报警'] = ($v[3] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['短周期1报警'] = ($v[3] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['短周期2报警'] = ($v[3] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['高温报警'] = ($v[3] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['低温报警'] = ($v[3] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['高湿报警'] = $v[4] & 0x1 == 1;
        $dataArray['AlertArray']['低湿报警'] = ($v[4] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['红外加湿器故障告警'] = ($v[4] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['卡乐加湿器故障告警'] = ($v[4] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['加湿器低水位故障报警'] = ($v[4] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['气流丢失报警'] = ($v[4] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['过滤网堵报警'] = ($v[4] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['远程关机报警'] = ($v[4] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['温湿度检测板故障报警'] = $v[5] & 0x1 == 1;
        $dataArray['AlertArray']['烟感传感器报警'] = ($v[5] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['火警传感器报警'] = ($v[5] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['自定义1报警'] = ($v[5] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['自定义2报警'] = ($v[5] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['风机运行超时报警'] = ($v[5] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机1运行超时报警'] = ($v[5] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['压缩机2运行超时报警'] = ($v[5] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['加热器1运行超时报警'] = $v[6] & 0x1 == 1;
        $dataArray['AlertArray']['加热器2运行超时报警'] = ($v[6] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['加湿器运行超时报警'] = ($v[6] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['电源丢失报警'] = ($v[6] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['电源过压报警'] = ($v[6] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['电源欠压报警'] = ($v[6] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['电源频偏报警'] = ($v[6] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['电源缺相报警'] = ($v[6] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['电源反相报警'] = $v[7] & 0x1 == 1;
        $dataArray['AlertArray']['地板溢水报警'] = ($v[7] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['NTC1故障报警'] = ($v[7] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['NTC2故障报警'] = ($v[7] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['NTC3故障报警'] = ($v[7] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['NTC4故障报警'] = ($v[7] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['#0机组组网故障报警'] = ($v[7] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['#1机组组网故障报警'] = ($v[7] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['#2机组组网故障报警'] = $v[8] & 0x1 == 1;
        $dataArray['AlertArray']['#3机组组网故障报警'] = ($v[8] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['#4机组组网故障报警'] = ($v[8] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['#5机组组网故障报警'] = ($v[8] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['#6机组组网故障报警'] = ($v[8] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['#7机组组网故障报警'] = ($v[8] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['#8机组组网故障报警'] = ($v[8] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['#9机组组网故障报警'] = ($v[8] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['#10机组组网故障报警'] = $v[9] & 0x1 == 1;
        $dataArray['AlertArray']['#11机组组网故障报警'] = ($v[9] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['#12机组组网故障报警'] = ($v[9] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['#13机组组网故障报警'] = ($v[9] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['#14机组组网故障报警'] = ($v[9] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['#15机组组网故障报警'] = ($v[9] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['高压1锁定报警'] = ($v[9] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['高压2锁定报警'] = ($v[9] >> 7) & 0x1 == 1;
        
        $dataArray['AlertArray']['低压1锁定报警'] = $v[10] & 0x1 == 1;
        $dataArray['AlertArray']['低压2锁定报警'] = ($v[10] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['排气温度1锁定报警'] = ($v[10] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['排气温度2锁定报警'] = ($v[10] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['盘管冻结1锁定报警'] = ($v[10] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['盘管冻结2锁定报警'] = ($v[10] >> 5) & 0x1 == 1;
        $v = unpack('v',substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2 + 19 + 6*2 + 23, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*2 + 5*2 + 4*2 + 4*2 + 19 + 6*2 + 23 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
