<?php


function Get_shendian_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['无数据'] = true;
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //模拟量
        $v = unpack('S*',substr($memData,4,2*37));
        $ct = $v[34];
        $pt = $v[35];
        $dataArray["CT"] = $ct;
        $dataArray["PT"] = $pt;

        $dataArray["频率"] = number_format($v[2]/10, 1)."Hz";
        $dataArray["A相电压"] = number_format($v[3]*$pt/100, 2)."V";
        $dataArray["B相电压"] = number_format($v[4]*$pt/100, 2)."V";
        $dataArray["C相电压"] = number_format($v[5]*$pt/100, 2)."V";

        $dataArray["A相电流"] = number_format($v[6]*$ct/10000, 2)."A";
        $dataArray["B相电流"] = number_format($v[7]*$ct/10000, 2)."A";
        $dataArray["C相电流"] = number_format($v[8]*$ct/10000, 2)."A";
        $dataArray["零线电流"] = number_format($v[9]*$ct/10000, 2)."A";


        $c = unpack('C*', substr($memData,4 + 2*9,2*4));
        //高位1,为负值
        $dataArray["A相功率因素"] = number_format( ( ($c[2] & 0x80) ? ( 0 - ((($c[2]&0x7) << 8) + $c[1]) ) : ((($c[2]&0x7) << 8) + $c[1]) )/1000, 2);
        $dataArray["B相功率因素"] = number_format( ( ($c[4] & 0x80) ? ( 0 - ((($c[4]&0x7) << 8) + $c[3]) ) : ((($c[4]&0x7) << 8) + $c[3]) )/1000, 2);
        $dataArray["C相功率因素"] = number_format( ( ($c[6] & 0x80) ? ( 0 - ((($c[6]&0x7) << 8) + $c[5]) ) : ((($c[6]&0x7) << 8) + $c[5]) )/1000, 2);
        $dataArray["总功率因素"] = number_format( ( ($c[8] & 0x80) ? ( 0 - ((($c[8]&0x7) << 8) + $c[7]) ) : ((($c[8]&0x7) << 8) + $c[7]) )/1000, 2);

        $dataArray["A相有功功率"] = number_format($v[14]*$ct*$pt/10000, 2)."KW";
        $dataArray["B相有功功率"] = number_format($v[15]*$ct*$pt/10000, 2)."KW";
        $dataArray["C相有功功率"] = number_format($v[16]*$ct*$pt/10000, 2)."KW";
        $dataArray["总有功功率"] = number_format($v[17]*$ct*$pt/10000, 2)."KW";

        //高位1,为负值
        $c = unpack('C*', substr($memData,4 + 2*17,2*4));
        $dataArray["A相无功功率"] = number_format( ( ($c[2] & 0x80) ? ( 0 - ((($c[2]&0x7) << 8) + $c[1]) ) : ((($c[2]&0x7) << 8) + $c[1]) ) *$ct*$pt/10000, 2)."Kvar";
        $dataArray["B相无功功率"] = number_format( ( ($c[4] & 0x80) ? ( 0 - ((($c[4]&0x7) << 8) + $c[3]) ) : ((($c[4]&0x7) << 8) + $c[3]) ) *$ct*$pt/10000, 2)."Kvar";
        $dataArray["C相无功功率"] = number_format( ( ($c[6] & 0x80) ? ( 0 - ((($c[6]&0x7) << 8) + $c[5]) ) : ((($c[6]&0x7) << 8) + $c[5]) ) *$ct*$pt/10000, 2)."Kvar";
        $dataArray["总无功功率"] = number_format(  ( ($c[8] & 0x80) ? ( 0 - ((($c[8]&0x7) << 8) + $c[7]) ) : ((($c[8]&0x7) << 8) + $c[7]) ) *$ct*$pt/10000, 2)."Kvar";

        $dataArray["A相视在功率"] = number_format($v[22]*$ct*$pt/10000, 2)."KVA";
        $dataArray["B相视在功率"] = number_format($v[23]*$ct*$pt/10000, 2)."KVA";
        $dataArray["C相视在功率"] = number_format($v[24]*$ct*$pt/10000, 2)."KVA";
        $dataArray["总视在功率"] = number_format($v[25]*$ct*$pt/10000, 2)."KVA";


        $dataArray["正向有功电能"] = number_format(  ( ($v[26] << 16) + $v[27]) /3200, 2)."Kwh";
        $dataArray["反向有功电能"] = number_format(  ( ($v[28] << 16) + $v[29]) /3200, 2)."Kwh";
        $dataArray["正向无功电能"] = number_format(  ( ($v[30] << 16) + $v[31]) *$ct*$pt/3200, 2)."Kvarh";
        $dataArray["反向无功电能"] = number_format(  ( ($v[32] << 16) + $v[33]) *$ct*$pt/3200, 2)."Kvarh";


        $v = unpack('v',substr($memData, 4 + 2*37, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*37 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }

}
