<?php
 
function checkAlarmType($alarmTypeValue){
    switch($alarmTypeValue){
        case 0: return 'A相功率因数';
        case 1: return 'B相功率因数';
        case 2: return 'C相功率因数';
        case 3: return '总相功率因数';
        case 6: return '频率';
        case 7: return 'A相电压';
        case 8: return 'B相电压';
        case 9: return 'C相电压';
        case 11: return 'AB相电压';
        case 12: return 'BC相电压';
        case 13: return 'CA相电压';
        case 15: return 'A相电流';
        case 16: return 'B相电流';
        case 17: return 'C相电流';
        case 20: return 'A相有功功率';
        case 21: return 'B相有功功率';
        case 22: return 'C相有功功率';
        case 23: return '总相有功功率';
        case 24: return 'A相无功功率';
        case 25: return 'B相无功功率';
        case 26: return 'C相无功功率';
        case 27: return '总相无功功率';
        case 28: return 'A相视在功率';
        case 29: return 'B相视在功率';
        case 30: return 'C相视在功率';
        case 31: return '总相视在功率';
    }
    return '报警功能关闭';
}

function Get_sicam_p35_Active_Power($dataArray){
    $active_power = ($dataArray['总正向有功电能(Wh)'] / 1000) + ($dataArray['总反向有功电能(Wh)'] / 1000) ;
    return array(0 , $active_power);
}

function Get_sicam_p35_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['AB线电压(V)']);
        case '[B相电压]':
            return array(0, $dataArray['BC线电压(V)']);
        case '[C相电压]':
            return array(0, $dataArray['CA线电压(V)']);
        case '[总功率]':
            return array(0, $dataArray["总有功功率2"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_sicam_p35_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData) ){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        //SICAM_P35_REG_0_5_t
        $v = unpack('S*', substr($memData, 4, 2*2));
        $dataArray["地址"] = $v[1];
        $dataArray["波特率(bps)"] = $v[2];
        $v = unpack('f*', substr($memData, 4 + 2*2 , 4*2));
        $PT = $v[1];
        $CT = $v[2];
        $dataArray["电压变比"] = $v[1] == 0 ? "10000" : $v[1];
        $dataArray["电流变比"] = $v[2] == 0 ? "10000" : $v[2];
        //SICAM_P35_100_106_t
        $v = unpack('C*', substr($memData, 4 + 2*2 + 4*2 , 1*4));
        $dataArray["输入口1开关状态"] = $v[1] == 1 ? "闭合" : "断开";
        $dataArray["输入口2开关状态"] = $v[2] == 1 ? "闭合" : "断开";
        $dataArray["输入口3开关状态"] = $v[3] == 1 ? "闭合" : "断开";
        $dataArray["输入口4开关状态"] = $v[4] == 1 ? "闭合" : "断开";
        $v = unpack('C*', substr($memData, 4 + 2*2 + 4*2 + 1*4, 1*2));
        $dataArray["继电器输出口1状态"] = $v[1] == 1 ? "闭合" : "断开";
        $dataArray["继电器输出口2状态"] = $v[2] == 1 ? "闭合" : "断开";
        $v = unpack('S*', substr($memData, 4 + 2*2 + 4*2 + 1*6, 2*1));
        
        switch ($v[1]) {
            case 0:
                $dataArray["报警方式控制"] = "报警功能关闭";
                break;
            case 1:
                $dataArray["报警方式控制"] = "输出口1报警";
                break;
            case 2:
                $dataArray["报警方式控制"] = "输出口2报警";
                break;
            case 3:
                $dataArray["报警方式控制"] = "输出口1、2均报警";
                break;
            default:
                $dataArray["报警方式控制"] = "无效";
                break;
        }

        $v = unpack('C*', substr($memData, 4 + 2*3 + 4*2 + 1*6, 1*6));
        $alarmStatus = $v;
        //SICAM_P35_110_12D_t
        for($i = 0 ; $i < 6 ; $i++){
            $j = $i + 1; 
            $dataArray["告警器{$j}-告警状态"] = $alarmStatus[$j] == 1 ? "告警" : "正常";
            $alarmData = substr($memData , 4 + 2*3 + 4*2 + 1*12 + $i*10, 10);
            $v = unpack('S*', substr($alarmData , 0 , 2));
            $dataArray["告警器{$j}-越限数据类型"] = checkAlarmType($v[1]);
            $v = unpack('f*', substr($alarmData , 2 , 4));
            $dataArray["告警器{$j}-越限阈值"] = $v[1];
            $v = unpack('S*', substr($alarmData , 6 , 4));
            $dataArray["告警器{$j}-检测类型"] = $v[1] == 0 ? "大于" : $v[1] == 1 ? "小于" : "无效";
            switch ($v[2]) {
                case 0:
                    $dataArray["告警器{$j}-报警端口"] = "关闭";
                    break;
                case 1:
                    $dataArray["告警器{$j}-报警端口"] = "报警输出至输出口1";
                    break;
                case 2:
                    $dataArray["告警器{$j}-报警端口"] = "报警输出至输出口2";
                    break;
                case 3:
                    $dataArray["告警器{$j}-报警端口"] = "报警输出至输出口1和2";
                    break;
                default:
                    $dataArray["告警器{$j}-报警端口"] = "无效";
                    break;
            }            
        }
        //SICAM_P35_REG_134_t
        $v = unpack('S*', substr($memData, 4 + 2*3 + 4*2 + 1*12 + 60, 2*1));
        switch ($v[1]) {
            case 0:
                $dataArray["电压规格"] = "三相三线  100V";
                break;
            case 1:
                $dataArray["电压规格"] = "三线四线  220V";
                break;
            case 2:
                $dataArray["电压规格"] = "三相四线  57.7V";
                break;
            case 3:
                $dataArray["电压规格"] = "三相三线  380V";
                break;
            default:
                $dataArray["电压规格"] = "无效";
                break;
        }
        //SICAM_P35_REG_1000_101D_t
        $v = unpack('f*', substr($memData, 4 + 2*4 + 4*2 + 1*12 + 60, 4*13));
        $dataArray["A相电压(V)"] = number_format($v[1],2);
        $dataArray["B相电压(V)"] = number_format($v[2],2);
        $dataArray["C相电压(V)"] = number_format($v[3],2);
        $dataArray["平均相电压(V)"] = number_format($v[4],2);
        $dataArray["AB线电压(V)"] = number_format($v[5],2);
        $dataArray["BC线电压(V)"] = number_format($v[6],2);
        $dataArray["CA线电压(V)"] = number_format($v[7],2);
        $dataArray["平均线电压(V)"] = number_format($v[8],2);
        $dataArray["A相电流(A)"] = number_format($v[9],2);
        $dataArray["B相电流(A)"] = number_format($v[10],2);
        $dataArray["C相电流(A)"] = number_format($v[11],2);
        $dataArray["平均电流(A)"] = number_format($v[12],2);
        $dataArray["零线电流(A)"] = number_format($v[13],2);
        $v = unpack('s*', substr($memData, 4 + 2*4 + 4*15 + 1*12 + 60, 2*12));
        $dataArray["A相有功功率(W)"] = $v[1] * $CT;
        $dataArray["B相有功功率(W)"] = $v[2] * $CT;
        $dataArray["C相有功功率(W)"] = $v[3] * $CT;
        $dataArray["总有功功率(W)"] = $v[4] * $CT;
        $dataArray["总有功功率2"] = $v[4] * $CT / 1000;
        $dataArray["A相无功功率(var)"] = $v[5] * $CT;
        $dataArray["B相无功功率(var)"] = $v[6] * $CT;
        $dataArray["C相无功功率(var)"] = $v[7] * $CT;
        $dataArray["总无功功率(var)"] = $v[8] * $CT;
        $dataArray["A相视在功率(VA)"] = $v[9] * $CT;
        $dataArray["B相视在功率(VA)"] = $v[10] * $CT;
        $dataArray["C相视在功率(VA)"] = $v[11] * $CT;
        $dataArray["总视在功率(VA)"] = $v[12] * $CT;
        $v = unpack('f*', substr($memData, 4 + 2*16 + 4*15 + 1*12 + 60, 4*5));
        $dataArray["A相功率因数"] = number_format($v[1],2);
        $dataArray["B相功率因数"] = number_format($v[2],2);
        $dataArray["C相功率因数"] = number_format($v[3],2);
        $dataArray["总功率因数"] = number_format($v[4],2);
        $dataArray["频率(Hz)"] = number_format($v[5],2);
        //SICAM_P35_REG_2000_200F_t
        $v = unpack('f*', substr($memData, 4 + 2*16 + 4*20 + 1*12 + 60, 4*8));
        $dataArray["A相正向有功电能(Wh)"] = number_format($v[1] * $CT,2);
        $dataArray["B相正向有功电能(Wh)"] = number_format($v[2] * $CT,2);
        $dataArray["C相正向有功电能(Wh)"] = number_format($v[3] * $CT,2);
        $dataArray["总正向有功电能(Wh)"] = number_format($v[4] * $CT , 2 , '.' , '');
        $dataArray["A相正向无功电能(varh)"] = number_format($v[5] * $CT,2);
        $dataArray["B相正向无功电能(varh)"] = number_format($v[6] * $CT,2);
        $dataArray["C相正向无功电能(varh)"] = number_format($v[7] * $CT,2);
        $dataArray["总正向无功电能(varh)"] = number_format($v[8] * $CT,2);
        //SICAM_P35_REG_2100_210E_t
        $v = unpack('f*', substr($memData, 4 + 2*16 + 4*28 + 1*12 + 60, 4*8));
        $dataArray["A相反向有功电能(Wh)"] = number_format($v[1] * $CT,2);
        $dataArray["B相反向有功电能(Wh)"] = number_format($v[2] * $CT,2);
        $dataArray["C相反向有功电能(Wh)"] = number_format($v[3] * $CT,2);
        $dataArray["总反向有功电能(Wh)"] = number_format($v[4] * $CT , 2 , '.' , '');
        $dataArray["A相反向无功电能(varh)"] = number_format($v[5] * $CT,2);
        $dataArray["B相反向无功电能(varh)"] = number_format($v[6] * $CT,2);
        $dataArray["C相反向无功电能(varh)"] = number_format($v[7] * $CT,2);
        $dataArray["总反向无功电能(varh)"] = number_format($v[8] * $CT,2);
        $v = unpack('v', substr($memData,  4 + 2*16 + 4*28 + 1*12 + 60 + 4*8, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*16 + 4*28 + 1*12 + 60 + 4*8 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
