<?php
function Get_smpdu_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2'] * 1.732);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

//设备类型
function Get_smpdu_UnicomCategory()
{
    return "427";//240v 直流配电
}


function Get_smpdu_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //DTSD3366D_REG_8_A_t
        $v = unpack("f*" , substr($memData , 4 , 4 * 6));
        $dataArray['A或B路正母排对保护地电压'] = number_format($v[1], 3);
        $dataArray['A或B路负母排对保护地电压'] = number_format($v[2], 3);
        $dataArray['A或B路正母排对保护地阻抗'] = number_format($v[3], 3);
        $dataArray['A或B路负母排对保护地阻抗'] = number_format($v[4], 3);
        $dataArray['A路母排电压'] = number_format($v[5], 3);
        $dataArray['A路负载总电流'] = number_format($v[6], 3);
        $v = unpack("C", substr($memData, 4 + 4*6, 1));
        $dataArray['A路分路电流数量N'] = $v[1];
        //$dataArray["A路分路电流"] = [];
        $v = unpack("f*" , substr($memData, 4 + 4*6 + 1, 4*60));
        for($i=1; $i <= $dataArray['A路分路电流数量N']; $i++)
        {
            $dataArray["A路分路电流{$i}"] = number_format($v[1], 3);
        }
        $v = unpack("f*" , substr($memData, 4 + 4*6 + 1 + 4*60, 4*2));
        $dataArray['B路母排电压'] = number_format($v[1], 3);
        $dataArray['B路负载总电流'] = number_format($v[2], 3);
        $v = unpack("C", substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2, 1));
        $dataArray['B路分路电流数量M'] = $v[1];
        //$dataArray["B路分路电流"] = [];
        $v = unpack("f*" , substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2 + 1, 4*60));
        for($i=1; $i <= $dataArray['B路分路电流数量M']; $i++)
        {
            $dataArray["B路分路电流{$i}"] = number_format($v[1], 3);
        }
        //status
        $v = unpack("C*", substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2 + 1 + 4*60, 5));
        $dataArray["工作模式"] = $v[1] == 0 ? "A/B同源" : "A/B不同源";
        switch($v[2])
        {
            case 0:
                $dataArray["绝缘功能模式"] = "无";
                break;
            case 1:
                $dataArray["绝缘功能模式"] = "电阻模式";
                break;
            case 2:
                $dataArray["绝缘功能模式"] = "电压模式";
                break;
        }
        $dataArray["是否主机"] = $v[3] == 0 ? "从机" : "主机";
        $dataArray["是否存在绝缘故障"] = $v[4] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["是否存在绝缘故障"] == $v[4];
        switch($v[5])
        {
            case 0:
                $dataArray["支路巡检控制状态"] = "空闲命令";
                break;
            case 0xF0:
                $dataArray["支路巡检控制状态"] = "启动单极正母线支路巡检";
                break;
            case 0xF1:
                $dataArray["支路巡检控制状态"] = "启动单极负母线支路巡检";
                break;
            case 0xF2:
                $dataArray["支路巡检控制状态"] = "启动双极正母线支路巡检";
                break;
            case 0xF3:
                $dataArray["支路巡检控制状态"] = "启动双极负母线支路巡检";
                break;
            case 0xF4:
                $dataArray["支路巡检控制状态"] = "故障消除，停止支路巡检";
                break;
            case 0xF5:
                $dataArray["支路巡检控制状态"] = "启动支路校准";
                break;
        }
        //告警
        $v = unpack("C*", substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2 + 1 + 4*60 + 5, 322));
        $dataArray["A或B母排对保护地绝缘故障"] = $v[1] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["A或B母排对保护地绝缘故障"] = $v[1];

        $dataArray["A路直流电压告警"] = $v[2] == 0 ? "正常" : ($v[2] == 1 ? "欠压" : "过压");
        $dataArray["AlertArray"]["A路直流电压告警"] = $v[2];

        $dataArray["A路负载熔丝数量"] = $v[3];
        $dataArray["A路熔丝断"] = $v[4] == 0 ? "正常" : ($v[4] == 3 ? "A路辅助熔丝断告警" : "电池支路1断");
        $dataArray["AlertArray"]["A路熔丝断"] = $v[4];

        for($i=1;$i<$dataArray["A路负载熔丝数量"];$i++)
        {
            $dataArray["A路负载熔丝{$i}断"] = $v[4 + $i] == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["A路负载熔丝{$i}断"] = $v[4 + $i];
        }
        $offset = 3 + $dataArray["A路负载熔丝数量"] + 1;
        $dataArray["A路绝缘检测数量"] = $v[$offset];
        for($i=1;$i<=$dataArray["A路绝缘检测数量"];$i++)
        {
            $dataArray["A路绝缘故障$i"] = $v[$offset + $i] == 0 ? "正常" : ($v[$offset + $i] == 1 ? "绝缘故障":"互感器故障");
            $dataArray["AlertArray"]["A路绝缘故障{$i}"] = $v[$offset + $i];
        }
        $offset += 1 + $dataArray["A路绝缘检测数量"];
        $dataArray["A路EGU数量"] = $v[$offset];
        for($i=1;$i<=$dataArray["A路EGU数量"];$i++)
        {
            $dataArray["A路EGU通讯故障$i"] = $v[$offset + $i] == 0 ? "正常" : "故障";
            $dataArray["AlertArray"]["A路EGU通讯故障{$i}"] = $v[$offset + $i];
        }
        $offset += 1 + $dataArray["A路EGU数量"];
        for($i=1;$i<=$dataArray["A路EGU数量"];$i++)
        {
            $dataArray["A路EGU故障$i"] = $v[$offset + $i] == 0 ? "正常" : "故障";
            $dataArray["AlertArray"]["A路EGU故障{$i}"] = $v[$offset + $i];
        }
        $offset += $dataArray["A路EGU数量"];
        $dataArray["A路输入总开关"] = $v[$offset] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["A路输入总开关"] = $v[$offset];

        //b路
        $offset++;

        $dataArray["B路直流电压告警"] = $v[$offset] == 0 ? "正常" : ($v[$offset] == 1 ? "欠压" : "过压");
        $dataArray["AlertArray"]["B路直流电压告警"] = $v[$offset];

        $dataArray["B路负载熔丝数量"] = $v[$offset+1];
        $dataArray["B路熔丝断"] = $v[$offset+2] == 0 ? "正常" : ($v[$offset+2] == 3 ? "B路辅助熔丝断告警" : "电池支路1断");
        $dataArray["AlertArray"]["B路熔丝断"] = $v[$offset+2];
        for($i=1;$i<$dataArray["B路负载熔丝数量"];$i++)
        {
            $dataArray["B路负载熔丝{$i}断"] = $v[$offset +2 + $i] == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["B路负载熔丝{$i}断"] = $v[$offset +2 + $i];
        }
        $offset += 2 + $dataArray["B路负载熔丝数量"];
        $dataArray["B路绝缘检测数量"] = $v[$offset];
        for($i=1;$i<=$dataArray["B路绝缘检测数量"];$i++)
        {
            $dataArray["B路绝缘故障$i"] = $v[$offset + $i] == 0 ? "正常" : ($v[$offset + $i] == 1 ? "绝缘故障":"互感器故障");
            $dataArray["AlertArray"]["B路绝缘故障{$i}"] = $v[$offset + $i];
        }
        $offset += 1 + $dataArray["B路绝缘检测数量"];
        $dataArray["B路EGU数量"] = $v[$offset];
        for($i=1;$i<=$dataArray["B路EGU数量"];$i++)
        {
            $dataArray["B路EGU通讯故障$i"] = $v[$offset + $i] == 0 ? "正常" : "故障";
            $dataArray["AlertArray"]["B路EGU通讯故障{$i}"] = $v[$offset + $i];
        }
        $offset += 1 + $dataArray["B路EGU数量"];
        for($i=1;$i<=$dataArray["B路EGU数量"];$i++)
        {
            $dataArray["B路EGU故障$i"] = $v[$offset + $i] == 0 ? "正常" : "故障";
            $dataArray["AlertArray"]["B路EGU故障{$i}"] = $v[$offset + $i];
        }
        $offset += $dataArray["B路EGU数量"];
        $dataArray["B路输入总开关"] = $v[$offset] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["B路输入总开关"] = $v[$offset];
        $offset++;
        $dataArray["监控故障"] = $v[$offset] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["监控故障"] = $v[$offset];
        $offset++;//jump p
        $offset++;
        $dataArray["A路绝缘电阻不平衡"] = $v[$offset] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["A路绝缘电阻不平衡"] = $v[$offset];
        $offset++;
        $dataArray["B路绝缘电阻不平衡"] = $v[$offset] == 0 ? "正常" : "故障";
        $dataArray["AlertArray"]["B路绝缘电阻不平衡"] = $v[$offset];
        $v = unpack('v', substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2 + 1 + 4*60 + 5 + 322 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 4*6 + 1 + 4*60 + 4*2 + 1 + 4*60 + 5 + 322 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
