<?php

function Get_smu06c_419_UnicomCategory()
{
    return "419";
}

function Get_smu06c_config()
{
    $config = array(
	"ac" => array(
                        "airlock" => 0, "p40_43" => 13, "p40_41" => 30, "p40_44" => 18,
                        "p40_41_label" => array("交流柜环境温度" => false, "交流柜环境湿度" => false, "A相相位角" => false, "B相相位角" => false, "C相相位角" => false, "功率因素" => false, "有功功率" => false, "无功功率" => false, "视在功率" => false, "电能能耗" => false, "市电电量" => false, "油机电量" => false),
                        "p40_43_label" => array("交流切换状态" => true, "事故照明灯状态" => false, "当前工作路号" => false),
                        "p40_43_rules" => array(0 => array(array(0x80 => "交流切换自动", 0x81 => "交流切换手动"), "无效状态"), 1 => array(array(0x82 => "照明开", 0x83 => "照明关"), "无效状态"), 2 => array(array(0x84 => "第一路", 0x85 => "第二路", 0x86 => "第三路", 0x87 => "无工作路号", 0x88 => "没有交流切换(输入)"), "无效状态")),
                        "p40_44_label" => array("交流防雷器断" => true, "交流屏通讯中断" => false, "交流输入空开跳" => false, "交流输出空开跳" => false, "交流第一路输入停电" => true, "交流第二路输入停电" => false, "交流第三路输入停电" => false, "市电切换失败" => false),
                        "p40_44_rules" => array(
                                0 => array(array(0x0 => "正常", 0x81 => "告警"), "无效"), 1 => array(array(0x0 => "正常", 0x80 => "告警"), "无效"), 2 => array(array(0x0 => "正常", 0x82 => "告警"), "无效"),
                                3 => array(array(0x0 => "正常", 0x83 => "告警"), "无效"), 4 => array(array(0x0 => "正常", 0x84 => "告警"), "无效"), 5 => array(array(0x0 => "正常", 0x85 => "告警"), "无效"),
                                6 => array(array(0x0 => "正常", 0x86 => "告警"), "无效"), 7 => array(array(0x0 => "正常", 0x87 => "告警"), "无效")
                        ),
                        "ia_support" => false, "ib_support" => false, "ic_support" => false,
                        "ia_alert_support" => false, "ib_alert_support" => false, "ic_alert_support" => false
                ),
                "rc" => array(
                        "p42_46" => 67, "p42_46_size" => 208, "p41_41" => 13, "p41_43" => 16, "p41_44" => 18,
                        "p41_41_label" => array("模块限流点(百分数)" => true, "模块输出电压" => true, "模块温度" => false, "交流输入三相电压AB/A" => true, "交流输入三相电压BC/B" => true, "交流输入三相电压CA/C" => true),
                        "p41_43_label" => array("模块交流限功率" => false, "模块温度限功率" => false, "风扇全速" => false, "WALK-In模式" => true, "模块顺序起机使能状态" => true),
                        "p41_43_rules" => array(
                                0 => array(array(0x0 => "正常", 0x80 => "限功率"), "无效"), 1 => array(array(0x0 => "正常", 0x81 => "限功率"), "无效"), 2 => array(array(0 => "正常", 0x82 => "全速"), "无效"),
                                3 => array(array(0 => "使能", 0x83 => "禁止"), "无效"), 4 => array(array(0 => "无顺序起机", 0x84 => "顺序起机"), "无效")
                        ),
                        "p41_44_label" => array("模块通讯中断" => true, "模块保护" => true, "模块不均流" => false, "模块交流过压" => false, "模块交流欠压" => false, "模块交流不平衡" => false, "模块交流缺相" => false, "模块环境温度异常" => false, "整流模块掉电告警" => false),
                        'p41_44_rules' => array(
                                0 => array(array(0 => "正常", 1 => "故障",0x80=>"告警"), "无效"),
                                1 => array(array(0 => "正常", 1 => "故障",0x81=>"告警"), "无效"),
                                2 => array(array(0 => "正常", 1 => "故障",0x82=>"告警"), "无效"),
                                3 => array(array(0 => "正常", 1 => "故障",0x83=>"告警"), "无效"),
                                4 => array(array(0 => "正常", 1 => "故障",0x84=>"告警"), "无效"),
                                5 => array(array(0 => "正常", 1 => "故障",0x85=>"告警"), "无效"),
                                6 => array(array(0 => "正常", 1 => "故障",0x86=>"告警"), "无效"),
                                7 => array(array(0 => "正常", 1 => "故障",0x87=>"告警"), "无效"),
                                8 => array(array(0 => "正常", 1 => "故障",0x88=>"告警"), "无效"),
                        ),
                        "p42_46_label" => array("定时均充使能")
                ),
                "dc" => array(
                        "m" => 18, "n" => 6, "p" => 55, "alert_m" => 18, "alert_p" => 151,
                        "p_label" => array(
                                "电池总电流" => true,
                                "电池组1电压" => false, "电池组2电压" => false, "电池组3电压" => false, "电池组4电压" => false, "电池组5电压" => false, "电池组6电压" => false, "电池组1中点电压" => false,
                                "电池组2中点电压" => false, "电池组3中点电压" => false, "电池组4中点电压" => false, "电池组5中点电压" => false, "电池组6中点电压" => false,
                                "电池组1剩余容量百分比" => true, "电池组2剩余容量百分比" => true, "电池组3剩余容量百分比" => false, "电池组4剩余容量百分比" => false,
                                "电池组5剩余容量百分比" => false, "电池组6剩余容量百分比" => false, "电池组1温度" => true, "电池组2温度" => false, "电池组3温度" => false,
                                "电池组4温度" => false, "电池组5温度" => false, "电池组6温度" => false, "机柜内环境温度1" => true, "机柜内环境温度2" => true, "机柜内环境温度3" => true,
                                "机柜内环境湿度1" => true, "机柜内环境湿度2" => false, "机柜内环境湿度3" => false, "风扇组1风扇1转速" => true, "风扇组1风扇2转速" => true,
                                "风扇组2风扇1转速" => true, "风扇组2风扇2转速" => true, "扩展柜1风扇组1风扇1转速" => false, "扩展柜1风扇组1风扇2转速" => false,
                                "扩展柜1风扇组2风扇1转速" => false, "扩展柜1风扇组2风扇2转速" => false, "扩展柜2风扇组1风扇1转速" => false, "扩展柜2风扇组1风扇2转速" => false,
                                "扩展柜2风扇组2风扇1转速" => false, "扩展柜2风扇组2风扇2转速" => false, "总直流负载电量" => false, "电池组放电电量" => false
                        ),
                        "alert_p_label" => array(
                                "直流防雷器故障" => true, "直流屏通讯中断" => false, "负载熔丝断(归一)" => true, "电池组1熔丝断" => true, "电池组2熔丝断" => true,
                                "电池组3熔丝断" => true, "电池组4熔丝断" => true, "电池组5熔丝断" => true, "电池组6熔丝断" => true,
                                "电池组1充电过流" => true, "电池组2充电过流" => true, "电池组3充电过流" => true, "电池组4充电过流" => true,
                                "电池组5充电过流" => true, "电池组6充电过流" => true, "电池组1不平衡" => true, "电池组2不平衡" => true,
                                "电池组3不平衡" => true, "电池组4不平衡" => true, "电池组5不平衡" => true, "电池组6不平衡" => true,
                                "电池组1丢失" => true, "电池组2丢失" => true, "电池组3丢失" => true, "电池组4丢失" => true,
                                "电池组5丢失" => true, "电池组6丢失" => true, "BLVD即将下电" => true, "BLVD下电" => true,
                                "负载即将下电LLVD1" => true, "负载下电LLVD1" => true, "负载即将下电LLVD2" => false,
                                "负载下电LLVD2" => false, "负载即将下电LLVD3" => false, "负载下电LLVD3" => false, "负载即将下电LLVD4" => false,
                                "负载下电LLVD4" => false, "BLVD下电回采告警状态" => false, "LLVD1下电回采告警状态" => false, "LLVD2下电回采告警状态" => false,
                                "LLVD3下电回采告警状态" => false, "LLVD4下电回采告警状态" => false, "电池电流异常" => false, "电池组间电流不平衡" => true,
                                "电池反接告警" => false, "电池温补激活" => false, "电池放电告警" => true, "电池均充告警" => false, "电池温度告警状态" => true,
                                "电池温度传感器1异常" => true, "电池温度传感器2异常" => true, "电池温度传感器3异常" => false, "电池温度传感器4异常" => false,
                                "电池温度传感器5异常" => false, "电池温度传感器6异常" => false, "环境温度告警状态" => true, "环境温度传感器1异常" => true,
                                "环境温度传感器2异常" => false, "环境温度传感器3异常" => false, "环境湿度告警状态" => true, "环境湿度传感器1异常" => true,
                                "环境湿度传感器2异常" => false, "环境湿度传感器3异常" => false, "门磁告警" => true, "水浸告警" => true, "烟雾告警" => true, "红外告警" => false,
                                "开关量输入1告警" => true, "开关量输入2告警" => true, "开关量输入3告警" => true, "开关量输入4告警" => true, "开关量输入5告警" => true, "开关量输入6告警" => true,
                                "开关量输入7告警" => false, "开关量输入8告警" => false, "开关量输入9告警" => false, "开关量输入10告警" => false, "开关量输入11告警" => false, "开关量输入12告警" => false,
                                "风扇组1风扇1告警" => true, "风扇组1风扇2告警" => true, "风扇组2风扇1告警" => true, "风扇组2风扇2告警" => true, "扩展柜1风扇组1风扇1告警" => false, "扩展柜1风扇组1风扇2告警" => false,
                                "扩展柜1风扇组2风扇1告警" => false, "扩展柜1风扇组2风扇2告警" => false, "扩展柜2风扇组1风扇1告警" => false, "扩展柜2风扇组1风扇2告警" => false, "扩展柜2风扇组2风扇1告警" => false,
                                "扩展柜2风扇组2风扇2告警" => false, "温控高温告警" => true, "扩展柜1温控高温告警" => false, "扩展柜2温控高温告警" => false, "温控传感器1异常" => true,
                                "温控传感器2异常" => true, "扩展柜1温控传感器1异常" => false, "扩展柜1温控传感器2异常" => false, "扩展柜2温控传感器1异常" => false, "扩展柜2温控传感器2异常" => false,
                                "温控设备1通信中断-告警" => false, "温控设备2通信中断-告警" => false, "温控设备3通信中断-告警" => false, "电池组1电压异常" => false, "电池组2电压异常" => false,
                                "电池组3电压异常" => false, "电池组4电压异常" => false, "电池组5电压异常" => false, "电池组6电压异常" => false, "电池测试失败-告警" => false, "电池测试结果异常告警" => false,
                                "加热器告警-告警" => false, "逆变器告警-告警" => false, "逆变器防雷器告警-告警" => false, "电池柜通信失败-告警" => false, "锂电池通信失败-告警" => false, "锂电池故障-告警" => false
                        ),
                        "alert_p_rules" => array(
                                0 => array(array(0x0 => "正常", 0x81 => "告警"), "无效"), 1 => array(array(0x0 => "正常", 0x80 => "告警"), "无效"), 2 => array(array(0x0 => "正常", 0x82 => "告警"), "无效"),
                                3 => array(array(0x0 => "正常", 0x83 => "告警"), "无效"), 4 => array(array(0x0 => "正常", 0x84 => "告警"), "无效"), 5 => array(array(0x0 => "正常", 0x85 => "告警"), "无效"),
                                6 => array(array(0x0 => "正常", 0x86 => "告警"), "无效"), 7 => array(array(0x0 => "正常", 0x87 => "告警"), "无效"), 8 => array(array(0x0 => "正常", 0x88 => "告警"), "无效"),
                                9 => array(array(0x0 => "正常", 0x89 => "告警"), "无效"), 10 => array(array(0x0 => "正常", 0x8a => "告警"), "无效"), 11 => array(array(0x0 => "正常", 0x8b => "告警"), "无效"),
                                12 => array(array(0x0 => "正常", 0x8c => "告警"), "无效"), 13 => array(array(0x0 => "正常", 0x8d => "告警"), "无效"), 14 => array(array(0x0 => "正常", 0x8e => "告警"), "无效"),
                                15 => array(array(0x0 => "正常", 0x8f => "告警"), "无效"), 16 => array(array(0x0 => "正常", 0x90 => "告警"), "无效"), 17 => array(array(0x0 => "正常", 0x91 => "告警"), "无效"),
                                18 => array(array(0x0 => "正常", 0x92 => "告警"), "无效"), 19 => array(array(0x0 => "正常", 0x93 => "告警"), "无效"), 20 => array(array(0x0 => "正常", 0x94 => "告警"), "无效"),
                                21 => array(array(0x0 => "正常", 0x95 => "告警"), "无效"), 22 => array(array(0x0 => "正常", 0x96 => "告警"), "无效"), 23 => array(array(0x0 => "正常", 0x97 => "告警"), "无效"),
                                24 => array(array(0x0 => "正常", 0x98 => "告警"), "无效"), 25 => array(array(0x0 => "正常", 0x99 => "告警"), "无效"), 26 => array(array(0x0 => "正常", 0x9a => "告警"), "无效"),
                                27 => array(array(0x0 => "正常", 0x9b => "告警"), "无效"), 28 => array(array(0x0 => "正常", 0x9c => "告警"), "无效"), 29 => array(array(0x0 => "正常", 0x9d => "告警"), "无效"),
                                30 => array(array(0x0 => "正常", 0x9e => "告警"), "无效"), 31 => array(array(0x0 => "正常", 0x9f => "告警"), "无效"), 32 => array(array(0x0 => "正常", 0xa0 => "告警"), "无效"),
                                33 => array(array(0x0 => "正常", 0xa1 => "告警"), "无效"), 34 => array(array(0x0 => "正常", 0xa2 => "告警"), "无效"), 35 => array(array(0x0 => "正常", 0xa3 => "告警"), "无效"),
                                36 => array(array(0x0 => "正常", 0xa4 => "告警"), "无效"), 37 => array(array(0x0 => "正常", 0xa5 => "告警"), "无效"), 38 => array(array(0x0 => "正常", 0xa6 => "告警"), "无效"),
                                39 => array(array(0x0 => "正常", 0xa7 => "告警"), "无效"), 40 => array(array(0x0 => "正常", 0xa8 => "告警"), "无效"), 41 => array(array(0x0 => "正常", 0xa9 => "告警"), "无效"),
                                42 => array(array(0x0 => "正常", 0xaa => "告警"), "无效"), 43 => array(array(0x0 => "正常", 0xab => "告警"), "无效"), 44 => array(array(0x0 => "正常", 0xac => "告警"), "无效"),
                                45 => array(array(0x0 => "正常", 0xad => "告警"), "无效"), 46 => array(array(0x0 => "正常", 0xae => "告警"), "无效"), 47 => array(array(0x0 => "正常", 0xaf => "告警"), "无效"),
                                48 => array(array(0x0 => "正常", 0xB0 => "过温", 0xB1 => "欠温"), "无效"), 49 => array(array(0x0 => "正常", 0xB2 => "过温", 0xB3 => "欠温"), "无效"), 50 => array(array(0x0 => "正常", 0xB4 => "过温", 0xB5 => "欠温"), "无效"),
                                51 => array(array(0x0 => "正常", 0xB6 => "过温", 0xB7 => "欠温"), "无效"), 52 => array(array(0x0 => "正常", 0xB8 => "过温", 0xB9 => "欠温"), "无效"), 53 => array(array(0x0 => "正常", 0xBa => "过温", 0xBb => "欠温"), "无效"),
                                54 => array(array(0x0 => "正常", 0xBc => "过温", 0xBd => "欠温"), "无效"), 55 => array(array(0x0 => "正常", 0xBE => "过温", 0xBF => "欠温"), "无效"), 56 => array(array(0x0 => "正常", 0xC0 => "未接", 0xC1 => "故障"), "无效"),
                                57 => array(array(0x0 => "正常", 0xC2 => "未接", 0xC3 => "故障"), "无效"), 58 => array(array(0x0 => "正常", 0xC4 => "未接", 0xC5 => "故障"), "无效"), 59 => array(array(0x0 => "正常", 0xC6 => "过湿", 0xC7 => "欠湿"), "无效"),
                                60 => array(array(0x0 => "正常", 0xC8 => "未接", 0xC9 => "故障"), "无效"), 61 => array(array(0x0 => "正常", 0xCA => "未接", 0xCB => "故障"), "无效"), 62 => array(array(0x0 => "正常", 0xCC => "未接", 0xCD => "故障"), "无效"),
                                63 => array(array(0x0 => "正常", 0xCE => "告警"), "无效"), 64 => array(array(0x0 => "正常", 0xCF => "告警"), "无效"), 65 => array(array(0x0 => "正常", 0xD0 => "告警"), "无效"),
                                66 => array(array(0x0 => "正常", 0xD1 => "告警"), "无效"), 67 => array(array(0x0 => "正常", 0xD2 => "告警"), "无效"), 68 => array(array(0x0 => "正常", 0xD3 => "告警"), "无效"),
                                69 => array(array(0x0 => "正常", 0xD4 => "告警"), "无效"), 70 => array(array(0x0 => "正常", 0xD5 => "告警"), "无效"), 71 => array(array(0x0 => "正常", 0xD6 => "告警"), "无效"),
                                72 => array(array(0x0 => "正常", 0xD7 => "告警"), "无效"), 73 => array(array(0x0 => "正常", 0xD8 => "告警"), "无效"), 74 => array(array(0x0 => "正常", 0xD9 => "告警"), "无效"),
                                75 => array(array(0x0 => "正常", 0xDa => "告警"), "无效"), 76 => array(array(0x0 => "正常", 0xDb => "告警"), "无效"), 77 => array(array(0x0 => "正常", 0xDc => "告警"), "无效"),
                                78 => array(array(0x0 => "正常", 0xDD => "告警"), "无效"), 79 => array(array(0x0 => "正常", 0xDE => "告警"), "无效"), 80 => array(array(0x0 => "正常", 0xDF => "告警"), "无效"),
                                81 => array(array(0x0 => "正常", 0xE0 => "告警"), "无效"), 82 => array(array(0x0 => "正常", 0xE1 => "告警"), "无效"), 83 => array(array(0x0 => "正常", 0xE2 => "告警"), "无效"),
                                84 => array(array(0x0 => "正常", 0xE3 => "告警"), "无效"), 85 => array(array(0x0 => "正常", 0xE4 => "告警"), "无效"), 86 => array(array(0x0 => "正常", 0xE5 => "告警"), "无效"),
                                87 => array(array(0x0 => "正常", 0xE6 => "告警"), "无效"), 88 => array(array(0x0 => "正常", 0xE7 => "告警"), "无效"), 89 => array(array(0x0 => "正常", 0xE8 => "告警"), "无效"),
                                90 => array(array(0x0 => "正常", 0xE9 => "告警"), "无效"), 91 => array(array(0x0 => "正常", 0xEA => "告警"), "无效"), 92 => array(array(0x0 => "正常", 0xEB => "告警"), "无效"),
                                93 => array(array(0x0 => "正常", 0xEC => "告警"), "无效"), 94 => array(array(0x0 => "正常", 0xED => "未接", 0xEE => "故障"), "无效"), 95 => array(array(0x0 => "正常", 0xEF => "未接", 0x80 => "故障"), "无效"),
                                96 => array(array(0x0 => "正常", 0x81 => "未接", 0x82 => "故障"), "无效"), 97 => array(array(0x0 => "正常", 0x83 => "未接", 0x84 => "故障"), "无效"), 98 => array(array(0x0 => "正常", 0x85 => "未接", 0x86 => "故障"), "无效"),
                                99 => array(array(0x0 => "正常", 0x87 => "未接", 0x88 => "故障"), "无效"), 100 => array(array(0x0 => "正常", 0x89 => "告警"), "无效"), 101 => array(array(0x0 => "正常", 0x8A => "告警"), "无效"), 102 => array(array(0x0 => "正常", 0x8B => "告警"), "无效"),
                                103 => array(array(0x0 => "正常", 0x8C => "过压", 0x8D => "欠压"), "无效"), 104 => array(array(0x0 => "正常", 0x8E => "过压", 0x8F => "欠压"), "无效"), 105 => array(array(0x0 => "正常", 0x90 => "过压", 0x91 => "欠压"), "无效"),
                                106 => array(array(0x0 => "正常", 0x92 => "过压", 0x93 => "欠压"), "无效"), 107 => array(array(0x0 => "正常", 0x94 => "过压", 0x95 => "欠压"), "无效"), 108 => array(array(0x0 => "正常", 0x96 => "过压", 0x97 => "欠压"), "无效"),
                                109 => array(array(0x0 => "正常", 0x98 => "告警"), "无效"), 110 => array(array(0x0 => "正常", 0x99 => "告警"), "无效"), 111 => array(array(0x0 => "正常", 0x9a => "告警"), "无效"),
                                112 => array(array(0x0 => "正常", 0x9b => "告警"), "无效"), 113 => array(array(0x0 => "正常", 0x9c => "告警"), "无效"), 114 => array(array(0x0 => "正常", 0x9d => "告警"), "无效"),
                                115 => array(array(0x0 => "正常", 0x9e => "告警"), "无效"), 116 => array(array(0x0 => "正常", 0x9f => "告警"), "无效")
                        )
                )
	);

    return $config;
}

function Get_smu06c_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_smu06c_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}
?>
