<?php

function Get_snp1313_RtData($memData, &$dataArray, $extraPara = false){
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('f*',substr($memData, 4,4*12));
        //'频率','AB线电压','BC线电压','CA线电压','A相电压','B相电压','C相电压','零序电压','A相电流','C相电流','有功功率','无功功率'
        $dataArray['频率'] = number_format($v[1]/100, 2)."Hz";
        $dataArray['AB线电压'] = number_format($v[2]/100, 2)."KV";
        $dataArray['BC线电压'] = number_format($v[3]/100, 2)."KV";
        $dataArray['CA线电压'] = number_format($v[4]/100, 2)."KV";
        $dataArray['A相电压'] = number_format($v[5]/100, 2)."KV";
        $dataArray['B相电压'] = number_format($v[6]/100, 2)."KV";
        $dataArray['C相电压'] = number_format($v[7]/100, 2)."KV";
        $dataArray['零序电压'] = number_format($v[8]/100, 2)."KV";
        $dataArray['A相电流'] = number_format($v[9], 2)."A";
        $dataArray['C相电流'] = number_format($v[10], 2)."A";
        $dataArray['有功功率'] = number_format($v[11] * 10, 2)."KW";
        $dataArray['无功功率'] = number_format($v[12], 2)."kVar";

        $v = unpack('v',substr($memData, 4 + 4*12, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*12 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
}
?>
