<?php
function Get_spm33_Standard_Variable($dataArray, $varname){
    //var_dump($dataArray);die;
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压']);
        case '[总功率]':
            return array(0, $dataArray["总有功功率2"]);
        case 'I路电源开关状态':
            return array(0, $dataArray['主空开检测板上有空开断开']);
        case 'I路电源相电流Ia':
            return array(0, $dataArray['主用 A相过流']);
        case 'I路电源相电流Ib':
            return array(0, $dataArray['主用 B相过流']);
        case 'I路电源相电流Ic':
            return array(0, $dataArray["主用 C相过流"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_spm33_Active_Power($dataArray){
    return array(0 , $dataArray['有功电能总和2'],$dataArray["总有功功率"]);
}

function Get_spm33_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*',substr($memData, 4 , 20));
        $dataArray['A相电压'] = ($v[1] / 100).' V';
        $dataArray['B相电压'] = ($v[2] / 100).' V';
        $dataArray['C相电压'] = ($v[3] / 100).' V';
        $dataArray['AB线电压'] = ($v[4] / 100).' V';
        $dataArray['A相电压2'] = ($v[4] / 100);
        $dataArray['BC线电压'] = ($v[5] / 100).' V';
        $dataArray['B相电压2'] = ($v[5] / 100);
        $dataArray['CA线电压'] = ($v[6] / 100).' V';
        $dataArray['C相电压2'] = ($v[6] / 100);
        $Phase_A = $v[7] / 1000;
        $Phase_B = $v[8] / 1000;
        $Phase_C = $v[9] / 1000;
        $Phase_Zero = $v[10] / 1000;
        $v = unpack('i*',substr($memData, 24 , 8));
        $totalActivePower = $v[1] / 10;
        $totalDisactivePower = $v[2] / 10;
        $v = unpack('s*',substr($memData, 32 , 20));
        $dataArray['总功率因数'] = number_format($v[1] / 1000 , 2);
        $A_PhaseActivePowerFactor = ($v[2] / 10);
        $B_PhaseActivePowerFactor = ($v[3] / 10);
        $C_PhaseActivePowerFactor = ($v[4] / 10);
        $A_PhaseDisActivePowerFactor = ($v[5] / 10);
        $B_PhaseDisActivePowerFactor = ($v[6] / 10);
        $C_PhaseDisActivePowerFactor = ($v[7] / 10);
        $dataArray['A相功率因数'] = number_format($v[8] / 1000 , 2);
        $dataArray['B相功率因数'] = number_format($v[9] / 1000 , 2);
        $dataArray['C相功率因数'] = number_format($v[10] / 1000 , 2);
        $v = unpack('S*',substr($memData, 52 , 2));
        $dataArray['频率'] = number_format($v[1] / 100 , 2).' Hz';
        $v = unpack('I*',substr($memData, 54 , 24));
        $dataArray['有功电能总和'] = number_format($v[1] / 10 , 2 , '.' , '').' KWh';
        $dataArray['有功电能总和2'] = number_format($v[1] / 10 , 2 , '.' , '');
        $dataArray['无功电能总和'] = number_format($v[2] / 10 , 2).' Kvarh';
        $dataArray['输入有功电能'] = number_format($v[3] / 10 , 2).' KWh';
        $dataArray['输出有功电能'] = number_format($v[4] / 10 , 2).' KWh';
        $dataArray['输入无功电能'] = number_format($v[5] / 10 , 2).' Kvarh';
        $dataArray['输出无功电能'] = number_format($v[6] / 10 , 2).' Kvarh';
        $v = unpack('S*',substr($memData, 78 , 24));
        //状态
        $dataArray['开关量1状态'] = ($v[1] >> 0) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量2状态'] = ($v[1] >> 1) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量3状态'] = ($v[1] >> 2) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量4状态'] = ($v[1] >> 3) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量5状态'] = ($v[1] >> 4) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量6状态'] = ($v[1] >> 5) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量7状态'] = ($v[1] >> 6) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量8状态'] = ($v[1] >> 7) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量9状态'] = ($v[1] >> 8) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量10状态'] = ($v[1] >> 9) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量11状态'] = ($v[1] >> 10) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量12状态'] = ($v[1] >> 11) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量13状态'] = ($v[1] >> 12) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量14状态'] = ($v[1] >> 13) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['开关量15状态'] = ($v[1] >> 14) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['继电器1状态'] = ($v[2] >> 0) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['继电器2状态'] = ($v[2] >> 1) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['继电器3状态'] = ($v[2] >> 2) & 0x1 == 1 ? '闭合' : '断开';
        $dataArray['继电器4状态'] = ($v[2] >> 3) & 0x1 == 1 ? '闭合' : '断开';
        //告警
        $dataArray['过压'] = ($v[3] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['欠压'] = ($v[3] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['过流'] = ($v[3] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['欠流'] = ($v[3] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['频率过高'] = ($v[3] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['频率过低'] = ($v[3] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['负荷过高'] = ($v[3] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['电压缺相'] = ($v[3] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['开关量1断'] = ($v[3] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['第一路温度过高'] = ($v[3] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['第二路温度过高'] = ($v[3] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['第三路温度过高'] = ($v[3] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['第四路温度过高'] = ($v[3] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['第五路温度过高'] = ($v[3] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['过压'] = ($v[3] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['欠压'] = ($v[3] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['过流'] = ($v[3] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['欠流'] = ($v[3] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['频率过高'] = ($v[3] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['频率过低'] = ($v[3] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['负荷过高'] = ($v[3] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['电压缺相'] = ($v[3] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['开关量1断'] = ($v[3] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['第一路温度过高'] = ($v[3] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['第二路温度过高'] = ($v[3] >> 11) & 0x1 == 1;
        $dataArray['AlertArray']['第三路温度过高'] = ($v[3] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['第四路温度过高'] = ($v[3] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['第五路温度过高'] = ($v[3] >> 14) & 0x1 == 1;
        //
        $dataArray['CT一次侧'] = $CT = $v[4];
        $dataArray['PT一次侧'] = $PT = $v[5];
        $dataArray['平均相电压'] = number_format($v[6] / 100 , 2).' V';
        $dataArray['平均线电压'] = number_format($v[7] / 100 , 2).' V';
        $dataArray['平均相电流'] = number_format(($v[8] / 1000) * $CT , 2).' A';
        $dataArray['电流不平衡率'] = number_format($v[9] / 1000 , 2).' %';
        $dataArray['A相视在功率'] = number_format(($v[10] / 10) * $CT , 2).' VA';
        $dataArray['B相视在功率'] = number_format(($v[11] / 10) * $CT , 2).' VA';
        $dataArray['C相视在功率'] = number_format(($v[12] / 10) * $CT , 2).' VA';
        $v = unpack('I*',substr($memData,102,52));
        $dataArray['总视在功率'] = number_format(($v[1] / 10) * $CT , 2).' VA';
        $dataArray['电网输入有功电能'] = number_format($v[2] / 10 , 2).' KWh';
        $dataArray['电网输出有功电能'] = number_format($v[3] / 10 , 2).' KWh';
        $dataArray['电网总有功电能'] = number_format($v[4] / 10 , 2).' KWh';
        $dataArray['电网输入无功电能'] = number_format($v[5] / 10 , 2).' Kvarh';
        $dataArray['电网输出无功电能'] = number_format($v[6] / 10 , 2).' Kvarh';
        $dataArray['电网总无功电能'] = number_format($v[7] / 10 , 2).' Kvarh';
        $dataArray['发电机输入有功电能'] = number_format($v[8] / 10 , 2).' KWh';
        $dataArray['发电机输出有功电能'] = number_format($v[9] / 10 , 2).' KWh';
        $dataArray['发电机总有功电能'] = number_format($v[10] / 10 , 2).' KWh';
        $dataArray['发电机输入无功电能'] = number_format($v[11] / 10 , 2).' Kvarh';
        $dataArray['发电机输出无功电能'] = number_format($v[12] / 10 , 2).' Kvarh';
        $dataArray['发电机总无功电能'] = number_format($v[13] / 10 , 2).' Kvarh';
        $v = unpack('S*',substr($memData,154,4));
        $dataArray['铁电状态'] = $v[1] == 1 ? '铁电异常' : '铁电正常';
        $dataArray['REF采样实时值'] = $v[2];
        $v = unpack('I*',substr($memData,158,12));
        $dataArray['视在电能总和'] = number_format($v[1] / 10 , 2).' KVAh';
        $dataArray['电网总视在电能'] = number_format($v[2] / 10 , 2).' KVAh';
        $dataArray['发电机总视在电能'] = number_format($v[3] / 10 , 2).' KVAh';
        $v = unpack('S*',substr($memData,170,16));
        $dataArray['第一路温度'] = number_format($v[1] / 10 , 2).' ℃';
        $dataArray['第二路温度'] = number_format($v[2] / 10 , 2).' ℃';
        $dataArray['第三路温度'] = number_format($v[3] / 10 , 2).' ℃';
        $dataArray['第四路温度'] = number_format($v[4] / 10 , 2).' ℃';
        $dataArray['第五路温度'] = number_format($v[5] / 10 , 2).' ℃';
        $dataArray['A相电流需量'] = number_format(($v[6] / 1000) * $CT , 2).' A';
        $dataArray['B相电流需量'] = number_format(($v[7] / 1000) * $CT , 2).' A';
        $dataArray['C相电流需量'] = number_format(($v[8] / 1000) * $CT , 2).' A';
        $v = unpack('s*',substr($memData,186,6));
        $dataArray['A相有功功率需量'] = number_format(($v[1] / 10) * $CT , 2).' W';
        $dataArray['B相有功功率需量'] = number_format(($v[2] / 10) * $CT , 2).' W';
        $dataArray['C相有功功率需量'] = number_format(($v[3] / 10) * $CT , 2).' W';
        $v = unpack('i*',substr($memData,192,4));
        $dataArray['总有功功率需量'] = number_format(($v[1] / 10) * $CT , 2).' W';
        $v = unpack('S*',substr($memData,196,6));
        $dataArray['A相电流最大需量'] = number_format(($v[1] / 1000) * $CT , 2).' A';
        $dataArray['B相电流最大需量'] = number_format(($v[2] / 1000) * $CT , 2).' A';
        $dataArray['C相电流最大需量'] = number_format(($v[3] / 1000) * $CT , 2).' A';
        $v = unpack('s*',substr($memData,202,6));
        $dataArray['A相有功功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' W';
        $dataArray['B相有功功率最大需量'] = number_format(($v[2] / 10) * $CT , 2).' W';
        $dataArray['C相有功功率最大需量'] = number_format(($v[3] / 10) * $CT , 2).' W';
        $v = unpack('i*',substr($memData,208,4));
        $dataArray['总有功功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' W';
        $v = unpack('s*',substr($memData,212,6));
        $dataArray['A相无功功率需量'] = number_format(($v[1] / 10) * $CT , 2).' var';
        $dataArray['B相无功功率需量'] = number_format(($v[2] / 10) * $CT , 2).' var';
        $dataArray['C相无功功率需量'] = number_format(($v[3] / 10) * $CT , 2).' var';
        $v = unpack('i*',substr($memData,218,4));
        $dataArray['总无功功率需量'] = number_format(($v[1] / 10) * $CT , 2).' var';
        $v = unpack('S*',substr($memData,222,6));
        $dataArray['A相视在功率需量'] = number_format(($v[1] / 10) * $CT , 2).' VA';
        $dataArray['B相视在功率需量'] = number_format(($v[2] / 10) * $CT , 2).' VA';
        $dataArray['C相视在功率需量'] = number_format(($v[3] / 10) * $CT , 2).' VA';
        $v = unpack('I*',substr($memData,228,4));
        $dataArray['总视在功率需量'] = number_format(($v[1] / 10) * $CT , 2).' VA';
        $v = unpack('s*',substr($memData,232,6));
        $dataArray['A相无功功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' var';
        $dataArray['B相无功功率最大需量'] = number_format(($v[2] / 10) * $CT , 2).' var';
        $dataArray['C相无功功率最大需量'] = number_format(($v[3] / 10) * $CT , 2).' var';
        $v = unpack('i*',substr($memData,238,4));
        $dataArray['总无功功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' var';
        $v = unpack('S*',substr($memData,242,6));
        $dataArray['A相视在功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' VA';
        $dataArray['B相视在功率最大需量'] = number_format(($v[2] / 10) * $CT , 2).' VA';
        $dataArray['C相视在功率最大需量'] = number_format(($v[3] / 10) * $CT , 2).' VA';
        $v = unpack('I*',substr($memData,248,4));
        $dataArray['总视在功率最大需量'] = number_format(($v[1] / 10) * $CT , 2).' VA';
        $v = unpack('S*',substr($memData,252,12));
        $dataArray['设备地址'] = $v[1];
        $dataArray['CT一次测值'] = $v[2].' A';
        $dataArray['接线模式'] = $v[3] == 0 ? '四线星形' : '三线三角形';
        $dataArray['PT一次测值'] = ($v[4] / 100).' KV';
        $dataArray['PT二次测值'] = $v[5].' V';
        if($v[6] == 0){
            $dataArray['波特率'] = '4800 bps';
        }else if($v[6] == 1){
            $dataArray['波特率'] = '9600 bps';
        }else if($v[6] == 2){
            $dataArray['波特率'] = '19200 bps';
        }else{
            $dataArray['波特率'] = '无效';
        }
        $v = unpack('v',substr($memData,264,2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,266,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
        $dataArray['A相电流'] = number_format($Phase_A * $CT /5, 2).' A';
        $dataArray['B相电流'] = number_format($Phase_B * $CT /5, 2).' A';
        $dataArray['C相电流'] = number_format($Phase_C * $CT /5, 2).' A';
        $dataArray['零序电流'] = number_format($Phase_Zero * $CT , 2).' A';
        $dataArray['总有功功率'] =  number_format($totalActivePower * $CT/1000/5 , 2, ".", "").' KW';
        $dataArray['总有功功率2'] =  number_format($totalActivePower * $CT/1000/5 , 3, ".", "");
        $dataArray['总无功功率'] =  number_format($totalDisactivePower * $CT/5 , 2).' var';
        $dataArray['A相有功功率'] = number_format($A_PhaseActivePowerFactor * $CT /5, 2).' W';
        $dataArray['B相有功功率'] = number_format($B_PhaseActivePowerFactor * $CT /5, 2).' W';
        $dataArray['C相有功功率'] = number_format($C_PhaseActivePowerFactor * $CT /5, 2).' W';
        $dataArray['A相无功功率'] = number_format($A_PhaseDisActivePowerFactor * $CT /5, 2).' var';
        $dataArray['B相无功功率'] = number_format($B_PhaseDisActivePowerFactor * $CT /5, 2).' var';
        $dataArray['C相无功功率'] = number_format($C_PhaseDisActivePowerFactor * $CT /5, 2).' var';
    }
}
?>
