<?php

function Get_st6_20k_RtData($memData, &$dataArray, $extraPara = false)
{
    if(!$memData) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
	//rt
        $v = unpack('C*', substr($memData, 4, 6));
	$dataArray["UPS硬件版本"] = $v[1];
        $v = unpack('C*', substr($memData, 4 + 6, 6));
	$dataArray["通讯协议的编号"] = $v[1];
        $v = unpack('C*', substr($memData, 4 + 6 +6 , 31));
	$dataArray["UPS型号名称"] = $v[1];
        $v = unpack('C*', substr($memData, 4 + 6 +6 + 31, 4));
	$dataArray["输入源/输出源的数量"] = $v[1];
        $v = unpack('C*', substr($memData, 4 + 6 +6 + 31 + 4, 4));
	$dataArray["输入/输出相数"] = $v[1];
        $v = unpack('S*', substr($memData, 4 + 6 +6 + 31 + 4 + 4, 2*6));
	$dataArray["额定输出电压"] = $v[1];
	$dataArray["额定输出频率"] = $v[2]/100;
	$dataArray["一个电池组的电池数量"] = $v[3];
	$dataArray["每节电池电压"] = $v[4]/10;
	$dataArray["UPS模块的最大数量"] = $v[5];
	$dataArray["额定功率"] = $v[6];
	//q1
	$v = unpack('S*', substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6, 2*7));
	$dataArray["输入电压值"] = $v[1]/10;
	$dataArray["发生故障时的输入电压"] = $v[2]/10;
	$dataArray["输出电压值"] = $v[3]/10;
	$dataArray["输出电流值"] = $v[4]/10;
	$dataArray["输入频率"] = $v[5]/10;
	$dataArray["电池电压"] = $v[6]/100;
	$dataArray["温度"] = $v[7]/10;
	$v = unpack('S*', substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6 + 2*7, 1));
	$dataArray["市电状态"] = (($v[1]>>7) & 0x1 == 0) ? "市电正常" : "市电失败,电池供电";
	$dataArray["电池电压状态"] = (($v[1]>>6) & 0x1 == 0) ? "电池电压不低" : "电池电压低";
	$dataArray["旁路状态"] = (($v[1]>>5) & 0x1 == 0) ? "非旁路" : "旁路";
	$dataArray["UPS状态"] = (($v[1]>>4) & 0x1 == 0) ? "正常" : "有故障";
	$dataArray["在线式UPS"] = (($v[1]>>3) & 0x1 == 0) ? "是" : "不是";
	$dataArray["非自检过程中"] = (($v[1]>>2) & 0x1 == 0) ? "非自检过程中" : "正在自检中......";
	$dataArray["运行状态"] = (($v[1]>>1) & 0x1 == 0) ? "正常运行状态" : "正在关机或者已经关机";
	$dataArray["蜂鸣器状态"] = (($v[1]) & 0x1 == 0) ? "关闭" : "打开";
	//q6
	$v = unpack('S*', substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6 + 2*7 + 1, 2*16));
	$dataArray["UPS输入电压R"] = $v[1]/10;
	$dataArray["UPS输入电压S"] = $v[2]/10;
	$dataArray["UPS输入电压T"] = $v[3]/10;
	$dataArray["UPS输入频率"] = $v[4]/10;

	$dataArray["输出电压R"] = $v[5]/10;
	$dataArray["输出电压S"] = $v[6]/10;
	$dataArray["输出电压T"] = $v[7]/10;
	$dataArray["输出频率"] = $v[8]/10;

	$dataArray["输出电流R"] = $v[9];
	$dataArray["输出电流S"] = $v[10];
	$dataArray["输出电流T"] = $v[11];

	$dataArray["Positive电池电压"] = $v[12]/10;
	$dataArray["Negative电池电压"] = $v[13]/10;

	$dataArray["实时温度"] = $v[14]/10;
	$dataArray["电池剩余备用时间估计"] = $v[15]." 秒";
	$dataArray["电池容量百分比"] = $v[16];

	$v = unpack('C*', substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6 + 2*7 + 1 + 2*16, 2));
	switch($v[1])
	{
	  case 0:
	    $dataArray["系统模式"] = "PowerOn";
	    break;
	  case 1:
	    $dataArray["系统模式"] = "Standby";
	    break;
	  case 2:
	    $dataArray["系统模式"] = "Bypass";
	    break;
	  case 3:
	    $dataArray["系统模式"] = "Line";
	    break;
	  case 4:
	    $dataArray["系统模式"] = "Bat";
	    break;
	  case 5:
	    $dataArray["系统模式"] = "BatTest";
	    break;
	  case 6:
	    $dataArray["系统模式"] = "Fault";
	    break;
	  case 7:
	    $dataArray["系统模式"] = "Converter";
	    break;
	  case 8:
	    $dataArray["系统模式"] = "HE";
	    break;
	  case 9:
	    $dataArray["系统模式"] = "Shutdown";
	    break;
        }
	switch($v[2]){
	  case 0:
	    $dataArray["电池测试状态"] = "IDLE";
	    break;
	  case 1:
	    $dataArray["电池测试状态"] = "PROCESSING";
	    break;
	  case 2:
	    $dataArray["电池测试状态"] = "Result: No failure";
	    break;
	  case 3:
	    $dataArray["电池测试状态"] = "Result: Failure";
	    break;
	  case 4:
	    $dataArray["电池测试状态"] = "Not possible";
	    break;
	  case 5:
	    $dataArray["电池测试状态"] = "Test Cancel";
	    break;
	  case 6:
	    $dataArray["电池测试状态"] = "Reserved";
	    break;
	  case 7:
	    $dataArray["电池测试状态"] = "Other Values";
	    break;
	}
        $v = unpack('v',substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6 + 2*7 + 1 + 2*16 + 2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 6 +6 + 31 + 4 + 4 + 2*6 + 2*7 + 1 + 2*16 + 2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
