<?php

function Get_sunrise_eda_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定温度']);
        case '回风温度':
            return array(0, $dataArray["当前回风温度"]);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}   


function Get_sunrise_eda_RtData($memData, &$dataArray, $extraPara = false)
{
    if (strlen($memData) == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('f*', substr($memData, 4, 4 * 2));
        $dataArray['当前回风温度'] = number_format($v[1] , 2).' ℃';
        $dataArray['当前回风湿度'] = number_format($v[2] , 2).' %';
        /* $dataObj->temp = $v[1];
        $dataObj->humidity = $v[2]; */
        $v = unpack('C*', substr($memData, 4 + 4 * 2 , 1 *34));
        $dataArray['开关机状态'] = $v[1] == 1 ? '开机' : '关机';
        $dataArray['风机状态'] = $v[2] == 1 ? '运行' : '停机';
        $dataArray['加热状态'] = $v[3] == 1 ? '加热' : '未加热';
        $dataArray['制冷状态'] = $v[4] == 1 ? '制冷' : '未制冷';
        $dataArray['加湿'] = $v[5] == 1 ? '加湿' : '未加湿';
        $dataArray['除湿'] = $v[6] == 1 ? '除湿' : '未除湿';
        $dataArray['压缩机高压'] = $v[7] == 1 ? '告警' : '正常';
        $dataArray['系统低压'] = $v[8] == 1 ? '告警' : '正常';
        $dataArray['气流丢失'] = $v[9] == 1 ? '告警' : '正常';
        $dataArray['风机过载'] = $v[10] == 1 ? '告警' : '正常';
        $dataArray['加热器过载'] = $v[11] == 1 ? '告警' : '正常';
        $dataArray['空气过滤'] = $v[12] == 1 ? '告警' : '正常';
        $dataArray['高温告警'] = $v[13] == 1 ? '告警' : '正常';
        $dataArray['低温告警'] = $v[14] == 1 ? '告警' : '正常';
        $dataArray['高湿告警'] = $v[15] == 1 ? '告警' : '正常';
        $dataArray['低湿告警'] = $v[16] == 1 ? '告警' : '正常';
        $dataArray['室内温度探头故障'] = $v[17] == 1 ? '告警' : '正常';
        $dataArray['送风温度探头故障'] = $v[18] == 1 ? '告警' : '正常';
        $dataArray['房间湿度探头故障'] = $v[19] == 1 ? '告警' : '正常';
        $dataArray['室外温度探头故障'] = $v[20] == 1 ? '告警' : '正常';
        $dataArray['送风温度告警'] = $v[21] == 1 ? '告警' : '正常';
        $dataArray['加湿器告警'] = $v[22] == 1 ? '告警' : '正常';
        $dataArray['加湿器大电流告警'] = $v[23] == 1 ? '告警' : '正常';
        $dataArray['加湿器缺水告警'] = $v[24] == 1 ? '告警' : '正常';
        $dataArray['加湿器无电流告警'] = $v[25] == 1 ? '告警' : '正常';
        $dataArray['用户告警'] = $v[26] == 1 ? '告警' : '正常';
        $dataArray['烟雾告警'] = $v[27] == 1 ? '告警' : '正常';
        $dataArray['风机超时告警'] = $v[28] == 1 ? '告警' : '正常';
        $dataArray['滤网超时告警'] = $v[29] == 1 ? '告警' : '正常';
        $dataArray['阀门超时告警'] = $v[30] == 1 ? '告警' : '正常';
        $dataArray['压缩机超时告警'] = $v[31] == 1 ? '告警' : '正常';
        $dataArray['压缩机2高压'] = $v[32] == 1 ? '告警' : '正常';
        $dataArray['压缩机2低压'] = $v[33] == 1 ? '告警' : '正常';
        $dataArray['漏水告警'] = $v[34] == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['压缩机高压'] = $v[7] == 1;
        $dataArray['AlertArray']['系统低压'] = $v[8] == 1;
        $dataArray['AlertArray']['气流丢失'] = $v[9] == 1;
        $dataArray['AlertArray']['风机过载'] = $v[10] == 1;
        $dataArray['AlertArray']['加热器过载'] = $v[11] == 1;
        $dataArray['AlertArray']['空气过滤'] = $v[12] == 1;
        $dataArray['AlertArray']['高温告警'] = $v[13] == 1;
        $dataArray['AlertArray']['低温告警'] = $v[14] == 1;
        $dataArray['AlertArray']['高湿告警'] = $v[15] == 1;
        $dataArray['AlertArray']['低湿告警'] = $v[16] == 1;
        $dataArray['AlertArray']['室内温度探头故障'] = $v[17] == 1;
        $dataArray['AlertArray']['送风温度探头故障'] = $v[18] == 1;
        $dataArray['AlertArray']['房间湿度探头故障'] = $v[19] == 1;
        $dataArray['AlertArray']['室外温度探头故障'] = $v[20] == 1;
        $dataArray['AlertArray']['送风温度告警'] = $v[21] == 1;
        $dataArray['AlertArray']['加湿器告警'] = $v[22] == 1;
        $dataArray['AlertArray']['加湿器大电流告警'] = $v[23] == 1;
        $dataArray['AlertArray']['加湿器缺水告警'] = $v[24] == 1;
        $dataArray['AlertArray']['加湿器无电流告警'] = $v[25] == 1;
        $dataArray['AlertArray']['用户告警'] = $v[26] == 1;
        $dataArray['AlertArray']['烟雾告警'] = $v[27] == 1;
        $dataArray['AlertArray']['风机超时告警'] = $v[28] == 1;
        $dataArray['AlertArray']['滤网超时告警'] = $v[29] == 1;
        $dataArray['AlertArray']['阀门超时告警'] = $v[30] == 1;
        $dataArray['AlertArray']['压机超时告警'] = $v[31] == 1;
        $dataArray['AlertArray']['压缩机2高压'] = $v[32] == 1;
        $dataArray['AlertArray']['压缩机2低压'] = $v[33] == 1;
        $dataArray['AlertArray']['漏水告警'] = $v[34] == 1;
        $v = unpack('f*', substr($memData, 4 + 4 * 2 + 1 * 34 , 4 * 6));
        $dataArray['回风温度调整值'] = number_format($v[1] , 2).' ℃';
        $dataArray['湿度调整值'] = number_format($v[2] , 2).' %';
        $dataArray['设定温度'] = number_format($v[3] , 2).' ℃';
        $dataArray['设定湿度'] = number_format($v[4] , 2).' %';
        $dataArray['温度死区'] = number_format($v[5] , 2).' ℃';
        $dataArray['湿度死区'] = number_format($v[6] , 2).' %';
        $v = unpack('v', substr($memData, 4 + 4 * 8 + 1 * 34 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 4 * 8 + 1 * 34 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
