<?php 

function Get_taac_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '回风温度':
            return array(0, $dataArray["室内温度"]);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}   


function Get_taac_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['错误'] = '数据长度不一致';
        $dataArray['更新时间'] = '无';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('S*',substr($memData, 4 , 2*2));
        $dataArray['AlertArray'] = array();
        $dataArray['自动模式'] = ($v[1] & 0x1) == 1 ? '开启' : '关闭';
        $dataArray['手动模式'] = (($v[1] >> 1) & 0x1) == 1 ? '开启' : '关闭';
        $dataArray['夏季模式'] = (($v[1] >> 2) & 0x1) == 1 ? '开启' : '关闭';
        $dataArray['冬季模式'] = (($v[1] >> 3) & 0x1) == 1 ? '开启' : '关闭';
        $dataArray['水泵轮巡'] = (($v[1] >> 4) & 0x1) == 1 ? '开启' : '关闭';
        $dataArray['选择1号泵'] = (($v[1] >> 5) & 0x1) == 1 ? '是' : '否';
        $dataArray['选择2号泵'] = (($v[1] >> 6) & 0x1) == 1 ? '是' : '否';
        $dataArray['间接风机运行'] = (($v[1] >> 7) & 0x1) == 1 ? '运行' : '关机';
        $dataArray['间接风机故障'] = (($v[1] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['间接风机故障'] = (($v[1] >> 8) & 0x1) == 1;
        $dataArray['间接水泵运行'] = (($v[1] >> 9) & 0x1) == 1 ? '运行' : '关机';
        $dataArray['间接水泵故障'] = (($v[1] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['间接水泵故障'] = (($v[1] >> 10) & 0x1) == 1;
        $dataArray['1号加湿水泵运行'] = (($v[1] >> 11) & 0x1) == 1 ? '运行' : '关机';
        $dataArray['1号加湿水泵故障'] = (($v[1] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['1号加湿水泵故障'] = (($v[1] >> 12) & 0x1) == 1;
        $dataArray['2号加湿水泵运行'] = (($v[1] >> 13) & 0x1) == 1 ? '运行' : '关机';
        $dataArray['2号加湿水泵故障'] = (($v[1] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['2号加湿水泵故障'] = (($v[1] >> 14) & 0x1) == 1;
        $dataArray['1号送风机运行'] = (($v[1] >> 15) & 0x1) == 1 ? '运行' : '关机';
        $dataArray['2号送风机运行'] = ($v[2] & 0x1) == 1 ? '运行' : '关机';
        $dataArray['送风机故障'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['送风机故障'] = (($v[2] >> 1) & 0x1) == 1;
        $dataArray['排风机运行'] = (($v[2] >> 2) & 0x1) == 1 ? '运行' : '关机';
        
        $v = unpack('f*',substr($memData, 4 + 4 , 8*4));
        $dataArray['室内温度'] = number_format($v[1], 2 ,'.','').' ℃';
        $dataArray['室内湿度'] = number_format($v[2], 2 ,'.','').' %';
        $dataArray['室外温度'] = number_format($v[3], 2 ,'.','').' ℃';
        $dataArray['室外湿度'] = number_format($v[4], 2 ,'.','').' %';
        $dataArray['送风温度'] = number_format($v[5], 2 ,'.','').' ℃';
        $dataArray['送风湿度'] = number_format($v[6], 2 ,'.','').' %';
        $dataArray['PM2.5'] = number_format($v[7], 2 ,'.','');
        $dataArray['回风阀开度'] = number_format($v[8], 2 ,'.','').' °';
        $v = unpack('v', substr($memData, 8 + 8*4 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 8 + 8*4 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}




?>
