<?php
//设备类型
function Get_tbea_powermeter1_UnicomCategory()
{
    return "321";
}

function Is_tbea_powermeter1_NeedExtraPara(){
    return true;
}


function Get_tbea_powermeter1_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack("S*" , substr($memData , 4 , 2 * 63));
	$pt = $v[62];
	if(isset($extraPara->pt)){
	   $pt = $extraPara->pt;
	}
	$ct  = $v[63];
	if(isset($extraPara->ct)){
	   $ct = $extraPara->ct;
	}
        $dataArray['A相电压'] = number_format($v[1]*$pt / 100 , 2, ".", "").' V';
        $dataArray['B相电压'] = number_format($v[2]*$pt / 100 , 2, ".", "").' V';
        $dataArray['C相电压'] = number_format($v[3]*$pt / 100 , 2, ".", "" ).' V';
        $dataArray['AB线电压'] = number_format($v[4]*$pt / 100 , 2, ".", "").' V';
        $dataArray['BC线电压'] = number_format($v[5]*$pt / 100 , 2, ".", "").' V';
        $dataArray['AC线电压'] = number_format($v[6]*$pt / 100 , 2, ".", "" ).' V';
        $dataArray['A相电流'] = number_format($v[7]*$ct / 1000 , 2 ).' A';
        $dataArray['B相电流'] = number_format($v[8]*$ct  / 1000 , 2 ).' A';
        $dataArray['C相电流'] = number_format($v[9]*$ct  / 1000 , 2 ).' A';

        $dataArray['A相有功功率'] = number_format($v[10]*$ct*$pt / 10000 , 2,'.','').' KW';
        $dataArray['B相有功功率'] = number_format($v[11]*$ct*$pt / 10000 , 2,'.','').' KW';
        $dataArray['C相有功功率'] = number_format($v[12]*$ct*$pt / 10000 , 2,'.','').' KW';
        $dataArray['总有功功率'] = number_format( ($v[13]<<16 | $v[14])*$ct*$pt / 10000 , 2,'.','').' KW';
        
        $dataArray['A相无功功率'] = number_format($v[15]*$ct*$pt / 10000 , 2,'.','').' var';
        $dataArray['B相无功功率'] = number_format($v[16]*$ct*$pt / 10000 , 2,'.','').' var';
        $dataArray['C相无功功率'] = number_format($v[17]*$ct*$pt / 10000 , 2,'.','').' var';
        $dataArray['总无功功率'] = number_format( ($v[18]<<16 | $v[19])*$ct*$pt / 10000 , 2,'.','').' var';

        $dataArray['A相功率因数'] = $v[20] / 1000;
        $dataArray['B相功率因数'] = $v[21] / 1000;
        $dataArray['C相功率因数'] = $v[22] / 1000;
        $dataArray['总功率因数'] = $v[23] / 1000;

	$dataArray['A相视在功率'] = number_format($v[24]*$ct*$pt / 10000 , 2,'.','').' VA';
        $dataArray['B相视在功率'] = number_format($v[25]*$ct*$pt / 10000 , 2,'.','').' VA';
        $dataArray['C相视在功率'] = number_format($v[26]*$ct*$pt / 10000 , 2,'.','').' VA';
        $dataArray['总视在功率'] = number_format( ($v[27]<<16|$v[28])*$ct*$pt / 10000 , 2,'.','').' VA';

        $dataArray['频率'] = number_format( $v[29] / 100 , 2,'.','').' Hz';

        $dataArray['总正向有功电能'] = number_format( ($v[30]<<16|$v[31])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['总正向无功电能'] = number_format( ($v[32]<<16|$v[33])*$ct*$pt / 1000/1000 , 2,'.','').' KVArh';
        $dataArray['总反向有功电能'] = number_format( ($v[34]<<16|$v[35])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['总反向无功电能'] = number_format( ($v[36]<<16|$v[37])*$ct*$pt / 1000/1000 , 2,'.','').' KVArh';

        
        $dataArray['A相正向有功电能'] = number_format( ($v[38]<<16|$v[39])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['B相正向有功电能'] = number_format( ($v[40]<<16|$v[41])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['C相正向有功电能'] = number_format( ($v[42]<<16|$v[43])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['A相正向无功电能'] = number_format( ($v[44]<<16|$v[45])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';
        $dataArray['B相正向无功电能'] = number_format( ($v[46]<<16|$v[47])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';
        $dataArray['C相正向无功电能'] = number_format( ($v[48]<<16|$v[49])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';

	$dataArray['A相反向有功电能'] = number_format( ($v[50]<<16|$v[51])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['B相反向有功电能'] = number_format( ($v[52]<<16|$v[53])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['C相反向有功电能'] = number_format( ($v[54]<<16|$v[55])*$ct*$pt / 1000/1000 , 2,'.','').' KWh';
        $dataArray['A相反向无功电能'] = number_format( ($v[56]<<16|$v[57])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';
        $dataArray['B相反向无功电能'] = number_format( ($v[58]<<16|$v[59])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';
        $dataArray['C相反向无功电能'] = number_format( ($v[60]<<16|$v[61])*$ct*$pt / 1000/1000 , 2,'.','').' KVarh';

	$dataArray["电压变比"] = $v[62];
	$dataArray["电流变比"] = $v[63];
        $v = unpack('v', substr($memData, 4 + 63*2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 63*2 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
