<?php
//设备类型
function Get_tbea_powermeter2_UnicomCategory()
{
    return "321";
}

function Is_tbea_powermeter2_NeedExtraPara(){
    return true;
}


function Get_tbea_powermeter2_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack("S*" , substr($memData , 4 , 2 * 13));
	$dataArray["电压变比"] = $pt = $v[1];
	if(isset($extraPara->pt)){
	   $pt = $extraPara->pt;
	}
	$dataArray["电流变比"] = $ct  = $v[2];
	if(isset($extraPara->ct)){
	   $ct = $extraPara->ct;
	}
	$dataArray["开入1"] = (($v[3] & 0x1) == 1) ? "开" : "关";
	$dataArray["开入2"] = ((($v[3] >> 1) & 0x1) == 1) ? "开" : "关";
	$dataArray["开入3"] = ((($v[3] >> 2) & 0x1) == 1) ? "开" : "关";
	$dataArray["开出1"] = (($v[4] & 0x1) == 1) ? "开" : "关";
	$dataArray["开出2"] = ((($v[4] >> 1) & 0x1) == 1) ? "开" : "关";
	$dataArray["开出3"] = ((($v[4] >> 2) & 0x1) == 1) ? "开" : "关";

        $dataArray['A(ab)电压'] = number_format($v[5]*$pt / 10 , 2, ".", "").' V';
        $dataArray['B(bc)电压'] = number_format($v[6]*$pt / 10 , 2, ".", "").' V';
        $dataArray['C(ac)电压'] = number_format($v[7]*$pt / 10 , 2, ".", "" ).' V';

        $dataArray['A相电流'] = number_format($v[8]*$ct / 100 , 2 ).' A';
        $dataArray['B相电流'] = number_format($v[9]*$ct  / 100 , 2 ).' A';
        $dataArray['C相电流'] = number_format($v[10]*$ct  / 100 , 2 ).' A';


        $v = unpack('v', substr($memData, 4 + 13*2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 13*2 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
