<?php


function _GetTc20GenStatus($val){
    switch($val){
        case 0: return '待机';
        case 1: return '预热';
        case 2: return '燃油输出';
        case 3: return '起动';
        case 4: return '起动间隔';
        case 5: return '安全延时';
        case 6: return '开机怠速';
        case 7: return '高速暖机';
        case 8: return '等待带载';
        case 9: return '正常运行';
        case 10: return '高速散热';
        case 11: return '停机怠速';
        case 12: return '得电停机';
        case 13: return '等待停稳';
        case 14: return '过停稳';
        case 15: return '停机失败';
    }
    return '无效';
}
function Get_tc20_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('S*',substr($memData,4,122));
        //告警  状态
        $dataArray['公共报警'] = ($v[1] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['公共停机报警'] = ($v[1] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['公共警告报警'] = ($v[1] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['公共跳闸停机报警'] = ($v[1] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['公共分闸不停机'] = ($v[1] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['公共跳闸停机报警和公共停机报警'] = ($v[1] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['公共报警'] = ($v[1] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['公共停机报警'] = ($v[1] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['公共警告报警'] = ($v[1] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['公共跳闸停机报警'] = ($v[1] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['公共分闸不停机'] = ($v[1] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['公共跳闸停机报警和公共停机报警'] = ($v[1] >> 5) & 0x1 == 1;
        $dataArray['系统在测试模式'] = ($v[1] >> 8) & 0x1 == 1 ? "是" : "否";
        $dataArray['系统在自动模式'] = ($v[1] >> 9) & 0x1 == 1 ? "是" : "否";
        $dataArray['系统在手动模式'] = ($v[1] >> 10) & 0x1 == 1 ? "是" : "否";
        $dataArray['系统在停机模式'] = ($v[1] >> 11) & 0x1 == 1 ? "是" : "否";

        $dataArray['紧急停机报警'] = ($v[2] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['超速报警停机'] = ($v[2] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['欠速停机'] = ($v[2] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['速度信号丢失报警'] = ($v[2] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过频报警停机'] = ($v[2] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电欠频停机'] = ($v[2] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过压停机'] = ($v[2] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电欠压停机'] = ($v[2] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['起动失败报警'] = ($v[2] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过流停机'] = ($v[2] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['维护时间到报警停机'] = ($v[2] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['逆功率报警停机'] = ($v[2] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['过功率报警停机'] = ($v[2] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度高输入报警停机'] = ($v[2] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['油压低输入报警停机'] = ($v[2] >> 15) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['紧急停机报警'] = ($v[2] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['超速报警停机'] = ($v[2] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['欠速停机'] = ($v[2] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['速度信号丢失报警'] = ($v[2] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['发电过频报警停机'] = ($v[2] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['发电欠频停机'] = ($v[2] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['发电过压停机'] = ($v[2] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['发电欠压停机'] = ($v[2] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['起动失败报警'] = ($v[2] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['发电过流停机'] = ($v[2] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['维护时间到报警停机'] = ($v[2] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['逆功率报警停机'] = ($v[2] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['过功率报警停机'] = ($v[2] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['温度高输入报警停机'] = ($v[2] >> 14) & 0x1 == 1;
        $dataArray['AlertArray']['油压低输入报警停机'] = ($v[2] >> 15) & 0x1 == 1;

        $dataArray['ECU通信失败报警停机'] = ($v[3] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度传感器开路报警停机'] = ($v[3] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度高报警停机'] = ($v[3] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['压力传感器开路报警停机'] = ($v[3] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['压力低报警停机'] = ($v[3] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['ECU通信失败报警停机'] = ($v[3] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['温度传感器开路报警停机'] = ($v[3] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['温度高报警停机'] = ($v[3] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['压力传感器开路报警停机'] = ($v[3] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['压力低报警停机'] = ($v[3] >> 14) & 0x1 == 1;

        $dataArray['液位传感器开路报警停机'] = ($v[4] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1开路报警停机'] = ($v[4] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1高报警停机'] = ($v[4] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1低报警停机'] = ($v[4] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2开路报警停机'] = ($v[4] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2高报警停机'] = ($v[4] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2低报警停机'] = ($v[4] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['液位传感器开路报警停机'] = ($v[4] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1开路报警停机'] = ($v[4] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1高报警停机'] = ($v[4] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1低报警停机'] = ($v[4] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2开路报警停机'] = ($v[4] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2高报警停机'] = ($v[4] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2低报警停机'] = ($v[4] >> 10) & 0x1 == 1;

        $dataArray['输入口1停机'] = ($v[9] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口2停机'] = ($v[9] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口3停机'] = ($v[9] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口4停机'] = ($v[9] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口5停机'] = ($v[9] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口6停机'] = ($v[9] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口7停机'] = ($v[9] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['输入口1停机'] = ($v[9] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['输入口2停机'] = ($v[9] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['输入口3停机'] = ($v[9] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['输入口4停机'] = ($v[9] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['输入口5停机'] = ($v[9] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['输入口6停机'] = ($v[9] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['输入口7停机'] = ($v[9] >> 6) & 0x1 == 1;

        $dataArray['过流跳闸停机'] = ($v[13] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['维护时间到跳闸停机'] = ($v[13] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['逆功率跳闸停机'] = ($v[13] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['过功率跳闸停机'] = ($v[13] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口1跳闸停机'] = ($v[13] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口2跳闸停机'] = ($v[13] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口3跳闸停机'] = ($v[13] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口4跳闸停机'] = ($v[13] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口5跳闸停机'] = ($v[13] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口6跳闸停机'] = ($v[13] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口7跳闸停机'] = ($v[13] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['过流跳闸停机'] = ($v[13] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['维护时间到跳闸停机'] = ($v[13] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['逆功率跳闸停机'] = ($v[13] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['过功率跳闸停机'] = ($v[13] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['输入口1跳闸停机'] = ($v[13] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['输入口2跳闸停机'] = ($v[13] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['输入口3跳闸停机'] = ($v[13] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['输入口4跳闸停机'] = ($v[13] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['输入口5跳闸停机'] = ($v[13] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['输入口6跳闸停机'] = ($v[13] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['输入口7跳闸停机'] = ($v[13] >> 10) & 0x1 == 1;

        $dataArray['过流跳闸不停机'] = ($v[17] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['维护时间到跳闸不停机'] = ($v[17] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['逆功率跳闸不停机'] = ($v[17] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['过功率跳闸不停机'] = ($v[17] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口1跳闸不停机'] = ($v[17] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口2跳闸不停机'] = ($v[17] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口3跳闸不停机'] = ($v[17] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口4跳闸不停机'] = ($v[17] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口5跳闸不停机'] = ($v[17] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口6跳闸不停机'] = ($v[17] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口7跳闸不停机'] = ($v[17] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['过流跳闸不停机'] = ($v[17] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['维护时间到跳闸不停机'] = ($v[17] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['逆功率跳闸不停机'] = ($v[17] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['过功率跳闸不停机'] = ($v[17] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['输入口1跳闸不停机'] = ($v[17] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['输入口2跳闸不停机'] = ($v[17] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['输入口3跳闸不停机'] = ($v[17] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['输入口4跳闸不停机'] = ($v[17] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['输入口5跳闸不停机'] = ($v[17] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['输入口6跳闸不停机'] = ($v[17] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['输入口7跳闸不停机'] = ($v[17] >> 10) & 0x1 == 1;

        $dataArray['发电超速警告'] = ($v[21] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电欠速警告'] = ($v[21] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['速度信号丢失警告'] = ($v[21] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过频警告'] = ($v[21] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电欠频警告'] = ($v[21] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过压警告'] = ($v[21] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电欠压警告'] = ($v[21] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['发电过流'] = ($v[21] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['停机失败警告'] = ($v[21] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['充电失败警告'] = ($v[21] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['电池过压警告'] = ($v[21] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['电池欠压警告'] = ($v[21] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['维护时间到警告'] = ($v[21] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['逆功率警告'] = ($v[21] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['过功率警告'] = ($v[21] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['发电超速警告'] = ($v[21] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['发电欠速警告'] = ($v[21] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['速度信号丢失警告'] = ($v[21] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['发电过频警告'] = ($v[21] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['发电欠频警告'] = ($v[21] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['发电过压警告'] = ($v[21] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['发电欠压警告'] = ($v[21] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['发电过流'] = ($v[21] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['停机失败警告'] = ($v[21] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['充电失败警告'] = ($v[21] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['电池过压警告'] = ($v[21] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['电池欠压警告'] = ($v[21] >> 11) & 0x1 == 1;
        $dataArray['AlertArray']['维护时间到警告'] = ($v[21] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['逆功率警告'] = ($v[21] >> 13) & 0x1 == 1;
        $dataArray['AlertArray']['过功率警告'] = ($v[21] >> 14) & 0x1 == 1;

        $dataArray['发电相序错误警告'] = ($v[22] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['开关转换失败警告'] = ($v[22] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度传感器开路警告'] = ($v[22] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度高警告'] = ($v[22] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['温度低警告'] = ($v[22] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['压力传感器开路警告'] = ($v[22] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['压力低警告'] = ($v[22] >> 14) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['发电相序错误警告'] = ($v[22] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['开关转换失败警告'] = ($v[22] >> 7) & 0x1 == 1;
        $dataArray['AlertArray']['温度传感器开路警告'] = ($v[22] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['温度高警告'] = ($v[22] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['温度低警告'] = ($v[22] >> 10) & 0x1 == 1;
        $dataArray['AlertArray']['压力传感器开路警告'] = ($v[22] >> 12) & 0x1 == 1;
        $dataArray['AlertArray']['压力低警告'] = ($v[22] >> 14) & 0x1 == 1;

        $dataArray['液位传感器开路警告'] = ($v[23] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['液位低警告'] = ($v[23] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1开路警告'] = ($v[23] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1高警告'] = ($v[23] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器1低警告'] = ($v[23] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2开路警告'] = ($v[23] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2高警告'] = ($v[23] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['可编程传感器2低警告'] = ($v[23] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['液位传感器开路警告'] = ($v[23] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['液位低警告'] = ($v[23] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1开路警告'] = ($v[23] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1高警告'] = ($v[23] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器1低警告'] = ($v[23] >> 6) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2开路警告'] = ($v[23] >> 8) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2高警告'] = ($v[23] >> 9) & 0x1 == 1;
        $dataArray['AlertArray']['可编程传感器2低警告'] = ($v[23] >> 10) & 0x1 == 1;

        $dataArray['GSM通信失败警告'] = ($v[28] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['GSM通信失败警告'] = ($v[28] >> 0) & 0x1 == 1;

        $dataArray['输入口1警告'] = ($v[30] >> 0) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口2警告'] = ($v[30] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口3警告'] = ($v[30] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口4警告'] = ($v[30] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口5警告'] = ($v[30] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口6警告'] = ($v[30] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['输入口7警告'] = ($v[30] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['输入口1警告'] = ($v[30] >> 0) & 0x1 == 1;
        $dataArray['AlertArray']['输入口2警告'] = ($v[30] >> 1) & 0x1 == 1;
        $dataArray['AlertArray']['输入口3警告'] = ($v[30] >> 2) & 0x1 == 1;
        $dataArray['AlertArray']['输入口4警告'] = ($v[30] >> 3) & 0x1 == 1;
        $dataArray['AlertArray']['输入口5警告'] = ($v[30] >> 4) & 0x1 == 1;
        $dataArray['AlertArray']['输入口6警告'] = ($v[30] >> 5) & 0x1 == 1;
        $dataArray['AlertArray']['输入口7警告'] = ($v[30] >> 6) & 0x1 == 1;

        //状态
        $dataArray['禁止报警停机指示'] = ($v[32] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['维护时间到指示'] = ($v[32] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['在不开机时间内指示'] = ($v[32] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray['GSM通信失败指示'] = ($v[32] >> 3) & 0x1 == 1 ? "是" : "否";

        $dataArray['自动模式输入'] = ($v[33] >> 6) & 0x1 == 1 ? "是" : "否";
        $dataArray['自动模式失效'] = ($v[33] >> 7) & 0x1 == 1 ? "是" : "否";
        $dataArray['GSM禁止开机'] = ($v[33] >> 8) & 0x1 == 1 ? "是" : "否";
        $dataArray['过流指示'] = ($v[33] >> 13) & 0x1 == 1 ? "是" : "否";
        $dataArray['逆功率指示'] = ($v[33] >> 14) & 0x1 == 1 ? "是" : "否";
        $dataArray['过功率指示'] = ($v[33] >> 15) & 0x1 == 1 ? "是" : "否";

        $dataArray['燃油继电器输出状态'] = ($v[38] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['起动继电器输出状态'] = ($v[38] >> 1) & 0x1 == 1 ? "是" : "否";

        $dataArray['市电正常'] = ($v[44] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电合闸'] = ($v[44] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['发电正常'] = ($v[44] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray['发电合闸'] = ($v[44] >> 3) & 0x1 == 1 ? "是" : "否";
        $dataArray['报警灯状态'] = ($v[44] >> 4) & 0x1 == 1 ? "是" : "否";
        $dataArray['运行灯状态'] = ($v[44] >> 5) & 0x1 == 1 ? "是" : "否";

        $dataArray['市电异常'] = ($v[45] >> 0) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电过压'] = ($v[45] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电欠压'] = ($v[45] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电过频'] = ($v[45] >> 3) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电欠频'] = ($v[45] >> 4) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电缺相'] = ($v[45] >> 5) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电逆相序'] = ($v[45] >> 6) & 0x1 == 1 ? "是" : "否";
        $dataArray['市电无'] = ($v[45] >> 7) & 0x1 == 1 ? "是" : "否";

        //模拟量
        $dataArray['市电AB线电压'] = $v[56].' V';
        $dataArray['市电BC线电压'] = $v[57].' V';
        $dataArray['市电CA线电压'] = $v[58].' V';
        $dataArray['市电A相电压'] = $v[59].' V';
        $dataArray['市电B相电压'] = $v[60].' V';
        $dataArray['市电C相电压'] = $v[61].' V';
        $v = unpack('s*',substr($memData,126,6));
        $dataArray['市电A相位'] = $v[1] == 32766 ? '无效' : $v[1];
        $dataArray['市电B相位'] = $v[2] == 32766 ? '无效' : $v[2];
        $dataArray['市电C相位'] = $v[3] == 32766 ? '无效' : $v[3];
        $v = unpack('S*',substr($memData,132,34));
        $dataArray['市电频率'] = ($v[1] / 10).' Hz';
        //保留  2-11  10位
        $dataArray['发电AB线电压'] = $v[12].' V';
        $dataArray['发电BC线电压'] = $v[13].' V';
        $dataArray['发电CA线电压'] = $v[14].' V';
        $dataArray['发电A相电压'] = $v[15].' V';
        $dataArray['发电B相电压'] = $v[16].' V';
        $dataArray['发电C相电压'] = $v[17].' V';
        $v = unpack('s*',substr($memData,166,6));
        $dataArray['发电A相位'] = $v[1] == 32766 ? '无效' : $v[1];
        $dataArray['发电B相位'] = $v[2] == 32766 ? '无效' : $v[2];
        $dataArray['发电C相位'] = $v[3] == 32766 ? '无效' : $v[3];
        $v = unpack('S*',substr($memData,172,38));
        $dataArray['发电频率'] = ($v[1] / 10).' Hz';
        $dataArray['A相电流'] = ($v[12] / 10).' A';
        $dataArray['B相电流'] = ($v[13] / 10).' A';
        $dataArray['C相电流'] = ($v[14] / 10).' A';
        $dataArray['接地电流'] = ($v[15] / 10).' A';
        $v = unpack('f*',substr($memData,210,48));
        $dataArray['A相有功功率'] = number_format($v[1] / 10 , 2).' W';
        $dataArray['B相有功功率'] = number_format($v[2] / 10 , 2).' W';
        $dataArray['C相有功功率'] = number_format($v[3] / 10 , 2).' W';
        $dataArray['总有功功率'] = number_format($v[4] / 10 , 2).' W';
        $dataArray['A相无功功率'] = number_format($v[5] / 10 , 2).' Var';
        $dataArray['B相无功功率'] = number_format($v[6] / 10 , 2).' Var';
        $dataArray['C相无功功率'] = number_format($v[7] / 10 , 2).' Var';
        $dataArray['总无功功率'] = number_format($v[8] / 10 , 2).' Var';
        $dataArray['A相视在功率'] = number_format($v[9] / 10 , 2).' VA';
        $dataArray['B相视在功率'] = number_format($v[10] / 10 , 2).' VA';
        $dataArray['C相视在功率'] = number_format($v[11] / 10 , 2).' VA';
        $dataArray['总视在功率'] = number_format($v[12] / 10 , 2).' VA';
        $v = unpack('s*',substr($memData,258,8));
        $dataArray['A相功率因数'] = $v[1] / 100;
        $dataArray['B相功率因数'] = $v[2] / 100;
        $dataArray['C相功率因数'] = $v[3] / 100;
        $dataArray['平均功率因数'] = $v[4] / 100;
        $v = unpack('S*',substr($memData,266,36));
        $dataArray['发动机转速'] = $v[11].' r/min';
        $dataArray['电池电压'] = ($v[12] / 10).' V';
        $dataArray['充电机电压'] = ($v[13] / 10).' V';
        $dataArray['温度传感器电阻值'] = $v[18] == 65535 ? '无效' : ($v[18] / 10).' Ω';
        $v = unpack('s*',substr($memData,302,2));
        $dataArray['温度传感器数值'] = $v[1].' ℃';
        $v = unpack('S*',substr($memData,304,2));
        $dataArray['压力传感器电阻值'] = ($v[1] / 10).' Ω';
        $v = unpack('s*',substr($memData,306,2));
        $dataArray['压力传感器数值'] = $v[1].' Pa';
        $v = unpack('S*',substr($memData,308,2));
        $dataArray['液位传感器电阻值'] = $v[1] == 65535 ? '无效' : ($v[1] / 10).' Ω';
        $v = unpack('s*',substr($memData,310,2));
        $dataArray['液位传感器数值'] = $v[1] == 32767 ? '无效' : $v[1].' %';
        $v = unpack('S*',substr($memData,312,2));
        $dataArray['可编程传感器1电阻值'] = $v[1] == 65535 ? '无效' : ($v[1] / 10).' Ω';
        $v = unpack('s*',substr($memData,314,2));
        $dataArray['可编程传感器1数值'] = $v[1] == 32767 ? '无效' : $v[1];
        $v = unpack('S*',substr($memData,316,2));
        $dataArray['可编程传感器2电阻值'] = $v[1] == 65535 ? '无效' : ($v[1] / 10).' Ω';
        $v = unpack('s*',substr($memData,318,2));
        $dataArray['可编程传感器2数值'] = $v[1] == 32767 ? '无效' : $v[1];
        $v = unpack('S*',substr($memData,320,26));
        //保留 4
        $dataArray['冷却液位'] = $v[5] == 32766 ? '无效' : $v[5].' %';
        $dataArray['机油温度'] = $v[6].' ℃';
        $dataArray['冷却液压力'] = $v[7].' Pa';
        $dataArray['燃油压力'] = $v[8].' Pa';
        $dataArray['燃油温度'] = $v[9].' ℃';
        $dataArray['进气口温度'] = $v[10] == 32766 ? '无效' : $v[10].' ℃';
        $dataArray['排气口温度'] = $v[11] == 32766 ? '无效' : $v[11].' ℃';
        $dataArray['涡轮压力'] = $v[12].' Pa';
        $dataArray['燃油消耗'] = $v[13].' %';
        $v = unpack('i*',substr($memData,346,4));
        $dataArray['累计燃油消耗'] = number_format($v[1] , 2);
        $v = unpack('S*',substr($memData,350,60));
        //保留16位
        $dataArray['发电机状态'] = _GetTc20GenStatus($v[17]);
        $dataArray['发电延时值'] = $v[18];
        if($v[19] == 0){
            $dataArray['远程开机状态'] = '无延时';
        }else if($v[19] == 1){
            $dataArray['远程开机状态'] = '开机延时';
        }else if($v[19] == 2){
            $dataArray['远程开机状态'] = '停机延时';
        }else{
            $dataArray['远程开机状态'] = '无效';
        }
        $dataArray['远程开机延时值'] = $v[20];
        //保留  2位
        if($v[23] == 0){
            $dataArray['市电状态'] = '市电正常';
        }else if($v[23] == 1){
            $dataArray['市电状态'] = '市电正常延时';
        }else if($v[23] == 2){
            $dataArray['市电状态'] = '市电异常';
        }else if($v[23] == 3){
            $dataArray['市电状态'] = '市电异常延时';
        }else{
            $dataArray['市电状态'] = '无效';
        }
        $dataArray['市电延时值'] = $v[24];
        //保留5位
        $dataArray['累计开机次数'] = $v[30];
        $v = unpack('f*',substr($memData,410,12));
        $dataArray['累计有功电能'] = number_format($v[1] , 2).' KWh';
        $dataArray['累计无功电能'] = number_format($v[2] , 2).' KVarh';
        $dataArray['累计视在电能'] = number_format($v[3] , 2).' KVAh';
        $v = unpack('v',substr($memData,480,2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,482,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}


?>
