<?php
function Get_tm5530_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['更新时间'] = '无';
        $dataArray['无数据'] = true;
        $dataArray['错误']  = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*', substr($memData, 4, 2 * 53));
        $dataArray['S1 C 相相电压'] = $v[1]."V";
        $dataArray['S1 B 相相电压'] = $v[2]."V";
        $dataArray['S1 A 相相电压'] = $v[3]."V";
        $dataArray['S1 AC 相线电压'] = $v[4]."V";
        $dataArray['S1 BC 相线电压'] = $v[5]."V";
        $dataArray['S1 AB 相线电压'] = $v[6]."V";
        $dataArray['S1 负载 C 相相电流'] = $v[7]."A";
        $dataArray['S1 负载 B 相相电流'] = $v[8]."A";
        $dataArray['S1 负载 A 相相电流'] = $v[9]."A";
        $dataArray['S1 负载 C 相功率因数'] = $v[10]/100;
        $dataArray['S1 负载 B 相功率因数'] = $v[11]/100;
        $dataArray['S1 负载 A 相功率因数'] = $v[12]/100;
        $dataArray['S1 频率'] = ($v[13]/10)."Hz";
        $dataArray['S1 负载 C 相视在功率'] = ($v[14]/10)."KVA";
        $dataArray['S1 负载 B 相视在功率'] = ($v[15]/10)."KVA";
        $dataArray['S1 负载 A 相视在功率'] = ($v[16]/10)."KVA";

        $dataArray['S1 负载 C 相有功功率'] = $v[17]."KW";
        $dataArray['S1 负载 B 相有功功率'] = $v[18]."KW";
        $dataArray['S1 负载 A 相有功功率'] = $v[19]."KW";

        $dataArray['S1 负载 C 相无功功率'] = $v[20]."KVar";
        $dataArray['S1 负载 B 相无功功率'] = $v[21]."KVar";
        $dataArray['S1 负载 A 相无功功率'] = $v[22]."KVar";

        $dataArray['电池电压'] = ($v[23]/10)."V";
        $dataArray['辅助模拟输入'] = ($v[24]/10)."V";

        $dataArray['开关量输入1'] = $v[25] & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入2'] = ($v[25] >> 1) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入3'] = ($v[25] >> 2) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入4'] = ($v[25] >> 3) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入5'] = ($v[25] >> 4) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入6'] = ($v[25] >> 5) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入7'] = ($v[25] >> 6) & 0x1 ? "无效" : "有效";
        $dataArray['开关量输入8'] = ($v[25] >> 7) & 0x1 ? "无效" : "有效";

        $dataArray['S1合闸继电器'] = $v[26] & 0x1 ? "动作" : "无动作";
        $dataArray['S2合闸继电器'] = ($v[26] >> 1) & 0x1 ? "动作" : "无动作";
        $dataArray['继电器1'] = ($v[26] >> 2) & 0x1 ? "动作" : "无动作";
        $dataArray['继电器2'] = ($v[26] >> 3) & 0x1 ? "动作" : "无动作";
        $dataArray['继电器3'] = ($v[26] >> 4) & 0x1 ? "动作" : "无动作";
        $dataArray['继电器4'] = ($v[26] >> 5) & 0x1 ? "动作" : "无动作";
        $dataArray['继电器5'] = ($v[26] >> 6) & 0x1 ? "动作" : "无动作";

        $dataArray['S2合闸指示灯'] = $v[27] & 0x1  ? "熄灭" : "亮起";
        $dataArray['S2正常指示灯'] = ($v[27] >> 1) & 0x1 ? "熄灭" : "亮起";
        $dataArray['AUTO键灯'] = ($v[27] >> 2) & 0x1 ? "熄灭" : "亮起";
        $dataArray['TEST键灯'] = ($v[27] >> 3) & 0x1 ? "熄灭" : "亮起";
        $dataArray['故障指示灯'] = ($v[27] >> 4) & 0x1 ? "熄灭" : "亮起";
        $dataArray['停止模式指示灯'] = ($v[27] >> 5) & 0x1 ? "熄灭" : "亮起";
        $dataArray['S1正常指示灯'] = ($v[27] >> 6) & 0x1 ? "熄灭" : "亮起";
        $dataArray['S1合闸指示灯'] = ($v[27] >> 7) & 0x1 ? "熄灭" : "亮起";

        $dataArray['预报警代码'] = $v[28];
        $dataArray['报警代码'] = $v[29];

        switch ($v[30]) {
            case 1:
                $dataArray['状态'] = "手动转换到S1";
                break;
            case 2:
                $dataArray['状态'] = "手动转换到S2";
                break;
            case 3:
                $dataArray['状态'] = "进入停止状态";
                break;
            case 4:
                $dataArray['状态'] = "进入测试状态";
                break;
            case 6:
                $dataArray['状态'] = "进入手动状态";
                break;
            case 7:
                $dataArray['状态'] = "进入自动状态";
                break;
            case 8:
                $dataArray['状态'] = "复位";
                break;
            case 20:
                $dataArray['状态'] = "自投自复";
                break;
            case 21:
                $dataArray['状态'] = "自投不自复(故障复)";
                break;
            case 22:
                $dataArray['状态'] = "自投不自复(完全)";
                break;
            default:
                $dataArray['状态'] = "无效状态" .$v[30] ;
                break;
        }

        $dataArray["S1相序错"] = $v[31] & 0x1 ? "错误" : "正常";
        $dataArray["S2相序错"] = ($v[31] >> 1) & 0x1 ? "错误" : "正常";

        $dataArray['S2 频率'] = ($v[32]/10)."Hz";
        $dataArray['S2 C 相相电压'] = $v[33]."V";
        $dataArray['S2 B 相相电压'] = $v[34]."V";
        $dataArray['S2 A 相相电压'] = $v[35]."V";
        $dataArray['S2 AC 相线电压'] = $v[36]."V";
        $dataArray['S2 BC 相线电压'] = $v[37]."V";
        $dataArray['S2 AB 相线电压'] = $v[38]."V";

        $dataArray['S2 负载 C 相相电流'] = $v[39]."A";
        $dataArray['S2 负载 B 相相电流'] = $v[40]."A";
        $dataArray['S2 负载 A 相相电流'] = $v[41]."A";

        $dataArray['S2 负载 C 相视在功率'] = ($v[42]/10)."KVA";
        $dataArray['S2 负载 B 相视在功率'] = ($v[43]/10)."KVA";
        $dataArray['S2 负载 A 相视在功率'] = ($v[44]/10)."KVA";

        $dataArray['S2 负载 C 相有功功率'] = $v[45]."KW";
        $dataArray['S2 负载 B 相有功功率'] = $v[46]."KW";
        $dataArray['S2 负载 A 相有功功率'] = $v[47]."KW";

        $dataArray['S2 负载 C 相无功功率'] = $v[48]."KVar";
        $dataArray['S2 负载 B 相无功功率'] = $v[49]."KVar";
        $dataArray['S2 负载 A 相无功功率'] = $v[50]."KVar";


        $dataArray['S2 负载 C 相功率因数'] = $v[51]/100;
        $dataArray['S2 负载 B 相功率因数'] = $v[52]/100;
        $dataArray['S2 负载 A 相功率因数'] = $v[53]/100;

        $v = unpack('v', substr($memData, 4 + 2*53, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*53 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
