<?php

function Get_uh11_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray['交流输出A相电流']);
        case 'B相输出电流':
            return array(0, $dataArray['交流输出B相电流']);
        case 'C相输出电流':
            return array(0, $dataArray['交流输出C相电流']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    


function Get_uh11_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData) ){
            $dataArray['更新时间'] = '无';
            $dataArray['无数据'] = true;
            $dataArray['错误']  = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('f*', substr($memData, 4, 4 * 10));
            $dataArray['交流输入AB线电压/A相电压'] = number_format($v[1], 2).' V';
            $dataArray['交流输入BC线电压/B相电压'] = number_format($v[2], 2).' V';
            $dataArray['交流输入CA线电压/C相电压'] = number_format($v[3], 2).' V';
            $dataArray['交流输出AB线电压/A相电压'] = number_format($v[4], 2).' V';
            $dataArray['交流输出BC线电压/B相电压'] = number_format($v[5], 2).' V';
            $dataArray['交流输出CA线电压/C相电压'] = number_format($v[6], 2).' V';
            $dataArray['交流输出A相电流'] = number_format($v[7], 2).' A';
            $dataArray['交流输出B相电流'] = number_format($v[8], 2).' A';
            $dataArray['交流输出C相电流'] = number_format($v[9], 2).' A';
            $dataArray['直流输入电压']= number_format($v[10], 2).' V';
            $v = unpack('I*', substr($memData, 4 + 4 * 10, 4*1));
            $dataArray['输出频率'] = $v[1].' Hz';
            $v = unpack('c*', substr($memData, 4 + 4 * 10 + 4*1, 1*3));
            $dataArray['标示电池数量'] = $v[1];
            $dataArray['标示温度数量'] = $v[2];
            //$dataArray['用户自定义遥测内容数量'] = $v[3];
            $v = unpack('f*', substr($memData, 4 + 4 * 10 + 4*1 + 1*3, 4*4));
            $dataArray['交流输入频率'] = number_format($v[1], 2).' Hz';
            $dataArray['负载大小'] = number_format($v[2], 2).' %';
            $dataArray['电池容量'] = number_format($v[3], 2).' %';
            $dataArray['机内温度'] = number_format($v[4], 2).' ℃';
            //系统状态
            $v = unpack('C*', substr($memData, 4 + 4 * 14 + 4*1 + 1*3, 1*6));
            if($v[1] == 1){
                $dataArray['供电方式'] = 'UPS供电';
            }else if($v[1] == 2){
                $dataArray['供电方式'] = '旁路供电';
            }else if($v[1] == 0xE9){
                $dataArray['供电方式'] = '均不供电';
            }else{
                $dataArray['供电方式'] = '无效';
            }
            //$dataArray['用户自定义数量'] = $v[2];
            if($v[3] == 0xE0){
                $dataArray['电池自检'] = '自检中';
            }else if($v[3] == 0xE1){
                $dataArray['电池自检'] = '没在自检';
            }else{
                $dataArray['电池自检'] = '无效';
            }
            
            if($v[4] == 0xE2){
                $dataArray['均充/浮充'] = '浮充';
            }else if($v[4] == 0xE3){
                $dataArray['均充/浮充'] = '均充';
            }else if($v[4] == 0xEA){
                $dataArray['均充/浮充'] = '非充电状态';
            }else{
                $dataArray['均充/浮充'] = '无效';
            }
            
            if($v[5] == 0xE4){
                $dataArray['开机/关机'] = '开机';
            }else if($v[5] == 0xE5){
                $dataArray['开机/关机'] = '关机';
            }else if($v[5] == 0xE6){
                $dataArray['开机/关机'] = '正在关机';
            }else{
                $dataArray['开机/关机'] = '无效';
            }
            
            if($v[6] == 0xE7){
                $dataArray['UPS供电'] = '电池逆变供电';
            }else if($v[6] == 0xE8){
                $dataArray['UPS供电'] = '市电逆变供电';
            }else{
                $dataArray['UPS供电'] = '无效';
            }
            //系统告警
            $v = unpack('C*', substr($memData, 4 + 4 * 14 + 4*1 + 1*9, 1*14));
            $dataArray['不同步告警'] = $v[1] == 3 ? '告警' : '正常';
            $dataArray['市电电压低于下限'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['市电电压高于上限'] = $v[2] == 2 ? '告警' : '正常';
            $dataArray['市电电压超限'] = $v[2] == 0xE0 ? '告警' : '正常';
            $dataArray['整流器故障'] = $v[3] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变器故障'] = $v[4] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路电压低于下限'] = $v[5] == 1 ? '告警' : '正常';
            $dataArray['旁路电压高于上限'] = $v[5] == 2 ? '告警' : '正常';
            $dataArray['蓄电池总电压低于下限'] = $v[6] == 1 ? '告警' : '正常';
            $dataArray['蓄电池总电压高于上限'] = $v[6] == 2 ? '告警' : '正常';
            $dataArray['蓄电池总电压故障'] = $v[6] == 0xF0 ? '告警' : '正常';
            $dataArray['蓄电池总电压预告警'] = $v[6] == 0xE1 ? '告警' : '正常';
            //$dataArray['标示电池数量'] = $v[7];
            //$dataArray['用户自定义告警数量'] = $v[8];
            $dataArray['充电器故障'] = $v[9] == 0xF0 ? '告警' : '正常';
            $dataArray['零线/火线接反'] = $v[10] == 0xF0 ? '告警' : '正常';
            $dataArray['输出短路'] = $v[11] == 0xF0 ? '告警' : '正常';
            $dataArray['输出过载'] = $v[12] == 0xF0 ? '告警' : '正常';
            $dataArray['散热器温度过高'] = $v[13] == 0xF0 ? '告警' : '正常';
            $dataArray['市电频率超限'] = $v[14] == 0xE0 ? '告警' : '正常';
            
            $dataArray['AlertArray']['不同步告警'] = $v[1] == 3;
            $dataArray['AlertArray']['市电电压低于下限'] = $v[2] == 1;
            $dataArray['AlertArray']['市电电压高于上限'] = $v[2] == 2;
            $dataArray['AlertArray']['市电电压超限'] = $v[2] == 0xE0;
            $dataArray['AlertArray']['整流器故障'] = $v[3] == 0xF0;
            $dataArray['AlertArray']['逆变器故障'] = $v[4] == 0xF0;
            $dataArray['AlertArray']['旁路电压低于下限'] = $v[5] == 1;
            $dataArray['AlertArray']['旁路电压高于上限'] = $v[5] == 2;
            $dataArray['AlertArray']['蓄电池总电压低于下限'] = $v[6] == 1;
            $dataArray['AlertArray']['蓄电池总电压高于上限'] = $v[6] == 2;
            $dataArray['AlertArray']['蓄电池总电压故障'] = $v[6] == 0xF0;
            $dataArray['AlertArray']['蓄电池总电压预告警'] = $v[6] == 0xE1;
            $dataArray['AlertArray']['充电器故障'] = $v[9] == 0xF0;
            $dataArray['AlertArray']['零线/火线接反'] = $v[10] == 0xF0;
            $dataArray['AlertArray']['输出短路'] = $v[11] == 0xF0;
            $dataArray['AlertArray']['输出过载'] = $v[12] == 0xF0;
            $dataArray['AlertArray']['散热器温度过高'] = $v[13] == 0xF0;
            $dataArray['AlertArray']['市电频率超限'] = $v[14] == 0xE0;
            //系统参数
            $v = unpack('f*', substr($memData, 4 + 4 * 14 + 4*1 + 1*23, 4*4));
            $dataArray['蓄电池总电压上限'] = number_format($v[1],2).' V';
            $dataArray['蓄电池总电压下限'] = number_format($v[2],2).' V';
            $dataArray['蓄电池单体电压上限'] = number_format($v[3],2).' V';
            $dataArray['蓄电池单体电压下限'] = number_format($v[4],2).' V';
            $v = unpack('C*', substr($memData, 4 + 4 * 18 + 4*1 + 1*23, 1));
            //$dataArray['用户自定义参数数量'] = $v[1];
            $v = unpack('f*', substr($memData, 4 + 4 * 18 + 4*1 + 1*24, 4*7));
            $dataArray['后台电池自检时间长度'] = number_format($v[1] , 2).' S';
            $dataArray['遥控关机延迟时间'] = number_format($v[2] , 2).' S';
            $dataArray['UPS恢复延迟时间'] = number_format($v[3] , 2).' S';
            if($v[4] == 1){
                $dataArray['是否自动重起机'] = '不自动';
            }else if($v[4] == 2){
                $dataArray['是否自动重起机'] = '自动';
            }else{
                $dataArray['是否自动重起机'] = '无效';
            }
            
            if($v[5] == 1){
                $dataArray['是否允许均充设置'] = '不允许';
            }else if($v[5] == 2){
                $dataArray['是否允许均充设置'] = '允许';
            }else{
                $dataArray['是否允许均充设置'] = '无效';
            }
            
            if($v[6] == 1){
                $dataArray['主/从/单机设置'] = '单';
            }else if($v[6] == 2){
                $dataArray['主/从/单机设置'] = '主';
            }else if($v[6] == 3){
                $dataArray['主/从/单机设置'] = '从';
            }else{
                $dataArray['主/从/单机设置'] = '无效';
            }
            $dataArray['主从机交替工作时间'] = number_format($v[7] , 2).' 天';
            $v = unpack('v', substr($memData, 4 + 4 * 25 + 4*1 + 1*24, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 4 * 25 + 4*1 + 1*24 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
