<?php

    function _GetUl33Runstate($v, $k)
    {
        if($k == "1"){
            switch ($v) {
                case 1: return "UPS供电";
                case 3: return "旁路供电";
                case 233: return "均不供电";
            }
            return "无效";
        }
        else if($k == "2"){
            return "13";
        }
        else if($k == "3"){
            switch ($v) {
                case 224: return "自检中";
                case 225: return "没在自检";
            }
            return "无效";
        }
        else if($k == "4"){
            switch ($v) {
                case 226: return "浮充";
                case 227: return "均充";
                case 234: return "非充电状态";
            }
            return "无效";
        }
        else if($k == "5"){
            switch ($v) {
                case 228: return "开机";
                case 229: return "关机";
            }
            return "无效";
        }
        else if($k == "6"){
            switch ($v) {
                case 231: return "电池逆变供电";
                case 232: return "市电逆变供电";
                case 233: return "市电电池联合供电";
            }
            return "无效";
        }
        else if($k == "7"){
            switch ($v) {
                case 224: return "发电机接入";
                case 225: return "发电机没接入";
            }
            return "无效";
        }
        else if($k == "8"){
            switch ($v) {
                case 224: return "断开状态";
                case 225: return "闭合状态";
            }
            return "无效";
        }
        else if($k == "9"){
            switch ($v) {
                case 224: return "断开状态";
                case 225: return "闭合状态";
            }
            return "无效";
        }
        else if($k == "10"){
            switch ($v) {
                case 224: return "断开状态";
                case 225: return "闭合状态";
            }
            return "无效";
        }
        else if($k == "11"){
            switch ($v) {
                case 224: return "断开状态";
                case 225: return "闭合状态";
            }
            return "无效";
        }
        else if($k == "12"){
            switch ($v) {
                case 224: return "非工作状态";
                case 225: return "正工作状态";
            }
            return "无效";
        }
        else if($k == "13"){
            switch ($v) {
                case 224: return "输出禁止状态";
                case 225: return "非输出禁止状态";
            }
            return "无效";
        }
        else if($k == "14"){
            switch ($v) {
                case 224: return "输出禁止状态";
                case 225: return "非输出禁止状态";
            }
            return "无效";
        }
        else if($k == "15"){
            switch ($v) {
                case 1: return "单机";
                case 2: return "热备份主机";
                case 3: return "热备份从机";
                case 4: return "并机通讯主机";
                case 5: return "并机通讯从机";
            }
            return "无效";
        }
    }

    function _GetUl33Warnstate($v, $k)
    {
        if($k == "1"){
            switch ($v) {
                case 0: return "同步";
                case 3: return "不同步";
            }
            return "无效";
        }
        else if($k == "2"){
            switch ($v) {
                case 0: return "正常";
                case 2: return "异常";
                case 3: return "欠压";
            }
            return "无效";
        }
        else if($k == "3"||$k == "4"){
            switch ($v) {
                case 0: return "正常";
                case F0: return "故障";
            }
            return "无效";
        }
        else if($k == "5"){
            switch ($v) {
                case 0: return "正常";
                case 1: return "超出跟踪范围";
                case 2: return "超出保护范围";
            }
            return "无效";
        }
        else if($k == "6"){
            switch ($v) {
                case 0: return "正常";
                case 1: return "电池无";
                case 2: return "低于下限（关机点）";
                case 3: return "高于上限（电压过高 ）";
                case 240: return "接反";
                case 225: return "预告警";
            }
            return "无效";
        }
    }

    function _GetUl33Warnstate_c7($v, $k)
    {
        switch ($v) {
            case 0: return "正常";
            case 1: return "低于下限";
            case 2: return "高于上限";
            case 3: return "不同步";
            case 240:
                if(in_array($k, array("1"))){
                    return "需要更换";
                }else if(in_array($k, array("2","5","6","7","12","13","14","15","16","23"))){
                    return "异常";
                }else if(in_array($k, array("3","4","8","9"))){
                    return "过温";
                }else if(in_array($k, array("17","18"))){
                    return "过载";
                }else if(in_array($k, array("19","20"))){
                    return "过载超时";
                }
            case 224: return "超限";
            case 225: return "预告警";
        }
        return "无效";
    }

    function _GetUl33Warnstate_c8($v)
    {
        switch ($v) {
            case 0: return "正常";
            case 1: return "低于下限";
            case 2: return "高于上限";
            case 3: return "不同步";
            case 240: return "故障";
            case 224: return "超限";
            case 225: return "预告警";
        }
        return "无效";
    }

    function Get_ul33_Standard_Variable($dataArray, $varname){
        switch ($varname){
            case 'A相输出电流':
                return array(0, $dataArray["A相输出电流（A）"]);
            case 'B相输出电流':
                return array(0, $dataArray["B相输出电流（A）"]);
            case 'C相输出电流':
                return array(0, $dataArray["C相输出电流（A）"]);
            case 'A相输出负载百分比':    
                return array(0,$dataArray['A相输出负载百分比（%）']);
            case 'B相输出负载百分比':    
                return array(0,$dataArray['B相输出负载百分比（%）']);
            case 'C相输出负载百分比':    
                return array(0,$dataArray['C相输出负载百分比（%）']);
            default:
                break;
        }
        return array(1 , '设备无此信号数据:'. $varname);
    }    

    
    function Get_ul33_RtData($memData, &$dataArray, $extraPara = false)
    {
        if($memData == false) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            
            $v = unpack('f*', substr($memData, 4, 4 * 11));
            $dataArray["A相输入电压（V）"] = number_format($v[1], 2);
            $dataArray["B相输入电压（V）"] = number_format($v[2], 2);
            $dataArray["C相输入电压（V）"] = number_format($v[3], 2);
            $dataArray["A相输出电压（V）"] = number_format($v[4], 2);
            $dataArray["B相输出电压（V）"] = number_format($v[5], 2);
            $dataArray["C相输出电压（V）"] = number_format($v[6], 2);
            $dataArray["A相输出电流（A）"] = number_format($v[7], 2);
            $dataArray["B相输出电流（A）"] = number_format($v[8], 2);
            $dataArray["C相输出电流（A）"] = number_format($v[9], 2);
            $dataArray["直流输入电压（V）"] = number_format($v[10], 2);
            $dataArray["输出频率（Hz）"] = number_format($v[11], 2);
            $v = unpack('c*', substr($memData, 4 * 12, 1 * 2));
            $dataArray["整机标识电池数量m"] = $v[1];
            $dataArray["整机标识温度数量n"] = $v[2];
            $v = unpack('f*', substr($memData, 4 * 12 + 2, 4 * 34));
            $dataArray["交流输入线电压AB（V）"] = number_format($v[1], 2);
            $dataArray["交流输入线电压BC（V）"] = number_format($v[2], 2);
            $dataArray["交流输入线电压CA（V）"] = number_format($v[3], 2);
            $dataArray["A相输入电流（A）"] = number_format($v[4], 2);
            $dataArray["B相输入电流（A）"] = number_format($v[5], 2);
            $dataArray["C相输入电流（A）"] = number_format($v[6], 2);
            $dataArray["输入频率（Hz）"] = number_format($v[7], 2);
            $dataArray["输入功率因数"] = number_format($v[8], 2);
            $dataArray["A相旁路电压（V）"] = number_format($v[9], 2);
            $dataArray["B相旁路电压（V）"] = number_format($v[10], 2);
            $dataArray["C相旁路电压（V）"] = number_format($v[11], 2);
            $dataArray["A相旁路电流（A）"] = number_format($v[12], 2);
            $dataArray["B相旁路电流（A）"] = number_format($v[13], 2);
            $dataArray["C相旁路电流（A）"] = number_format($v[14], 2);
            $dataArray["旁路频率（Hz）"] = number_format($v[15], 2);
            $dataArray["电池温度（℃）"] = number_format($v[16], 2);
            $dataArray["A相输出功率因数"] = number_format($v[17], 2);
            $dataArray["B相输出功率因数"] = number_format($v[18], 2);
            $dataArray["C相输出功率因数"] = number_format($v[19], 2);
            $dataArray["A相输出有功功率（kW）"] = number_format($v[20], 2);
            $dataArray["B相输出有功功率（kW）"] = number_format($v[21], 2);
            $dataArray["C相输出有功功率（kW）"] = number_format($v[22], 2);
            $dataArray["电池电流（A）"] = number_format($v[23], 2);
            $dataArray["电池后备时间（s）"] = number_format($v[24], 2);
            $dataArray["A相视在功率（kVA）"] = number_format($v[25], 2);
            $dataArray["B相视在功率（kVA）"] = number_format($v[26], 2);
            $dataArray["C相视在功率（kVA）"] = number_format($v[27], 2);
            $dataArray["A相输出负载百分比（%）"] = number_format($v[28], 2);
            $dataArray["B相输出负载百分比（%）"] = number_format($v[29], 2);
            $dataArray["C相输出负载百分比（%）"] = number_format($v[30], 2);
            $dataArray["环境温度（℃）"] = number_format($v[31], 2);
            $dataArray["A相输出峰值比（%）"] = number_format($v[32], 2);
            $dataArray["B相输出峰值比（%）"] = number_format($v[33], 2);
            $dataArray["C相输出峰值比（%）"] = number_format($v[34], 2);
            $v = unpack('C*', substr($memData, 4 * 46 + 2, 1 * 15));
            $dataArray["runstate"] = array();
            $statusList = [
                "供电方式",
                "用户自定义数量",
                "电池自检中",
                "均充/浮充（正组）",
                "开机/关机",
                "UPS供电",
                "发电机接入",
                "输入空开状态",
                "手动旁路空开状态",
                "自动旁路空开状态",
                "输出空开状态",
                "发电机工作状态",
                "本机处于输出禁止状态",
                "并机系统处于输出禁止状态",
                "UPS机型属性"
            ];
            foreach ($v as $key => $val) {
                $dataArray[$statusList[$key-1]] = _GetUl33Runstate($val, $key);
            }
            $alarmStatusList = [
                "同步/不同步",
                "市电电压",
                "整流器",
                "逆变器",
                "旁路情况（电压或频率）",
                "蓄电池总电压状态",
                "电池自检结果",
                "市电频率",
                "输入变压器过温",
                "输出变压器过温",
                "逆变晶闸管坏",
                "旁路晶闸管坏",
                "用户操作故障",
                "逆变散热器过温",
                "整流散热器过温",
                "逆变风扇故障",
                "整流风扇故障",
                "电池接触器故障",
                "主路接触器异常",
                "辅助接触器异常",
                "输入熔断器坏",
                "输出熔断器坏",
                "本机输出过载",
                "并机系统过载",
                "本机过载超时",
                "旁路过流超时",
                "辅作电源一故障",
                "辅作电源二故障",
                "旁路异常关机",
                "旁路输入反序",
                "主路输入反序",
                "输入软启动失败",
                "交流输出过压",
                "输出冲击过流",
                "逆变模块过流",
                "整流模块过流",
                "负载冲击转旁路",
                "本小时允许切换次数限制",
                "并机均流故障",
                "母线电压低关机",
                "邻机请求转旁路",
                "环境温度过高",
                "环境告警量通道1报警",
                "环境告警量通道2报警",
                "环境告警量通道3报警",
                "环境告警量通道4报警",
                "环境告警量通道5报警",
                "环境告警量通道报警",
                "环境告警量通道7报警",
                "环境告警量通道8报警",
                "整流通讯故障",
                "逆变通讯故障",
                "并机板故障",
                "直流母线过压故障"
            ];
            $v = unpack('C*', substr($memData, 4 * 46 + 17, 1 * 8));
            // $dataArray["warnstate"] = array();
            $index = 0;
            foreach ($v as $key => $val) {
                $dataArray[$alarmStatusList[$index]] = _GetUl33Warnstate($val, $key);
                $index++;
                if ($index == 6) break;
            }

            $v = unpack('C*', substr($memData, 4 * 46 + 25, 1 * 30));
            // $dataArray["warnstate_c7"] = array();
            foreach ($v as $key => $val) {
                $dataArray[$alarmStatusList[$index]] = _GetUl33Warnstate_c7($val, $key);
                $index++;

            }
            $v = unpack('C*', substr($memData, 4 * 46 + 55, 1 * 18));
            // $dataArray["warnstate_c8"] = array();
            foreach ($v as $key => $val) {
                $dataArray[$alarmStatusList[$index]] =  _GetUl33Warnstate_c8($val);
                $index++;
            }
            $v = unpack('v', substr($memData, 4 * 46 + 73, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 * 46 + 75, 5));
            $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
    }

?>